/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldNameable;
import net.minecraft.world.World;

public abstract class BlockContainer
extends Block
implements ITileEntityProvider {
    protected BlockContainer(Material p_i45386_1_) {
        this(p_i45386_1_, p_i45386_1_.getMaterialMapColor());
    }

    protected BlockContainer(Material p_i46402_1_, MapColor p_i46402_2_) {
        super(p_i46402_1_, p_i46402_2_);
        this.isBlockContainer = true;
    }

    protected boolean isInvalidNeighbor(World p_isInvalidNeighbor_1_, BlockPos p_isInvalidNeighbor_2_, EnumFacing p_isInvalidNeighbor_3_) {
        return p_isInvalidNeighbor_1_.getBlockState(p_isInvalidNeighbor_2_.offset(p_isInvalidNeighbor_3_)).getMaterial() == Material.CACTUS;
    }

    protected boolean hasInvalidNeighbor(World p_hasInvalidNeighbor_1_, BlockPos p_hasInvalidNeighbor_2_) {
        return this.isInvalidNeighbor(p_hasInvalidNeighbor_1_, p_hasInvalidNeighbor_2_, EnumFacing.NORTH) || this.isInvalidNeighbor(p_hasInvalidNeighbor_1_, p_hasInvalidNeighbor_2_, EnumFacing.SOUTH) || this.isInvalidNeighbor(p_hasInvalidNeighbor_1_, p_hasInvalidNeighbor_2_, EnumFacing.WEST) || this.isInvalidNeighbor(p_hasInvalidNeighbor_1_, p_hasInvalidNeighbor_2_, EnumFacing.EAST);
    }

    @Override
    public EnumBlockRenderType getRenderType(IBlockState p_getRenderType_1_) {
        return EnumBlockRenderType.INVISIBLE;
    }

    @Override
    public void breakBlock(World p_breakBlock_1_, BlockPos p_breakBlock_2_, IBlockState p_breakBlock_3_) {
        super.breakBlock(p_breakBlock_1_, p_breakBlock_2_, p_breakBlock_3_);
        p_breakBlock_1_.removeTileEntity(p_breakBlock_2_);
    }

    @Override
    public void harvestBlock(World p_harvestBlock_1_, EntityPlayer p_harvestBlock_2_, BlockPos p_harvestBlock_3_, IBlockState p_harvestBlock_4_, TileEntity p_harvestBlock_5_, ItemStack p_harvestBlock_6_) {
        if (p_harvestBlock_5_ instanceof IWorldNameable && ((IWorldNameable)((Object)p_harvestBlock_5_)).hasCustomName()) {
            p_harvestBlock_2_.addStat(StatList.getBlockStats(this));
            p_harvestBlock_2_.addExhaustion(0.005f);
            if (p_harvestBlock_1_.isRemote) {
                return;
            }
            int lvt_7_1_ = EnchantmentHelper.getEnchantmentLevel(Enchantments.FORTUNE, p_harvestBlock_6_);
            Item lvt_8_1_ = this.getItemDropped(p_harvestBlock_4_, p_harvestBlock_1_.rand, lvt_7_1_);
            if (lvt_8_1_ == Items.AIR) {
                return;
            }
            ItemStack lvt_9_1_ = new ItemStack(lvt_8_1_, this.quantityDropped(p_harvestBlock_1_.rand));
            lvt_9_1_.setStackDisplayName(((IWorldNameable)((Object)p_harvestBlock_5_)).getName());
            BlockContainer.spawnAsEntity(p_harvestBlock_1_, p_harvestBlock_3_, lvt_9_1_);
        } else {
            super.harvestBlock(p_harvestBlock_1_, p_harvestBlock_2_, p_harvestBlock_3_, p_harvestBlock_4_, null, p_harvestBlock_6_);
        }
    }

    @Override
    public boolean eventReceived(IBlockState p_eventReceived_1_, World p_eventReceived_2_, BlockPos p_eventReceived_3_, int p_eventReceived_4_, int p_eventReceived_5_) {
        super.eventReceived(p_eventReceived_1_, p_eventReceived_2_, p_eventReceived_3_, p_eventReceived_4_, p_eventReceived_5_);
        TileEntity lvt_6_1_ = p_eventReceived_2_.getTileEntity(p_eventReceived_3_);
        if (lvt_6_1_ == null) {
            return false;
        }
        return lvt_6_1_.receiveClientEvent(p_eventReceived_4_, p_eventReceived_5_);
    }
}

