/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;

public class BlockCrops
extends BlockBush
implements IGrowable {
    public static final PropertyInteger AGE = PropertyInteger.create("age", 0, 7);
    private static final AxisAlignedBB[] CROPS_AABB = new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.25, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.375, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.625, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.75, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.875, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0)};

    protected BlockCrops() {
        this.setDefaultState(this.blockState.getBaseState().withProperty(this.getAgeProperty(), 0));
        this.setTickRandomly(true);
        this.setCreativeTab(null);
        this.setHardness(0.0f);
        this.setSoundType(SoundType.PLANT);
        this.disableStats();
    }

    @Override
    public AxisAlignedBB getBoundingBox(IBlockState p_getBoundingBox_1_, IBlockAccess p_getBoundingBox_2_, BlockPos p_getBoundingBox_3_) {
        return CROPS_AABB[p_getBoundingBox_1_.getValue(this.getAgeProperty())];
    }

    @Override
    protected boolean canSustainBush(IBlockState p_canSustainBush_1_) {
        return p_canSustainBush_1_.getBlock() == Blocks.FARMLAND;
    }

    protected PropertyInteger getAgeProperty() {
        return AGE;
    }

    public int getMaxAge() {
        return 7;
    }

    protected int getAge(IBlockState p_getAge_1_) {
        return p_getAge_1_.getValue(this.getAgeProperty());
    }

    public IBlockState withAge(int p_withAge_1_) {
        return this.getDefaultState().withProperty(this.getAgeProperty(), p_withAge_1_);
    }

    public boolean isMaxAge(IBlockState p_isMaxAge_1_) {
        return p_isMaxAge_1_.getValue(this.getAgeProperty()) >= this.getMaxAge();
    }

    @Override
    public void updateTick(World p_updateTick_1_, BlockPos p_updateTick_2_, IBlockState p_updateTick_3_, Random p_updateTick_4_) {
        float f;
        int i;
        super.updateTick(p_updateTick_1_, p_updateTick_2_, p_updateTick_3_, p_updateTick_4_);
        if (p_updateTick_1_.getLightFromNeighbors(p_updateTick_2_.up()) >= 9 && (i = this.getAge(p_updateTick_3_)) < this.getMaxAge() && ForgeHooks.onCropsGrowPre(p_updateTick_1_, p_updateTick_2_, p_updateTick_3_, p_updateTick_4_.nextInt((int)(25.0f / (f = BlockCrops.getGrowthChance(this, p_updateTick_1_, p_updateTick_2_))) + 1) == 0)) {
            p_updateTick_1_.setBlockState(p_updateTick_2_, this.withAge(i + 1), 2);
            ForgeHooks.onCropsGrowPost(p_updateTick_1_, p_updateTick_2_, p_updateTick_3_, p_updateTick_1_.getBlockState(p_updateTick_2_));
        }
    }

    public void grow(World p_grow_1_, BlockPos p_grow_2_, IBlockState p_grow_3_) {
        int j;
        int i = this.getAge(p_grow_3_) + this.getBonemealAgeIncrease(p_grow_1_);
        if (i > (j = this.getMaxAge())) {
            i = j;
        }
        p_grow_1_.setBlockState(p_grow_2_, this.withAge(i), 2);
    }

    protected int getBonemealAgeIncrease(World p_getBonemealAgeIncrease_1_) {
        return MathHelper.getInt(p_getBonemealAgeIncrease_1_.rand, 2, 5);
    }

    protected static float getGrowthChance(Block p_getGrowthChance_0_, World p_getGrowthChance_1_, BlockPos p_getGrowthChance_2_) {
        boolean flag1;
        float f = 1.0f;
        BlockPos blockpos = p_getGrowthChance_2_.down();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                float f1 = 0.0f;
                IBlockState iblockstate = p_getGrowthChance_1_.getBlockState(blockpos.add(i, 0, j));
                if (iblockstate.getBlock().canSustainPlant(iblockstate, p_getGrowthChance_1_, blockpos.add(i, 0, j), EnumFacing.UP, (IPlantable)((Object)p_getGrowthChance_0_))) {
                    f1 = 1.0f;
                    if (iblockstate.getBlock().isFertile(p_getGrowthChance_1_, blockpos.add(i, 0, j))) {
                        f1 = 3.0f;
                    }
                }
                if (i != 0 || j != 0) {
                    f1 /= 4.0f;
                }
                f += f1;
            }
        }
        BlockPos blockpos1 = p_getGrowthChance_2_.north();
        BlockPos blockpos2 = p_getGrowthChance_2_.south();
        BlockPos blockpos3 = p_getGrowthChance_2_.west();
        BlockPos blockpos4 = p_getGrowthChance_2_.east();
        boolean flag = p_getGrowthChance_0_ == p_getGrowthChance_1_.getBlockState(blockpos3).getBlock() || p_getGrowthChance_0_ == p_getGrowthChance_1_.getBlockState(blockpos4).getBlock();
        boolean bl = flag1 = p_getGrowthChance_0_ == p_getGrowthChance_1_.getBlockState(blockpos1).getBlock() || p_getGrowthChance_0_ == p_getGrowthChance_1_.getBlockState(blockpos2).getBlock();
        if (flag && flag1) {
            f /= 2.0f;
        } else {
            boolean flag2;
            boolean bl2 = flag2 = p_getGrowthChance_0_ == p_getGrowthChance_1_.getBlockState(blockpos3.north()).getBlock() || p_getGrowthChance_0_ == p_getGrowthChance_1_.getBlockState(blockpos4.north()).getBlock() || p_getGrowthChance_0_ == p_getGrowthChance_1_.getBlockState(blockpos4.south()).getBlock() || p_getGrowthChance_0_ == p_getGrowthChance_1_.getBlockState(blockpos3.south()).getBlock();
            if (flag2) {
                f /= 2.0f;
            }
        }
        return f;
    }

    @Override
    public boolean canBlockStay(World p_canBlockStay_1_, BlockPos p_canBlockStay_2_, IBlockState p_canBlockStay_3_) {
        IBlockState soil = p_canBlockStay_1_.getBlockState(p_canBlockStay_2_.down());
        return (p_canBlockStay_1_.getLight(p_canBlockStay_2_) >= 8 || p_canBlockStay_1_.canSeeSky(p_canBlockStay_2_)) && soil.getBlock().canSustainPlant(soil, p_canBlockStay_1_, p_canBlockStay_2_.down(), EnumFacing.UP, this);
    }

    protected Item getSeed() {
        return Items.WHEAT_SEEDS;
    }

    protected Item getCrop() {
        return Items.WHEAT;
    }

    @Override
    public List<ItemStack> getDrops(IBlockAccess p_getDrops_1_, BlockPos p_getDrops_2_, IBlockState p_getDrops_3_, int p_getDrops_4_) {
        Random rand;
        List<ItemStack> ret = super.getDrops(p_getDrops_1_, p_getDrops_2_, p_getDrops_3_, p_getDrops_4_);
        int age = this.getAge(p_getDrops_3_);
        Random random = rand = p_getDrops_1_ instanceof World ? ((World)p_getDrops_1_).rand : new Random();
        if (age >= this.getMaxAge()) {
            int k = 3 + p_getDrops_4_;
            for (int i = 0; i < 3 + p_getDrops_4_; ++i) {
                if (rand.nextInt(2 * this.getMaxAge()) > age) continue;
                ret.add(new ItemStack(this.getSeed(), 1, 0));
            }
        }
        return ret;
    }

    @Override
    public void dropBlockAsItemWithChance(World p_dropBlockAsItemWithChance_1_, BlockPos p_dropBlockAsItemWithChance_2_, IBlockState p_dropBlockAsItemWithChance_3_, float p_dropBlockAsItemWithChance_4_, int p_dropBlockAsItemWithChance_5_) {
        super.dropBlockAsItemWithChance(p_dropBlockAsItemWithChance_1_, p_dropBlockAsItemWithChance_2_, p_dropBlockAsItemWithChance_3_, p_dropBlockAsItemWithChance_4_, 0);
    }

    @Override
    public Item getItemDropped(IBlockState p_getItemDropped_1_, Random p_getItemDropped_2_, int p_getItemDropped_3_) {
        return this.isMaxAge(p_getItemDropped_1_) ? this.getCrop() : this.getSeed();
    }

    @Override
    public ItemStack getItem(World p_getItem_1_, BlockPos p_getItem_2_, IBlockState p_getItem_3_) {
        return new ItemStack(this.getSeed());
    }

    @Override
    public boolean canGrow(World p_canGrow_1_, BlockPos p_canGrow_2_, IBlockState p_canGrow_3_, boolean p_canGrow_4_) {
        return !this.isMaxAge(p_canGrow_3_);
    }

    @Override
    public boolean canUseBonemeal(World p_canUseBonemeal_1_, Random p_canUseBonemeal_2_, BlockPos p_canUseBonemeal_3_, IBlockState p_canUseBonemeal_4_) {
        return true;
    }

    @Override
    public void grow(World p_grow_1_, Random p_grow_2_, BlockPos p_grow_3_, IBlockState p_grow_4_) {
        this.grow(p_grow_1_, p_grow_3_, p_grow_4_);
    }

    @Override
    public IBlockState getStateFromMeta(int p_getStateFromMeta_1_) {
        return this.withAge(p_getStateFromMeta_1_);
    }

    @Override
    public int getMetaFromState(IBlockState p_getMetaFromState_1_) {
        return this.getAge(p_getMetaFromState_1_);
    }

    @Override
    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, AGE);
    }
}

