/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityDaylightDetector;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockDaylightDetector
extends BlockContainer {
    public static final PropertyInteger POWER = PropertyInteger.create("power", 0, 15);
    protected static final AxisAlignedBB DAYLIGHT_DETECTOR_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.375, 1.0);
    private final boolean inverted;

    public BlockDaylightDetector(boolean p_i45729_1_) {
        super(Material.WOOD);
        this.inverted = p_i45729_1_;
        this.setDefaultState(this.blockState.getBaseState().withProperty(POWER, 0));
        this.setCreativeTab(CreativeTabs.REDSTONE);
        this.setHardness(0.2f);
        this.setSoundType(SoundType.WOOD);
        this.setUnlocalizedName("daylightDetector");
    }

    @Override
    public AxisAlignedBB getBoundingBox(IBlockState p_getBoundingBox_1_, IBlockAccess p_getBoundingBox_2_, BlockPos p_getBoundingBox_3_) {
        return DAYLIGHT_DETECTOR_AABB;
    }

    @Override
    public int getWeakPower(IBlockState p_getWeakPower_1_, IBlockAccess p_getWeakPower_2_, BlockPos p_getWeakPower_3_, EnumFacing p_getWeakPower_4_) {
        return p_getWeakPower_1_.getValue(POWER);
    }

    public void updatePower(World p_updatePower_1_, BlockPos p_updatePower_2_) {
        if (!p_updatePower_1_.provider.hasSkyLight()) {
            return;
        }
        IBlockState lvt_3_1_ = p_updatePower_1_.getBlockState(p_updatePower_2_);
        int lvt_4_1_ = p_updatePower_1_.getLightFor(EnumSkyBlock.SKY, p_updatePower_2_) - p_updatePower_1_.getSkylightSubtracted();
        float lvt_5_1_ = p_updatePower_1_.getCelestialAngleRadians(1.0f);
        if (this.inverted) {
            lvt_4_1_ = 15 - lvt_4_1_;
        }
        if (lvt_4_1_ > 0 && !this.inverted) {
            float lvt_6_1_ = lvt_5_1_ < (float)Math.PI ? 0.0f : (float)Math.PI * 2;
            lvt_5_1_ += (lvt_6_1_ - lvt_5_1_) * 0.2f;
            lvt_4_1_ = Math.round((float)lvt_4_1_ * MathHelper.cos(lvt_5_1_));
        }
        lvt_4_1_ = MathHelper.clamp(lvt_4_1_, 0, 15);
        if (lvt_3_1_.getValue(POWER) != lvt_4_1_) {
            p_updatePower_1_.setBlockState(p_updatePower_2_, lvt_3_1_.withProperty(POWER, lvt_4_1_), 3);
        }
    }

    @Override
    public boolean onBlockActivated(World p_onBlockActivated_1_, BlockPos p_onBlockActivated_2_, IBlockState p_onBlockActivated_3_, EntityPlayer p_onBlockActivated_4_, EnumHand p_onBlockActivated_5_, EnumFacing p_onBlockActivated_6_, float p_onBlockActivated_7_, float p_onBlockActivated_8_, float p_onBlockActivated_9_) {
        if (p_onBlockActivated_4_.isAllowEdit()) {
            if (p_onBlockActivated_1_.isRemote) {
                return true;
            }
            if (this.inverted) {
                p_onBlockActivated_1_.setBlockState(p_onBlockActivated_2_, Blocks.DAYLIGHT_DETECTOR.getDefaultState().withProperty(POWER, p_onBlockActivated_3_.getValue(POWER)), 4);
                Blocks.DAYLIGHT_DETECTOR.updatePower(p_onBlockActivated_1_, p_onBlockActivated_2_);
            } else {
                p_onBlockActivated_1_.setBlockState(p_onBlockActivated_2_, Blocks.DAYLIGHT_DETECTOR_INVERTED.getDefaultState().withProperty(POWER, p_onBlockActivated_3_.getValue(POWER)), 4);
                Blocks.DAYLIGHT_DETECTOR_INVERTED.updatePower(p_onBlockActivated_1_, p_onBlockActivated_2_);
            }
            return true;
        }
        return super.onBlockActivated(p_onBlockActivated_1_, p_onBlockActivated_2_, p_onBlockActivated_3_, p_onBlockActivated_4_, p_onBlockActivated_5_, p_onBlockActivated_6_, p_onBlockActivated_7_, p_onBlockActivated_8_, p_onBlockActivated_9_);
    }

    @Override
    public Item getItemDropped(IBlockState p_getItemDropped_1_, Random p_getItemDropped_2_, int p_getItemDropped_3_) {
        return Item.getItemFromBlock(Blocks.DAYLIGHT_DETECTOR);
    }

    @Override
    public ItemStack getItem(World p_getItem_1_, BlockPos p_getItem_2_, IBlockState p_getItem_3_) {
        return new ItemStack(Blocks.DAYLIGHT_DETECTOR);
    }

    @Override
    public boolean isFullCube(IBlockState p_isFullCube_1_) {
        return false;
    }

    @Override
    public boolean isOpaqueCube(IBlockState p_isOpaqueCube_1_) {
        return false;
    }

    @Override
    public EnumBlockRenderType getRenderType(IBlockState p_getRenderType_1_) {
        return EnumBlockRenderType.MODEL;
    }

    @Override
    public boolean canProvidePower(IBlockState p_canProvidePower_1_) {
        return true;
    }

    @Override
    public TileEntity createNewTileEntity(World p_createNewTileEntity_1_, int p_createNewTileEntity_2_) {
        return new TileEntityDaylightDetector();
    }

    @Override
    public IBlockState getStateFromMeta(int p_getStateFromMeta_1_) {
        return this.getDefaultState().withProperty(POWER, p_getStateFromMeta_1_);
    }

    @Override
    public int getMetaFromState(IBlockState p_getMetaFromState_1_) {
        return p_getMetaFromState_1_.getValue(POWER);
    }

    @Override
    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, POWER);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getSubBlocks(Item p_getSubBlocks_1_, CreativeTabs p_getSubBlocks_2_, NonNullList<ItemStack> p_getSubBlocks_3_) {
        if (!this.inverted) {
            super.getSubBlocks(p_getSubBlocks_1_, p_getSubBlocks_2_, p_getSubBlocks_3_);
        }
    }
}

