/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockDirt
extends Block {
    public static final PropertyEnum<DirtType> VARIANT = PropertyEnum.create("variant", DirtType.class);
    public static final PropertyBool SNOWY = PropertyBool.create("snowy");

    protected BlockDirt() {
        super(Material.GROUND);
        this.setDefaultState(this.blockState.getBaseState().withProperty(VARIANT, DirtType.DIRT).withProperty(SNOWY, false));
        this.setCreativeTab(CreativeTabs.BUILDING_BLOCKS);
    }

    @Override
    public MapColor getMapColor(IBlockState p_getMapColor_1_) {
        return p_getMapColor_1_.getValue(VARIANT).getColor();
    }

    @Override
    public IBlockState getActualState(IBlockState p_getActualState_1_, IBlockAccess p_getActualState_2_, BlockPos p_getActualState_3_) {
        if (p_getActualState_1_.getValue(VARIANT) == DirtType.PODZOL) {
            Block lvt_4_1_ = p_getActualState_2_.getBlockState(p_getActualState_3_.up()).getBlock();
            p_getActualState_1_ = p_getActualState_1_.withProperty(SNOWY, lvt_4_1_ == Blocks.SNOW || lvt_4_1_ == Blocks.SNOW_LAYER);
        }
        return p_getActualState_1_;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getSubBlocks(Item p_getSubBlocks_1_, CreativeTabs p_getSubBlocks_2_, NonNullList<ItemStack> p_getSubBlocks_3_) {
        p_getSubBlocks_3_.add(new ItemStack(this, 1, DirtType.DIRT.getMetadata()));
        p_getSubBlocks_3_.add(new ItemStack(this, 1, DirtType.COARSE_DIRT.getMetadata()));
        p_getSubBlocks_3_.add(new ItemStack(this, 1, DirtType.PODZOL.getMetadata()));
    }

    @Override
    public ItemStack getItem(World p_getItem_1_, BlockPos p_getItem_2_, IBlockState p_getItem_3_) {
        return new ItemStack(this, 1, p_getItem_3_.getValue(VARIANT).getMetadata());
    }

    @Override
    public IBlockState getStateFromMeta(int p_getStateFromMeta_1_) {
        return this.getDefaultState().withProperty(VARIANT, DirtType.byMetadata(p_getStateFromMeta_1_));
    }

    @Override
    public int getMetaFromState(IBlockState p_getMetaFromState_1_) {
        return p_getMetaFromState_1_.getValue(VARIANT).getMetadata();
    }

    @Override
    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, VARIANT, SNOWY);
    }

    @Override
    public int damageDropped(IBlockState p_damageDropped_1_) {
        DirtType lvt_2_1_ = p_damageDropped_1_.getValue(VARIANT);
        if (lvt_2_1_ == DirtType.PODZOL) {
            lvt_2_1_ = DirtType.DIRT;
        }
        return lvt_2_1_.getMetadata();
    }

    public static enum DirtType implements IStringSerializable
    {
        DIRT(0, "dirt", "default", MapColor.DIRT),
        COARSE_DIRT(1, "coarse_dirt", "coarse", MapColor.DIRT),
        PODZOL(2, "podzol", MapColor.OBSIDIAN);

        private static final DirtType[] METADATA_LOOKUP;
        private final int metadata;
        private final String name;
        private final String unlocalizedName;
        private final MapColor color;

        private DirtType(int p_i46396_3_, String p_i46396_4_, MapColor p_i46396_5_) {
            this(p_i46396_3_, p_i46396_4_, p_i46396_4_, p_i46396_5_);
        }

        private DirtType(int p_i46397_3_, String p_i46397_4_, String p_i46397_5_, MapColor p_i46397_6_) {
            this.metadata = p_i46397_3_;
            this.name = p_i46397_4_;
            this.unlocalizedName = p_i46397_5_;
            this.color = p_i46397_6_;
        }

        public int getMetadata() {
            return this.metadata;
        }

        public String getUnlocalizedName() {
            return this.unlocalizedName;
        }

        public MapColor getColor() {
            return this.color;
        }

        public String toString() {
            return this.name;
        }

        public static DirtType byMetadata(int p_byMetadata_0_) {
            if (p_byMetadata_0_ < 0 || p_byMetadata_0_ >= METADATA_LOOKUP.length) {
                p_byMetadata_0_ = 0;
            }
            return METADATA_LOOKUP[p_byMetadata_0_];
        }

        @Override
        public String getName() {
            return this.name;
        }

        static {
            METADATA_LOOKUP = new DirtType[DirtType.values().length];
            DirtType[] dirtTypeArray = DirtType.values();
            int n = dirtTypeArray.length;
            for (int i = 0; i < n; ++i) {
                DirtType lvt_3_1_;
                DirtType.METADATA_LOOKUP[lvt_3_1_.getMetadata()] = lvt_3_1_ = dirtTypeArray[i];
            }
        }
    }
}

