/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.BlockSourceImpl;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IPosition;
import net.minecraft.dispenser.PositionImpl;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.tileentity.TileEntityDropper;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.RegistryDefaulted;
import net.minecraft.world.World;

public class BlockDispenser
extends BlockContainer {
    public static final PropertyDirection FACING = BlockDirectional.FACING;
    public static final PropertyBool TRIGGERED = PropertyBool.create("triggered");
    public static final RegistryDefaulted<Item, IBehaviorDispenseItem> DISPENSE_BEHAVIOR_REGISTRY = new RegistryDefaulted(new BehaviorDefaultDispenseItem());
    protected Random rand = new Random();

    protected BlockDispenser() {
        super(Material.ROCK);
        this.setDefaultState(this.blockState.getBaseState().withProperty(FACING, EnumFacing.NORTH).withProperty(TRIGGERED, false));
        this.setCreativeTab(CreativeTabs.REDSTONE);
    }

    @Override
    public int tickRate(World p_tickRate_1_) {
        return 4;
    }

    @Override
    public void onBlockAdded(World p_onBlockAdded_1_, BlockPos p_onBlockAdded_2_, IBlockState p_onBlockAdded_3_) {
        super.onBlockAdded(p_onBlockAdded_1_, p_onBlockAdded_2_, p_onBlockAdded_3_);
        this.setDefaultDirection(p_onBlockAdded_1_, p_onBlockAdded_2_, p_onBlockAdded_3_);
    }

    private void setDefaultDirection(World p_setDefaultDirection_1_, BlockPos p_setDefaultDirection_2_, IBlockState p_setDefaultDirection_3_) {
        if (p_setDefaultDirection_1_.isRemote) {
            return;
        }
        EnumFacing lvt_4_1_ = p_setDefaultDirection_3_.getValue(FACING);
        boolean lvt_5_1_ = p_setDefaultDirection_1_.getBlockState(p_setDefaultDirection_2_.north()).isFullBlock();
        boolean lvt_6_1_ = p_setDefaultDirection_1_.getBlockState(p_setDefaultDirection_2_.south()).isFullBlock();
        if (lvt_4_1_ == EnumFacing.NORTH && lvt_5_1_ && !lvt_6_1_) {
            lvt_4_1_ = EnumFacing.SOUTH;
        } else if (lvt_4_1_ == EnumFacing.SOUTH && lvt_6_1_ && !lvt_5_1_) {
            lvt_4_1_ = EnumFacing.NORTH;
        } else {
            boolean lvt_7_1_ = p_setDefaultDirection_1_.getBlockState(p_setDefaultDirection_2_.west()).isFullBlock();
            boolean lvt_8_1_ = p_setDefaultDirection_1_.getBlockState(p_setDefaultDirection_2_.east()).isFullBlock();
            if (lvt_4_1_ == EnumFacing.WEST && lvt_7_1_ && !lvt_8_1_) {
                lvt_4_1_ = EnumFacing.EAST;
            } else if (lvt_4_1_ == EnumFacing.EAST && lvt_8_1_ && !lvt_7_1_) {
                lvt_4_1_ = EnumFacing.WEST;
            }
        }
        p_setDefaultDirection_1_.setBlockState(p_setDefaultDirection_2_, p_setDefaultDirection_3_.withProperty(FACING, lvt_4_1_).withProperty(TRIGGERED, false), 2);
    }

    @Override
    public boolean onBlockActivated(World p_onBlockActivated_1_, BlockPos p_onBlockActivated_2_, IBlockState p_onBlockActivated_3_, EntityPlayer p_onBlockActivated_4_, EnumHand p_onBlockActivated_5_, EnumFacing p_onBlockActivated_6_, float p_onBlockActivated_7_, float p_onBlockActivated_8_, float p_onBlockActivated_9_) {
        if (p_onBlockActivated_1_.isRemote) {
            return true;
        }
        TileEntity lvt_10_1_ = p_onBlockActivated_1_.getTileEntity(p_onBlockActivated_2_);
        if (lvt_10_1_ instanceof TileEntityDispenser) {
            p_onBlockActivated_4_.displayGUIChest((TileEntityDispenser)lvt_10_1_);
            if (lvt_10_1_ instanceof TileEntityDropper) {
                p_onBlockActivated_4_.addStat(StatList.DROPPER_INSPECTED);
            } else {
                p_onBlockActivated_4_.addStat(StatList.DISPENSER_INSPECTED);
            }
        }
        return true;
    }

    protected void dispense(World p_dispense_1_, BlockPos p_dispense_2_) {
        BlockSourceImpl lvt_3_1_ = new BlockSourceImpl(p_dispense_1_, p_dispense_2_);
        TileEntityDispenser lvt_4_1_ = (TileEntityDispenser)lvt_3_1_.getBlockTileEntity();
        if (lvt_4_1_ == null) {
            return;
        }
        int lvt_5_1_ = lvt_4_1_.getDispenseSlot();
        if (lvt_5_1_ < 0) {
            p_dispense_1_.playEvent(1001, p_dispense_2_, 0);
            return;
        }
        ItemStack lvt_6_1_ = lvt_4_1_.getStackInSlot(lvt_5_1_);
        IBehaviorDispenseItem lvt_7_1_ = this.getBehavior(lvt_6_1_);
        if (lvt_7_1_ != IBehaviorDispenseItem.DEFAULT_BEHAVIOR) {
            lvt_4_1_.setInventorySlotContents(lvt_5_1_, lvt_7_1_.dispense(lvt_3_1_, lvt_6_1_));
        }
    }

    protected IBehaviorDispenseItem getBehavior(ItemStack p_getBehavior_1_) {
        return DISPENSE_BEHAVIOR_REGISTRY.getObject(p_getBehavior_1_.getItem());
    }

    @Override
    public void neighborChanged(IBlockState p_neighborChanged_1_, World p_neighborChanged_2_, BlockPos p_neighborChanged_3_, Block p_neighborChanged_4_, BlockPos p_neighborChanged_5_) {
        boolean lvt_6_1_ = p_neighborChanged_2_.isBlockPowered(p_neighborChanged_3_) || p_neighborChanged_2_.isBlockPowered(p_neighborChanged_3_.up());
        boolean lvt_7_1_ = p_neighborChanged_1_.getValue(TRIGGERED);
        if (lvt_6_1_ && !lvt_7_1_) {
            p_neighborChanged_2_.scheduleUpdate(p_neighborChanged_3_, this, this.tickRate(p_neighborChanged_2_));
            p_neighborChanged_2_.setBlockState(p_neighborChanged_3_, p_neighborChanged_1_.withProperty(TRIGGERED, true), 4);
        } else if (!lvt_6_1_ && lvt_7_1_) {
            p_neighborChanged_2_.setBlockState(p_neighborChanged_3_, p_neighborChanged_1_.withProperty(TRIGGERED, false), 4);
        }
    }

    @Override
    public void updateTick(World p_updateTick_1_, BlockPos p_updateTick_2_, IBlockState p_updateTick_3_, Random p_updateTick_4_) {
        if (!p_updateTick_1_.isRemote) {
            this.dispense(p_updateTick_1_, p_updateTick_2_);
        }
    }

    @Override
    public TileEntity createNewTileEntity(World p_createNewTileEntity_1_, int p_createNewTileEntity_2_) {
        return new TileEntityDispenser();
    }

    @Override
    public IBlockState getStateForPlacement(World p_getStateForPlacement_1_, BlockPos p_getStateForPlacement_2_, EnumFacing p_getStateForPlacement_3_, float p_getStateForPlacement_4_, float p_getStateForPlacement_5_, float p_getStateForPlacement_6_, int p_getStateForPlacement_7_, EntityLivingBase p_getStateForPlacement_8_) {
        return this.getDefaultState().withProperty(FACING, EnumFacing.getDirectionFromEntityLiving(p_getStateForPlacement_2_, p_getStateForPlacement_8_)).withProperty(TRIGGERED, false);
    }

    @Override
    public void onBlockPlacedBy(World p_onBlockPlacedBy_1_, BlockPos p_onBlockPlacedBy_2_, IBlockState p_onBlockPlacedBy_3_, EntityLivingBase p_onBlockPlacedBy_4_, ItemStack p_onBlockPlacedBy_5_) {
        TileEntity lvt_6_1_;
        p_onBlockPlacedBy_1_.setBlockState(p_onBlockPlacedBy_2_, p_onBlockPlacedBy_3_.withProperty(FACING, EnumFacing.getDirectionFromEntityLiving(p_onBlockPlacedBy_2_, p_onBlockPlacedBy_4_)), 2);
        if (p_onBlockPlacedBy_5_.hasDisplayName() && (lvt_6_1_ = p_onBlockPlacedBy_1_.getTileEntity(p_onBlockPlacedBy_2_)) instanceof TileEntityDispenser) {
            ((TileEntityDispenser)lvt_6_1_).setCustomName(p_onBlockPlacedBy_5_.getDisplayName());
        }
    }

    @Override
    public void breakBlock(World p_breakBlock_1_, BlockPos p_breakBlock_2_, IBlockState p_breakBlock_3_) {
        TileEntity lvt_4_1_ = p_breakBlock_1_.getTileEntity(p_breakBlock_2_);
        if (lvt_4_1_ instanceof TileEntityDispenser) {
            InventoryHelper.dropInventoryItems(p_breakBlock_1_, p_breakBlock_2_, (IInventory)((TileEntityDispenser)lvt_4_1_));
            p_breakBlock_1_.updateComparatorOutputLevel(p_breakBlock_2_, this);
        }
        super.breakBlock(p_breakBlock_1_, p_breakBlock_2_, p_breakBlock_3_);
    }

    public static IPosition getDispensePosition(IBlockSource p_getDispensePosition_0_) {
        EnumFacing lvt_1_1_ = p_getDispensePosition_0_.getBlockState().getValue(FACING);
        double lvt_2_1_ = p_getDispensePosition_0_.getX() + 0.7 * (double)lvt_1_1_.getFrontOffsetX();
        double lvt_4_1_ = p_getDispensePosition_0_.getY() + 0.7 * (double)lvt_1_1_.getFrontOffsetY();
        double lvt_6_1_ = p_getDispensePosition_0_.getZ() + 0.7 * (double)lvt_1_1_.getFrontOffsetZ();
        return new PositionImpl(lvt_2_1_, lvt_4_1_, lvt_6_1_);
    }

    @Override
    public boolean hasComparatorInputOverride(IBlockState p_hasComparatorInputOverride_1_) {
        return true;
    }

    @Override
    public int getComparatorInputOverride(IBlockState p_getComparatorInputOverride_1_, World p_getComparatorInputOverride_2_, BlockPos p_getComparatorInputOverride_3_) {
        return Container.calcRedstone(p_getComparatorInputOverride_2_.getTileEntity(p_getComparatorInputOverride_3_));
    }

    @Override
    public EnumBlockRenderType getRenderType(IBlockState p_getRenderType_1_) {
        return EnumBlockRenderType.MODEL;
    }

    @Override
    public IBlockState getStateFromMeta(int p_getStateFromMeta_1_) {
        return this.getDefaultState().withProperty(FACING, EnumFacing.getFront(p_getStateFromMeta_1_ & 7)).withProperty(TRIGGERED, (p_getStateFromMeta_1_ & 8) > 0);
    }

    @Override
    public int getMetaFromState(IBlockState p_getMetaFromState_1_) {
        int lvt_2_1_ = 0;
        lvt_2_1_ |= p_getMetaFromState_1_.getValue(FACING).getIndex();
        if (p_getMetaFromState_1_.getValue(TRIGGERED).booleanValue()) {
            lvt_2_1_ |= 8;
        }
        return lvt_2_1_;
    }

    @Override
    public IBlockState withRotation(IBlockState p_withRotation_1_, Rotation p_withRotation_2_) {
        return p_withRotation_1_.withProperty(FACING, p_withRotation_2_.rotate(p_withRotation_1_.getValue(FACING)));
    }

    @Override
    public IBlockState withMirror(IBlockState p_withMirror_1_, Mirror p_withMirror_2_) {
        return p_withMirror_1_.withRotation(p_withMirror_2_.toRotation(p_withMirror_1_.getValue(FACING)));
    }

    @Override
    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, FACING, TRIGGERED);
    }
}

