/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockDoor
extends Block {
    public static final PropertyDirection FACING = BlockHorizontal.FACING;
    public static final PropertyBool OPEN = PropertyBool.create("open");
    public static final PropertyEnum<EnumHingePosition> HINGE = PropertyEnum.create("hinge", EnumHingePosition.class);
    public static final PropertyBool POWERED = PropertyBool.create("powered");
    public static final PropertyEnum<EnumDoorHalf> HALF = PropertyEnum.create("half", EnumDoorHalf.class);
    protected static final AxisAlignedBB SOUTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.1875);
    protected static final AxisAlignedBB NORTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.8125, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB WEST_AABB = new AxisAlignedBB(0.8125, 0.0, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB EAST_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.1875, 1.0, 1.0);

    protected BlockDoor(Material p_i45402_1_) {
        super(p_i45402_1_);
        this.setDefaultState(this.blockState.getBaseState().withProperty(FACING, EnumFacing.NORTH).withProperty(OPEN, false).withProperty(HINGE, EnumHingePosition.LEFT).withProperty(POWERED, false).withProperty(HALF, EnumDoorHalf.LOWER));
    }

    @Override
    public AxisAlignedBB getBoundingBox(IBlockState p_getBoundingBox_1_, IBlockAccess p_getBoundingBox_2_, BlockPos p_getBoundingBox_3_) {
        p_getBoundingBox_1_ = p_getBoundingBox_1_.getActualState(p_getBoundingBox_2_, p_getBoundingBox_3_);
        EnumFacing enumfacing = p_getBoundingBox_1_.getValue(FACING);
        boolean flag = p_getBoundingBox_1_.getValue(OPEN) == false;
        boolean flag1 = p_getBoundingBox_1_.getValue(HINGE) == EnumHingePosition.RIGHT;
        switch (enumfacing) {
            default: {
                return flag ? EAST_AABB : (flag1 ? NORTH_AABB : SOUTH_AABB);
            }
            case SOUTH: {
                return flag ? SOUTH_AABB : (flag1 ? EAST_AABB : WEST_AABB);
            }
            case WEST: {
                return flag ? WEST_AABB : (flag1 ? SOUTH_AABB : NORTH_AABB);
            }
            case NORTH: 
        }
        return flag ? NORTH_AABB : (flag1 ? WEST_AABB : EAST_AABB);
    }

    @Override
    public String getLocalizedName() {
        return I18n.translateToLocal((this.getUnlocalizedName() + ".name").replaceAll("tile", "item"));
    }

    @Override
    public boolean isOpaqueCube(IBlockState p_isOpaqueCube_1_) {
        return false;
    }

    @Override
    public boolean isPassable(IBlockAccess p_isPassable_1_, BlockPos p_isPassable_2_) {
        return BlockDoor.isOpen(BlockDoor.combineMetadata(p_isPassable_1_, p_isPassable_2_));
    }

    @Override
    public boolean isFullCube(IBlockState p_isFullCube_1_) {
        return false;
    }

    private int getCloseSound() {
        return this.blockMaterial == Material.IRON ? 1011 : 1012;
    }

    private int getOpenSound() {
        return this.blockMaterial == Material.IRON ? 1005 : 1006;
    }

    @Override
    public MapColor getMapColor(IBlockState p_getMapColor_1_) {
        return p_getMapColor_1_.getBlock() == Blocks.IRON_DOOR ? MapColor.IRON : (p_getMapColor_1_.getBlock() == Blocks.OAK_DOOR ? BlockPlanks.EnumType.OAK.getMapColor() : (p_getMapColor_1_.getBlock() == Blocks.SPRUCE_DOOR ? BlockPlanks.EnumType.SPRUCE.getMapColor() : (p_getMapColor_1_.getBlock() == Blocks.BIRCH_DOOR ? BlockPlanks.EnumType.BIRCH.getMapColor() : (p_getMapColor_1_.getBlock() == Blocks.JUNGLE_DOOR ? BlockPlanks.EnumType.JUNGLE.getMapColor() : (p_getMapColor_1_.getBlock() == Blocks.ACACIA_DOOR ? BlockPlanks.EnumType.ACACIA.getMapColor() : (p_getMapColor_1_.getBlock() == Blocks.DARK_OAK_DOOR ? BlockPlanks.EnumType.DARK_OAK.getMapColor() : super.getMapColor(p_getMapColor_1_)))))));
    }

    @Override
    public boolean onBlockActivated(World p_onBlockActivated_1_, BlockPos p_onBlockActivated_2_, IBlockState p_onBlockActivated_3_, EntityPlayer p_onBlockActivated_4_, EnumHand p_onBlockActivated_5_, EnumFacing p_onBlockActivated_6_, float p_onBlockActivated_7_, float p_onBlockActivated_8_, float p_onBlockActivated_9_) {
        IBlockState iblockstate;
        if (this.blockMaterial == Material.IRON) {
            return false;
        }
        BlockPos blockpos = p_onBlockActivated_3_.getValue(HALF) == EnumDoorHalf.LOWER ? p_onBlockActivated_2_ : p_onBlockActivated_2_.down();
        IBlockState iBlockState = iblockstate = p_onBlockActivated_2_.equals(blockpos) ? p_onBlockActivated_3_ : p_onBlockActivated_1_.getBlockState(blockpos);
        if (iblockstate.getBlock() != this) {
            return false;
        }
        p_onBlockActivated_3_ = iblockstate.cycleProperty(OPEN);
        p_onBlockActivated_1_.setBlockState(blockpos, p_onBlockActivated_3_, 10);
        p_onBlockActivated_1_.markBlockRangeForRenderUpdate(blockpos, p_onBlockActivated_2_);
        p_onBlockActivated_1_.playEvent(p_onBlockActivated_4_, p_onBlockActivated_3_.getValue(OPEN) != false ? this.getOpenSound() : this.getCloseSound(), p_onBlockActivated_2_, 0);
        return true;
    }

    public void toggleDoor(World p_toggleDoor_1_, BlockPos p_toggleDoor_2_, boolean p_toggleDoor_3_) {
        IBlockState iblockstate = p_toggleDoor_1_.getBlockState(p_toggleDoor_2_);
        if (iblockstate.getBlock() == this) {
            IBlockState iblockstate1;
            BlockPos blockpos = iblockstate.getValue(HALF) == EnumDoorHalf.LOWER ? p_toggleDoor_2_ : p_toggleDoor_2_.down();
            IBlockState iBlockState = iblockstate1 = p_toggleDoor_2_ == blockpos ? iblockstate : p_toggleDoor_1_.getBlockState(blockpos);
            if (iblockstate1.getBlock() == this && iblockstate1.getValue(OPEN) != p_toggleDoor_3_) {
                p_toggleDoor_1_.setBlockState(blockpos, iblockstate1.withProperty(OPEN, p_toggleDoor_3_), 10);
                p_toggleDoor_1_.markBlockRangeForRenderUpdate(blockpos, p_toggleDoor_2_);
                p_toggleDoor_1_.playEvent(null, p_toggleDoor_3_ ? this.getOpenSound() : this.getCloseSound(), p_toggleDoor_2_, 0);
            }
        }
    }

    @Override
    public void neighborChanged(IBlockState p_neighborChanged_1_, World p_neighborChanged_2_, BlockPos p_neighborChanged_3_, Block p_neighborChanged_4_, BlockPos p_neighborChanged_5_) {
        if (p_neighborChanged_1_.getValue(HALF) == EnumDoorHalf.UPPER) {
            BlockPos blockpos = p_neighborChanged_3_.down();
            IBlockState iblockstate = p_neighborChanged_2_.getBlockState(blockpos);
            if (iblockstate.getBlock() != this) {
                p_neighborChanged_2_.setBlockToAir(p_neighborChanged_3_);
            } else if (p_neighborChanged_4_ != this) {
                iblockstate.neighborChanged(p_neighborChanged_2_, blockpos, p_neighborChanged_4_, p_neighborChanged_5_);
            }
        } else {
            boolean flag1 = false;
            BlockPos blockpos1 = p_neighborChanged_3_.up();
            IBlockState iblockstate1 = p_neighborChanged_2_.getBlockState(blockpos1);
            if (iblockstate1.getBlock() != this) {
                p_neighborChanged_2_.setBlockToAir(p_neighborChanged_3_);
                flag1 = true;
            }
            if (!p_neighborChanged_2_.getBlockState(p_neighborChanged_3_.down()).isSideSolid(p_neighborChanged_2_, p_neighborChanged_3_.down(), EnumFacing.UP)) {
                p_neighborChanged_2_.setBlockToAir(p_neighborChanged_3_);
                flag1 = true;
                if (iblockstate1.getBlock() == this) {
                    p_neighborChanged_2_.setBlockToAir(blockpos1);
                }
            }
            if (flag1) {
                if (!p_neighborChanged_2_.isRemote) {
                    this.dropBlockAsItem(p_neighborChanged_2_, p_neighborChanged_3_, p_neighborChanged_1_, 0);
                }
            } else {
                boolean flag;
                boolean bl = flag = p_neighborChanged_2_.isBlockPowered(p_neighborChanged_3_) || p_neighborChanged_2_.isBlockPowered(blockpos1);
                if (p_neighborChanged_4_ != this && (flag || p_neighborChanged_4_.getDefaultState().canProvidePower()) && flag != iblockstate1.getValue(POWERED)) {
                    p_neighborChanged_2_.setBlockState(blockpos1, iblockstate1.withProperty(POWERED, flag), 2);
                    if (flag != p_neighborChanged_1_.getValue(OPEN)) {
                        p_neighborChanged_2_.setBlockState(p_neighborChanged_3_, p_neighborChanged_1_.withProperty(OPEN, flag), 2);
                        p_neighborChanged_2_.markBlockRangeForRenderUpdate(p_neighborChanged_3_, p_neighborChanged_3_);
                        p_neighborChanged_2_.playEvent(null, flag ? this.getOpenSound() : this.getCloseSound(), p_neighborChanged_3_, 0);
                    }
                }
            }
        }
    }

    @Override
    public Item getItemDropped(IBlockState p_getItemDropped_1_, Random p_getItemDropped_2_, int p_getItemDropped_3_) {
        return p_getItemDropped_1_.getValue(HALF) == EnumDoorHalf.UPPER ? Items.AIR : this.getItem();
    }

    @Override
    public boolean canPlaceBlockAt(World p_canPlaceBlockAt_1_, BlockPos p_canPlaceBlockAt_2_) {
        return p_canPlaceBlockAt_2_.getY() >= p_canPlaceBlockAt_1_.getHeight() - 1 ? false : p_canPlaceBlockAt_1_.getBlockState(p_canPlaceBlockAt_2_.down()).isSideSolid(p_canPlaceBlockAt_1_, p_canPlaceBlockAt_2_.down(), EnumFacing.UP) && super.canPlaceBlockAt(p_canPlaceBlockAt_1_, p_canPlaceBlockAt_2_) && super.canPlaceBlockAt(p_canPlaceBlockAt_1_, p_canPlaceBlockAt_2_.up());
    }

    @Override
    public EnumPushReaction getMobilityFlag(IBlockState p_getMobilityFlag_1_) {
        return EnumPushReaction.DESTROY;
    }

    public static int combineMetadata(IBlockAccess p_combineMetadata_0_, BlockPos p_combineMetadata_1_) {
        IBlockState iblockstate = p_combineMetadata_0_.getBlockState(p_combineMetadata_1_);
        int i = iblockstate.getBlock().getMetaFromState(iblockstate);
        boolean flag = BlockDoor.isTop(i);
        IBlockState iblockstate1 = p_combineMetadata_0_.getBlockState(p_combineMetadata_1_.down());
        int j = iblockstate1.getBlock().getMetaFromState(iblockstate1);
        int k = flag ? j : i;
        IBlockState iblockstate2 = p_combineMetadata_0_.getBlockState(p_combineMetadata_1_.up());
        int l = iblockstate2.getBlock().getMetaFromState(iblockstate2);
        int i1 = flag ? i : l;
        boolean flag1 = (i1 & 1) != 0;
        boolean flag2 = (i1 & 2) != 0;
        return BlockDoor.removeHalfBit(k) | (flag ? 8 : 0) | (flag1 ? 16 : 0) | (flag2 ? 32 : 0);
    }

    @Override
    public ItemStack getItem(World p_getItem_1_, BlockPos p_getItem_2_, IBlockState p_getItem_3_) {
        return new ItemStack(this.getItem());
    }

    private Item getItem() {
        return this == Blocks.IRON_DOOR ? Items.IRON_DOOR : (this == Blocks.SPRUCE_DOOR ? Items.SPRUCE_DOOR : (this == Blocks.BIRCH_DOOR ? Items.BIRCH_DOOR : (this == Blocks.JUNGLE_DOOR ? Items.JUNGLE_DOOR : (this == Blocks.ACACIA_DOOR ? Items.ACACIA_DOOR : (this == Blocks.DARK_OAK_DOOR ? Items.DARK_OAK_DOOR : Items.OAK_DOOR)))));
    }

    @Override
    public void onBlockHarvested(World p_onBlockHarvested_1_, BlockPos p_onBlockHarvested_2_, IBlockState p_onBlockHarvested_3_, EntityPlayer p_onBlockHarvested_4_) {
        BlockPos blockpos = p_onBlockHarvested_2_.down();
        BlockPos blockpos1 = p_onBlockHarvested_2_.up();
        if (p_onBlockHarvested_4_.capabilities.isCreativeMode && p_onBlockHarvested_3_.getValue(HALF) == EnumDoorHalf.UPPER && p_onBlockHarvested_1_.getBlockState(blockpos).getBlock() == this) {
            p_onBlockHarvested_1_.setBlockToAir(blockpos);
        }
        if (p_onBlockHarvested_3_.getValue(HALF) == EnumDoorHalf.LOWER && p_onBlockHarvested_1_.getBlockState(blockpos1).getBlock() == this) {
            if (p_onBlockHarvested_4_.capabilities.isCreativeMode) {
                p_onBlockHarvested_1_.setBlockToAir(p_onBlockHarvested_2_);
            }
            p_onBlockHarvested_1_.setBlockToAir(blockpos1);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer getBlockLayer() {
        return BlockRenderLayer.CUTOUT;
    }

    @Override
    public IBlockState getActualState(IBlockState p_getActualState_1_, IBlockAccess p_getActualState_2_, BlockPos p_getActualState_3_) {
        if (p_getActualState_1_.getValue(HALF) == EnumDoorHalf.LOWER) {
            IBlockState iblockstate = p_getActualState_2_.getBlockState(p_getActualState_3_.up());
            if (iblockstate.getBlock() == this) {
                p_getActualState_1_ = p_getActualState_1_.withProperty(HINGE, iblockstate.getValue(HINGE)).withProperty(POWERED, iblockstate.getValue(POWERED));
            }
        } else {
            IBlockState iblockstate1 = p_getActualState_2_.getBlockState(p_getActualState_3_.down());
            if (iblockstate1.getBlock() == this) {
                p_getActualState_1_ = p_getActualState_1_.withProperty(FACING, iblockstate1.getValue(FACING)).withProperty(OPEN, iblockstate1.getValue(OPEN));
            }
        }
        return p_getActualState_1_;
    }

    @Override
    public IBlockState withRotation(IBlockState p_withRotation_1_, Rotation p_withRotation_2_) {
        return p_withRotation_1_.getValue(HALF) != EnumDoorHalf.LOWER ? p_withRotation_1_ : p_withRotation_1_.withProperty(FACING, p_withRotation_2_.rotate(p_withRotation_1_.getValue(FACING)));
    }

    @Override
    public IBlockState withMirror(IBlockState p_withMirror_1_, Mirror p_withMirror_2_) {
        return p_withMirror_2_ == Mirror.NONE ? p_withMirror_1_ : p_withMirror_1_.withRotation(p_withMirror_2_.toRotation(p_withMirror_1_.getValue(FACING))).cycleProperty(HINGE);
    }

    @Override
    public IBlockState getStateFromMeta(int p_getStateFromMeta_1_) {
        return (p_getStateFromMeta_1_ & 8) > 0 ? this.getDefaultState().withProperty(HALF, EnumDoorHalf.UPPER).withProperty(HINGE, (p_getStateFromMeta_1_ & 1) > 0 ? EnumHingePosition.RIGHT : EnumHingePosition.LEFT).withProperty(POWERED, (p_getStateFromMeta_1_ & 2) > 0) : this.getDefaultState().withProperty(HALF, EnumDoorHalf.LOWER).withProperty(FACING, EnumFacing.getHorizontal(p_getStateFromMeta_1_ & 3).rotateYCCW()).withProperty(OPEN, (p_getStateFromMeta_1_ & 4) > 0);
    }

    @Override
    public int getMetaFromState(IBlockState p_getMetaFromState_1_) {
        int i = 0;
        if (p_getMetaFromState_1_.getValue(HALF) == EnumDoorHalf.UPPER) {
            i |= 8;
            if (p_getMetaFromState_1_.getValue(HINGE) == EnumHingePosition.RIGHT) {
                i |= 1;
            }
            if (p_getMetaFromState_1_.getValue(POWERED).booleanValue()) {
                i |= 2;
            }
        } else {
            i |= p_getMetaFromState_1_.getValue(FACING).rotateY().getHorizontalIndex();
            if (p_getMetaFromState_1_.getValue(OPEN).booleanValue()) {
                i |= 4;
            }
        }
        return i;
    }

    protected static int removeHalfBit(int p_removeHalfBit_0_) {
        return p_removeHalfBit_0_ & 7;
    }

    public static boolean isOpen(IBlockAccess p_isOpen_0_, BlockPos p_isOpen_1_) {
        return BlockDoor.isOpen(BlockDoor.combineMetadata(p_isOpen_0_, p_isOpen_1_));
    }

    public static EnumFacing getFacing(IBlockAccess p_getFacing_0_, BlockPos p_getFacing_1_) {
        return BlockDoor.getFacing(BlockDoor.combineMetadata(p_getFacing_0_, p_getFacing_1_));
    }

    public static EnumFacing getFacing(int p_getFacing_0_) {
        return EnumFacing.getHorizontal(p_getFacing_0_ & 3).rotateYCCW();
    }

    protected static boolean isOpen(int p_isOpen_0_) {
        return (p_isOpen_0_ & 4) != 0;
    }

    protected static boolean isTop(int p_isTop_0_) {
        return (p_isTop_0_ & 8) != 0;
    }

    @Override
    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, HALF, FACING, OPEN, HINGE, POWERED);
    }

    public static enum EnumHingePosition implements IStringSerializable
    {
        LEFT,
        RIGHT;


        public String toString() {
            return this.getName();
        }

        @Override
        public String getName() {
            return this == LEFT ? "left" : "right";
        }
    }

    public static enum EnumDoorHalf implements IStringSerializable
    {
        UPPER,
        LOWER;


        public String toString() {
            return this.getName();
        }

        @Override
        public String getName() {
            return this == UPPER ? "upper" : "lower";
        }
    }
}

