/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockDoublePlant
extends BlockBush
implements IGrowable,
IShearable {
    public static final PropertyEnum<EnumPlantType> VARIANT = PropertyEnum.create("variant", EnumPlantType.class);
    public static final PropertyEnum<EnumBlockHalf> HALF = PropertyEnum.create("half", EnumBlockHalf.class);
    public static final PropertyEnum<EnumFacing> FACING = BlockHorizontal.FACING;

    public BlockDoublePlant() {
        super(Material.VINE);
        this.setDefaultState(this.blockState.getBaseState().withProperty(VARIANT, EnumPlantType.SUNFLOWER).withProperty(HALF, EnumBlockHalf.LOWER).withProperty(FACING, EnumFacing.NORTH));
        this.setHardness(0.0f);
        this.setSoundType(SoundType.PLANT);
        this.setUnlocalizedName("doublePlant");
    }

    @Override
    public AxisAlignedBB getBoundingBox(IBlockState p_getBoundingBox_1_, IBlockAccess p_getBoundingBox_2_, BlockPos p_getBoundingBox_3_) {
        return FULL_BLOCK_AABB;
    }

    private EnumPlantType getType(IBlockAccess p_getType_1_, BlockPos p_getType_2_, IBlockState p_getType_3_) {
        if (p_getType_3_.getBlock() == this) {
            p_getType_3_ = p_getType_3_.getActualState(p_getType_1_, p_getType_2_);
            return p_getType_3_.getValue(VARIANT);
        }
        return EnumPlantType.FERN;
    }

    @Override
    public boolean canPlaceBlockAt(World p_canPlaceBlockAt_1_, BlockPos p_canPlaceBlockAt_2_) {
        return super.canPlaceBlockAt(p_canPlaceBlockAt_1_, p_canPlaceBlockAt_2_) && p_canPlaceBlockAt_1_.isAirBlock(p_canPlaceBlockAt_2_.up());
    }

    @Override
    public boolean isReplaceable(IBlockAccess p_isReplaceable_1_, BlockPos p_isReplaceable_2_) {
        IBlockState iblockstate = p_isReplaceable_1_.getBlockState(p_isReplaceable_2_);
        if (iblockstate.getBlock() != this) {
            return true;
        }
        EnumPlantType blockdoubleplant$enumplanttype = iblockstate.getActualState(p_isReplaceable_1_, p_isReplaceable_2_).getValue(VARIANT);
        return blockdoubleplant$enumplanttype == EnumPlantType.FERN || blockdoubleplant$enumplanttype == EnumPlantType.GRASS;
    }

    @Override
    protected void checkAndDropBlock(World p_checkAndDropBlock_1_, BlockPos p_checkAndDropBlock_2_, IBlockState p_checkAndDropBlock_3_) {
        if (!this.canBlockStay(p_checkAndDropBlock_1_, p_checkAndDropBlock_2_, p_checkAndDropBlock_3_)) {
            BlockDoublePlant block1;
            boolean flag = p_checkAndDropBlock_3_.getValue(HALF) == EnumBlockHalf.UPPER;
            BlockPos blockpos = flag ? p_checkAndDropBlock_2_ : p_checkAndDropBlock_2_.up();
            BlockPos blockpos1 = flag ? p_checkAndDropBlock_2_.down() : p_checkAndDropBlock_2_;
            BlockDoublePlant block = flag ? this : p_checkAndDropBlock_1_.getBlockState(blockpos).getBlock();
            Block block2 = block1 = flag ? p_checkAndDropBlock_1_.getBlockState(blockpos1).getBlock() : this;
            if (!flag) {
                this.dropBlockAsItem(p_checkAndDropBlock_1_, p_checkAndDropBlock_2_, p_checkAndDropBlock_3_, 0);
            }
            if (block == this) {
                p_checkAndDropBlock_1_.setBlockState(blockpos, Blocks.AIR.getDefaultState(), 2);
            }
            if (block1 == this) {
                p_checkAndDropBlock_1_.setBlockState(blockpos1, Blocks.AIR.getDefaultState(), 3);
            }
        }
    }

    @Override
    public boolean canBlockStay(World p_canBlockStay_1_, BlockPos p_canBlockStay_2_, IBlockState p_canBlockStay_3_) {
        if (p_canBlockStay_3_.getBlock() != this) {
            return super.canBlockStay(p_canBlockStay_1_, p_canBlockStay_2_, p_canBlockStay_3_);
        }
        if (p_canBlockStay_3_.getValue(HALF) == EnumBlockHalf.UPPER) {
            return p_canBlockStay_1_.getBlockState(p_canBlockStay_2_.down()).getBlock() == this;
        }
        IBlockState iblockstate = p_canBlockStay_1_.getBlockState(p_canBlockStay_2_.up());
        return iblockstate.getBlock() == this && super.canBlockStay(p_canBlockStay_1_, p_canBlockStay_2_, iblockstate);
    }

    @Override
    public Item getItemDropped(IBlockState p_getItemDropped_1_, Random p_getItemDropped_2_, int p_getItemDropped_3_) {
        if (p_getItemDropped_1_.getValue(HALF) == EnumBlockHalf.UPPER) {
            return Items.AIR;
        }
        EnumPlantType blockdoubleplant$enumplanttype = p_getItemDropped_1_.getValue(VARIANT);
        return blockdoubleplant$enumplanttype == EnumPlantType.FERN ? Items.AIR : (blockdoubleplant$enumplanttype == EnumPlantType.GRASS ? (p_getItemDropped_2_.nextInt(8) == 0 ? Items.WHEAT_SEEDS : Items.AIR) : super.getItemDropped(p_getItemDropped_1_, p_getItemDropped_2_, p_getItemDropped_3_));
    }

    @Override
    public int damageDropped(IBlockState p_damageDropped_1_) {
        return p_damageDropped_1_.getValue(HALF) != EnumBlockHalf.UPPER && p_damageDropped_1_.getValue(VARIANT) != EnumPlantType.GRASS ? p_damageDropped_1_.getValue(VARIANT).getMeta() : 0;
    }

    public void placeAt(World p_placeAt_1_, BlockPos p_placeAt_2_, EnumPlantType p_placeAt_3_, int p_placeAt_4_) {
        p_placeAt_1_.setBlockState(p_placeAt_2_, this.getDefaultState().withProperty(HALF, EnumBlockHalf.LOWER).withProperty(VARIANT, p_placeAt_3_), p_placeAt_4_);
        p_placeAt_1_.setBlockState(p_placeAt_2_.up(), this.getDefaultState().withProperty(HALF, EnumBlockHalf.UPPER), p_placeAt_4_);
    }

    @Override
    public void onBlockPlacedBy(World p_onBlockPlacedBy_1_, BlockPos p_onBlockPlacedBy_2_, IBlockState p_onBlockPlacedBy_3_, EntityLivingBase p_onBlockPlacedBy_4_, ItemStack p_onBlockPlacedBy_5_) {
        p_onBlockPlacedBy_1_.setBlockState(p_onBlockPlacedBy_2_.up(), this.getDefaultState().withProperty(HALF, EnumBlockHalf.UPPER), 2);
    }

    @Override
    public void harvestBlock(World p_harvestBlock_1_, EntityPlayer p_harvestBlock_2_, BlockPos p_harvestBlock_3_, IBlockState p_harvestBlock_4_, TileEntity p_harvestBlock_5_, ItemStack p_harvestBlock_6_) {
        super.harvestBlock(p_harvestBlock_1_, p_harvestBlock_2_, p_harvestBlock_3_, p_harvestBlock_4_, p_harvestBlock_5_, p_harvestBlock_6_);
    }

    @Override
    public void onBlockHarvested(World p_onBlockHarvested_1_, BlockPos p_onBlockHarvested_2_, IBlockState p_onBlockHarvested_3_, EntityPlayer p_onBlockHarvested_4_) {
        if (p_onBlockHarvested_3_.getValue(HALF) == EnumBlockHalf.UPPER) {
            if (p_onBlockHarvested_1_.getBlockState(p_onBlockHarvested_2_.down()).getBlock() == this) {
                if (p_onBlockHarvested_4_.capabilities.isCreativeMode) {
                    p_onBlockHarvested_1_.setBlockToAir(p_onBlockHarvested_2_.down());
                } else {
                    IBlockState iblockstate = p_onBlockHarvested_1_.getBlockState(p_onBlockHarvested_2_.down());
                    EnumPlantType blockdoubleplant$enumplanttype = iblockstate.getValue(VARIANT);
                    if (blockdoubleplant$enumplanttype != EnumPlantType.FERN && blockdoubleplant$enumplanttype != EnumPlantType.GRASS) {
                        p_onBlockHarvested_1_.destroyBlock(p_onBlockHarvested_2_.down(), true);
                    } else if (p_onBlockHarvested_1_.isRemote) {
                        p_onBlockHarvested_1_.setBlockToAir(p_onBlockHarvested_2_.down());
                    } else if (!p_onBlockHarvested_4_.getHeldItemMainhand().isEmpty() && p_onBlockHarvested_4_.getHeldItemMainhand().getItem() == Items.SHEARS) {
                        this.onHarvest(p_onBlockHarvested_1_, p_onBlockHarvested_2_, iblockstate, p_onBlockHarvested_4_);
                        p_onBlockHarvested_1_.setBlockToAir(p_onBlockHarvested_2_.down());
                    } else {
                        p_onBlockHarvested_1_.destroyBlock(p_onBlockHarvested_2_.down(), true);
                    }
                }
            }
        } else if (p_onBlockHarvested_1_.getBlockState(p_onBlockHarvested_2_.up()).getBlock() == this) {
            p_onBlockHarvested_1_.setBlockState(p_onBlockHarvested_2_.up(), Blocks.AIR.getDefaultState(), 2);
        }
        super.onBlockHarvested(p_onBlockHarvested_1_, p_onBlockHarvested_2_, p_onBlockHarvested_3_, p_onBlockHarvested_4_);
    }

    private boolean onHarvest(World p_onHarvest_1_, BlockPos p_onHarvest_2_, IBlockState p_onHarvest_3_, EntityPlayer p_onHarvest_4_) {
        EnumPlantType blockdoubleplant$enumplanttype = p_onHarvest_3_.getValue(VARIANT);
        if (blockdoubleplant$enumplanttype != EnumPlantType.FERN && blockdoubleplant$enumplanttype != EnumPlantType.GRASS) {
            return false;
        }
        p_onHarvest_4_.addStat(StatList.getBlockStats(this));
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getSubBlocks(Item p_getSubBlocks_1_, CreativeTabs p_getSubBlocks_2_, NonNullList<ItemStack> p_getSubBlocks_3_) {
        for (EnumPlantType blockdoubleplant$enumplanttype : EnumPlantType.values()) {
            p_getSubBlocks_3_.add(new ItemStack(p_getSubBlocks_1_, 1, blockdoubleplant$enumplanttype.getMeta()));
        }
    }

    @Override
    public ItemStack getItem(World p_getItem_1_, BlockPos p_getItem_2_, IBlockState p_getItem_3_) {
        return new ItemStack(this, 1, this.getType(p_getItem_1_, p_getItem_2_, p_getItem_3_).getMeta());
    }

    @Override
    public boolean canGrow(World p_canGrow_1_, BlockPos p_canGrow_2_, IBlockState p_canGrow_3_, boolean p_canGrow_4_) {
        EnumPlantType blockdoubleplant$enumplanttype = this.getType(p_canGrow_1_, p_canGrow_2_, p_canGrow_3_);
        return blockdoubleplant$enumplanttype != EnumPlantType.GRASS && blockdoubleplant$enumplanttype != EnumPlantType.FERN;
    }

    @Override
    public boolean canUseBonemeal(World p_canUseBonemeal_1_, Random p_canUseBonemeal_2_, BlockPos p_canUseBonemeal_3_, IBlockState p_canUseBonemeal_4_) {
        return true;
    }

    @Override
    public void grow(World p_grow_1_, Random p_grow_2_, BlockPos p_grow_3_, IBlockState p_grow_4_) {
        BlockDoublePlant.spawnAsEntity(p_grow_1_, p_grow_3_, new ItemStack(this, 1, this.getType(p_grow_1_, p_grow_3_, p_grow_4_).getMeta()));
    }

    @Override
    public IBlockState getStateFromMeta(int p_getStateFromMeta_1_) {
        return (p_getStateFromMeta_1_ & 8) > 0 ? this.getDefaultState().withProperty(HALF, EnumBlockHalf.UPPER) : this.getDefaultState().withProperty(HALF, EnumBlockHalf.LOWER).withProperty(VARIANT, EnumPlantType.byMetadata(p_getStateFromMeta_1_ & 7));
    }

    @Override
    public IBlockState getActualState(IBlockState p_getActualState_1_, IBlockAccess p_getActualState_2_, BlockPos p_getActualState_3_) {
        IBlockState iblockstate;
        if (p_getActualState_1_.getValue(HALF) == EnumBlockHalf.UPPER && (iblockstate = p_getActualState_2_.getBlockState(p_getActualState_3_.down())).getBlock() == this) {
            p_getActualState_1_ = p_getActualState_1_.withProperty(VARIANT, iblockstate.getValue(VARIANT));
        }
        return p_getActualState_1_;
    }

    @Override
    public int getMetaFromState(IBlockState p_getMetaFromState_1_) {
        return p_getMetaFromState_1_.getValue(HALF) == EnumBlockHalf.UPPER ? 8 | p_getMetaFromState_1_.getValue(FACING).getHorizontalIndex() : p_getMetaFromState_1_.getValue(VARIANT).getMeta();
    }

    @Override
    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, HALF, VARIANT, FACING);
    }

    @Override
    public Block.EnumOffsetType getOffsetType() {
        return Block.EnumOffsetType.XZ;
    }

    @Override
    public boolean isShearable(ItemStack p_isShearable_1_, IBlockAccess p_isShearable_2_, BlockPos p_isShearable_3_) {
        IBlockState state = p_isShearable_2_.getBlockState(p_isShearable_3_);
        EnumPlantType type = state.getValue(VARIANT);
        return state.getValue(HALF) == EnumBlockHalf.LOWER && (type == EnumPlantType.FERN || type == EnumPlantType.GRASS);
    }

    @Override
    public List<ItemStack> onSheared(ItemStack p_onSheared_1_, IBlockAccess p_onSheared_2_, BlockPos p_onSheared_3_, int p_onSheared_4_) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        EnumPlantType type = p_onSheared_2_.getBlockState(p_onSheared_3_).getValue(VARIANT);
        if (type == EnumPlantType.FERN) {
            ret.add(new ItemStack(Blocks.TALLGRASS, 2, BlockTallGrass.EnumType.FERN.getMeta()));
        }
        if (type == EnumPlantType.GRASS) {
            ret.add(new ItemStack(Blocks.TALLGRASS, 2, BlockTallGrass.EnumType.GRASS.getMeta()));
        }
        return ret;
    }

    @Override
    public boolean removedByPlayer(IBlockState p_removedByPlayer_1_, World p_removedByPlayer_2_, BlockPos p_removedByPlayer_3_, EntityPlayer p_removedByPlayer_4_, boolean p_removedByPlayer_5_) {
        if (p_removedByPlayer_1_.getBlock() == this && p_removedByPlayer_1_.getValue(HALF) == EnumBlockHalf.LOWER && p_removedByPlayer_2_.getBlockState(p_removedByPlayer_3_.up()).getBlock() == this) {
            p_removedByPlayer_2_.setBlockToAir(p_removedByPlayer_3_.up());
        }
        return p_removedByPlayer_2_.setBlockToAir(p_removedByPlayer_3_);
    }

    public static enum EnumPlantType implements IStringSerializable
    {
        SUNFLOWER(0, "sunflower"),
        SYRINGA(1, "syringa"),
        GRASS(2, "double_grass", "grass"),
        FERN(3, "double_fern", "fern"),
        ROSE(4, "double_rose", "rose"),
        PAEONIA(5, "paeonia");

        private static final EnumPlantType[] META_LOOKUP;
        private final int meta;
        private final String name;
        private final String unlocalizedName;

        private EnumPlantType(int p_i45722_3_, String p_i45722_4_) {
            this(p_i45722_3_, p_i45722_4_, p_i45722_4_);
        }

        private EnumPlantType(int p_i45723_3_, String p_i45723_4_, String p_i45723_5_) {
            this.meta = p_i45723_3_;
            this.name = p_i45723_4_;
            this.unlocalizedName = p_i45723_5_;
        }

        public int getMeta() {
            return this.meta;
        }

        public String toString() {
            return this.name;
        }

        public static EnumPlantType byMetadata(int p_byMetadata_0_) {
            if (p_byMetadata_0_ < 0 || p_byMetadata_0_ >= META_LOOKUP.length) {
                p_byMetadata_0_ = 0;
            }
            return META_LOOKUP[p_byMetadata_0_];
        }

        @Override
        public String getName() {
            return this.name;
        }

        public String getUnlocalizedName() {
            return this.unlocalizedName;
        }

        static {
            META_LOOKUP = new EnumPlantType[EnumPlantType.values().length];
            EnumPlantType[] enumPlantTypeArray = EnumPlantType.values();
            int n = enumPlantTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumPlantType blockdoubleplant$enumplanttype;
                EnumPlantType.META_LOOKUP[blockdoubleplant$enumplanttype.getMeta()] = blockdoubleplant$enumplanttype = enumPlantTypeArray[i];
            }
        }
    }

    public static enum EnumBlockHalf implements IStringSerializable
    {
        UPPER,
        LOWER;


        public String toString() {
            return this.getName();
        }

        @Override
        public String getName() {
            return this == UPPER ? "upper" : "lower";
        }
    }
}

