/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockDragonEgg
extends Block {
    protected static final AxisAlignedBB DRAGON_EGG_AABB = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 1.0, 0.9375);

    public BlockDragonEgg() {
        super(Material.DRAGON_EGG, MapColor.BLACK);
    }

    @Override
    public AxisAlignedBB getBoundingBox(IBlockState p_getBoundingBox_1_, IBlockAccess p_getBoundingBox_2_, BlockPos p_getBoundingBox_3_) {
        return DRAGON_EGG_AABB;
    }

    @Override
    public void onBlockAdded(World p_onBlockAdded_1_, BlockPos p_onBlockAdded_2_, IBlockState p_onBlockAdded_3_) {
        p_onBlockAdded_1_.scheduleUpdate(p_onBlockAdded_2_, this, this.tickRate(p_onBlockAdded_1_));
    }

    @Override
    public void neighborChanged(IBlockState p_neighborChanged_1_, World p_neighborChanged_2_, BlockPos p_neighborChanged_3_, Block p_neighborChanged_4_, BlockPos p_neighborChanged_5_) {
        p_neighborChanged_2_.scheduleUpdate(p_neighborChanged_3_, this, this.tickRate(p_neighborChanged_2_));
    }

    @Override
    public void updateTick(World p_updateTick_1_, BlockPos p_updateTick_2_, IBlockState p_updateTick_3_, Random p_updateTick_4_) {
        this.checkFall(p_updateTick_1_, p_updateTick_2_);
    }

    private void checkFall(World p_checkFall_1_, BlockPos p_checkFall_2_) {
        if (p_checkFall_1_.isAirBlock(p_checkFall_2_.down()) && BlockFalling.canFallThrough(p_checkFall_1_.getBlockState(p_checkFall_2_.down())) && p_checkFall_2_.getY() >= 0) {
            int i = 32;
            if (!BlockFalling.fallInstantly && p_checkFall_1_.isAreaLoaded(p_checkFall_2_.add(-32, -32, -32), p_checkFall_2_.add(32, 32, 32))) {
                p_checkFall_1_.spawnEntity(new EntityFallingBlock(p_checkFall_1_, (float)p_checkFall_2_.getX() + 0.5f, p_checkFall_2_.getY(), (float)p_checkFall_2_.getZ() + 0.5f, this.getDefaultState()));
            } else {
                p_checkFall_1_.setBlockToAir(p_checkFall_2_);
                BlockPos blockpos = p_checkFall_2_;
                while (p_checkFall_1_.isAirBlock(blockpos) && BlockFalling.canFallThrough(p_checkFall_1_.getBlockState(blockpos)) && blockpos.getY() > 0) {
                    blockpos = blockpos.down();
                }
                if (blockpos.getY() > 0) {
                    p_checkFall_1_.setBlockState(blockpos, this.getDefaultState(), 2);
                }
            }
        }
    }

    @Override
    public boolean onBlockActivated(World p_onBlockActivated_1_, BlockPos p_onBlockActivated_2_, IBlockState p_onBlockActivated_3_, EntityPlayer p_onBlockActivated_4_, EnumHand p_onBlockActivated_5_, EnumFacing p_onBlockActivated_6_, float p_onBlockActivated_7_, float p_onBlockActivated_8_, float p_onBlockActivated_9_) {
        this.teleport(p_onBlockActivated_1_, p_onBlockActivated_2_);
        return true;
    }

    @Override
    public void onBlockClicked(World p_onBlockClicked_1_, BlockPos p_onBlockClicked_2_, EntityPlayer p_onBlockClicked_3_) {
        this.teleport(p_onBlockClicked_1_, p_onBlockClicked_2_);
    }

    private void teleport(World p_teleport_1_, BlockPos p_teleport_2_) {
        IBlockState iblockstate = p_teleport_1_.getBlockState(p_teleport_2_);
        if (iblockstate.getBlock() == this) {
            for (int i = 0; i < 1000; ++i) {
                BlockPos blockpos = p_teleport_2_.add(p_teleport_1_.rand.nextInt(16) - p_teleport_1_.rand.nextInt(16), p_teleport_1_.rand.nextInt(8) - p_teleport_1_.rand.nextInt(8), p_teleport_1_.rand.nextInt(16) - p_teleport_1_.rand.nextInt(16));
                if (p_teleport_1_.getBlockState((BlockPos)blockpos).getBlock().blockMaterial != Material.AIR) continue;
                if (p_teleport_1_.isRemote) {
                    for (int j = 0; j < 128; ++j) {
                        double d0 = p_teleport_1_.rand.nextDouble();
                        float f = (p_teleport_1_.rand.nextFloat() - 0.5f) * 0.2f;
                        float f1 = (p_teleport_1_.rand.nextFloat() - 0.5f) * 0.2f;
                        float f2 = (p_teleport_1_.rand.nextFloat() - 0.5f) * 0.2f;
                        double d1 = (double)blockpos.getX() + (double)(p_teleport_2_.getX() - blockpos.getX()) * d0 + (p_teleport_1_.rand.nextDouble() - 0.5) + 0.5;
                        double d2 = (double)blockpos.getY() + (double)(p_teleport_2_.getY() - blockpos.getY()) * d0 + p_teleport_1_.rand.nextDouble() - 0.5;
                        double d3 = (double)blockpos.getZ() + (double)(p_teleport_2_.getZ() - blockpos.getZ()) * d0 + (p_teleport_1_.rand.nextDouble() - 0.5) + 0.5;
                        p_teleport_1_.spawnParticle(EnumParticleTypes.PORTAL, d1, d2, d3, (double)f, (double)f1, (double)f2, new int[0]);
                    }
                } else {
                    p_teleport_1_.setBlockState(blockpos, iblockstate, 2);
                    p_teleport_1_.setBlockToAir(p_teleport_2_);
                }
                return;
            }
        }
    }

    @Override
    public int tickRate(World p_tickRate_1_) {
        return 5;
    }

    @Override
    public boolean isOpaqueCube(IBlockState p_isOpaqueCube_1_) {
        return false;
    }

    @Override
    public boolean isFullCube(IBlockState p_isFullCube_1_) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(IBlockState p_shouldSideBeRendered_1_, IBlockAccess p_shouldSideBeRendered_2_, BlockPos p_shouldSideBeRendered_3_, EnumFacing p_shouldSideBeRendered_4_) {
        return true;
    }
}

