/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import net.minecraft.block.BlockDispenser;
import net.minecraft.block.BlockSourceImpl;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.tileentity.TileEntityDropper;
import net.minecraft.tileentity.TileEntityHopper;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.VanillaInventoryCodeHooks;

public class BlockDropper
extends BlockDispenser {
    private final IBehaviorDispenseItem dropBehavior = new BehaviorDefaultDispenseItem();

    @Override
    protected IBehaviorDispenseItem getBehavior(ItemStack p_getBehavior_1_) {
        return this.dropBehavior;
    }

    @Override
    public TileEntity createNewTileEntity(World p_createNewTileEntity_1_, int p_createNewTileEntity_2_) {
        return new TileEntityDropper();
    }

    @Override
    protected void dispense(World p_dispense_1_, BlockPos p_dispense_2_) {
        BlockSourceImpl blocksourceimpl = new BlockSourceImpl(p_dispense_1_, p_dispense_2_);
        TileEntityDispenser tileentitydispenser = (TileEntityDispenser)blocksourceimpl.getBlockTileEntity();
        if (tileentitydispenser != null) {
            int i = tileentitydispenser.getDispenseSlot();
            if (i < 0) {
                p_dispense_1_.playEvent(1001, p_dispense_2_, 0);
            } else {
                ItemStack itemstack = tileentitydispenser.getStackInSlot(i);
                if (!itemstack.isEmpty() && VanillaInventoryCodeHooks.dropperInsertHook(p_dispense_1_, p_dispense_2_, tileentitydispenser, i, itemstack)) {
                    ItemStack itemstack1;
                    EnumFacing enumfacing = p_dispense_1_.getBlockState(p_dispense_2_).getValue(FACING);
                    BlockPos blockpos = p_dispense_2_.offset(enumfacing);
                    IInventory iinventory = TileEntityHopper.getInventoryAtPosition(p_dispense_1_, blockpos.getX(), blockpos.getY(), blockpos.getZ());
                    if (iinventory == null) {
                        itemstack1 = this.dropBehavior.dispense(blocksourceimpl, itemstack);
                    } else {
                        itemstack1 = TileEntityHopper.putStackInInventoryAllSlots(tileentitydispenser, iinventory, itemstack.copy().splitStack(1), enumfacing.getOpposite());
                        if (itemstack1.isEmpty()) {
                            itemstack1 = itemstack.copy();
                            itemstack1.shrink(1);
                        } else {
                            itemstack1 = itemstack.copy();
                        }
                    }
                    tileentitydispenser.setInventorySlotContents(i, itemstack1);
                }
            }
        }
    }
}

