/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.EnumSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class BlockDynamicLiquid
extends BlockLiquid {
    int adjacentSourceBlocks;

    protected BlockDynamicLiquid(Material p_i45403_1_) {
        super(p_i45403_1_);
    }

    private void placeStaticBlock(World p_placeStaticBlock_1_, BlockPos p_placeStaticBlock_2_, IBlockState p_placeStaticBlock_3_) {
        p_placeStaticBlock_1_.setBlockState(p_placeStaticBlock_2_, BlockDynamicLiquid.getStaticBlock(this.blockMaterial).getDefaultState().withProperty(LEVEL, p_placeStaticBlock_3_.getValue(LEVEL)), 2);
    }

    @Override
    public void updateTick(World p_updateTick_1_, BlockPos p_updateTick_2_, IBlockState p_updateTick_3_, Random p_updateTick_4_) {
        int i = p_updateTick_3_.getValue(LEVEL);
        int j = 1;
        if (this.blockMaterial == Material.LAVA && !p_updateTick_1_.provider.doesWaterVaporize()) {
            j = 2;
        }
        int k = this.tickRate(p_updateTick_1_);
        if (i > 0) {
            int j1;
            int l = -100;
            this.adjacentSourceBlocks = 0;
            for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
                l = this.checkAdjacentBlock(p_updateTick_1_, p_updateTick_2_.offset(enumfacing), l);
            }
            int i1 = l + j;
            if (i1 >= 8 || l < 0) {
                i1 = -1;
            }
            if ((j1 = this.getDepth(p_updateTick_1_.getBlockState(p_updateTick_2_.up()))) >= 0) {
                i1 = j1 >= 8 ? j1 : j1 + 8;
            }
            if (this.adjacentSourceBlocks >= 2 && ForgeEventFactory.canCreateFluidSource(p_updateTick_1_, p_updateTick_2_, p_updateTick_3_, this.blockMaterial == Material.WATER)) {
                IBlockState iblockstate = p_updateTick_1_.getBlockState(p_updateTick_2_.down());
                if (iblockstate.getMaterial().isSolid()) {
                    i1 = 0;
                } else if (iblockstate.getMaterial() == this.blockMaterial && iblockstate.getValue(LEVEL) == 0) {
                    i1 = 0;
                }
            }
            if (this.blockMaterial == Material.LAVA && i < 8 && i1 < 8 && i1 > i && p_updateTick_4_.nextInt(4) != 0) {
                k *= 4;
            }
            if (i1 == i) {
                this.placeStaticBlock(p_updateTick_1_, p_updateTick_2_, p_updateTick_3_);
            } else {
                i = i1;
                if (i1 < 0) {
                    p_updateTick_1_.setBlockToAir(p_updateTick_2_);
                } else {
                    p_updateTick_3_ = p_updateTick_3_.withProperty(LEVEL, i1);
                    p_updateTick_1_.setBlockState(p_updateTick_2_, p_updateTick_3_, 2);
                    p_updateTick_1_.scheduleUpdate(p_updateTick_2_, this, k);
                    p_updateTick_1_.notifyNeighborsOfStateChange(p_updateTick_2_, this, false);
                }
            }
        } else {
            this.placeStaticBlock(p_updateTick_1_, p_updateTick_2_, p_updateTick_3_);
        }
        IBlockState iblockstate1 = p_updateTick_1_.getBlockState(p_updateTick_2_.down());
        if (this.canFlowInto(p_updateTick_1_, p_updateTick_2_.down(), iblockstate1)) {
            if (this.blockMaterial == Material.LAVA && p_updateTick_1_.getBlockState(p_updateTick_2_.down()).getMaterial() == Material.WATER) {
                p_updateTick_1_.setBlockState(p_updateTick_2_.down(), Blocks.STONE.getDefaultState());
                this.triggerMixEffects(p_updateTick_1_, p_updateTick_2_.down());
                return;
            }
            if (i >= 8) {
                this.tryFlowInto(p_updateTick_1_, p_updateTick_2_.down(), iblockstate1, i);
            } else {
                this.tryFlowInto(p_updateTick_1_, p_updateTick_2_.down(), iblockstate1, i + 8);
            }
        } else if (i >= 0 && (i == 0 || this.isBlocked(p_updateTick_1_, p_updateTick_2_.down(), iblockstate1))) {
            Set<EnumFacing> set = this.getPossibleFlowDirections(p_updateTick_1_, p_updateTick_2_);
            int k1 = i + j;
            if (i >= 8) {
                k1 = 1;
            }
            if (k1 >= 8) {
                return;
            }
            for (EnumFacing enumfacing1 : set) {
                this.tryFlowInto(p_updateTick_1_, p_updateTick_2_.offset(enumfacing1), p_updateTick_1_.getBlockState(p_updateTick_2_.offset(enumfacing1)), k1);
            }
        }
    }

    private void tryFlowInto(World p_tryFlowInto_1_, BlockPos p_tryFlowInto_2_, IBlockState p_tryFlowInto_3_, int p_tryFlowInto_4_) {
        if (this.canFlowInto(p_tryFlowInto_1_, p_tryFlowInto_2_, p_tryFlowInto_3_)) {
            if (p_tryFlowInto_3_.getMaterial() != Material.AIR) {
                if (this.blockMaterial == Material.LAVA) {
                    this.triggerMixEffects(p_tryFlowInto_1_, p_tryFlowInto_2_);
                } else if (p_tryFlowInto_3_.getBlock() != Blocks.SNOW_LAYER) {
                    p_tryFlowInto_3_.getBlock().dropBlockAsItem(p_tryFlowInto_1_, p_tryFlowInto_2_, p_tryFlowInto_3_, 0);
                }
            }
            p_tryFlowInto_1_.setBlockState(p_tryFlowInto_2_, this.getDefaultState().withProperty(LEVEL, p_tryFlowInto_4_), 3);
        }
    }

    private int getSlopeDistance(World p_getSlopeDistance_1_, BlockPos p_getSlopeDistance_2_, int p_getSlopeDistance_3_, EnumFacing p_getSlopeDistance_4_) {
        int i = 1000;
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            int j;
            IBlockState iblockstate;
            BlockPos blockpos;
            if (enumfacing == p_getSlopeDistance_4_ || this.isBlocked(p_getSlopeDistance_1_, blockpos = p_getSlopeDistance_2_.offset(enumfacing), iblockstate = p_getSlopeDistance_1_.getBlockState(blockpos)) || iblockstate.getMaterial() == this.blockMaterial && iblockstate.getValue(LEVEL) <= 0) continue;
            if (!this.isBlocked(p_getSlopeDistance_1_, blockpos.down(), iblockstate)) {
                return p_getSlopeDistance_3_;
            }
            if (p_getSlopeDistance_3_ >= this.getSlopeFindDistance(p_getSlopeDistance_1_) || (j = this.getSlopeDistance(p_getSlopeDistance_1_, blockpos, p_getSlopeDistance_3_ + 1, enumfacing.getOpposite())) >= i) continue;
            i = j;
        }
        return i;
    }

    private int getSlopeFindDistance(World p_getSlopeFindDistance_1_) {
        return this.blockMaterial == Material.LAVA && !p_getSlopeFindDistance_1_.provider.doesWaterVaporize() ? 2 : 4;
    }

    private Set<EnumFacing> getPossibleFlowDirections(World p_getPossibleFlowDirections_1_, BlockPos p_getPossibleFlowDirections_2_) {
        int i = 1000;
        EnumSet<EnumFacing> set = EnumSet.noneOf(EnumFacing.class);
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            IBlockState iblockstate;
            BlockPos blockpos = p_getPossibleFlowDirections_2_.offset(enumfacing);
            if (this.isBlocked(p_getPossibleFlowDirections_1_, blockpos, iblockstate = p_getPossibleFlowDirections_1_.getBlockState(blockpos)) || iblockstate.getMaterial() == this.blockMaterial && iblockstate.getValue(LEVEL) <= 0) continue;
            int j = this.isBlocked(p_getPossibleFlowDirections_1_, blockpos.down(), p_getPossibleFlowDirections_1_.getBlockState(blockpos.down())) ? this.getSlopeDistance(p_getPossibleFlowDirections_1_, blockpos, 1, enumfacing.getOpposite()) : 0;
            if (j < i) {
                set.clear();
            }
            if (j > i) continue;
            set.add(enumfacing);
            i = j;
        }
        return set;
    }

    private boolean isBlocked(World p_isBlocked_1_, BlockPos p_isBlocked_2_, IBlockState p_isBlocked_3_) {
        Block block = p_isBlocked_1_.getBlockState(p_isBlocked_2_).getBlock();
        return !(block instanceof BlockDoor) && block != Blocks.STANDING_SIGN && block != Blocks.LADDER && block != Blocks.REEDS ? (block.blockMaterial != Material.PORTAL && block.blockMaterial != Material.STRUCTURE_VOID ? block.blockMaterial.blocksMovement() : true) : true;
    }

    protected int checkAdjacentBlock(World p_checkAdjacentBlock_1_, BlockPos p_checkAdjacentBlock_2_, int p_checkAdjacentBlock_3_) {
        int i = this.getDepth(p_checkAdjacentBlock_1_.getBlockState(p_checkAdjacentBlock_2_));
        if (i < 0) {
            return p_checkAdjacentBlock_3_;
        }
        if (i == 0) {
            ++this.adjacentSourceBlocks;
        }
        if (i >= 8) {
            i = 0;
        }
        return p_checkAdjacentBlock_3_ >= 0 && i >= p_checkAdjacentBlock_3_ ? p_checkAdjacentBlock_3_ : i;
    }

    private boolean canFlowInto(World p_canFlowInto_1_, BlockPos p_canFlowInto_2_, IBlockState p_canFlowInto_3_) {
        Material material = p_canFlowInto_3_.getMaterial();
        return material != this.blockMaterial && material != Material.LAVA && !this.isBlocked(p_canFlowInto_1_, p_canFlowInto_2_, p_canFlowInto_3_);
    }

    @Override
    public void onBlockAdded(World p_onBlockAdded_1_, BlockPos p_onBlockAdded_2_, IBlockState p_onBlockAdded_3_) {
        if (!this.checkForMixing(p_onBlockAdded_1_, p_onBlockAdded_2_, p_onBlockAdded_3_)) {
            p_onBlockAdded_1_.scheduleUpdate(p_onBlockAdded_2_, this, this.tickRate(p_onBlockAdded_1_));
        }
    }
}

