/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityEnchantmentTable;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockEnchantmentTable
extends BlockContainer {
    protected static final AxisAlignedBB AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.75, 1.0);

    protected BlockEnchantmentTable() {
        super(Material.ROCK, MapColor.RED);
        this.setLightOpacity(0);
        this.setCreativeTab(CreativeTabs.DECORATIONS);
    }

    @Override
    public AxisAlignedBB getBoundingBox(IBlockState p_getBoundingBox_1_, IBlockAccess p_getBoundingBox_2_, BlockPos p_getBoundingBox_3_) {
        return AABB;
    }

    @Override
    public boolean isFullCube(IBlockState p_isFullCube_1_) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(IBlockState p_randomDisplayTick_1_, World p_randomDisplayTick_2_, BlockPos p_randomDisplayTick_3_, Random p_randomDisplayTick_4_) {
        super.randomDisplayTick(p_randomDisplayTick_1_, p_randomDisplayTick_2_, p_randomDisplayTick_3_, p_randomDisplayTick_4_);
        for (int i = -2; i <= 2; ++i) {
            block1: for (int j = -2; j <= 2; ++j) {
                if (i > -2 && i < 2 && j == -1) {
                    j = 2;
                }
                if (p_randomDisplayTick_4_.nextInt(16) != 0) continue;
                for (int k = 0; k <= 1; ++k) {
                    BlockPos blockpos = p_randomDisplayTick_3_.add(i, k, j);
                    if (!(ForgeHooks.getEnchantPower(p_randomDisplayTick_2_, blockpos) > 0.0f)) continue;
                    if (!p_randomDisplayTick_2_.isAirBlock(p_randomDisplayTick_3_.add(i / 2, 0, j / 2))) continue block1;
                    p_randomDisplayTick_2_.spawnParticle(EnumParticleTypes.ENCHANTMENT_TABLE, (double)p_randomDisplayTick_3_.getX() + 0.5, (double)p_randomDisplayTick_3_.getY() + 2.0, (double)p_randomDisplayTick_3_.getZ() + 0.5, (double)((float)i + p_randomDisplayTick_4_.nextFloat()) - 0.5, (double)((float)k - p_randomDisplayTick_4_.nextFloat() - 1.0f), (double)((float)j + p_randomDisplayTick_4_.nextFloat()) - 0.5, new int[0]);
                }
            }
        }
    }

    @Override
    public boolean isOpaqueCube(IBlockState p_isOpaqueCube_1_) {
        return false;
    }

    @Override
    public EnumBlockRenderType getRenderType(IBlockState p_getRenderType_1_) {
        return EnumBlockRenderType.MODEL;
    }

    @Override
    public TileEntity createNewTileEntity(World p_createNewTileEntity_1_, int p_createNewTileEntity_2_) {
        return new TileEntityEnchantmentTable();
    }

    @Override
    public boolean onBlockActivated(World p_onBlockActivated_1_, BlockPos p_onBlockActivated_2_, IBlockState p_onBlockActivated_3_, EntityPlayer p_onBlockActivated_4_, EnumHand p_onBlockActivated_5_, EnumFacing p_onBlockActivated_6_, float p_onBlockActivated_7_, float p_onBlockActivated_8_, float p_onBlockActivated_9_) {
        if (p_onBlockActivated_1_.isRemote) {
            return true;
        }
        TileEntity tileentity = p_onBlockActivated_1_.getTileEntity(p_onBlockActivated_2_);
        if (tileentity instanceof TileEntityEnchantmentTable) {
            p_onBlockActivated_4_.displayGui((TileEntityEnchantmentTable)tileentity);
        }
        return true;
    }

    @Override
    public void onBlockPlacedBy(World p_onBlockPlacedBy_1_, BlockPos p_onBlockPlacedBy_2_, IBlockState p_onBlockPlacedBy_3_, EntityLivingBase p_onBlockPlacedBy_4_, ItemStack p_onBlockPlacedBy_5_) {
        TileEntity tileentity;
        super.onBlockPlacedBy(p_onBlockPlacedBy_1_, p_onBlockPlacedBy_2_, p_onBlockPlacedBy_3_, p_onBlockPlacedBy_4_, p_onBlockPlacedBy_5_);
        if (p_onBlockPlacedBy_5_.hasDisplayName() && (tileentity = p_onBlockPlacedBy_1_.getTileEntity(p_onBlockPlacedBy_2_)) instanceof TileEntityEnchantmentTable) {
            ((TileEntityEnchantmentTable)tileentity).setCustomName(p_onBlockPlacedBy_5_.getDisplayName());
        }
    }
}

