/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityEndGateway;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockEndGateway
extends BlockContainer {
    protected BlockEndGateway(Material p_i46687_1_) {
        super(p_i46687_1_);
        this.setLightLevel(1.0f);
    }

    @Override
    public TileEntity createNewTileEntity(World p_createNewTileEntity_1_, int p_createNewTileEntity_2_) {
        return new TileEntityEndGateway();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(IBlockState p_shouldSideBeRendered_1_, IBlockAccess p_shouldSideBeRendered_2_, BlockPos p_shouldSideBeRendered_3_, EnumFacing p_shouldSideBeRendered_4_) {
        IBlockState lvt_5_1_ = p_shouldSideBeRendered_2_.getBlockState(p_shouldSideBeRendered_3_.offset(p_shouldSideBeRendered_4_));
        Block lvt_6_1_ = lvt_5_1_.getBlock();
        return !lvt_5_1_.isOpaqueCube() && lvt_6_1_ != Blocks.END_GATEWAY;
    }

    @Override
    @Nullable
    public AxisAlignedBB getCollisionBoundingBox(IBlockState p_getCollisionBoundingBox_1_, IBlockAccess p_getCollisionBoundingBox_2_, BlockPos p_getCollisionBoundingBox_3_) {
        return NULL_AABB;
    }

    @Override
    public boolean isOpaqueCube(IBlockState p_isOpaqueCube_1_) {
        return false;
    }

    @Override
    public boolean isFullCube(IBlockState p_isFullCube_1_) {
        return false;
    }

    @Override
    public int quantityDropped(Random p_quantityDropped_1_) {
        return 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(IBlockState p_randomDisplayTick_1_, World p_randomDisplayTick_2_, BlockPos p_randomDisplayTick_3_, Random p_randomDisplayTick_4_) {
        TileEntity lvt_5_1_ = p_randomDisplayTick_2_.getTileEntity(p_randomDisplayTick_3_);
        if (!(lvt_5_1_ instanceof TileEntityEndGateway)) {
            return;
        }
        int lvt_6_1_ = ((TileEntityEndGateway)lvt_5_1_).getParticleAmount();
        for (int lvt_7_1_ = 0; lvt_7_1_ < lvt_6_1_; ++lvt_7_1_) {
            double lvt_8_1_ = (float)p_randomDisplayTick_3_.getX() + p_randomDisplayTick_4_.nextFloat();
            double lvt_10_1_ = (float)p_randomDisplayTick_3_.getY() + p_randomDisplayTick_4_.nextFloat();
            double lvt_12_1_ = (float)p_randomDisplayTick_3_.getZ() + p_randomDisplayTick_4_.nextFloat();
            double lvt_14_1_ = ((double)p_randomDisplayTick_4_.nextFloat() - 0.5) * 0.5;
            double lvt_16_1_ = ((double)p_randomDisplayTick_4_.nextFloat() - 0.5) * 0.5;
            double lvt_18_1_ = ((double)p_randomDisplayTick_4_.nextFloat() - 0.5) * 0.5;
            int lvt_20_1_ = p_randomDisplayTick_4_.nextInt(2) * 2 - 1;
            if (p_randomDisplayTick_4_.nextBoolean()) {
                lvt_12_1_ = (double)p_randomDisplayTick_3_.getZ() + 0.5 + 0.25 * (double)lvt_20_1_;
                lvt_18_1_ = p_randomDisplayTick_4_.nextFloat() * 2.0f * (float)lvt_20_1_;
            } else {
                lvt_8_1_ = (double)p_randomDisplayTick_3_.getX() + 0.5 + 0.25 * (double)lvt_20_1_;
                lvt_14_1_ = p_randomDisplayTick_4_.nextFloat() * 2.0f * (float)lvt_20_1_;
            }
            p_randomDisplayTick_2_.spawnParticle(EnumParticleTypes.PORTAL, lvt_8_1_, lvt_10_1_, lvt_12_1_, lvt_14_1_, lvt_16_1_, lvt_18_1_, new int[0]);
        }
    }

    @Override
    public ItemStack getItem(World p_getItem_1_, BlockPos p_getItem_2_, IBlockState p_getItem_3_) {
        return ItemStack.EMPTY;
    }

    @Override
    public MapColor getMapColor(IBlockState p_getMapColor_1_) {
        return MapColor.BLACK;
    }
}

