/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityEndPortal;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockEndPortal
extends BlockContainer {
    protected static final AxisAlignedBB END_PORTAL_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.75, 1.0);

    protected BlockEndPortal(Material p_i45404_1_) {
        super(p_i45404_1_);
        this.setLightLevel(1.0f);
    }

    @Override
    public TileEntity createNewTileEntity(World p_createNewTileEntity_1_, int p_createNewTileEntity_2_) {
        return new TileEntityEndPortal();
    }

    @Override
    public AxisAlignedBB getBoundingBox(IBlockState p_getBoundingBox_1_, IBlockAccess p_getBoundingBox_2_, BlockPos p_getBoundingBox_3_) {
        return END_PORTAL_AABB;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(IBlockState p_shouldSideBeRendered_1_, IBlockAccess p_shouldSideBeRendered_2_, BlockPos p_shouldSideBeRendered_3_, EnumFacing p_shouldSideBeRendered_4_) {
        if (p_shouldSideBeRendered_4_ == EnumFacing.DOWN) {
            return super.shouldSideBeRendered(p_shouldSideBeRendered_1_, p_shouldSideBeRendered_2_, p_shouldSideBeRendered_3_, p_shouldSideBeRendered_4_);
        }
        return false;
    }

    @Override
    public void addCollisionBoxToList(IBlockState p_addCollisionBoxToList_1_, World p_addCollisionBoxToList_2_, BlockPos p_addCollisionBoxToList_3_, AxisAlignedBB p_addCollisionBoxToList_4_, List<AxisAlignedBB> p_addCollisionBoxToList_5_, Entity p_addCollisionBoxToList_6_, boolean p_addCollisionBoxToList_7_) {
    }

    @Override
    public boolean isOpaqueCube(IBlockState p_isOpaqueCube_1_) {
        return false;
    }

    @Override
    public boolean isFullCube(IBlockState p_isFullCube_1_) {
        return false;
    }

    @Override
    public int quantityDropped(Random p_quantityDropped_1_) {
        return 0;
    }

    @Override
    public void onEntityCollidedWithBlock(World p_onEntityCollidedWithBlock_1_, BlockPos p_onEntityCollidedWithBlock_2_, IBlockState p_onEntityCollidedWithBlock_3_, Entity p_onEntityCollidedWithBlock_4_) {
        if (!p_onEntityCollidedWithBlock_4_.isRiding() && !p_onEntityCollidedWithBlock_4_.isBeingRidden() && p_onEntityCollidedWithBlock_4_.isNonBoss() && !p_onEntityCollidedWithBlock_1_.isRemote && p_onEntityCollidedWithBlock_4_.getEntityBoundingBox().intersectsWith(p_onEntityCollidedWithBlock_3_.getBoundingBox(p_onEntityCollidedWithBlock_1_, p_onEntityCollidedWithBlock_2_).offset(p_onEntityCollidedWithBlock_2_))) {
            p_onEntityCollidedWithBlock_4_.changeDimension(1);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(IBlockState p_randomDisplayTick_1_, World p_randomDisplayTick_2_, BlockPos p_randomDisplayTick_3_, Random p_randomDisplayTick_4_) {
        double lvt_5_1_ = (float)p_randomDisplayTick_3_.getX() + p_randomDisplayTick_4_.nextFloat();
        double lvt_7_1_ = (float)p_randomDisplayTick_3_.getY() + 0.8f;
        double lvt_9_1_ = (float)p_randomDisplayTick_3_.getZ() + p_randomDisplayTick_4_.nextFloat();
        double lvt_11_1_ = 0.0;
        double lvt_13_1_ = 0.0;
        double lvt_15_1_ = 0.0;
        p_randomDisplayTick_2_.spawnParticle(EnumParticleTypes.SMOKE_NORMAL, lvt_5_1_, lvt_7_1_, lvt_9_1_, 0.0, 0.0, 0.0, new int[0]);
    }

    @Override
    public ItemStack getItem(World p_getItem_1_, BlockPos p_getItem_2_, IBlockState p_getItem_3_) {
        return ItemStack.EMPTY;
    }

    @Override
    public MapColor getMapColor(IBlockState p_getMapColor_1_) {
        return MapColor.BLACK;
    }
}

