/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockEndRod
extends BlockDirectional {
    protected static final AxisAlignedBB END_ROD_VERTICAL_AABB = new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 1.0, 0.625);
    protected static final AxisAlignedBB END_ROD_NS_AABB = new AxisAlignedBB(0.375, 0.375, 0.0, 0.625, 0.625, 1.0);
    protected static final AxisAlignedBB END_ROD_EW_AABB = new AxisAlignedBB(0.0, 0.375, 0.375, 1.0, 0.625, 0.625);

    protected BlockEndRod() {
        super(Material.CIRCUITS);
        this.setDefaultState(this.blockState.getBaseState().withProperty(FACING, EnumFacing.UP));
        this.setCreativeTab(CreativeTabs.DECORATIONS);
    }

    @Override
    public IBlockState withRotation(IBlockState p_withRotation_1_, Rotation p_withRotation_2_) {
        return p_withRotation_1_.withProperty(FACING, p_withRotation_2_.rotate(p_withRotation_1_.getValue(FACING)));
    }

    @Override
    public IBlockState withMirror(IBlockState p_withMirror_1_, Mirror p_withMirror_2_) {
        return p_withMirror_1_.withProperty(FACING, p_withMirror_2_.mirror(p_withMirror_1_.getValue(FACING)));
    }

    @Override
    public AxisAlignedBB getBoundingBox(IBlockState p_getBoundingBox_1_, IBlockAccess p_getBoundingBox_2_, BlockPos p_getBoundingBox_3_) {
        switch (p_getBoundingBox_1_.getValue(FACING).getAxis()) {
            default: {
                return END_ROD_EW_AABB;
            }
            case Z: {
                return END_ROD_NS_AABB;
            }
            case Y: 
        }
        return END_ROD_VERTICAL_AABB;
    }

    @Override
    public boolean isOpaqueCube(IBlockState p_isOpaqueCube_1_) {
        return false;
    }

    @Override
    public boolean isFullCube(IBlockState p_isFullCube_1_) {
        return false;
    }

    @Override
    public boolean canPlaceBlockAt(World p_canPlaceBlockAt_1_, BlockPos p_canPlaceBlockAt_2_) {
        return true;
    }

    @Override
    public IBlockState getStateForPlacement(World p_getStateForPlacement_1_, BlockPos p_getStateForPlacement_2_, EnumFacing p_getStateForPlacement_3_, float p_getStateForPlacement_4_, float p_getStateForPlacement_5_, float p_getStateForPlacement_6_, int p_getStateForPlacement_7_, EntityLivingBase p_getStateForPlacement_8_) {
        EnumFacing lvt_10_1_;
        IBlockState lvt_9_1_ = p_getStateForPlacement_1_.getBlockState(p_getStateForPlacement_2_.offset(p_getStateForPlacement_3_.getOpposite()));
        if (lvt_9_1_.getBlock() == Blocks.END_ROD && (lvt_10_1_ = lvt_9_1_.getValue(FACING)) == p_getStateForPlacement_3_) {
            return this.getDefaultState().withProperty(FACING, p_getStateForPlacement_3_.getOpposite());
        }
        return this.getDefaultState().withProperty(FACING, p_getStateForPlacement_3_);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(IBlockState p_randomDisplayTick_1_, World p_randomDisplayTick_2_, BlockPos p_randomDisplayTick_3_, Random p_randomDisplayTick_4_) {
        EnumFacing lvt_5_1_ = p_randomDisplayTick_1_.getValue(FACING);
        double lvt_6_1_ = (double)p_randomDisplayTick_3_.getX() + 0.55 - (double)(p_randomDisplayTick_4_.nextFloat() * 0.1f);
        double lvt_8_1_ = (double)p_randomDisplayTick_3_.getY() + 0.55 - (double)(p_randomDisplayTick_4_.nextFloat() * 0.1f);
        double lvt_10_1_ = (double)p_randomDisplayTick_3_.getZ() + 0.55 - (double)(p_randomDisplayTick_4_.nextFloat() * 0.1f);
        double lvt_12_1_ = 0.4f - (p_randomDisplayTick_4_.nextFloat() + p_randomDisplayTick_4_.nextFloat()) * 0.4f;
        if (p_randomDisplayTick_4_.nextInt(5) == 0) {
            p_randomDisplayTick_2_.spawnParticle(EnumParticleTypes.END_ROD, lvt_6_1_ + (double)lvt_5_1_.getFrontOffsetX() * lvt_12_1_, lvt_8_1_ + (double)lvt_5_1_.getFrontOffsetY() * lvt_12_1_, lvt_10_1_ + (double)lvt_5_1_.getFrontOffsetZ() * lvt_12_1_, p_randomDisplayTick_4_.nextGaussian() * 0.005, p_randomDisplayTick_4_.nextGaussian() * 0.005, p_randomDisplayTick_4_.nextGaussian() * 0.005, new int[0]);
        }
    }

    @Override
    public IBlockState getStateFromMeta(int p_getStateFromMeta_1_) {
        IBlockState lvt_2_1_ = this.getDefaultState();
        lvt_2_1_ = lvt_2_1_.withProperty(FACING, EnumFacing.getFront(p_getStateFromMeta_1_));
        return lvt_2_1_;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer getBlockLayer() {
        return BlockRenderLayer.CUTOUT;
    }

    @Override
    public int getMetaFromState(IBlockState p_getMetaFromState_1_) {
        return p_getMetaFromState_1_.getValue(FACING).getIndex();
    }

    @Override
    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, FACING);
    }

    @Override
    public EnumPushReaction getMobilityFlag(IBlockState p_getMobilityFlag_1_) {
        return EnumPushReaction.NORMAL;
    }
}

