/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockFalling
extends Block {
    public static boolean fallInstantly;

    public BlockFalling() {
        super(Material.SAND);
        this.setCreativeTab(CreativeTabs.BUILDING_BLOCKS);
    }

    public BlockFalling(Material p_i45405_1_) {
        super(p_i45405_1_);
    }

    @Override
    public void onBlockAdded(World p_onBlockAdded_1_, BlockPos p_onBlockAdded_2_, IBlockState p_onBlockAdded_3_) {
        p_onBlockAdded_1_.scheduleUpdate(p_onBlockAdded_2_, this, this.tickRate(p_onBlockAdded_1_));
    }

    @Override
    public void neighborChanged(IBlockState p_neighborChanged_1_, World p_neighborChanged_2_, BlockPos p_neighborChanged_3_, Block p_neighborChanged_4_, BlockPos p_neighborChanged_5_) {
        p_neighborChanged_2_.scheduleUpdate(p_neighborChanged_3_, this, this.tickRate(p_neighborChanged_2_));
    }

    @Override
    public void updateTick(World p_updateTick_1_, BlockPos p_updateTick_2_, IBlockState p_updateTick_3_, Random p_updateTick_4_) {
        if (!p_updateTick_1_.isRemote) {
            this.checkFallable(p_updateTick_1_, p_updateTick_2_);
        }
    }

    private void checkFallable(World p_checkFallable_1_, BlockPos p_checkFallable_2_) {
        if ((p_checkFallable_1_.isAirBlock(p_checkFallable_2_.down()) || BlockFalling.canFallThrough(p_checkFallable_1_.getBlockState(p_checkFallable_2_.down()))) && p_checkFallable_2_.getY() >= 0) {
            int i = 32;
            if (!fallInstantly && p_checkFallable_1_.isAreaLoaded(p_checkFallable_2_.add(-32, -32, -32), p_checkFallable_2_.add(32, 32, 32))) {
                if (!p_checkFallable_1_.isRemote) {
                    EntityFallingBlock entityfallingblock = new EntityFallingBlock(p_checkFallable_1_, (double)p_checkFallable_2_.getX() + 0.5, p_checkFallable_2_.getY(), (double)p_checkFallable_2_.getZ() + 0.5, p_checkFallable_1_.getBlockState(p_checkFallable_2_));
                    this.onStartFalling(entityfallingblock);
                    p_checkFallable_1_.spawnEntity(entityfallingblock);
                }
            } else {
                IBlockState state = p_checkFallable_1_.getBlockState(p_checkFallable_2_);
                p_checkFallable_1_.setBlockToAir(p_checkFallable_2_);
                BlockPos blockpos = p_checkFallable_2_.down();
                while ((p_checkFallable_1_.isAirBlock(blockpos) || BlockFalling.canFallThrough(p_checkFallable_1_.getBlockState(blockpos))) && blockpos.getY() > 0) {
                    blockpos = blockpos.down();
                }
                if (blockpos.getY() > 0) {
                    p_checkFallable_1_.setBlockState(blockpos.up(), state);
                }
            }
        }
    }

    protected void onStartFalling(EntityFallingBlock p_onStartFalling_1_) {
    }

    @Override
    public int tickRate(World p_tickRate_1_) {
        return 2;
    }

    public static boolean canFallThrough(IBlockState p_canFallThrough_0_) {
        Block block = p_canFallThrough_0_.getBlock();
        Material material = p_canFallThrough_0_.getMaterial();
        return block == Blocks.FIRE || material == Material.AIR || material == Material.WATER || material == Material.LAVA;
    }

    public void onEndFalling(World p_onEndFalling_1_, BlockPos p_onEndFalling_2_) {
    }

    public void onBroken(World p_onBroken_1_, BlockPos p_onBroken_2_) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(IBlockState p_randomDisplayTick_1_, World p_randomDisplayTick_2_, BlockPos p_randomDisplayTick_3_, Random p_randomDisplayTick_4_) {
        BlockPos blockpos;
        if (p_randomDisplayTick_4_.nextInt(16) == 0 && BlockFalling.canFallThrough(p_randomDisplayTick_2_.getBlockState(blockpos = p_randomDisplayTick_3_.down()))) {
            double d0 = (float)p_randomDisplayTick_3_.getX() + p_randomDisplayTick_4_.nextFloat();
            double d1 = (double)p_randomDisplayTick_3_.getY() - 0.05;
            double d2 = (float)p_randomDisplayTick_3_.getZ() + p_randomDisplayTick_4_.nextFloat();
            p_randomDisplayTick_2_.spawnParticle(EnumParticleTypes.FALLING_DUST, d0, d1, d2, 0.0, 0.0, 0.0, Block.getStateId(p_randomDisplayTick_1_));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getDustColor(IBlockState p_getDustColor_1_) {
        return -16777216;
    }
}

