/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockFarmland
extends Block {
    public static final PropertyInteger MOISTURE = PropertyInteger.create("moisture", 0, 7);
    protected static final AxisAlignedBB FARMLAND_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.9375, 1.0);

    protected BlockFarmland() {
        super(Material.GROUND);
        this.setDefaultState(this.blockState.getBaseState().withProperty(MOISTURE, 0));
        this.setTickRandomly(true);
        this.setLightOpacity(255);
    }

    @Override
    public AxisAlignedBB getBoundingBox(IBlockState p_getBoundingBox_1_, IBlockAccess p_getBoundingBox_2_, BlockPos p_getBoundingBox_3_) {
        return FARMLAND_AABB;
    }

    @Override
    public boolean isOpaqueCube(IBlockState p_isOpaqueCube_1_) {
        return false;
    }

    @Override
    public boolean isFullCube(IBlockState p_isFullCube_1_) {
        return false;
    }

    @Override
    public void updateTick(World p_updateTick_1_, BlockPos p_updateTick_2_, IBlockState p_updateTick_3_, Random p_updateTick_4_) {
        int i = p_updateTick_3_.getValue(MOISTURE);
        if (!this.hasWater(p_updateTick_1_, p_updateTick_2_) && !p_updateTick_1_.isRainingAt(p_updateTick_2_.up())) {
            if (i > 0) {
                p_updateTick_1_.setBlockState(p_updateTick_2_, p_updateTick_3_.withProperty(MOISTURE, i - 1), 2);
            } else if (!this.hasCrops(p_updateTick_1_, p_updateTick_2_)) {
                this.turnToDirt(p_updateTick_1_, p_updateTick_2_);
            }
        } else if (i < 7) {
            p_updateTick_1_.setBlockState(p_updateTick_2_, p_updateTick_3_.withProperty(MOISTURE, 7), 2);
        }
    }

    @Override
    public void onFallenUpon(World p_onFallenUpon_1_, BlockPos p_onFallenUpon_2_, Entity p_onFallenUpon_3_, float p_onFallenUpon_4_) {
        if (!p_onFallenUpon_1_.isRemote && p_onFallenUpon_3_.canTrample(p_onFallenUpon_1_, this, p_onFallenUpon_2_, p_onFallenUpon_4_)) {
            this.turnToDirt(p_onFallenUpon_1_, p_onFallenUpon_2_);
        }
        super.onFallenUpon(p_onFallenUpon_1_, p_onFallenUpon_2_, p_onFallenUpon_3_, p_onFallenUpon_4_);
    }

    private void turnToDirt(World p_turnToDirt_1_, BlockPos p_turnToDirt_2_) {
        IBlockState iblockstate = Blocks.DIRT.getDefaultState();
        p_turnToDirt_1_.setBlockState(p_turnToDirt_2_, iblockstate);
        AxisAlignedBB axisalignedbb = iblockstate.getCollisionBoundingBox(p_turnToDirt_1_, p_turnToDirt_2_).offset(p_turnToDirt_2_);
        for (Entity entity : p_turnToDirt_1_.getEntitiesWithinAABBExcludingEntity(null, axisalignedbb)) {
            entity.setPosition(entity.posX, axisalignedbb.maxY, entity.posZ);
        }
    }

    private boolean hasCrops(World p_hasCrops_1_, BlockPos p_hasCrops_2_) {
        Block block = p_hasCrops_1_.getBlockState(p_hasCrops_2_.up()).getBlock();
        return block instanceof IPlantable && this.canSustainPlant(p_hasCrops_1_.getBlockState(p_hasCrops_2_), p_hasCrops_1_, p_hasCrops_2_, EnumFacing.UP, (IPlantable)((Object)block));
    }

    private boolean hasWater(World p_hasWater_1_, BlockPos p_hasWater_2_) {
        for (BlockPos.MutableBlockPos blockpos$mutableblockpos : BlockPos.getAllInBoxMutable(p_hasWater_2_.add(-4, 0, -4), p_hasWater_2_.add(4, 1, 4))) {
            if (p_hasWater_1_.getBlockState(blockpos$mutableblockpos).getMaterial() != Material.WATER) continue;
            return true;
        }
        return false;
    }

    @Override
    public void neighborChanged(IBlockState p_neighborChanged_1_, World p_neighborChanged_2_, BlockPos p_neighborChanged_3_, Block p_neighborChanged_4_, BlockPos p_neighborChanged_5_) {
        super.neighborChanged(p_neighborChanged_1_, p_neighborChanged_2_, p_neighborChanged_3_, p_neighborChanged_4_, p_neighborChanged_5_);
        if (p_neighborChanged_2_.getBlockState(p_neighborChanged_3_.up()).getMaterial().isSolid()) {
            this.turnToDirt(p_neighborChanged_2_, p_neighborChanged_3_);
        }
    }

    @Override
    public void onBlockAdded(World p_onBlockAdded_1_, BlockPos p_onBlockAdded_2_, IBlockState p_onBlockAdded_3_) {
        super.onBlockAdded(p_onBlockAdded_1_, p_onBlockAdded_2_, p_onBlockAdded_3_);
        if (p_onBlockAdded_1_.getBlockState(p_onBlockAdded_2_.up()).getMaterial().isSolid()) {
            this.turnToDirt(p_onBlockAdded_1_, p_onBlockAdded_2_);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(IBlockState p_shouldSideBeRendered_1_, IBlockAccess p_shouldSideBeRendered_2_, BlockPos p_shouldSideBeRendered_3_, EnumFacing p_shouldSideBeRendered_4_) {
        switch (p_shouldSideBeRendered_4_) {
            case UP: {
                return true;
            }
            case NORTH: 
            case SOUTH: 
            case WEST: 
            case EAST: {
                IBlockState iblockstate = p_shouldSideBeRendered_2_.getBlockState(p_shouldSideBeRendered_3_.offset(p_shouldSideBeRendered_4_));
                Block block = iblockstate.getBlock();
                return !iblockstate.isOpaqueCube() && block != Blocks.FARMLAND && block != Blocks.GRASS_PATH;
            }
        }
        return super.shouldSideBeRendered(p_shouldSideBeRendered_1_, p_shouldSideBeRendered_2_, p_shouldSideBeRendered_3_, p_shouldSideBeRendered_4_);
    }

    @Override
    public Item getItemDropped(IBlockState p_getItemDropped_1_, Random p_getItemDropped_2_, int p_getItemDropped_3_) {
        return Blocks.DIRT.getItemDropped(Blocks.DIRT.getDefaultState().withProperty(BlockDirt.VARIANT, BlockDirt.DirtType.DIRT), p_getItemDropped_2_, p_getItemDropped_3_);
    }

    @Override
    public IBlockState getStateFromMeta(int p_getStateFromMeta_1_) {
        return this.getDefaultState().withProperty(MOISTURE, p_getStateFromMeta_1_ & 7);
    }

    @Override
    public int getMetaFromState(IBlockState p_getMetaFromState_1_) {
        return p_getMetaFromState_1_.getValue(MOISTURE);
    }

    @Override
    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, MOISTURE);
    }
}

