/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockWall;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockFenceGate
extends BlockHorizontal {
    public static final PropertyBool OPEN = PropertyBool.create("open");
    public static final PropertyBool POWERED = PropertyBool.create("powered");
    public static final PropertyBool IN_WALL = PropertyBool.create("in_wall");
    protected static final AxisAlignedBB AABB_COLLIDE_ZAXIS = new AxisAlignedBB(0.0, 0.0, 0.375, 1.0, 1.0, 0.625);
    protected static final AxisAlignedBB AABB_COLLIDE_XAXIS = new AxisAlignedBB(0.375, 0.0, 0.0, 0.625, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_COLLIDE_ZAXIS_INWALL = new AxisAlignedBB(0.0, 0.0, 0.375, 1.0, 0.8125, 0.625);
    protected static final AxisAlignedBB AABB_COLLIDE_XAXIS_INWALL = new AxisAlignedBB(0.375, 0.0, 0.0, 0.625, 0.8125, 1.0);
    protected static final AxisAlignedBB AABB_CLOSED_SELECTED_ZAXIS = new AxisAlignedBB(0.0, 0.0, 0.375, 1.0, 1.5, 0.625);
    protected static final AxisAlignedBB AABB_CLOSED_SELECTED_XAXIS = new AxisAlignedBB(0.375, 0.0, 0.0, 0.625, 1.5, 1.0);

    public BlockFenceGate(BlockPlanks.EnumType p_i46394_1_) {
        super(Material.WOOD, p_i46394_1_.getMapColor());
        this.setDefaultState(this.blockState.getBaseState().withProperty(OPEN, false).withProperty(POWERED, false).withProperty(IN_WALL, false));
        this.setCreativeTab(CreativeTabs.REDSTONE);
    }

    @Override
    public AxisAlignedBB getBoundingBox(IBlockState p_getBoundingBox_1_, IBlockAccess p_getBoundingBox_2_, BlockPos p_getBoundingBox_3_) {
        return (p_getBoundingBox_1_ = this.getActualState(p_getBoundingBox_1_, p_getBoundingBox_2_, p_getBoundingBox_3_)).getValue(IN_WALL).booleanValue() ? (p_getBoundingBox_1_.getValue(FACING).getAxis() == EnumFacing.Axis.X ? AABB_COLLIDE_XAXIS_INWALL : AABB_COLLIDE_ZAXIS_INWALL) : (p_getBoundingBox_1_.getValue(FACING).getAxis() == EnumFacing.Axis.X ? AABB_COLLIDE_XAXIS : AABB_COLLIDE_ZAXIS);
    }

    @Override
    public IBlockState getActualState(IBlockState p_getActualState_1_, IBlockAccess p_getActualState_2_, BlockPos p_getActualState_3_) {
        EnumFacing.Axis enumfacing$axis = p_getActualState_1_.getValue(FACING).getAxis();
        if (enumfacing$axis == EnumFacing.Axis.Z && (this.canFenceGateConnectTo(p_getActualState_2_, p_getActualState_3_, EnumFacing.WEST) || this.canFenceGateConnectTo(p_getActualState_2_, p_getActualState_3_, EnumFacing.EAST)) || enumfacing$axis == EnumFacing.Axis.X && (this.canFenceGateConnectTo(p_getActualState_2_, p_getActualState_3_, EnumFacing.NORTH) || this.canFenceGateConnectTo(p_getActualState_2_, p_getActualState_3_, EnumFacing.SOUTH))) {
            p_getActualState_1_ = p_getActualState_1_.withProperty(IN_WALL, true);
        }
        return p_getActualState_1_;
    }

    @Override
    public IBlockState withRotation(IBlockState p_withRotation_1_, Rotation p_withRotation_2_) {
        return p_withRotation_1_.withProperty(FACING, p_withRotation_2_.rotate(p_withRotation_1_.getValue(FACING)));
    }

    @Override
    public IBlockState withMirror(IBlockState p_withMirror_1_, Mirror p_withMirror_2_) {
        return p_withMirror_1_.withRotation(p_withMirror_2_.toRotation(p_withMirror_1_.getValue(FACING)));
    }

    @Override
    public boolean canPlaceBlockAt(World p_canPlaceBlockAt_1_, BlockPos p_canPlaceBlockAt_2_) {
        return p_canPlaceBlockAt_1_.getBlockState(p_canPlaceBlockAt_2_.down()).getMaterial().isSolid() ? super.canPlaceBlockAt(p_canPlaceBlockAt_1_, p_canPlaceBlockAt_2_) : false;
    }

    @Override
    @Nullable
    public AxisAlignedBB getCollisionBoundingBox(IBlockState p_getCollisionBoundingBox_1_, IBlockAccess p_getCollisionBoundingBox_2_, BlockPos p_getCollisionBoundingBox_3_) {
        return p_getCollisionBoundingBox_1_.getValue(OPEN) != false ? NULL_AABB : (p_getCollisionBoundingBox_1_.getValue(FACING).getAxis() == EnumFacing.Axis.Z ? AABB_CLOSED_SELECTED_ZAXIS : AABB_CLOSED_SELECTED_XAXIS);
    }

    @Override
    public boolean isOpaqueCube(IBlockState p_isOpaqueCube_1_) {
        return false;
    }

    @Override
    public boolean isFullCube(IBlockState p_isFullCube_1_) {
        return false;
    }

    @Override
    public boolean isPassable(IBlockAccess p_isPassable_1_, BlockPos p_isPassable_2_) {
        return p_isPassable_1_.getBlockState(p_isPassable_2_).getValue(OPEN);
    }

    @Override
    public IBlockState getStateForPlacement(World p_getStateForPlacement_1_, BlockPos p_getStateForPlacement_2_, EnumFacing p_getStateForPlacement_3_, float p_getStateForPlacement_4_, float p_getStateForPlacement_5_, float p_getStateForPlacement_6_, int p_getStateForPlacement_7_, EntityLivingBase p_getStateForPlacement_8_) {
        boolean flag = p_getStateForPlacement_1_.isBlockPowered(p_getStateForPlacement_2_);
        return this.getDefaultState().withProperty(FACING, p_getStateForPlacement_8_.getHorizontalFacing()).withProperty(OPEN, flag).withProperty(POWERED, flag).withProperty(IN_WALL, false);
    }

    @Override
    public boolean onBlockActivated(World p_onBlockActivated_1_, BlockPos p_onBlockActivated_2_, IBlockState p_onBlockActivated_3_, EntityPlayer p_onBlockActivated_4_, EnumHand p_onBlockActivated_5_, EnumFacing p_onBlockActivated_6_, float p_onBlockActivated_7_, float p_onBlockActivated_8_, float p_onBlockActivated_9_) {
        if (p_onBlockActivated_3_.getValue(OPEN).booleanValue()) {
            p_onBlockActivated_3_ = p_onBlockActivated_3_.withProperty(OPEN, false);
            p_onBlockActivated_1_.setBlockState(p_onBlockActivated_2_, p_onBlockActivated_3_, 10);
        } else {
            EnumFacing enumfacing = EnumFacing.fromAngle(p_onBlockActivated_4_.rotationYaw);
            if (p_onBlockActivated_3_.getValue(FACING) == enumfacing.getOpposite()) {
                p_onBlockActivated_3_ = p_onBlockActivated_3_.withProperty(FACING, enumfacing);
            }
            p_onBlockActivated_3_ = p_onBlockActivated_3_.withProperty(OPEN, true);
            p_onBlockActivated_1_.setBlockState(p_onBlockActivated_2_, p_onBlockActivated_3_, 10);
        }
        p_onBlockActivated_1_.playEvent(p_onBlockActivated_4_, p_onBlockActivated_3_.getValue(OPEN) != false ? 1008 : 1014, p_onBlockActivated_2_, 0);
        return true;
    }

    @Override
    public void neighborChanged(IBlockState p_neighborChanged_1_, World p_neighborChanged_2_, BlockPos p_neighborChanged_3_, Block p_neighborChanged_4_, BlockPos p_neighborChanged_5_) {
        if (!p_neighborChanged_2_.isRemote) {
            boolean flag = p_neighborChanged_2_.isBlockPowered(p_neighborChanged_3_);
            if (p_neighborChanged_1_.getValue(POWERED) != flag) {
                p_neighborChanged_2_.setBlockState(p_neighborChanged_3_, p_neighborChanged_1_.withProperty(POWERED, flag).withProperty(OPEN, flag), 2);
                if (p_neighborChanged_1_.getValue(OPEN) != flag) {
                    p_neighborChanged_2_.playEvent(null, flag ? 1008 : 1014, p_neighborChanged_3_, 0);
                }
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(IBlockState p_shouldSideBeRendered_1_, IBlockAccess p_shouldSideBeRendered_2_, BlockPos p_shouldSideBeRendered_3_, EnumFacing p_shouldSideBeRendered_4_) {
        return true;
    }

    @Override
    public IBlockState getStateFromMeta(int p_getStateFromMeta_1_) {
        return this.getDefaultState().withProperty(FACING, EnumFacing.getHorizontal(p_getStateFromMeta_1_)).withProperty(OPEN, (p_getStateFromMeta_1_ & 4) != 0).withProperty(POWERED, (p_getStateFromMeta_1_ & 8) != 0);
    }

    @Override
    public int getMetaFromState(IBlockState p_getMetaFromState_1_) {
        int i = 0;
        i |= p_getMetaFromState_1_.getValue(FACING).getHorizontalIndex();
        if (p_getMetaFromState_1_.getValue(POWERED).booleanValue()) {
            i |= 8;
        }
        if (p_getMetaFromState_1_.getValue(OPEN).booleanValue()) {
            i |= 4;
        }
        return i;
    }

    @Override
    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, FACING, OPEN, POWERED, IN_WALL);
    }

    @Override
    public boolean canBeConnectedTo(IBlockAccess p_canBeConnectedTo_1_, BlockPos p_canBeConnectedTo_2_, EnumFacing p_canBeConnectedTo_3_) {
        Block connector = p_canBeConnectedTo_1_.getBlockState(p_canBeConnectedTo_2_.offset(p_canBeConnectedTo_3_)).getBlock();
        return connector instanceof BlockFence || connector instanceof BlockWall;
    }

    private boolean canFenceGateConnectTo(IBlockAccess p_canFenceGateConnectTo_1_, BlockPos p_canFenceGateConnectTo_2_, EnumFacing p_canFenceGateConnectTo_3_) {
        Block block = p_canFenceGateConnectTo_1_.getBlockState(p_canFenceGateConnectTo_2_.offset(p_canFenceGateConnectTo_3_)).getBlock();
        return block.canBeConnectedTo(p_canFenceGateConnectTo_1_, p_canFenceGateConnectTo_2_.offset(p_canFenceGateConnectTo_3_), p_canFenceGateConnectTo_3_.getOpposite());
    }
}

