/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTNT;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockFire
extends Block {
    public static final PropertyInteger AGE = PropertyInteger.create("age", 0, 15);
    public static final PropertyBool NORTH = PropertyBool.create("north");
    public static final PropertyBool EAST = PropertyBool.create("east");
    public static final PropertyBool SOUTH = PropertyBool.create("south");
    public static final PropertyBool WEST = PropertyBool.create("west");
    public static final PropertyBool UPPER = PropertyBool.create("up");
    private final Map<Block, Integer> encouragements = Maps.newIdentityHashMap();
    private final Map<Block, Integer> flammabilities = Maps.newIdentityHashMap();

    @Override
    public IBlockState getActualState(IBlockState p_getActualState_1_, IBlockAccess p_getActualState_2_, BlockPos p_getActualState_3_) {
        if (!p_getActualState_2_.getBlockState(p_getActualState_3_.down()).isSideSolid(p_getActualState_2_, p_getActualState_3_.down(), EnumFacing.UP) && !Blocks.FIRE.canCatchFire(p_getActualState_2_, p_getActualState_3_.down(), EnumFacing.UP)) {
            return p_getActualState_1_.withProperty(NORTH, this.canCatchFire(p_getActualState_2_, p_getActualState_3_.north(), EnumFacing.SOUTH)).withProperty(EAST, this.canCatchFire(p_getActualState_2_, p_getActualState_3_.east(), EnumFacing.WEST)).withProperty(SOUTH, this.canCatchFire(p_getActualState_2_, p_getActualState_3_.south(), EnumFacing.NORTH)).withProperty(WEST, this.canCatchFire(p_getActualState_2_, p_getActualState_3_.west(), EnumFacing.EAST)).withProperty(UPPER, this.canCatchFire(p_getActualState_2_, p_getActualState_3_.up(), EnumFacing.DOWN));
        }
        return this.getDefaultState();
    }

    protected BlockFire() {
        super(Material.FIRE);
        this.setDefaultState(this.blockState.getBaseState().withProperty(AGE, 0).withProperty(NORTH, false).withProperty(EAST, false).withProperty(SOUTH, false).withProperty(WEST, false).withProperty(UPPER, false));
        this.setTickRandomly(true);
    }

    public static void init() {
        Blocks.FIRE.setFireInfo(Blocks.PLANKS, 5, 20);
        Blocks.FIRE.setFireInfo(Blocks.DOUBLE_WOODEN_SLAB, 5, 20);
        Blocks.FIRE.setFireInfo(Blocks.WOODEN_SLAB, 5, 20);
        Blocks.FIRE.setFireInfo(Blocks.OAK_FENCE_GATE, 5, 20);
        Blocks.FIRE.setFireInfo(Blocks.SPRUCE_FENCE_GATE, 5, 20);
        Blocks.FIRE.setFireInfo(Blocks.BIRCH_FENCE_GATE, 5, 20);
        Blocks.FIRE.setFireInfo(Blocks.JUNGLE_FENCE_GATE, 5, 20);
        Blocks.FIRE.setFireInfo(Blocks.DARK_OAK_FENCE_GATE, 5, 20);
        Blocks.FIRE.setFireInfo(Blocks.ACACIA_FENCE_GATE, 5, 20);
        Blocks.FIRE.setFireInfo(Blocks.OAK_FENCE, 5, 20);
        Blocks.FIRE.setFireInfo(Blocks.SPRUCE_FENCE, 5, 20);
        Blocks.FIRE.setFireInfo(Blocks.BIRCH_FENCE, 5, 20);
        Blocks.FIRE.setFireInfo(Blocks.JUNGLE_FENCE, 5, 20);
        Blocks.FIRE.setFireInfo(Blocks.DARK_OAK_FENCE, 5, 20);
        Blocks.FIRE.setFireInfo(Blocks.ACACIA_FENCE, 5, 20);
        Blocks.FIRE.setFireInfo(Blocks.OAK_STAIRS, 5, 20);
        Blocks.FIRE.setFireInfo(Blocks.BIRCH_STAIRS, 5, 20);
        Blocks.FIRE.setFireInfo(Blocks.SPRUCE_STAIRS, 5, 20);
        Blocks.FIRE.setFireInfo(Blocks.JUNGLE_STAIRS, 5, 20);
        Blocks.FIRE.setFireInfo(Blocks.ACACIA_STAIRS, 5, 20);
        Blocks.FIRE.setFireInfo(Blocks.DARK_OAK_STAIRS, 5, 20);
        Blocks.FIRE.setFireInfo(Blocks.LOG, 5, 5);
        Blocks.FIRE.setFireInfo(Blocks.LOG2, 5, 5);
        Blocks.FIRE.setFireInfo(Blocks.LEAVES, 30, 60);
        Blocks.FIRE.setFireInfo(Blocks.LEAVES2, 30, 60);
        Blocks.FIRE.setFireInfo(Blocks.BOOKSHELF, 30, 20);
        Blocks.FIRE.setFireInfo(Blocks.TNT, 15, 100);
        Blocks.FIRE.setFireInfo(Blocks.TALLGRASS, 60, 100);
        Blocks.FIRE.setFireInfo(Blocks.DOUBLE_PLANT, 60, 100);
        Blocks.FIRE.setFireInfo(Blocks.YELLOW_FLOWER, 60, 100);
        Blocks.FIRE.setFireInfo(Blocks.RED_FLOWER, 60, 100);
        Blocks.FIRE.setFireInfo(Blocks.DEADBUSH, 60, 100);
        Blocks.FIRE.setFireInfo(Blocks.WOOL, 30, 60);
        Blocks.FIRE.setFireInfo(Blocks.VINE, 15, 100);
        Blocks.FIRE.setFireInfo(Blocks.COAL_BLOCK, 5, 5);
        Blocks.FIRE.setFireInfo(Blocks.HAY_BLOCK, 60, 20);
        Blocks.FIRE.setFireInfo(Blocks.CARPET, 60, 20);
    }

    public void setFireInfo(Block p_setFireInfo_1_, int p_setFireInfo_2_, int p_setFireInfo_3_) {
        if (p_setFireInfo_1_ == Blocks.AIR) {
            throw new IllegalArgumentException("Tried to set air on fire... This is bad.");
        }
        this.encouragements.put(p_setFireInfo_1_, p_setFireInfo_2_);
        this.flammabilities.put(p_setFireInfo_1_, p_setFireInfo_3_);
    }

    @Override
    @Nullable
    public AxisAlignedBB getCollisionBoundingBox(IBlockState p_getCollisionBoundingBox_1_, IBlockAccess p_getCollisionBoundingBox_2_, BlockPos p_getCollisionBoundingBox_3_) {
        return NULL_AABB;
    }

    @Override
    public boolean isOpaqueCube(IBlockState p_isOpaqueCube_1_) {
        return false;
    }

    @Override
    public boolean isFullCube(IBlockState p_isFullCube_1_) {
        return false;
    }

    @Override
    public int quantityDropped(Random p_quantityDropped_1_) {
        return 0;
    }

    @Override
    public int tickRate(World p_tickRate_1_) {
        return 30;
    }

    @Override
    public void updateTick(World p_updateTick_1_, BlockPos p_updateTick_2_, IBlockState p_updateTick_3_, Random p_updateTick_4_) {
        if (p_updateTick_1_.getGameRules().getBoolean("doFireTick")) {
            if (!this.canPlaceBlockAt(p_updateTick_1_, p_updateTick_2_)) {
                p_updateTick_1_.setBlockToAir(p_updateTick_2_);
            }
            Block block = p_updateTick_1_.getBlockState(p_updateTick_2_.down()).getBlock();
            boolean flag = block.isFireSource(p_updateTick_1_, p_updateTick_2_.down(), EnumFacing.UP);
            int i = p_updateTick_3_.getValue(AGE);
            if (!flag && p_updateTick_1_.isRaining() && this.canDie(p_updateTick_1_, p_updateTick_2_) && p_updateTick_4_.nextFloat() < 0.2f + (float)i * 0.03f) {
                p_updateTick_1_.setBlockToAir(p_updateTick_2_);
            } else {
                if (i < 15) {
                    p_updateTick_3_ = p_updateTick_3_.withProperty(AGE, i + p_updateTick_4_.nextInt(3) / 2);
                    p_updateTick_1_.setBlockState(p_updateTick_2_, p_updateTick_3_, 4);
                }
                p_updateTick_1_.scheduleUpdate(p_updateTick_2_, this, this.tickRate(p_updateTick_1_) + p_updateTick_4_.nextInt(10));
                if (!flag) {
                    if (!this.canNeighborCatchFire(p_updateTick_1_, p_updateTick_2_)) {
                        if (!p_updateTick_1_.getBlockState(p_updateTick_2_.down()).isSideSolid(p_updateTick_1_, p_updateTick_2_.down(), EnumFacing.UP) || i > 3) {
                            p_updateTick_1_.setBlockToAir(p_updateTick_2_);
                        }
                        return;
                    }
                    if (!this.canCatchFire(p_updateTick_1_, p_updateTick_2_.down(), EnumFacing.UP) && i == 15 && p_updateTick_4_.nextInt(4) == 0) {
                        p_updateTick_1_.setBlockToAir(p_updateTick_2_);
                        return;
                    }
                }
                boolean flag1 = p_updateTick_1_.isBlockinHighHumidity(p_updateTick_2_);
                int j = 0;
                if (flag1) {
                    j = -50;
                }
                this.tryCatchFire(p_updateTick_1_, p_updateTick_2_.east(), 300 + j, p_updateTick_4_, i, EnumFacing.WEST);
                this.tryCatchFire(p_updateTick_1_, p_updateTick_2_.west(), 300 + j, p_updateTick_4_, i, EnumFacing.EAST);
                this.tryCatchFire(p_updateTick_1_, p_updateTick_2_.down(), 250 + j, p_updateTick_4_, i, EnumFacing.UP);
                this.tryCatchFire(p_updateTick_1_, p_updateTick_2_.up(), 250 + j, p_updateTick_4_, i, EnumFacing.DOWN);
                this.tryCatchFire(p_updateTick_1_, p_updateTick_2_.north(), 300 + j, p_updateTick_4_, i, EnumFacing.SOUTH);
                this.tryCatchFire(p_updateTick_1_, p_updateTick_2_.south(), 300 + j, p_updateTick_4_, i, EnumFacing.NORTH);
                for (int k = -1; k <= 1; ++k) {
                    for (int l = -1; l <= 1; ++l) {
                        for (int i1 = -1; i1 <= 4; ++i1) {
                            BlockPos blockpos;
                            int k1;
                            if (k == 0 && i1 == 0 && l == 0) continue;
                            int j1 = 100;
                            if (i1 > 1) {
                                j1 += (i1 - 1) * 100;
                            }
                            if ((k1 = this.getNeighborEncouragement(p_updateTick_1_, blockpos = p_updateTick_2_.add(k, i1, l))) <= 0) continue;
                            int l1 = (k1 + 40 + p_updateTick_1_.getDifficulty().getDifficultyId() * 7) / (i + 30);
                            if (flag1) {
                                l1 /= 2;
                            }
                            if (l1 <= 0 || p_updateTick_4_.nextInt(j1) > l1 || p_updateTick_1_.isRaining() && this.canDie(p_updateTick_1_, blockpos)) continue;
                            int i2 = i + p_updateTick_4_.nextInt(5) / 4;
                            if (i2 > 15) {
                                i2 = 15;
                            }
                            p_updateTick_1_.setBlockState(blockpos, p_updateTick_3_.withProperty(AGE, i2), 3);
                        }
                    }
                }
            }
        }
    }

    protected boolean canDie(World p_canDie_1_, BlockPos p_canDie_2_) {
        return p_canDie_1_.isRainingAt(p_canDie_2_) || p_canDie_1_.isRainingAt(p_canDie_2_.west()) || p_canDie_1_.isRainingAt(p_canDie_2_.east()) || p_canDie_1_.isRainingAt(p_canDie_2_.north()) || p_canDie_1_.isRainingAt(p_canDie_2_.south());
    }

    @Override
    public boolean requiresUpdates() {
        return false;
    }

    @Deprecated
    public int getFlammability(Block p_getFlammability_1_) {
        Integer integer = this.flammabilities.get(p_getFlammability_1_);
        return integer == null ? 0 : integer;
    }

    @Deprecated
    public int getEncouragement(Block p_getEncouragement_1_) {
        Integer integer = this.encouragements.get(p_getEncouragement_1_);
        return integer == null ? 0 : integer;
    }

    @Deprecated
    private void catchOnFire(World p_catchOnFire_1_, BlockPos p_catchOnFire_2_, int p_catchOnFire_3_, Random p_catchOnFire_4_, int p_catchOnFire_5_) {
        this.tryCatchFire(p_catchOnFire_1_, p_catchOnFire_2_, p_catchOnFire_3_, p_catchOnFire_4_, p_catchOnFire_5_, EnumFacing.UP);
    }

    private void tryCatchFire(World p_tryCatchFire_1_, BlockPos p_tryCatchFire_2_, int p_tryCatchFire_3_, Random p_tryCatchFire_4_, int p_tryCatchFire_5_, EnumFacing p_tryCatchFire_6_) {
        int i = p_tryCatchFire_1_.getBlockState(p_tryCatchFire_2_).getBlock().getFlammability(p_tryCatchFire_1_, p_tryCatchFire_2_, p_tryCatchFire_6_);
        if (p_tryCatchFire_4_.nextInt(p_tryCatchFire_3_) < i) {
            IBlockState iblockstate = p_tryCatchFire_1_.getBlockState(p_tryCatchFire_2_);
            if (p_tryCatchFire_4_.nextInt(p_tryCatchFire_5_ + 10) < 5 && !p_tryCatchFire_1_.isRainingAt(p_tryCatchFire_2_)) {
                int j = p_tryCatchFire_5_ + p_tryCatchFire_4_.nextInt(5) / 4;
                if (j > 15) {
                    j = 15;
                }
                p_tryCatchFire_1_.setBlockState(p_tryCatchFire_2_, this.getDefaultState().withProperty(AGE, j), 3);
            } else {
                p_tryCatchFire_1_.setBlockToAir(p_tryCatchFire_2_);
            }
            if (iblockstate.getBlock() == Blocks.TNT) {
                Blocks.TNT.onBlockDestroyedByPlayer(p_tryCatchFire_1_, p_tryCatchFire_2_, iblockstate.withProperty(BlockTNT.EXPLODE, true));
            }
        }
    }

    private boolean canNeighborCatchFire(World p_canNeighborCatchFire_1_, BlockPos p_canNeighborCatchFire_2_) {
        for (EnumFacing enumfacing : EnumFacing.values()) {
            if (!this.canCatchFire(p_canNeighborCatchFire_1_, p_canNeighborCatchFire_2_.offset(enumfacing), enumfacing.getOpposite())) continue;
            return true;
        }
        return false;
    }

    private int getNeighborEncouragement(World p_getNeighborEncouragement_1_, BlockPos p_getNeighborEncouragement_2_) {
        if (!p_getNeighborEncouragement_1_.isAirBlock(p_getNeighborEncouragement_2_)) {
            return 0;
        }
        int i = 0;
        for (EnumFacing enumfacing : EnumFacing.values()) {
            i = Math.max(p_getNeighborEncouragement_1_.getBlockState(p_getNeighborEncouragement_2_.offset(enumfacing)).getBlock().getFireSpreadSpeed(p_getNeighborEncouragement_1_, p_getNeighborEncouragement_2_.offset(enumfacing), enumfacing.getOpposite()), i);
        }
        return i;
    }

    @Override
    public boolean isCollidable() {
        return false;
    }

    @Deprecated
    public boolean canCatchFire(IBlockAccess p_canCatchFire_1_, BlockPos p_canCatchFire_2_) {
        return this.canCatchFire(p_canCatchFire_1_, p_canCatchFire_2_, EnumFacing.UP);
    }

    @Override
    public boolean canPlaceBlockAt(World p_canPlaceBlockAt_1_, BlockPos p_canPlaceBlockAt_2_) {
        return p_canPlaceBlockAt_1_.getBlockState(p_canPlaceBlockAt_2_.down()).isFullyOpaque() || this.canNeighborCatchFire(p_canPlaceBlockAt_1_, p_canPlaceBlockAt_2_);
    }

    @Override
    public void neighborChanged(IBlockState p_neighborChanged_1_, World p_neighborChanged_2_, BlockPos p_neighborChanged_3_, Block p_neighborChanged_4_, BlockPos p_neighborChanged_5_) {
        if (!p_neighborChanged_2_.getBlockState(p_neighborChanged_3_.down()).isFullyOpaque() && !this.canNeighborCatchFire(p_neighborChanged_2_, p_neighborChanged_3_)) {
            p_neighborChanged_2_.setBlockToAir(p_neighborChanged_3_);
        }
    }

    @Override
    public void onBlockAdded(World p_onBlockAdded_1_, BlockPos p_onBlockAdded_2_, IBlockState p_onBlockAdded_3_) {
        if (p_onBlockAdded_1_.provider.getDimensionType().getId() > 0 || !Blocks.PORTAL.trySpawnPortal(p_onBlockAdded_1_, p_onBlockAdded_2_)) {
            if (!p_onBlockAdded_1_.getBlockState(p_onBlockAdded_2_.down()).isFullyOpaque() && !this.canNeighborCatchFire(p_onBlockAdded_1_, p_onBlockAdded_2_)) {
                p_onBlockAdded_1_.setBlockToAir(p_onBlockAdded_2_);
            } else {
                p_onBlockAdded_1_.scheduleUpdate(p_onBlockAdded_2_, this, this.tickRate(p_onBlockAdded_1_) + p_onBlockAdded_1_.rand.nextInt(10));
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(IBlockState p_randomDisplayTick_1_, World p_randomDisplayTick_2_, BlockPos p_randomDisplayTick_3_, Random p_randomDisplayTick_4_) {
        block12: {
            block11: {
                if (p_randomDisplayTick_4_.nextInt(24) == 0) {
                    p_randomDisplayTick_2_.playSound((float)p_randomDisplayTick_3_.getX() + 0.5f, (double)((float)p_randomDisplayTick_3_.getY() + 0.5f), (double)((float)p_randomDisplayTick_3_.getZ() + 0.5f), SoundEvents.BLOCK_FIRE_AMBIENT, SoundCategory.BLOCKS, 1.0f + p_randomDisplayTick_4_.nextFloat(), p_randomDisplayTick_4_.nextFloat() * 0.7f + 0.3f, false);
                }
                if (p_randomDisplayTick_2_.getBlockState(p_randomDisplayTick_3_.down()).isSideSolid(p_randomDisplayTick_2_, p_randomDisplayTick_3_.down(), EnumFacing.UP) || Blocks.FIRE.canCatchFire(p_randomDisplayTick_2_, p_randomDisplayTick_3_.down(), EnumFacing.UP)) break block11;
                if (Blocks.FIRE.canCatchFire(p_randomDisplayTick_2_, p_randomDisplayTick_3_.west(), EnumFacing.EAST)) {
                    for (int j = 0; j < 2; ++j) {
                        double d3 = (double)p_randomDisplayTick_3_.getX() + p_randomDisplayTick_4_.nextDouble() * (double)0.1f;
                        double d8 = (double)p_randomDisplayTick_3_.getY() + p_randomDisplayTick_4_.nextDouble();
                        double d13 = (double)p_randomDisplayTick_3_.getZ() + p_randomDisplayTick_4_.nextDouble();
                        p_randomDisplayTick_2_.spawnParticle(EnumParticleTypes.SMOKE_LARGE, d3, d8, d13, 0.0, 0.0, 0.0, new int[0]);
                    }
                }
                if (Blocks.FIRE.canCatchFire(p_randomDisplayTick_2_, p_randomDisplayTick_3_.east(), EnumFacing.WEST)) {
                    for (int k = 0; k < 2; ++k) {
                        double d4 = (double)(p_randomDisplayTick_3_.getX() + 1) - p_randomDisplayTick_4_.nextDouble() * (double)0.1f;
                        double d9 = (double)p_randomDisplayTick_3_.getY() + p_randomDisplayTick_4_.nextDouble();
                        double d14 = (double)p_randomDisplayTick_3_.getZ() + p_randomDisplayTick_4_.nextDouble();
                        p_randomDisplayTick_2_.spawnParticle(EnumParticleTypes.SMOKE_LARGE, d4, d9, d14, 0.0, 0.0, 0.0, new int[0]);
                    }
                }
                if (Blocks.FIRE.canCatchFire(p_randomDisplayTick_2_, p_randomDisplayTick_3_.north(), EnumFacing.SOUTH)) {
                    for (int l = 0; l < 2; ++l) {
                        double d5 = (double)p_randomDisplayTick_3_.getX() + p_randomDisplayTick_4_.nextDouble();
                        double d10 = (double)p_randomDisplayTick_3_.getY() + p_randomDisplayTick_4_.nextDouble();
                        double d15 = (double)p_randomDisplayTick_3_.getZ() + p_randomDisplayTick_4_.nextDouble() * (double)0.1f;
                        p_randomDisplayTick_2_.spawnParticle(EnumParticleTypes.SMOKE_LARGE, d5, d10, d15, 0.0, 0.0, 0.0, new int[0]);
                    }
                }
                if (Blocks.FIRE.canCatchFire(p_randomDisplayTick_2_, p_randomDisplayTick_3_.south(), EnumFacing.NORTH)) {
                    for (int i1 = 0; i1 < 2; ++i1) {
                        double d6 = (double)p_randomDisplayTick_3_.getX() + p_randomDisplayTick_4_.nextDouble();
                        double d11 = (double)p_randomDisplayTick_3_.getY() + p_randomDisplayTick_4_.nextDouble();
                        double d16 = (double)(p_randomDisplayTick_3_.getZ() + 1) - p_randomDisplayTick_4_.nextDouble() * (double)0.1f;
                        p_randomDisplayTick_2_.spawnParticle(EnumParticleTypes.SMOKE_LARGE, d6, d11, d16, 0.0, 0.0, 0.0, new int[0]);
                    }
                }
                if (!Blocks.FIRE.canCatchFire(p_randomDisplayTick_2_, p_randomDisplayTick_3_.up(), EnumFacing.DOWN)) break block12;
                for (int j1 = 0; j1 < 2; ++j1) {
                    double d7 = (double)p_randomDisplayTick_3_.getX() + p_randomDisplayTick_4_.nextDouble();
                    double d12 = (double)(p_randomDisplayTick_3_.getY() + 1) - p_randomDisplayTick_4_.nextDouble() * (double)0.1f;
                    double d17 = (double)p_randomDisplayTick_3_.getZ() + p_randomDisplayTick_4_.nextDouble();
                    p_randomDisplayTick_2_.spawnParticle(EnumParticleTypes.SMOKE_LARGE, d7, d12, d17, 0.0, 0.0, 0.0, new int[0]);
                }
                break block12;
            }
            for (int i = 0; i < 3; ++i) {
                double d0 = (double)p_randomDisplayTick_3_.getX() + p_randomDisplayTick_4_.nextDouble();
                double d1 = (double)p_randomDisplayTick_3_.getY() + p_randomDisplayTick_4_.nextDouble() * 0.5 + 0.5;
                double d2 = (double)p_randomDisplayTick_3_.getZ() + p_randomDisplayTick_4_.nextDouble();
                p_randomDisplayTick_2_.spawnParticle(EnumParticleTypes.SMOKE_LARGE, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    @Override
    public MapColor getMapColor(IBlockState p_getMapColor_1_) {
        return MapColor.TNT;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer getBlockLayer() {
        return BlockRenderLayer.CUTOUT;
    }

    @Override
    public IBlockState getStateFromMeta(int p_getStateFromMeta_1_) {
        return this.getDefaultState().withProperty(AGE, p_getStateFromMeta_1_);
    }

    @Override
    public int getMetaFromState(IBlockState p_getMetaFromState_1_) {
        return p_getMetaFromState_1_.getValue(AGE);
    }

    @Override
    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, AGE, NORTH, EAST, SOUTH, WEST, UPPER);
    }

    public boolean canCatchFire(IBlockAccess p_canCatchFire_1_, BlockPos p_canCatchFire_2_, EnumFacing p_canCatchFire_3_) {
        return p_canCatchFire_1_.getBlockState(p_canCatchFire_2_).getBlock().isFlammable(p_canCatchFire_1_, p_canCatchFire_2_, p_canCatchFire_3_);
    }
}

