/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockFlower
extends BlockBush {
    protected PropertyEnum<EnumFlowerType> type;

    protected BlockFlower() {
        this.setDefaultState(this.blockState.getBaseState().withProperty(this.getTypeProperty(), this.getBlockType() == EnumFlowerColor.RED ? EnumFlowerType.POPPY : EnumFlowerType.DANDELION));
    }

    @Override
    public AxisAlignedBB getBoundingBox(IBlockState p_getBoundingBox_1_, IBlockAccess p_getBoundingBox_2_, BlockPos p_getBoundingBox_3_) {
        return super.getBoundingBox(p_getBoundingBox_1_, p_getBoundingBox_2_, p_getBoundingBox_3_).move(p_getBoundingBox_1_.getOffset(p_getBoundingBox_2_, p_getBoundingBox_3_));
    }

    @Override
    public int damageDropped(IBlockState p_damageDropped_1_) {
        return p_damageDropped_1_.getValue(this.getTypeProperty()).getMeta();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getSubBlocks(Item p_getSubBlocks_1_, CreativeTabs p_getSubBlocks_2_, NonNullList<ItemStack> p_getSubBlocks_3_) {
        for (EnumFlowerType lvt_7_1_ : EnumFlowerType.getTypes(this.getBlockType())) {
            p_getSubBlocks_3_.add(new ItemStack(p_getSubBlocks_1_, 1, lvt_7_1_.getMeta()));
        }
    }

    @Override
    public IBlockState getStateFromMeta(int p_getStateFromMeta_1_) {
        return this.getDefaultState().withProperty(this.getTypeProperty(), EnumFlowerType.getType(this.getBlockType(), p_getStateFromMeta_1_));
    }

    public abstract EnumFlowerColor getBlockType();

    public IProperty<EnumFlowerType> getTypeProperty() {
        if (this.type == null) {
            this.type = PropertyEnum.create("type", EnumFlowerType.class, new Predicate<EnumFlowerType>(){

                public boolean apply(EnumFlowerType p_apply_1_) {
                    return p_apply_1_.getBlockType() == BlockFlower.this.getBlockType();
                }

                public /* synthetic */ boolean apply(Object p_apply_1_) {
                    return this.apply((EnumFlowerType)p_apply_1_);
                }
            });
        }
        return this.type;
    }

    @Override
    public int getMetaFromState(IBlockState p_getMetaFromState_1_) {
        return p_getMetaFromState_1_.getValue(this.getTypeProperty()).getMeta();
    }

    @Override
    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, this.getTypeProperty());
    }

    @Override
    public Block.EnumOffsetType getOffsetType() {
        return Block.EnumOffsetType.XZ;
    }

    public static enum EnumFlowerType implements IStringSerializable
    {
        DANDELION(EnumFlowerColor.YELLOW, 0, "dandelion"),
        POPPY(EnumFlowerColor.RED, 0, "poppy"),
        BLUE_ORCHID(EnumFlowerColor.RED, 1, "blue_orchid", "blueOrchid"),
        ALLIUM(EnumFlowerColor.RED, 2, "allium"),
        HOUSTONIA(EnumFlowerColor.RED, 3, "houstonia"),
        RED_TULIP(EnumFlowerColor.RED, 4, "red_tulip", "tulipRed"),
        ORANGE_TULIP(EnumFlowerColor.RED, 5, "orange_tulip", "tulipOrange"),
        WHITE_TULIP(EnumFlowerColor.RED, 6, "white_tulip", "tulipWhite"),
        PINK_TULIP(EnumFlowerColor.RED, 7, "pink_tulip", "tulipPink"),
        OXEYE_DAISY(EnumFlowerColor.RED, 8, "oxeye_daisy", "oxeyeDaisy");

        private static final EnumFlowerType[][] TYPES_FOR_BLOCK;
        private final EnumFlowerColor blockType;
        private final int meta;
        private final String name;
        private final String unlocalizedName;

        private EnumFlowerType(EnumFlowerColor p_i45718_3_, int p_i45718_4_, String p_i45718_5_) {
            this(p_i45718_3_, p_i45718_4_, p_i45718_5_, p_i45718_5_);
        }

        private EnumFlowerType(EnumFlowerColor p_i45719_3_, int p_i45719_4_, String p_i45719_5_, String p_i45719_6_) {
            this.blockType = p_i45719_3_;
            this.meta = p_i45719_4_;
            this.name = p_i45719_5_;
            this.unlocalizedName = p_i45719_6_;
        }

        public EnumFlowerColor getBlockType() {
            return this.blockType;
        }

        public int getMeta() {
            return this.meta;
        }

        public static EnumFlowerType getType(EnumFlowerColor p_getType_0_, int p_getType_1_) {
            EnumFlowerType[] lvt_2_1_ = TYPES_FOR_BLOCK[p_getType_0_.ordinal()];
            if (p_getType_1_ < 0 || p_getType_1_ >= lvt_2_1_.length) {
                p_getType_1_ = 0;
            }
            return lvt_2_1_[p_getType_1_];
        }

        @SideOnly(value=Side.CLIENT)
        public static EnumFlowerType[] getTypes(EnumFlowerColor p_getTypes_0_) {
            return TYPES_FOR_BLOCK[p_getTypes_0_.ordinal()];
        }

        public String toString() {
            return this.name;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public String getUnlocalizedName() {
            return this.unlocalizedName;
        }

        static {
            TYPES_FOR_BLOCK = new EnumFlowerType[EnumFlowerColor.values().length][];
            for (final EnumFlowerColor lvt_3_1_ : EnumFlowerColor.values()) {
                Collection lvt_4_1_ = Collections2.filter((Collection)Lists.newArrayList((Object[])EnumFlowerType.values()), (Predicate)new Predicate<EnumFlowerType>(){

                    public boolean apply(EnumFlowerType p_apply_1_) {
                        return p_apply_1_.getBlockType() == lvt_3_1_;
                    }

                    public /* synthetic */ boolean apply(Object p_apply_1_) {
                        return this.apply((EnumFlowerType)p_apply_1_);
                    }
                });
                EnumFlowerType.TYPES_FOR_BLOCK[lvt_3_1_.ordinal()] = lvt_4_1_.toArray(new EnumFlowerType[lvt_4_1_.size()]);
            }
        }
    }

    public static enum EnumFlowerColor {
        YELLOW,
        RED;


        public BlockFlower getBlock() {
            if (this == YELLOW) {
                return Blocks.YELLOW_FLOWER;
            }
            return Blocks.RED_FLOWER;
        }
    }
}

