/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFlowerPot;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockFlowerPot
extends BlockContainer {
    public static final PropertyInteger LEGACY_DATA = PropertyInteger.create("legacy_data", 0, 15);
    public static final PropertyEnum<EnumFlowerType> CONTENTS = PropertyEnum.create("contents", EnumFlowerType.class);
    protected static final AxisAlignedBB FLOWER_POT_AABB = new AxisAlignedBB(0.3125, 0.0, 0.3125, 0.6875, 0.375, 0.6875);

    public BlockFlowerPot() {
        super(Material.CIRCUITS);
        this.setDefaultState(this.blockState.getBaseState().withProperty(CONTENTS, EnumFlowerType.EMPTY).withProperty(LEGACY_DATA, 0));
    }

    @Override
    public String getLocalizedName() {
        return I18n.translateToLocal("item.flowerPot.name");
    }

    @Override
    public AxisAlignedBB getBoundingBox(IBlockState p_getBoundingBox_1_, IBlockAccess p_getBoundingBox_2_, BlockPos p_getBoundingBox_3_) {
        return FLOWER_POT_AABB;
    }

    @Override
    public boolean isOpaqueCube(IBlockState p_isOpaqueCube_1_) {
        return false;
    }

    @Override
    public EnumBlockRenderType getRenderType(IBlockState p_getRenderType_1_) {
        return EnumBlockRenderType.MODEL;
    }

    @Override
    public boolean isFullCube(IBlockState p_isFullCube_1_) {
        return false;
    }

    @Override
    public boolean onBlockActivated(World p_onBlockActivated_1_, BlockPos p_onBlockActivated_2_, IBlockState p_onBlockActivated_3_, EntityPlayer p_onBlockActivated_4_, EnumHand p_onBlockActivated_5_, EnumFacing p_onBlockActivated_6_, float p_onBlockActivated_7_, float p_onBlockActivated_8_, float p_onBlockActivated_9_) {
        ItemStack itemstack = p_onBlockActivated_4_.getHeldItem(p_onBlockActivated_5_);
        TileEntityFlowerPot tileentityflowerpot = this.getTileEntity(p_onBlockActivated_1_, p_onBlockActivated_2_);
        if (tileentityflowerpot == null) {
            return false;
        }
        ItemStack itemstack1 = tileentityflowerpot.getFlowerItemStack();
        if (itemstack1.isEmpty()) {
            if (!this.canBePotted(itemstack)) {
                return false;
            }
            tileentityflowerpot.setItemStack(itemstack);
            p_onBlockActivated_4_.addStat(StatList.FLOWER_POTTED);
            if (!p_onBlockActivated_4_.capabilities.isCreativeMode) {
                itemstack.shrink(1);
            }
        } else {
            if (itemstack.isEmpty()) {
                p_onBlockActivated_4_.setHeldItem(p_onBlockActivated_5_, itemstack1);
            } else if (!p_onBlockActivated_4_.func_191521_c(itemstack1)) {
                p_onBlockActivated_4_.dropItem(itemstack1, false);
            }
            tileentityflowerpot.setItemStack(ItemStack.EMPTY);
        }
        tileentityflowerpot.markDirty();
        p_onBlockActivated_1_.notifyBlockUpdate(p_onBlockActivated_2_, p_onBlockActivated_3_, p_onBlockActivated_3_, 3);
        return true;
    }

    private boolean canBePotted(ItemStack p_canBePotted_1_) {
        Block block = Block.getBlockFromItem(p_canBePotted_1_.getItem());
        if (block != Blocks.YELLOW_FLOWER && block != Blocks.RED_FLOWER && block != Blocks.CACTUS && block != Blocks.BROWN_MUSHROOM && block != Blocks.RED_MUSHROOM && block != Blocks.SAPLING && block != Blocks.DEADBUSH) {
            int i = p_canBePotted_1_.getMetadata();
            return block == Blocks.TALLGRASS && i == BlockTallGrass.EnumType.FERN.getMeta();
        }
        return true;
    }

    @Override
    public ItemStack getItem(World p_getItem_1_, BlockPos p_getItem_2_, IBlockState p_getItem_3_) {
        ItemStack itemstack;
        TileEntityFlowerPot tileentityflowerpot = this.getTileEntity(p_getItem_1_, p_getItem_2_);
        if (tileentityflowerpot != null && !(itemstack = tileentityflowerpot.getFlowerItemStack()).isEmpty()) {
            return itemstack;
        }
        return new ItemStack(Items.FLOWER_POT);
    }

    @Override
    public boolean canPlaceBlockAt(World p_canPlaceBlockAt_1_, BlockPos p_canPlaceBlockAt_2_) {
        return super.canPlaceBlockAt(p_canPlaceBlockAt_1_, p_canPlaceBlockAt_2_) && p_canPlaceBlockAt_1_.getBlockState(p_canPlaceBlockAt_2_.down()).isFullyOpaque();
    }

    @Override
    public void neighborChanged(IBlockState p_neighborChanged_1_, World p_neighborChanged_2_, BlockPos p_neighborChanged_3_, Block p_neighborChanged_4_, BlockPos p_neighborChanged_5_) {
        if (!p_neighborChanged_2_.getBlockState(p_neighborChanged_3_.down()).isFullyOpaque()) {
            this.dropBlockAsItem(p_neighborChanged_2_, p_neighborChanged_3_, p_neighborChanged_1_, 0);
            p_neighborChanged_2_.setBlockToAir(p_neighborChanged_3_);
        }
    }

    @Override
    public void breakBlock(World p_breakBlock_1_, BlockPos p_breakBlock_2_, IBlockState p_breakBlock_3_) {
        super.breakBlock(p_breakBlock_1_, p_breakBlock_2_, p_breakBlock_3_);
    }

    @Override
    public void onBlockHarvested(World p_onBlockHarvested_1_, BlockPos p_onBlockHarvested_2_, IBlockState p_onBlockHarvested_3_, EntityPlayer p_onBlockHarvested_4_) {
        TileEntityFlowerPot tileentityflowerpot;
        super.onBlockHarvested(p_onBlockHarvested_1_, p_onBlockHarvested_2_, p_onBlockHarvested_3_, p_onBlockHarvested_4_);
        if (p_onBlockHarvested_4_.capabilities.isCreativeMode && (tileentityflowerpot = this.getTileEntity(p_onBlockHarvested_1_, p_onBlockHarvested_2_)) != null) {
            tileentityflowerpot.setItemStack(ItemStack.EMPTY);
        }
    }

    @Override
    public Item getItemDropped(IBlockState p_getItemDropped_1_, Random p_getItemDropped_2_, int p_getItemDropped_3_) {
        return Items.FLOWER_POT;
    }

    @Nullable
    private TileEntityFlowerPot getTileEntity(World p_getTileEntity_1_, BlockPos p_getTileEntity_2_) {
        TileEntity tileentity = p_getTileEntity_1_.getTileEntity(p_getTileEntity_2_);
        return tileentity instanceof TileEntityFlowerPot ? (TileEntityFlowerPot)tileentity : null;
    }

    @Override
    public TileEntity createNewTileEntity(World p_createNewTileEntity_1_, int p_createNewTileEntity_2_) {
        Block block = null;
        int i = 0;
        switch (p_createNewTileEntity_2_) {
            case 1: {
                block = Blocks.RED_FLOWER;
                i = BlockFlower.EnumFlowerType.POPPY.getMeta();
                break;
            }
            case 2: {
                block = Blocks.YELLOW_FLOWER;
                break;
            }
            case 3: {
                block = Blocks.SAPLING;
                i = BlockPlanks.EnumType.OAK.getMetadata();
                break;
            }
            case 4: {
                block = Blocks.SAPLING;
                i = BlockPlanks.EnumType.SPRUCE.getMetadata();
                break;
            }
            case 5: {
                block = Blocks.SAPLING;
                i = BlockPlanks.EnumType.BIRCH.getMetadata();
                break;
            }
            case 6: {
                block = Blocks.SAPLING;
                i = BlockPlanks.EnumType.JUNGLE.getMetadata();
                break;
            }
            case 7: {
                block = Blocks.RED_MUSHROOM;
                break;
            }
            case 8: {
                block = Blocks.BROWN_MUSHROOM;
                break;
            }
            case 9: {
                block = Blocks.CACTUS;
                break;
            }
            case 10: {
                block = Blocks.DEADBUSH;
                break;
            }
            case 11: {
                block = Blocks.TALLGRASS;
                i = BlockTallGrass.EnumType.FERN.getMeta();
                break;
            }
            case 12: {
                block = Blocks.SAPLING;
                i = BlockPlanks.EnumType.ACACIA.getMetadata();
                break;
            }
            case 13: {
                block = Blocks.SAPLING;
                i = BlockPlanks.EnumType.DARK_OAK.getMetadata();
            }
        }
        return new TileEntityFlowerPot(Item.getItemFromBlock(block), i);
    }

    @Override
    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, CONTENTS, LEGACY_DATA);
    }

    @Override
    public int getMetaFromState(IBlockState p_getMetaFromState_1_) {
        return p_getMetaFromState_1_.getValue(LEGACY_DATA);
    }

    @Override
    public IBlockState getActualState(IBlockState p_getActualState_1_, IBlockAccess p_getActualState_2_, BlockPos p_getActualState_3_) {
        TileEntityFlowerPot tileentityflowerpot;
        Item item;
        TileEntity tileentity;
        EnumFlowerType blockflowerpot$enumflowertype = EnumFlowerType.EMPTY;
        TileEntity tileEntity = tileentity = p_getActualState_2_ instanceof ChunkCache ? ((ChunkCache)p_getActualState_2_).getTileEntity(p_getActualState_3_, Chunk.EnumCreateEntityType.CHECK) : p_getActualState_2_.getTileEntity(p_getActualState_3_);
        if (tileentity instanceof TileEntityFlowerPot && (item = (tileentityflowerpot = (TileEntityFlowerPot)tileentity).getFlowerPotItem()) instanceof ItemBlock) {
            int i = tileentityflowerpot.getFlowerPotData();
            Block block = Block.getBlockFromItem(item);
            if (block == Blocks.SAPLING) {
                switch (BlockPlanks.EnumType.byMetadata(i)) {
                    case OAK: {
                        blockflowerpot$enumflowertype = EnumFlowerType.OAK_SAPLING;
                        break;
                    }
                    case SPRUCE: {
                        blockflowerpot$enumflowertype = EnumFlowerType.SPRUCE_SAPLING;
                        break;
                    }
                    case BIRCH: {
                        blockflowerpot$enumflowertype = EnumFlowerType.BIRCH_SAPLING;
                        break;
                    }
                    case JUNGLE: {
                        blockflowerpot$enumflowertype = EnumFlowerType.JUNGLE_SAPLING;
                        break;
                    }
                    case ACACIA: {
                        blockflowerpot$enumflowertype = EnumFlowerType.ACACIA_SAPLING;
                        break;
                    }
                    case DARK_OAK: {
                        blockflowerpot$enumflowertype = EnumFlowerType.DARK_OAK_SAPLING;
                        break;
                    }
                    default: {
                        blockflowerpot$enumflowertype = EnumFlowerType.EMPTY;
                        break;
                    }
                }
            } else if (block == Blocks.TALLGRASS) {
                switch (i) {
                    case 0: {
                        blockflowerpot$enumflowertype = EnumFlowerType.DEAD_BUSH;
                        break;
                    }
                    case 2: {
                        blockflowerpot$enumflowertype = EnumFlowerType.FERN;
                        break;
                    }
                    default: {
                        blockflowerpot$enumflowertype = EnumFlowerType.EMPTY;
                        break;
                    }
                }
            } else if (block == Blocks.YELLOW_FLOWER) {
                blockflowerpot$enumflowertype = EnumFlowerType.DANDELION;
            } else if (block == Blocks.RED_FLOWER) {
                switch (BlockFlower.EnumFlowerType.getType(BlockFlower.EnumFlowerColor.RED, i)) {
                    case POPPY: {
                        blockflowerpot$enumflowertype = EnumFlowerType.POPPY;
                        break;
                    }
                    case BLUE_ORCHID: {
                        blockflowerpot$enumflowertype = EnumFlowerType.BLUE_ORCHID;
                        break;
                    }
                    case ALLIUM: {
                        blockflowerpot$enumflowertype = EnumFlowerType.ALLIUM;
                        break;
                    }
                    case HOUSTONIA: {
                        blockflowerpot$enumflowertype = EnumFlowerType.HOUSTONIA;
                        break;
                    }
                    case RED_TULIP: {
                        blockflowerpot$enumflowertype = EnumFlowerType.RED_TULIP;
                        break;
                    }
                    case ORANGE_TULIP: {
                        blockflowerpot$enumflowertype = EnumFlowerType.ORANGE_TULIP;
                        break;
                    }
                    case WHITE_TULIP: {
                        blockflowerpot$enumflowertype = EnumFlowerType.WHITE_TULIP;
                        break;
                    }
                    case PINK_TULIP: {
                        blockflowerpot$enumflowertype = EnumFlowerType.PINK_TULIP;
                        break;
                    }
                    case OXEYE_DAISY: {
                        blockflowerpot$enumflowertype = EnumFlowerType.OXEYE_DAISY;
                        break;
                    }
                    default: {
                        blockflowerpot$enumflowertype = EnumFlowerType.EMPTY;
                        break;
                    }
                }
            } else if (block == Blocks.RED_MUSHROOM) {
                blockflowerpot$enumflowertype = EnumFlowerType.MUSHROOM_RED;
            } else if (block == Blocks.BROWN_MUSHROOM) {
                blockflowerpot$enumflowertype = EnumFlowerType.MUSHROOM_BROWN;
            } else if (block == Blocks.DEADBUSH) {
                blockflowerpot$enumflowertype = EnumFlowerType.DEAD_BUSH;
            } else if (block == Blocks.CACTUS) {
                blockflowerpot$enumflowertype = EnumFlowerType.CACTUS;
            }
        }
        return p_getActualState_1_.withProperty(CONTENTS, blockflowerpot$enumflowertype);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer getBlockLayer() {
        return BlockRenderLayer.CUTOUT;
    }

    @Override
    public List<ItemStack> getDrops(IBlockAccess p_getDrops_1_, BlockPos p_getDrops_2_, IBlockState p_getDrops_3_, int p_getDrops_4_) {
        TileEntityFlowerPot te;
        List<ItemStack> ret = super.getDrops(p_getDrops_1_, p_getDrops_2_, p_getDrops_3_, p_getDrops_4_);
        TileEntityFlowerPot tileEntityFlowerPot = te = p_getDrops_1_.getTileEntity(p_getDrops_2_) instanceof TileEntityFlowerPot ? (TileEntityFlowerPot)p_getDrops_1_.getTileEntity(p_getDrops_2_) : null;
        if (te != null && te.getFlowerPotItem() != null) {
            ret.add(new ItemStack(te.getFlowerPotItem(), 1, te.getFlowerPotData()));
        }
        return ret;
    }

    @Override
    public boolean removedByPlayer(IBlockState p_removedByPlayer_1_, World p_removedByPlayer_2_, BlockPos p_removedByPlayer_3_, EntityPlayer p_removedByPlayer_4_, boolean p_removedByPlayer_5_) {
        if (p_removedByPlayer_5_) {
            return true;
        }
        return super.removedByPlayer(p_removedByPlayer_1_, p_removedByPlayer_2_, p_removedByPlayer_3_, p_removedByPlayer_4_, p_removedByPlayer_5_);
    }

    @Override
    public void harvestBlock(World p_harvestBlock_1_, EntityPlayer p_harvestBlock_2_, BlockPos p_harvestBlock_3_, IBlockState p_harvestBlock_4_, TileEntity p_harvestBlock_5_, ItemStack p_harvestBlock_6_) {
        super.harvestBlock(p_harvestBlock_1_, p_harvestBlock_2_, p_harvestBlock_3_, p_harvestBlock_4_, p_harvestBlock_5_, p_harvestBlock_6_);
        p_harvestBlock_1_.setBlockToAir(p_harvestBlock_3_);
    }

    public static enum EnumFlowerType implements IStringSerializable
    {
        EMPTY("empty"),
        POPPY("rose"),
        BLUE_ORCHID("blue_orchid"),
        ALLIUM("allium"),
        HOUSTONIA("houstonia"),
        RED_TULIP("red_tulip"),
        ORANGE_TULIP("orange_tulip"),
        WHITE_TULIP("white_tulip"),
        PINK_TULIP("pink_tulip"),
        OXEYE_DAISY("oxeye_daisy"),
        DANDELION("dandelion"),
        OAK_SAPLING("oak_sapling"),
        SPRUCE_SAPLING("spruce_sapling"),
        BIRCH_SAPLING("birch_sapling"),
        JUNGLE_SAPLING("jungle_sapling"),
        ACACIA_SAPLING("acacia_sapling"),
        DARK_OAK_SAPLING("dark_oak_sapling"),
        MUSHROOM_RED("mushroom_red"),
        MUSHROOM_BROWN("mushroom_brown"),
        DEAD_BUSH("dead_bush"),
        FERN("fern"),
        CACTUS("cactus");

        private final String name;

        private EnumFlowerType(String p_i45715_3_) {
            this.name = p_i45715_3_;
        }

        public String toString() {
            return this.name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

