/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockIce;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class BlockFrostedIce
extends BlockIce {
    public static final PropertyInteger AGE = PropertyInteger.create("age", 0, 3);

    public BlockFrostedIce() {
        this.setDefaultState(this.blockState.getBaseState().withProperty(AGE, 0));
    }

    @Override
    public int getMetaFromState(IBlockState p_getMetaFromState_1_) {
        return p_getMetaFromState_1_.getValue(AGE);
    }

    @Override
    public IBlockState getStateFromMeta(int p_getStateFromMeta_1_) {
        return this.getDefaultState().withProperty(AGE, MathHelper.clamp(p_getStateFromMeta_1_, 0, 3));
    }

    @Override
    public void updateTick(World p_updateTick_1_, BlockPos p_updateTick_2_, IBlockState p_updateTick_3_, Random p_updateTick_4_) {
        if ((p_updateTick_4_.nextInt(3) == 0 || this.countNeighbors(p_updateTick_1_, p_updateTick_2_) < 4) && p_updateTick_1_.getLightFromNeighbors(p_updateTick_2_) > 11 - p_updateTick_3_.getValue(AGE) - p_updateTick_3_.getLightOpacity()) {
            this.slightlyMelt(p_updateTick_1_, p_updateTick_2_, p_updateTick_3_, p_updateTick_4_, true);
        } else {
            p_updateTick_1_.scheduleUpdate(p_updateTick_2_, this, MathHelper.getInt(p_updateTick_4_, 20, 40));
        }
    }

    @Override
    public void neighborChanged(IBlockState p_neighborChanged_1_, World p_neighborChanged_2_, BlockPos p_neighborChanged_3_, Block p_neighborChanged_4_, BlockPos p_neighborChanged_5_) {
        int lvt_6_1_;
        if (p_neighborChanged_4_ == this && (lvt_6_1_ = this.countNeighbors(p_neighborChanged_2_, p_neighborChanged_3_)) < 2) {
            this.turnIntoWater(p_neighborChanged_2_, p_neighborChanged_3_);
        }
    }

    private int countNeighbors(World p_countNeighbors_1_, BlockPos p_countNeighbors_2_) {
        int lvt_3_1_ = 0;
        for (EnumFacing lvt_7_1_ : EnumFacing.values()) {
            if (p_countNeighbors_1_.getBlockState(p_countNeighbors_2_.offset(lvt_7_1_)).getBlock() != this || ++lvt_3_1_ < 4) continue;
            return lvt_3_1_;
        }
        return lvt_3_1_;
    }

    protected void slightlyMelt(World p_slightlyMelt_1_, BlockPos p_slightlyMelt_2_, IBlockState p_slightlyMelt_3_, Random p_slightlyMelt_4_, boolean p_slightlyMelt_5_) {
        int lvt_6_1_ = p_slightlyMelt_3_.getValue(AGE);
        if (lvt_6_1_ < 3) {
            p_slightlyMelt_1_.setBlockState(p_slightlyMelt_2_, p_slightlyMelt_3_.withProperty(AGE, lvt_6_1_ + 1), 2);
            p_slightlyMelt_1_.scheduleUpdate(p_slightlyMelt_2_, this, MathHelper.getInt(p_slightlyMelt_4_, 20, 40));
        } else {
            this.turnIntoWater(p_slightlyMelt_1_, p_slightlyMelt_2_);
            if (p_slightlyMelt_5_) {
                for (EnumFacing lvt_10_1_ : EnumFacing.values()) {
                    BlockPos lvt_11_1_ = p_slightlyMelt_2_.offset(lvt_10_1_);
                    IBlockState lvt_12_1_ = p_slightlyMelt_1_.getBlockState(lvt_11_1_);
                    if (lvt_12_1_.getBlock() != this) continue;
                    this.slightlyMelt(p_slightlyMelt_1_, lvt_11_1_, lvt_12_1_, p_slightlyMelt_4_, false);
                }
            }
        }
    }

    @Override
    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, AGE);
    }

    @Override
    public ItemStack getItem(World p_getItem_1_, BlockPos p_getItem_2_, IBlockState p_getItem_3_) {
        return ItemStack.EMPTY;
    }
}

