/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockFurnace
extends BlockContainer {
    public static final PropertyDirection FACING = BlockHorizontal.FACING;
    private final boolean isBurning;
    private static boolean keepInventory;

    protected BlockFurnace(boolean p_i45407_1_) {
        super(Material.ROCK);
        this.setDefaultState(this.blockState.getBaseState().withProperty(FACING, EnumFacing.NORTH));
        this.isBurning = p_i45407_1_;
    }

    @Override
    public Item getItemDropped(IBlockState p_getItemDropped_1_, Random p_getItemDropped_2_, int p_getItemDropped_3_) {
        return Item.getItemFromBlock(Blocks.FURNACE);
    }

    @Override
    public void onBlockAdded(World p_onBlockAdded_1_, BlockPos p_onBlockAdded_2_, IBlockState p_onBlockAdded_3_) {
        this.setDefaultFacing(p_onBlockAdded_1_, p_onBlockAdded_2_, p_onBlockAdded_3_);
    }

    private void setDefaultFacing(World p_setDefaultFacing_1_, BlockPos p_setDefaultFacing_2_, IBlockState p_setDefaultFacing_3_) {
        if (p_setDefaultFacing_1_.isRemote) {
            return;
        }
        IBlockState lvt_4_1_ = p_setDefaultFacing_1_.getBlockState(p_setDefaultFacing_2_.north());
        IBlockState lvt_5_1_ = p_setDefaultFacing_1_.getBlockState(p_setDefaultFacing_2_.south());
        IBlockState lvt_6_1_ = p_setDefaultFacing_1_.getBlockState(p_setDefaultFacing_2_.west());
        IBlockState lvt_7_1_ = p_setDefaultFacing_1_.getBlockState(p_setDefaultFacing_2_.east());
        EnumFacing lvt_8_1_ = p_setDefaultFacing_3_.getValue(FACING);
        if (lvt_8_1_ == EnumFacing.NORTH && lvt_4_1_.isFullBlock() && !lvt_5_1_.isFullBlock()) {
            lvt_8_1_ = EnumFacing.SOUTH;
        } else if (lvt_8_1_ == EnumFacing.SOUTH && lvt_5_1_.isFullBlock() && !lvt_4_1_.isFullBlock()) {
            lvt_8_1_ = EnumFacing.NORTH;
        } else if (lvt_8_1_ == EnumFacing.WEST && lvt_6_1_.isFullBlock() && !lvt_7_1_.isFullBlock()) {
            lvt_8_1_ = EnumFacing.EAST;
        } else if (lvt_8_1_ == EnumFacing.EAST && lvt_7_1_.isFullBlock() && !lvt_6_1_.isFullBlock()) {
            lvt_8_1_ = EnumFacing.WEST;
        }
        p_setDefaultFacing_1_.setBlockState(p_setDefaultFacing_2_, p_setDefaultFacing_3_.withProperty(FACING, lvt_8_1_), 2);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(IBlockState p_randomDisplayTick_1_, World p_randomDisplayTick_2_, BlockPos p_randomDisplayTick_3_, Random p_randomDisplayTick_4_) {
        if (!this.isBurning) {
            return;
        }
        EnumFacing lvt_5_1_ = p_randomDisplayTick_1_.getValue(FACING);
        double lvt_6_1_ = (double)p_randomDisplayTick_3_.getX() + 0.5;
        double lvt_8_1_ = (double)p_randomDisplayTick_3_.getY() + p_randomDisplayTick_4_.nextDouble() * 6.0 / 16.0;
        double lvt_10_1_ = (double)p_randomDisplayTick_3_.getZ() + 0.5;
        double lvt_12_1_ = 0.52;
        double lvt_14_1_ = p_randomDisplayTick_4_.nextDouble() * 0.6 - 0.3;
        if (p_randomDisplayTick_4_.nextDouble() < 0.1) {
            p_randomDisplayTick_2_.playSound((double)p_randomDisplayTick_3_.getX() + 0.5, (double)p_randomDisplayTick_3_.getY(), (double)p_randomDisplayTick_3_.getZ() + 0.5, SoundEvents.BLOCK_FURNACE_FIRE_CRACKLE, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
        }
        switch (lvt_5_1_) {
            case WEST: {
                p_randomDisplayTick_2_.spawnParticle(EnumParticleTypes.SMOKE_NORMAL, lvt_6_1_ - 0.52, lvt_8_1_, lvt_10_1_ + lvt_14_1_, 0.0, 0.0, 0.0, new int[0]);
                p_randomDisplayTick_2_.spawnParticle(EnumParticleTypes.FLAME, lvt_6_1_ - 0.52, lvt_8_1_, lvt_10_1_ + lvt_14_1_, 0.0, 0.0, 0.0, new int[0]);
                break;
            }
            case EAST: {
                p_randomDisplayTick_2_.spawnParticle(EnumParticleTypes.SMOKE_NORMAL, lvt_6_1_ + 0.52, lvt_8_1_, lvt_10_1_ + lvt_14_1_, 0.0, 0.0, 0.0, new int[0]);
                p_randomDisplayTick_2_.spawnParticle(EnumParticleTypes.FLAME, lvt_6_1_ + 0.52, lvt_8_1_, lvt_10_1_ + lvt_14_1_, 0.0, 0.0, 0.0, new int[0]);
                break;
            }
            case NORTH: {
                p_randomDisplayTick_2_.spawnParticle(EnumParticleTypes.SMOKE_NORMAL, lvt_6_1_ + lvt_14_1_, lvt_8_1_, lvt_10_1_ - 0.52, 0.0, 0.0, 0.0, new int[0]);
                p_randomDisplayTick_2_.spawnParticle(EnumParticleTypes.FLAME, lvt_6_1_ + lvt_14_1_, lvt_8_1_, lvt_10_1_ - 0.52, 0.0, 0.0, 0.0, new int[0]);
                break;
            }
            case SOUTH: {
                p_randomDisplayTick_2_.spawnParticle(EnumParticleTypes.SMOKE_NORMAL, lvt_6_1_ + lvt_14_1_, lvt_8_1_, lvt_10_1_ + 0.52, 0.0, 0.0, 0.0, new int[0]);
                p_randomDisplayTick_2_.spawnParticle(EnumParticleTypes.FLAME, lvt_6_1_ + lvt_14_1_, lvt_8_1_, lvt_10_1_ + 0.52, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    @Override
    public boolean onBlockActivated(World p_onBlockActivated_1_, BlockPos p_onBlockActivated_2_, IBlockState p_onBlockActivated_3_, EntityPlayer p_onBlockActivated_4_, EnumHand p_onBlockActivated_5_, EnumFacing p_onBlockActivated_6_, float p_onBlockActivated_7_, float p_onBlockActivated_8_, float p_onBlockActivated_9_) {
        if (p_onBlockActivated_1_.isRemote) {
            return true;
        }
        TileEntity lvt_10_1_ = p_onBlockActivated_1_.getTileEntity(p_onBlockActivated_2_);
        if (lvt_10_1_ instanceof TileEntityFurnace) {
            p_onBlockActivated_4_.displayGUIChest((TileEntityFurnace)lvt_10_1_);
            p_onBlockActivated_4_.addStat(StatList.FURNACE_INTERACTION);
        }
        return true;
    }

    public static void setState(boolean p_setState_0_, World p_setState_1_, BlockPos p_setState_2_) {
        IBlockState lvt_3_1_ = p_setState_1_.getBlockState(p_setState_2_);
        TileEntity lvt_4_1_ = p_setState_1_.getTileEntity(p_setState_2_);
        keepInventory = true;
        if (p_setState_0_) {
            p_setState_1_.setBlockState(p_setState_2_, Blocks.LIT_FURNACE.getDefaultState().withProperty(FACING, lvt_3_1_.getValue(FACING)), 3);
            p_setState_1_.setBlockState(p_setState_2_, Blocks.LIT_FURNACE.getDefaultState().withProperty(FACING, lvt_3_1_.getValue(FACING)), 3);
        } else {
            p_setState_1_.setBlockState(p_setState_2_, Blocks.FURNACE.getDefaultState().withProperty(FACING, lvt_3_1_.getValue(FACING)), 3);
            p_setState_1_.setBlockState(p_setState_2_, Blocks.FURNACE.getDefaultState().withProperty(FACING, lvt_3_1_.getValue(FACING)), 3);
        }
        keepInventory = false;
        if (lvt_4_1_ != null) {
            lvt_4_1_.validate();
            p_setState_1_.setTileEntity(p_setState_2_, lvt_4_1_);
        }
    }

    @Override
    public TileEntity createNewTileEntity(World p_createNewTileEntity_1_, int p_createNewTileEntity_2_) {
        return new TileEntityFurnace();
    }

    @Override
    public IBlockState getStateForPlacement(World p_getStateForPlacement_1_, BlockPos p_getStateForPlacement_2_, EnumFacing p_getStateForPlacement_3_, float p_getStateForPlacement_4_, float p_getStateForPlacement_5_, float p_getStateForPlacement_6_, int p_getStateForPlacement_7_, EntityLivingBase p_getStateForPlacement_8_) {
        return this.getDefaultState().withProperty(FACING, p_getStateForPlacement_8_.getHorizontalFacing().getOpposite());
    }

    @Override
    public void onBlockPlacedBy(World p_onBlockPlacedBy_1_, BlockPos p_onBlockPlacedBy_2_, IBlockState p_onBlockPlacedBy_3_, EntityLivingBase p_onBlockPlacedBy_4_, ItemStack p_onBlockPlacedBy_5_) {
        TileEntity lvt_6_1_;
        p_onBlockPlacedBy_1_.setBlockState(p_onBlockPlacedBy_2_, p_onBlockPlacedBy_3_.withProperty(FACING, p_onBlockPlacedBy_4_.getHorizontalFacing().getOpposite()), 2);
        if (p_onBlockPlacedBy_5_.hasDisplayName() && (lvt_6_1_ = p_onBlockPlacedBy_1_.getTileEntity(p_onBlockPlacedBy_2_)) instanceof TileEntityFurnace) {
            ((TileEntityFurnace)lvt_6_1_).setCustomInventoryName(p_onBlockPlacedBy_5_.getDisplayName());
        }
    }

    @Override
    public void breakBlock(World p_breakBlock_1_, BlockPos p_breakBlock_2_, IBlockState p_breakBlock_3_) {
        TileEntity lvt_4_1_;
        if (!keepInventory && (lvt_4_1_ = p_breakBlock_1_.getTileEntity(p_breakBlock_2_)) instanceof TileEntityFurnace) {
            InventoryHelper.dropInventoryItems(p_breakBlock_1_, p_breakBlock_2_, (IInventory)((TileEntityFurnace)lvt_4_1_));
            p_breakBlock_1_.updateComparatorOutputLevel(p_breakBlock_2_, this);
        }
        super.breakBlock(p_breakBlock_1_, p_breakBlock_2_, p_breakBlock_3_);
    }

    @Override
    public boolean hasComparatorInputOverride(IBlockState p_hasComparatorInputOverride_1_) {
        return true;
    }

    @Override
    public int getComparatorInputOverride(IBlockState p_getComparatorInputOverride_1_, World p_getComparatorInputOverride_2_, BlockPos p_getComparatorInputOverride_3_) {
        return Container.calcRedstone(p_getComparatorInputOverride_2_.getTileEntity(p_getComparatorInputOverride_3_));
    }

    @Override
    public ItemStack getItem(World p_getItem_1_, BlockPos p_getItem_2_, IBlockState p_getItem_3_) {
        return new ItemStack(Blocks.FURNACE);
    }

    @Override
    public EnumBlockRenderType getRenderType(IBlockState p_getRenderType_1_) {
        return EnumBlockRenderType.MODEL;
    }

    @Override
    public IBlockState getStateFromMeta(int p_getStateFromMeta_1_) {
        EnumFacing lvt_2_1_ = EnumFacing.getFront(p_getStateFromMeta_1_);
        if (lvt_2_1_.getAxis() == EnumFacing.Axis.Y) {
            lvt_2_1_ = EnumFacing.NORTH;
        }
        return this.getDefaultState().withProperty(FACING, lvt_2_1_);
    }

    @Override
    public int getMetaFromState(IBlockState p_getMetaFromState_1_) {
        return p_getMetaFromState_1_.getValue(FACING).getIndex();
    }

    @Override
    public IBlockState withRotation(IBlockState p_withRotation_1_, Rotation p_withRotation_2_) {
        return p_withRotation_1_.withProperty(FACING, p_withRotation_2_.rotate(p_withRotation_1_.getValue(FACING)));
    }

    @Override
    public IBlockState withMirror(IBlockState p_withMirror_1_, Mirror p_withMirror_2_) {
        return p_withMirror_1_.withRotation(p_withMirror_2_.toRotation(p_withMirror_1_.getValue(FACING)));
    }

    @Override
    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, FACING);
    }
}

