/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.IGrowable;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockGrass
extends Block
implements IGrowable {
    public static final PropertyBool SNOWY = PropertyBool.create("snowy");

    protected BlockGrass() {
        super(Material.GRASS);
        this.setDefaultState(this.blockState.getBaseState().withProperty(SNOWY, false));
        this.setTickRandomly(true);
        this.setCreativeTab(CreativeTabs.BUILDING_BLOCKS);
    }

    @Override
    public IBlockState getActualState(IBlockState p_getActualState_1_, IBlockAccess p_getActualState_2_, BlockPos p_getActualState_3_) {
        Block block = p_getActualState_2_.getBlockState(p_getActualState_3_.up()).getBlock();
        return p_getActualState_1_.withProperty(SNOWY, block == Blocks.SNOW || block == Blocks.SNOW_LAYER);
    }

    @Override
    public void updateTick(World p_updateTick_1_, BlockPos p_updateTick_2_, IBlockState p_updateTick_3_, Random p_updateTick_4_) {
        if (!p_updateTick_1_.isRemote) {
            if (p_updateTick_1_.getLightFromNeighbors(p_updateTick_2_.up()) < 4 && p_updateTick_1_.getBlockState(p_updateTick_2_.up()).getLightOpacity(p_updateTick_1_, p_updateTick_2_.up()) > 2) {
                p_updateTick_1_.setBlockState(p_updateTick_2_, Blocks.DIRT.getDefaultState());
            } else if (p_updateTick_1_.getLightFromNeighbors(p_updateTick_2_.up()) >= 9) {
                for (int i = 0; i < 4; ++i) {
                    BlockPos blockpos = p_updateTick_2_.add(p_updateTick_4_.nextInt(3) - 1, p_updateTick_4_.nextInt(5) - 3, p_updateTick_4_.nextInt(3) - 1);
                    if (blockpos.getY() >= 0 && blockpos.getY() < 256 && !p_updateTick_1_.isBlockLoaded(blockpos)) {
                        return;
                    }
                    IBlockState iblockstate = p_updateTick_1_.getBlockState(blockpos.up());
                    IBlockState iblockstate1 = p_updateTick_1_.getBlockState(blockpos);
                    if (iblockstate1.getBlock() != Blocks.DIRT || iblockstate1.getValue(BlockDirt.VARIANT) != BlockDirt.DirtType.DIRT || p_updateTick_1_.getLightFromNeighbors(blockpos.up()) < 4 || iblockstate.getLightOpacity(p_updateTick_1_, p_updateTick_2_.up()) > 2) continue;
                    p_updateTick_1_.setBlockState(blockpos, Blocks.GRASS.getDefaultState());
                }
            }
        }
    }

    @Override
    public Item getItemDropped(IBlockState p_getItemDropped_1_, Random p_getItemDropped_2_, int p_getItemDropped_3_) {
        return Blocks.DIRT.getItemDropped(Blocks.DIRT.getDefaultState().withProperty(BlockDirt.VARIANT, BlockDirt.DirtType.DIRT), p_getItemDropped_2_, p_getItemDropped_3_);
    }

    @Override
    public boolean canGrow(World p_canGrow_1_, BlockPos p_canGrow_2_, IBlockState p_canGrow_3_, boolean p_canGrow_4_) {
        return true;
    }

    @Override
    public boolean canUseBonemeal(World p_canUseBonemeal_1_, Random p_canUseBonemeal_2_, BlockPos p_canUseBonemeal_3_, IBlockState p_canUseBonemeal_4_) {
        return true;
    }

    @Override
    public void grow(World p_grow_1_, Random p_grow_2_, BlockPos p_grow_3_, IBlockState p_grow_4_) {
        BlockPos blockpos = p_grow_3_.up();
        block0: for (int i = 0; i < 128; ++i) {
            BlockPos blockpos1 = blockpos;
            int j = 0;
            while (true) {
                if (j >= i / 16) {
                    if (!p_grow_1_.isAirBlock(blockpos1)) continue block0;
                    if (p_grow_2_.nextInt(8) == 0) {
                        p_grow_1_.getBiome(blockpos1).plantFlower(p_grow_1_, p_grow_2_, blockpos1);
                        continue block0;
                    }
                    IBlockState iblockstate1 = Blocks.TALLGRASS.getDefaultState().withProperty(BlockTallGrass.TYPE, BlockTallGrass.EnumType.GRASS);
                    if (!Blocks.TALLGRASS.canBlockStay(p_grow_1_, blockpos1, iblockstate1)) continue block0;
                    p_grow_1_.setBlockState(blockpos1, iblockstate1, 3);
                    continue block0;
                }
                if (p_grow_1_.getBlockState((blockpos1 = blockpos1.add(p_grow_2_.nextInt(3) - 1, (p_grow_2_.nextInt(3) - 1) * p_grow_2_.nextInt(3) / 2, p_grow_2_.nextInt(3) - 1)).down()).getBlock() != Blocks.GRASS || p_grow_1_.getBlockState(blockpos1).isNormalCube()) continue block0;
                ++j;
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer getBlockLayer() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    @Override
    public int getMetaFromState(IBlockState p_getMetaFromState_1_) {
        return 0;
    }

    @Override
    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, SNOWY);
    }
}

