/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockGrassPath
extends Block {
    protected static final AxisAlignedBB GRASS_PATH_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.9375, 1.0);

    protected BlockGrassPath() {
        super(Material.GROUND);
        this.setLightOpacity(255);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(IBlockState p_shouldSideBeRendered_1_, IBlockAccess p_shouldSideBeRendered_2_, BlockPos p_shouldSideBeRendered_3_, EnumFacing p_shouldSideBeRendered_4_) {
        switch (p_shouldSideBeRendered_4_) {
            case UP: {
                return true;
            }
            case NORTH: 
            case SOUTH: 
            case WEST: 
            case EAST: {
                IBlockState lvt_5_1_ = p_shouldSideBeRendered_2_.getBlockState(p_shouldSideBeRendered_3_.offset(p_shouldSideBeRendered_4_));
                Block lvt_6_1_ = lvt_5_1_.getBlock();
                return !lvt_5_1_.isOpaqueCube() && lvt_6_1_ != Blocks.FARMLAND && lvt_6_1_ != Blocks.GRASS_PATH;
            }
        }
        return super.shouldSideBeRendered(p_shouldSideBeRendered_1_, p_shouldSideBeRendered_2_, p_shouldSideBeRendered_3_, p_shouldSideBeRendered_4_);
    }

    @Override
    public void onBlockAdded(World p_onBlockAdded_1_, BlockPos p_onBlockAdded_2_, IBlockState p_onBlockAdded_3_) {
        super.onBlockAdded(p_onBlockAdded_1_, p_onBlockAdded_2_, p_onBlockAdded_3_);
        this.updateBlockState(p_onBlockAdded_1_, p_onBlockAdded_2_);
    }

    private void updateBlockState(World p_updateBlockState_1_, BlockPos p_updateBlockState_2_) {
        if (p_updateBlockState_1_.getBlockState(p_updateBlockState_2_.up()).getMaterial().isSolid()) {
            p_updateBlockState_1_.setBlockState(p_updateBlockState_2_, Blocks.DIRT.getDefaultState());
        }
    }

    @Override
    public AxisAlignedBB getBoundingBox(IBlockState p_getBoundingBox_1_, IBlockAccess p_getBoundingBox_2_, BlockPos p_getBoundingBox_3_) {
        return GRASS_PATH_AABB;
    }

    @Override
    public boolean isOpaqueCube(IBlockState p_isOpaqueCube_1_) {
        return false;
    }

    @Override
    public boolean isFullCube(IBlockState p_isFullCube_1_) {
        return false;
    }

    @Override
    public Item getItemDropped(IBlockState p_getItemDropped_1_, Random p_getItemDropped_2_, int p_getItemDropped_3_) {
        return Blocks.DIRT.getItemDropped(Blocks.DIRT.getDefaultState().withProperty(BlockDirt.VARIANT, BlockDirt.DirtType.DIRT), p_getItemDropped_2_, p_getItemDropped_3_);
    }

    @Override
    public ItemStack getItem(World p_getItem_1_, BlockPos p_getItem_2_, IBlockState p_getItem_3_) {
        return new ItemStack(this);
    }

    @Override
    public void neighborChanged(IBlockState p_neighborChanged_1_, World p_neighborChanged_2_, BlockPos p_neighborChanged_3_, Block p_neighborChanged_4_, BlockPos p_neighborChanged_5_) {
        super.neighborChanged(p_neighborChanged_1_, p_neighborChanged_2_, p_neighborChanged_3_, p_neighborChanged_4_, p_neighborChanged_5_);
        this.updateBlockState(p_neighborChanged_2_, p_neighborChanged_3_);
    }
}

