/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockHugeMushroom
extends Block {
    public static final PropertyEnum<EnumType> VARIANT = PropertyEnum.create("variant", EnumType.class);
    private final Block smallBlock;

    public BlockHugeMushroom(Material p_i46392_1_, MapColor p_i46392_2_, Block p_i46392_3_) {
        super(p_i46392_1_, p_i46392_2_);
        this.setDefaultState(this.blockState.getBaseState().withProperty(VARIANT, EnumType.ALL_OUTSIDE));
        this.smallBlock = p_i46392_3_;
    }

    @Override
    public int quantityDropped(Random p_quantityDropped_1_) {
        return Math.max(0, p_quantityDropped_1_.nextInt(10) - 7);
    }

    @Override
    public MapColor getMapColor(IBlockState p_getMapColor_1_) {
        switch (p_getMapColor_1_.getValue(VARIANT)) {
            case ALL_STEM: {
                return MapColor.CLOTH;
            }
            case ALL_INSIDE: {
                return MapColor.SAND;
            }
            case STEM: {
                return MapColor.SAND;
            }
        }
        return super.getMapColor(p_getMapColor_1_);
    }

    @Override
    public Item getItemDropped(IBlockState p_getItemDropped_1_, Random p_getItemDropped_2_, int p_getItemDropped_3_) {
        return Item.getItemFromBlock(this.smallBlock);
    }

    @Override
    public ItemStack getItem(World p_getItem_1_, BlockPos p_getItem_2_, IBlockState p_getItem_3_) {
        return new ItemStack(this.smallBlock);
    }

    @Override
    public IBlockState getStateForPlacement(World p_getStateForPlacement_1_, BlockPos p_getStateForPlacement_2_, EnumFacing p_getStateForPlacement_3_, float p_getStateForPlacement_4_, float p_getStateForPlacement_5_, float p_getStateForPlacement_6_, int p_getStateForPlacement_7_, EntityLivingBase p_getStateForPlacement_8_) {
        return this.getDefaultState();
    }

    @Override
    public IBlockState getStateFromMeta(int p_getStateFromMeta_1_) {
        return this.getDefaultState().withProperty(VARIANT, EnumType.byMetadata(p_getStateFromMeta_1_));
    }

    @Override
    public int getMetaFromState(IBlockState p_getMetaFromState_1_) {
        return p_getMetaFromState_1_.getValue(VARIANT).getMetadata();
    }

    @Override
    public IBlockState withRotation(IBlockState p_withRotation_1_, Rotation p_withRotation_2_) {
        block0 : switch (p_withRotation_2_) {
            case CLOCKWISE_180: {
                switch (p_withRotation_1_.getValue(VARIANT)) {
                    case STEM: {
                        break;
                    }
                    case NORTH_WEST: {
                        return p_withRotation_1_.withProperty(VARIANT, EnumType.SOUTH_EAST);
                    }
                    case NORTH: {
                        return p_withRotation_1_.withProperty(VARIANT, EnumType.SOUTH);
                    }
                    case NORTH_EAST: {
                        return p_withRotation_1_.withProperty(VARIANT, EnumType.SOUTH_WEST);
                    }
                    case WEST: {
                        return p_withRotation_1_.withProperty(VARIANT, EnumType.EAST);
                    }
                    case EAST: {
                        return p_withRotation_1_.withProperty(VARIANT, EnumType.WEST);
                    }
                    case SOUTH_WEST: {
                        return p_withRotation_1_.withProperty(VARIANT, EnumType.NORTH_EAST);
                    }
                    case SOUTH: {
                        return p_withRotation_1_.withProperty(VARIANT, EnumType.NORTH);
                    }
                    case SOUTH_EAST: {
                        return p_withRotation_1_.withProperty(VARIANT, EnumType.NORTH_WEST);
                    }
                    default: {
                        return p_withRotation_1_;
                    }
                }
            }
            case COUNTERCLOCKWISE_90: {
                switch (p_withRotation_1_.getValue(VARIANT)) {
                    case STEM: {
                        break;
                    }
                    case NORTH_WEST: {
                        return p_withRotation_1_.withProperty(VARIANT, EnumType.SOUTH_WEST);
                    }
                    case NORTH: {
                        return p_withRotation_1_.withProperty(VARIANT, EnumType.WEST);
                    }
                    case NORTH_EAST: {
                        return p_withRotation_1_.withProperty(VARIANT, EnumType.NORTH_WEST);
                    }
                    case WEST: {
                        return p_withRotation_1_.withProperty(VARIANT, EnumType.SOUTH);
                    }
                    case EAST: {
                        return p_withRotation_1_.withProperty(VARIANT, EnumType.NORTH);
                    }
                    case SOUTH_WEST: {
                        return p_withRotation_1_.withProperty(VARIANT, EnumType.SOUTH_EAST);
                    }
                    case SOUTH: {
                        return p_withRotation_1_.withProperty(VARIANT, EnumType.EAST);
                    }
                    case SOUTH_EAST: {
                        return p_withRotation_1_.withProperty(VARIANT, EnumType.NORTH_EAST);
                    }
                    default: {
                        return p_withRotation_1_;
                    }
                }
            }
            case CLOCKWISE_90: {
                switch (p_withRotation_1_.getValue(VARIANT)) {
                    case STEM: {
                        break block0;
                    }
                    case NORTH_WEST: {
                        return p_withRotation_1_.withProperty(VARIANT, EnumType.NORTH_EAST);
                    }
                    case NORTH: {
                        return p_withRotation_1_.withProperty(VARIANT, EnumType.EAST);
                    }
                    case NORTH_EAST: {
                        return p_withRotation_1_.withProperty(VARIANT, EnumType.SOUTH_EAST);
                    }
                    case WEST: {
                        return p_withRotation_1_.withProperty(VARIANT, EnumType.NORTH);
                    }
                    case EAST: {
                        return p_withRotation_1_.withProperty(VARIANT, EnumType.SOUTH);
                    }
                    case SOUTH_WEST: {
                        return p_withRotation_1_.withProperty(VARIANT, EnumType.NORTH_WEST);
                    }
                    case SOUTH: {
                        return p_withRotation_1_.withProperty(VARIANT, EnumType.WEST);
                    }
                    case SOUTH_EAST: {
                        return p_withRotation_1_.withProperty(VARIANT, EnumType.SOUTH_WEST);
                    }
                }
                return p_withRotation_1_;
            }
        }
        return p_withRotation_1_;
    }

    @Override
    public IBlockState withMirror(IBlockState p_withMirror_1_, Mirror p_withMirror_2_) {
        EnumType blockhugemushroom$enumtype = p_withMirror_1_.getValue(VARIANT);
        block0 : switch (p_withMirror_2_) {
            case LEFT_RIGHT: {
                switch (blockhugemushroom$enumtype) {
                    case NORTH_WEST: {
                        return p_withMirror_1_.withProperty(VARIANT, EnumType.SOUTH_WEST);
                    }
                    case NORTH: {
                        return p_withMirror_1_.withProperty(VARIANT, EnumType.SOUTH);
                    }
                    case NORTH_EAST: {
                        return p_withMirror_1_.withProperty(VARIANT, EnumType.SOUTH_EAST);
                    }
                    default: {
                        return super.withMirror(p_withMirror_1_, p_withMirror_2_);
                    }
                    case SOUTH_WEST: {
                        return p_withMirror_1_.withProperty(VARIANT, EnumType.NORTH_WEST);
                    }
                    case SOUTH: {
                        return p_withMirror_1_.withProperty(VARIANT, EnumType.NORTH);
                    }
                    case SOUTH_EAST: 
                }
                return p_withMirror_1_.withProperty(VARIANT, EnumType.NORTH_EAST);
            }
            case FRONT_BACK: {
                switch (blockhugemushroom$enumtype) {
                    case NORTH_WEST: {
                        return p_withMirror_1_.withProperty(VARIANT, EnumType.NORTH_EAST);
                    }
                    default: {
                        break block0;
                    }
                    case NORTH_EAST: {
                        return p_withMirror_1_.withProperty(VARIANT, EnumType.NORTH_WEST);
                    }
                    case WEST: {
                        return p_withMirror_1_.withProperty(VARIANT, EnumType.EAST);
                    }
                    case EAST: {
                        return p_withMirror_1_.withProperty(VARIANT, EnumType.WEST);
                    }
                    case SOUTH_WEST: {
                        return p_withMirror_1_.withProperty(VARIANT, EnumType.SOUTH_EAST);
                    }
                    case SOUTH_EAST: 
                }
                return p_withMirror_1_.withProperty(VARIANT, EnumType.SOUTH_WEST);
            }
        }
        return super.withMirror(p_withMirror_1_, p_withMirror_2_);
    }

    @Override
    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, VARIANT);
    }

    @Override
    public boolean rotateBlock(World p_rotateBlock_1_, BlockPos p_rotateBlock_2_, EnumFacing p_rotateBlock_3_) {
        IBlockState state = p_rotateBlock_1_.getBlockState(p_rotateBlock_2_);
        for (IProperty prop : state.getProperties().keySet()) {
            if (!prop.getName().equals("variant")) continue;
            p_rotateBlock_1_.setBlockState(p_rotateBlock_2_, state.cycleProperty(prop));
            return true;
        }
        return false;
    }

    public static enum EnumType implements IStringSerializable
    {
        NORTH_WEST(1, "north_west"),
        NORTH(2, "north"),
        NORTH_EAST(3, "north_east"),
        WEST(4, "west"),
        CENTER(5, "center"),
        EAST(6, "east"),
        SOUTH_WEST(7, "south_west"),
        SOUTH(8, "south"),
        SOUTH_EAST(9, "south_east"),
        STEM(10, "stem"),
        ALL_INSIDE(0, "all_inside"),
        ALL_OUTSIDE(14, "all_outside"),
        ALL_STEM(15, "all_stem");

        private static final EnumType[] META_LOOKUP;
        private final int meta;
        private final String name;

        private EnumType(int p_i45710_3_, String p_i45710_4_) {
            this.meta = p_i45710_3_;
            this.name = p_i45710_4_;
        }

        public int getMetadata() {
            return this.meta;
        }

        public String toString() {
            return this.name;
        }

        public static EnumType byMetadata(int p_byMetadata_0_) {
            EnumType blockhugemushroom$enumtype;
            if (p_byMetadata_0_ < 0 || p_byMetadata_0_ >= META_LOOKUP.length) {
                p_byMetadata_0_ = 0;
            }
            return (blockhugemushroom$enumtype = META_LOOKUP[p_byMetadata_0_]) == null ? META_LOOKUP[0] : blockhugemushroom$enumtype;
        }

        @Override
        public String getName() {
            return this.name;
        }

        static {
            META_LOOKUP = new EnumType[16];
            EnumType[] enumTypeArray = EnumType.values();
            int n = enumTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumType blockhugemushroom$enumtype;
                EnumType.META_LOOKUP[blockhugemushroom$enumtype.getMetadata()] = blockhugemushroom$enumtype = enumTypeArray[i];
            }
        }
    }
}

