/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.BlockBreakable;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockIce
extends BlockBreakable {
    public BlockIce() {
        super(Material.ICE, false);
        this.slipperiness = 0.98f;
        this.setTickRandomly(true);
        this.setCreativeTab(CreativeTabs.BUILDING_BLOCKS);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer getBlockLayer() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    @Override
    public void harvestBlock(World p_harvestBlock_1_, EntityPlayer p_harvestBlock_2_, BlockPos p_harvestBlock_3_, IBlockState p_harvestBlock_4_, TileEntity p_harvestBlock_5_, ItemStack p_harvestBlock_6_) {
        p_harvestBlock_2_.addStat(StatList.getBlockStats(this));
        p_harvestBlock_2_.addExhaustion(0.005f);
        if (this.canSilkHarvest(p_harvestBlock_1_, p_harvestBlock_3_, p_harvestBlock_4_, p_harvestBlock_2_) && EnchantmentHelper.getEnchantmentLevel(Enchantments.SILK_TOUCH, p_harvestBlock_6_) > 0) {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            items.add(this.getSilkTouchDrop(p_harvestBlock_4_));
            ForgeEventFactory.fireBlockHarvesting(items, p_harvestBlock_1_, p_harvestBlock_3_, p_harvestBlock_4_, 0, 1.0f, true, p_harvestBlock_2_);
            for (ItemStack is : items) {
                BlockIce.spawnAsEntity(p_harvestBlock_1_, p_harvestBlock_3_, is);
            }
        } else {
            if (p_harvestBlock_1_.provider.doesWaterVaporize()) {
                p_harvestBlock_1_.setBlockToAir(p_harvestBlock_3_);
                return;
            }
            int i = EnchantmentHelper.getEnchantmentLevel(Enchantments.FORTUNE, p_harvestBlock_6_);
            this.harvesters.set(p_harvestBlock_2_);
            this.dropBlockAsItem(p_harvestBlock_1_, p_harvestBlock_3_, p_harvestBlock_4_, i);
            this.harvesters.set(null);
            Material material = p_harvestBlock_1_.getBlockState(p_harvestBlock_3_.down()).getMaterial();
            if (material.blocksMovement() || material.isLiquid()) {
                p_harvestBlock_1_.setBlockState(p_harvestBlock_3_, Blocks.FLOWING_WATER.getDefaultState());
            }
        }
    }

    @Override
    public int quantityDropped(Random p_quantityDropped_1_) {
        return 0;
    }

    @Override
    public void updateTick(World p_updateTick_1_, BlockPos p_updateTick_2_, IBlockState p_updateTick_3_, Random p_updateTick_4_) {
        if (p_updateTick_1_.getLightFor(EnumSkyBlock.BLOCK, p_updateTick_2_) > 11 - this.getDefaultState().getLightOpacity()) {
            this.turnIntoWater(p_updateTick_1_, p_updateTick_2_);
        }
    }

    protected void turnIntoWater(World p_turnIntoWater_1_, BlockPos p_turnIntoWater_2_) {
        if (p_turnIntoWater_1_.provider.doesWaterVaporize()) {
            p_turnIntoWater_1_.setBlockToAir(p_turnIntoWater_2_);
        } else {
            this.dropBlockAsItem(p_turnIntoWater_1_, p_turnIntoWater_2_, p_turnIntoWater_1_.getBlockState(p_turnIntoWater_2_), 0);
            p_turnIntoWater_1_.setBlockState(p_turnIntoWater_2_, Blocks.WATER.getDefaultState());
            p_turnIntoWater_1_.neighborChanged(p_turnIntoWater_2_, Blocks.WATER, p_turnIntoWater_2_);
        }
    }

    @Override
    public EnumPushReaction getMobilityFlag(IBlockState p_getMobilityFlag_1_) {
        return EnumPushReaction.NORMAL;
    }
}

