/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.datafix.DataFixer;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.walkers.ItemStackData;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockJukebox
extends BlockContainer {
    public static final PropertyBool HAS_RECORD = PropertyBool.create("has_record");

    public static void registerFixesJukebox(DataFixer p_registerFixesJukebox_0_) {
        p_registerFixesJukebox_0_.registerWalker(FixTypes.BLOCK_ENTITY, new ItemStackData(TileEntityJukebox.class, "RecordItem"));
    }

    protected BlockJukebox() {
        super(Material.WOOD, MapColor.DIRT);
        this.setDefaultState(this.blockState.getBaseState().withProperty(HAS_RECORD, false));
        this.setCreativeTab(CreativeTabs.DECORATIONS);
    }

    @Override
    public boolean onBlockActivated(World p_onBlockActivated_1_, BlockPos p_onBlockActivated_2_, IBlockState p_onBlockActivated_3_, EntityPlayer p_onBlockActivated_4_, EnumHand p_onBlockActivated_5_, EnumFacing p_onBlockActivated_6_, float p_onBlockActivated_7_, float p_onBlockActivated_8_, float p_onBlockActivated_9_) {
        if (p_onBlockActivated_3_.getValue(HAS_RECORD).booleanValue()) {
            this.dropRecord(p_onBlockActivated_1_, p_onBlockActivated_2_, p_onBlockActivated_3_);
            p_onBlockActivated_3_ = p_onBlockActivated_3_.withProperty(HAS_RECORD, false);
            p_onBlockActivated_1_.setBlockState(p_onBlockActivated_2_, p_onBlockActivated_3_, 2);
            return true;
        }
        return false;
    }

    public void insertRecord(World p_insertRecord_1_, BlockPos p_insertRecord_2_, IBlockState p_insertRecord_3_, ItemStack p_insertRecord_4_) {
        if (p_insertRecord_1_.isRemote) {
            return;
        }
        TileEntity lvt_5_1_ = p_insertRecord_1_.getTileEntity(p_insertRecord_2_);
        if (!(lvt_5_1_ instanceof TileEntityJukebox)) {
            return;
        }
        ((TileEntityJukebox)lvt_5_1_).setRecord(p_insertRecord_4_.copy());
        p_insertRecord_1_.setBlockState(p_insertRecord_2_, p_insertRecord_3_.withProperty(HAS_RECORD, true), 2);
    }

    private void dropRecord(World p_dropRecord_1_, BlockPos p_dropRecord_2_, IBlockState p_dropRecord_3_) {
        if (p_dropRecord_1_.isRemote) {
            return;
        }
        TileEntity lvt_4_1_ = p_dropRecord_1_.getTileEntity(p_dropRecord_2_);
        if (!(lvt_4_1_ instanceof TileEntityJukebox)) {
            return;
        }
        TileEntityJukebox lvt_5_1_ = (TileEntityJukebox)lvt_4_1_;
        ItemStack lvt_6_1_ = lvt_5_1_.getRecord();
        if (lvt_6_1_.isEmpty()) {
            return;
        }
        p_dropRecord_1_.playEvent(1010, p_dropRecord_2_, 0);
        p_dropRecord_1_.playRecord(p_dropRecord_2_, null);
        lvt_5_1_.setRecord(ItemStack.EMPTY);
        float lvt_7_1_ = 0.7f;
        double lvt_8_1_ = (double)(p_dropRecord_1_.rand.nextFloat() * 0.7f) + (double)0.15f;
        double lvt_10_1_ = (double)(p_dropRecord_1_.rand.nextFloat() * 0.7f) + 0.06000000238418579 + 0.6;
        double lvt_12_1_ = (double)(p_dropRecord_1_.rand.nextFloat() * 0.7f) + (double)0.15f;
        ItemStack lvt_14_1_ = lvt_6_1_.copy();
        EntityItem lvt_15_1_ = new EntityItem(p_dropRecord_1_, (double)p_dropRecord_2_.getX() + lvt_8_1_, (double)p_dropRecord_2_.getY() + lvt_10_1_, (double)p_dropRecord_2_.getZ() + lvt_12_1_, lvt_14_1_);
        lvt_15_1_.setDefaultPickupDelay();
        p_dropRecord_1_.spawnEntity(lvt_15_1_);
    }

    @Override
    public void breakBlock(World p_breakBlock_1_, BlockPos p_breakBlock_2_, IBlockState p_breakBlock_3_) {
        this.dropRecord(p_breakBlock_1_, p_breakBlock_2_, p_breakBlock_3_);
        super.breakBlock(p_breakBlock_1_, p_breakBlock_2_, p_breakBlock_3_);
    }

    @Override
    public void dropBlockAsItemWithChance(World p_dropBlockAsItemWithChance_1_, BlockPos p_dropBlockAsItemWithChance_2_, IBlockState p_dropBlockAsItemWithChance_3_, float p_dropBlockAsItemWithChance_4_, int p_dropBlockAsItemWithChance_5_) {
        if (p_dropBlockAsItemWithChance_1_.isRemote) {
            return;
        }
        super.dropBlockAsItemWithChance(p_dropBlockAsItemWithChance_1_, p_dropBlockAsItemWithChance_2_, p_dropBlockAsItemWithChance_3_, p_dropBlockAsItemWithChance_4_, 0);
    }

    @Override
    public TileEntity createNewTileEntity(World p_createNewTileEntity_1_, int p_createNewTileEntity_2_) {
        return new TileEntityJukebox();
    }

    @Override
    public boolean hasComparatorInputOverride(IBlockState p_hasComparatorInputOverride_1_) {
        return true;
    }

    @Override
    public int getComparatorInputOverride(IBlockState p_getComparatorInputOverride_1_, World p_getComparatorInputOverride_2_, BlockPos p_getComparatorInputOverride_3_) {
        ItemStack lvt_5_1_;
        TileEntity lvt_4_1_ = p_getComparatorInputOverride_2_.getTileEntity(p_getComparatorInputOverride_3_);
        if (lvt_4_1_ instanceof TileEntityJukebox && !(lvt_5_1_ = ((TileEntityJukebox)lvt_4_1_).getRecord()).isEmpty()) {
            return Item.getIdFromItem(lvt_5_1_.getItem()) + 1 - Item.getIdFromItem(Items.RECORD_13);
        }
        return 0;
    }

    @Override
    public EnumBlockRenderType getRenderType(IBlockState p_getRenderType_1_) {
        return EnumBlockRenderType.MODEL;
    }

    @Override
    public IBlockState getStateFromMeta(int p_getStateFromMeta_1_) {
        return this.getDefaultState().withProperty(HAS_RECORD, p_getStateFromMeta_1_ > 0);
    }

    @Override
    public int getMetaFromState(IBlockState p_getMetaFromState_1_) {
        return p_getMetaFromState_1_.getValue(HAS_RECORD) != false ? 1 : 0;
    }

    @Override
    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, HAS_RECORD);
    }

    public static class TileEntityJukebox
    extends TileEntity {
        private ItemStack record = ItemStack.EMPTY;

        @Override
        public void readFromNBT(NBTTagCompound p_readFromNBT_1_) {
            super.readFromNBT(p_readFromNBT_1_);
            if (p_readFromNBT_1_.hasKey("RecordItem", 10)) {
                this.setRecord(new ItemStack(p_readFromNBT_1_.getCompoundTag("RecordItem")));
            } else if (p_readFromNBT_1_.getInteger("Record") > 0) {
                this.setRecord(new ItemStack(Item.getItemById(p_readFromNBT_1_.getInteger("Record"))));
            }
        }

        @Override
        public NBTTagCompound writeToNBT(NBTTagCompound p_writeToNBT_1_) {
            super.writeToNBT(p_writeToNBT_1_);
            if (!this.getRecord().isEmpty()) {
                p_writeToNBT_1_.setTag("RecordItem", this.getRecord().writeToNBT(new NBTTagCompound()));
            }
            return p_writeToNBT_1_;
        }

        public ItemStack getRecord() {
            return this.record;
        }

        public void setRecord(ItemStack p_setRecord_1_) {
            this.record = p_setRecord_1_;
            this.markDirty();
        }
    }
}

