/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockLeaves
extends Block
implements IShearable {
    public static final PropertyBool DECAYABLE = PropertyBool.create("decayable");
    public static final PropertyBool CHECK_DECAY = PropertyBool.create("check_decay");
    protected boolean leavesFancy;
    int[] surroundings;

    public BlockLeaves() {
        super(Material.LEAVES);
        this.setTickRandomly(true);
        this.setCreativeTab(CreativeTabs.DECORATIONS);
        this.setHardness(0.2f);
        this.setLightOpacity(1);
        this.setSoundType(SoundType.PLANT);
    }

    @Override
    public void breakBlock(World p_breakBlock_1_, BlockPos p_breakBlock_2_, IBlockState p_breakBlock_3_) {
        int i1;
        int l;
        boolean i = true;
        int j = 2;
        int k = p_breakBlock_2_.getX();
        if (p_breakBlock_1_.isAreaLoaded(new BlockPos(k - 2, (l = p_breakBlock_2_.getY()) - 2, (i1 = p_breakBlock_2_.getZ()) - 2), new BlockPos(k + 2, l + 2, i1 + 2))) {
            for (int j1 = -1; j1 <= 1; ++j1) {
                for (int k1 = -1; k1 <= 1; ++k1) {
                    for (int l1 = -1; l1 <= 1; ++l1) {
                        BlockPos blockpos = p_breakBlock_2_.add(j1, k1, l1);
                        IBlockState iblockstate = p_breakBlock_1_.getBlockState(blockpos);
                        if (!iblockstate.getBlock().isLeaves(iblockstate, p_breakBlock_1_, blockpos)) continue;
                        iblockstate.getBlock().beginLeavesDecay(iblockstate, p_breakBlock_1_, blockpos);
                    }
                }
            }
        }
    }

    @Override
    public void updateTick(World p_updateTick_1_, BlockPos p_updateTick_2_, IBlockState p_updateTick_3_, Random p_updateTick_4_) {
        if (!p_updateTick_1_.isRemote && p_updateTick_3_.getValue(CHECK_DECAY).booleanValue() && p_updateTick_3_.getValue(DECAYABLE).booleanValue()) {
            int l2;
            int i = 4;
            int j = 5;
            int k = p_updateTick_2_.getX();
            int l = p_updateTick_2_.getY();
            int i1 = p_updateTick_2_.getZ();
            int j1 = 32;
            int k1 = 1024;
            int l1 = 16;
            if (this.surroundings == null) {
                this.surroundings = new int[32768];
            }
            if (p_updateTick_1_.isAreaLoaded(new BlockPos(k - 5, l - 5, i1 - 5), new BlockPos(k + 5, l + 5, i1 + 5))) {
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                for (int i2 = -4; i2 <= 4; ++i2) {
                    for (int j2 = -4; j2 <= 4; ++j2) {
                        for (int k2 = -4; k2 <= 4; ++k2) {
                            IBlockState iblockstate = p_updateTick_1_.getBlockState(blockpos$mutableblockpos.setPos(k + i2, l + j2, i1 + k2));
                            Block block = iblockstate.getBlock();
                            if (!block.canSustainLeaves(iblockstate, p_updateTick_1_, blockpos$mutableblockpos.setPos(k + i2, l + j2, i1 + k2))) {
                                if (block.isLeaves(iblockstate, p_updateTick_1_, blockpos$mutableblockpos.setPos(k + i2, l + j2, i1 + k2))) {
                                    this.surroundings[(i2 + 16) * 1024 + (j2 + 16) * 32 + k2 + 16] = -2;
                                    continue;
                                }
                                this.surroundings[(i2 + 16) * 1024 + (j2 + 16) * 32 + k2 + 16] = -1;
                                continue;
                            }
                            this.surroundings[(i2 + 16) * 1024 + (j2 + 16) * 32 + k2 + 16] = 0;
                        }
                    }
                }
                for (int i3 = 1; i3 <= 4; ++i3) {
                    for (int j3 = -4; j3 <= 4; ++j3) {
                        for (int k3 = -4; k3 <= 4; ++k3) {
                            for (int l3 = -4; l3 <= 4; ++l3) {
                                if (this.surroundings[(j3 + 16) * 1024 + (k3 + 16) * 32 + l3 + 16] != i3 - 1) continue;
                                if (this.surroundings[(j3 + 16 - 1) * 1024 + (k3 + 16) * 32 + l3 + 16] == -2) {
                                    this.surroundings[(j3 + 16 - 1) * 1024 + (k3 + 16) * 32 + l3 + 16] = i3;
                                }
                                if (this.surroundings[(j3 + 16 + 1) * 1024 + (k3 + 16) * 32 + l3 + 16] == -2) {
                                    this.surroundings[(j3 + 16 + 1) * 1024 + (k3 + 16) * 32 + l3 + 16] = i3;
                                }
                                if (this.surroundings[(j3 + 16) * 1024 + (k3 + 16 - 1) * 32 + l3 + 16] == -2) {
                                    this.surroundings[(j3 + 16) * 1024 + (k3 + 16 - 1) * 32 + l3 + 16] = i3;
                                }
                                if (this.surroundings[(j3 + 16) * 1024 + (k3 + 16 + 1) * 32 + l3 + 16] == -2) {
                                    this.surroundings[(j3 + 16) * 1024 + (k3 + 16 + 1) * 32 + l3 + 16] = i3;
                                }
                                if (this.surroundings[(j3 + 16) * 1024 + (k3 + 16) * 32 + (l3 + 16 - 1)] == -2) {
                                    this.surroundings[(j3 + 16) * 1024 + (k3 + 16) * 32 + (l3 + 16 - 1)] = i3;
                                }
                                if (this.surroundings[(j3 + 16) * 1024 + (k3 + 16) * 32 + l3 + 16 + 1] != -2) continue;
                                this.surroundings[(j3 + 16) * 1024 + (k3 + 16) * 32 + l3 + 16 + 1] = i3;
                            }
                        }
                    }
                }
            }
            if ((l2 = this.surroundings[16912]) >= 0) {
                p_updateTick_1_.setBlockState(p_updateTick_2_, p_updateTick_3_.withProperty(CHECK_DECAY, false), 4);
            } else {
                this.destroy(p_updateTick_1_, p_updateTick_2_);
            }
        }
    }

    private void destroy(World p_destroy_1_, BlockPos p_destroy_2_) {
        this.dropBlockAsItem(p_destroy_1_, p_destroy_2_, p_destroy_1_.getBlockState(p_destroy_2_), 0);
        p_destroy_1_.setBlockToAir(p_destroy_2_);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(IBlockState p_randomDisplayTick_1_, World p_randomDisplayTick_2_, BlockPos p_randomDisplayTick_3_, Random p_randomDisplayTick_4_) {
        if (p_randomDisplayTick_2_.isRainingAt(p_randomDisplayTick_3_.up()) && !p_randomDisplayTick_2_.getBlockState(p_randomDisplayTick_3_.down()).isFullyOpaque() && p_randomDisplayTick_4_.nextInt(15) == 1) {
            double d0 = (float)p_randomDisplayTick_3_.getX() + p_randomDisplayTick_4_.nextFloat();
            double d1 = (double)p_randomDisplayTick_3_.getY() - 0.05;
            double d2 = (float)p_randomDisplayTick_3_.getZ() + p_randomDisplayTick_4_.nextFloat();
            p_randomDisplayTick_2_.spawnParticle(EnumParticleTypes.DRIP_WATER, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    @Override
    public int quantityDropped(Random p_quantityDropped_1_) {
        return p_quantityDropped_1_.nextInt(20) == 0 ? 1 : 0;
    }

    @Override
    public Item getItemDropped(IBlockState p_getItemDropped_1_, Random p_getItemDropped_2_, int p_getItemDropped_3_) {
        return Item.getItemFromBlock(Blocks.SAPLING);
    }

    @Override
    public void dropBlockAsItemWithChance(World p_dropBlockAsItemWithChance_1_, BlockPos p_dropBlockAsItemWithChance_2_, IBlockState p_dropBlockAsItemWithChance_3_, float p_dropBlockAsItemWithChance_4_, int p_dropBlockAsItemWithChance_5_) {
        super.dropBlockAsItemWithChance(p_dropBlockAsItemWithChance_1_, p_dropBlockAsItemWithChance_2_, p_dropBlockAsItemWithChance_3_, p_dropBlockAsItemWithChance_4_, p_dropBlockAsItemWithChance_5_);
    }

    protected void dropApple(World p_dropApple_1_, BlockPos p_dropApple_2_, IBlockState p_dropApple_3_, int p_dropApple_4_) {
    }

    protected int getSaplingDropChance(IBlockState p_getSaplingDropChance_1_) {
        return 20;
    }

    @Override
    public boolean isOpaqueCube(IBlockState p_isOpaqueCube_1_) {
        return !this.leavesFancy;
    }

    @SideOnly(value=Side.CLIENT)
    public void setGraphicsLevel(boolean p_setGraphicsLevel_1_) {
        this.leavesFancy = p_setGraphicsLevel_1_;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer getBlockLayer() {
        return this.leavesFancy ? BlockRenderLayer.CUTOUT_MIPPED : BlockRenderLayer.SOLID;
    }

    @Override
    public boolean causesSuffocation(IBlockState p_causesSuffocation_1_) {
        return false;
    }

    public abstract BlockPlanks.EnumType getWoodType(int var1);

    @Override
    public boolean isShearable(ItemStack p_isShearable_1_, IBlockAccess p_isShearable_2_, BlockPos p_isShearable_3_) {
        return true;
    }

    @Override
    public boolean isLeaves(IBlockState p_isLeaves_1_, IBlockAccess p_isLeaves_2_, BlockPos p_isLeaves_3_) {
        return true;
    }

    @Override
    public void beginLeavesDecay(IBlockState p_beginLeavesDecay_1_, World p_beginLeavesDecay_2_, BlockPos p_beginLeavesDecay_3_) {
        if (!p_beginLeavesDecay_1_.getValue(CHECK_DECAY).booleanValue()) {
            p_beginLeavesDecay_2_.setBlockState(p_beginLeavesDecay_3_, p_beginLeavesDecay_1_.withProperty(CHECK_DECAY, true), 4);
        }
    }

    @Override
    public List<ItemStack> getDrops(IBlockAccess p_getDrops_1_, BlockPos p_getDrops_2_, IBlockState p_getDrops_3_, int p_getDrops_4_) {
        ItemStack drop;
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        Random rand = p_getDrops_1_ instanceof World ? ((World)p_getDrops_1_).rand : new Random();
        int chance = this.getSaplingDropChance(p_getDrops_3_);
        if (p_getDrops_4_ > 0 && (chance -= 2 << p_getDrops_4_) < 10) {
            chance = 10;
        }
        if (rand.nextInt(chance) == 0 && !(drop = new ItemStack(this.getItemDropped(p_getDrops_3_, rand, p_getDrops_4_), 1, this.damageDropped(p_getDrops_3_))).isEmpty()) {
            ret.add(drop);
        }
        chance = 200;
        if (p_getDrops_4_ > 0 && (chance -= 10 << p_getDrops_4_) < 40) {
            chance = 40;
        }
        this.captureDrops(true);
        if (p_getDrops_1_ instanceof World) {
            this.dropApple((World)p_getDrops_1_, p_getDrops_2_, p_getDrops_3_, chance);
        }
        ret.addAll(this.captureDrops(false));
        return ret;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(IBlockState p_shouldSideBeRendered_1_, IBlockAccess p_shouldSideBeRendered_2_, BlockPos p_shouldSideBeRendered_3_, EnumFacing p_shouldSideBeRendered_4_) {
        return !this.leavesFancy && p_shouldSideBeRendered_2_.getBlockState(p_shouldSideBeRendered_3_.offset(p_shouldSideBeRendered_4_)).getBlock() == this ? false : super.shouldSideBeRendered(p_shouldSideBeRendered_1_, p_shouldSideBeRendered_2_, p_shouldSideBeRendered_3_, p_shouldSideBeRendered_4_);
    }
}

