/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockButton;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockLever
extends Block {
    public static final PropertyEnum<EnumOrientation> FACING = PropertyEnum.create("facing", EnumOrientation.class);
    public static final PropertyBool POWERED = PropertyBool.create("powered");
    protected static final AxisAlignedBB LEVER_NORTH_AABB = new AxisAlignedBB(0.3125, 0.2f, 0.625, 0.6875, 0.8f, 1.0);
    protected static final AxisAlignedBB LEVER_SOUTH_AABB = new AxisAlignedBB(0.3125, 0.2f, 0.0, 0.6875, 0.8f, 0.375);
    protected static final AxisAlignedBB LEVER_WEST_AABB = new AxisAlignedBB(0.625, 0.2f, 0.3125, 1.0, 0.8f, 0.6875);
    protected static final AxisAlignedBB LEVER_EAST_AABB = new AxisAlignedBB(0.0, 0.2f, 0.3125, 0.375, 0.8f, 0.6875);
    protected static final AxisAlignedBB LEVER_UP_AABB = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.6f, 0.75);
    protected static final AxisAlignedBB LEVER_DOWN_AABB = new AxisAlignedBB(0.25, 0.4f, 0.25, 0.75, 1.0, 0.75);

    protected BlockLever() {
        super(Material.CIRCUITS);
        this.setDefaultState(this.blockState.getBaseState().withProperty(FACING, EnumOrientation.NORTH).withProperty(POWERED, false));
        this.setCreativeTab(CreativeTabs.REDSTONE);
    }

    @Override
    @Nullable
    public AxisAlignedBB getCollisionBoundingBox(IBlockState p_getCollisionBoundingBox_1_, IBlockAccess p_getCollisionBoundingBox_2_, BlockPos p_getCollisionBoundingBox_3_) {
        return NULL_AABB;
    }

    @Override
    public boolean isOpaqueCube(IBlockState p_isOpaqueCube_1_) {
        return false;
    }

    @Override
    public boolean isFullCube(IBlockState p_isFullCube_1_) {
        return false;
    }

    @Override
    public boolean canPlaceBlockOnSide(World p_canPlaceBlockOnSide_1_, BlockPos p_canPlaceBlockOnSide_2_, EnumFacing p_canPlaceBlockOnSide_3_) {
        return BlockLever.canAttachTo(p_canPlaceBlockOnSide_1_, p_canPlaceBlockOnSide_2_, p_canPlaceBlockOnSide_3_.getOpposite());
    }

    @Override
    public boolean canPlaceBlockAt(World p_canPlaceBlockAt_1_, BlockPos p_canPlaceBlockAt_2_) {
        for (EnumFacing enumfacing : EnumFacing.values()) {
            if (!BlockLever.canAttachTo(p_canPlaceBlockAt_1_, p_canPlaceBlockAt_2_, enumfacing)) continue;
            return true;
        }
        return false;
    }

    protected static boolean canAttachTo(World p_canAttachTo_0_, BlockPos p_canAttachTo_1_, EnumFacing p_canAttachTo_2_) {
        return BlockButton.canPlaceBlock(p_canAttachTo_0_, p_canAttachTo_1_, p_canAttachTo_2_);
    }

    @Override
    public IBlockState getStateForPlacement(World p_getStateForPlacement_1_, BlockPos p_getStateForPlacement_2_, EnumFacing p_getStateForPlacement_3_, float p_getStateForPlacement_4_, float p_getStateForPlacement_5_, float p_getStateForPlacement_6_, int p_getStateForPlacement_7_, EntityLivingBase p_getStateForPlacement_8_) {
        IBlockState iblockstate = this.getDefaultState().withProperty(POWERED, false);
        if (BlockLever.canAttachTo(p_getStateForPlacement_1_, p_getStateForPlacement_2_, p_getStateForPlacement_3_.getOpposite())) {
            return iblockstate.withProperty(FACING, EnumOrientation.forFacings(p_getStateForPlacement_3_, p_getStateForPlacement_8_.getHorizontalFacing()));
        }
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            if (enumfacing == p_getStateForPlacement_3_ || !BlockLever.canAttachTo(p_getStateForPlacement_1_, p_getStateForPlacement_2_, enumfacing.getOpposite())) continue;
            return iblockstate.withProperty(FACING, EnumOrientation.forFacings(enumfacing, p_getStateForPlacement_8_.getHorizontalFacing()));
        }
        if (p_getStateForPlacement_1_.getBlockState(p_getStateForPlacement_2_.down()).isFullyOpaque()) {
            return iblockstate.withProperty(FACING, EnumOrientation.forFacings(EnumFacing.UP, p_getStateForPlacement_8_.getHorizontalFacing()));
        }
        return iblockstate;
    }

    @Override
    public void neighborChanged(IBlockState p_neighborChanged_1_, World p_neighborChanged_2_, BlockPos p_neighborChanged_3_, Block p_neighborChanged_4_, BlockPos p_neighborChanged_5_) {
        if (this.checkCanSurvive(p_neighborChanged_2_, p_neighborChanged_3_, p_neighborChanged_1_) && !BlockLever.canAttachTo(p_neighborChanged_2_, p_neighborChanged_3_, p_neighborChanged_1_.getValue(FACING).getFacing().getOpposite())) {
            this.dropBlockAsItem(p_neighborChanged_2_, p_neighborChanged_3_, p_neighborChanged_1_, 0);
            p_neighborChanged_2_.setBlockToAir(p_neighborChanged_3_);
        }
    }

    private boolean checkCanSurvive(World p_checkCanSurvive_1_, BlockPos p_checkCanSurvive_2_, IBlockState p_checkCanSurvive_3_) {
        if (this.canPlaceBlockAt(p_checkCanSurvive_1_, p_checkCanSurvive_2_)) {
            return true;
        }
        this.dropBlockAsItem(p_checkCanSurvive_1_, p_checkCanSurvive_2_, p_checkCanSurvive_3_, 0);
        p_checkCanSurvive_1_.setBlockToAir(p_checkCanSurvive_2_);
        return false;
    }

    @Override
    public AxisAlignedBB getBoundingBox(IBlockState p_getBoundingBox_1_, IBlockAccess p_getBoundingBox_2_, BlockPos p_getBoundingBox_3_) {
        switch (p_getBoundingBox_1_.getValue(FACING)) {
            default: {
                return LEVER_EAST_AABB;
            }
            case WEST: {
                return LEVER_WEST_AABB;
            }
            case SOUTH: {
                return LEVER_SOUTH_AABB;
            }
            case NORTH: {
                return LEVER_NORTH_AABB;
            }
            case UP_Z: 
            case UP_X: {
                return LEVER_UP_AABB;
            }
            case DOWN_X: 
            case DOWN_Z: 
        }
        return LEVER_DOWN_AABB;
    }

    @Override
    public boolean onBlockActivated(World p_onBlockActivated_1_, BlockPos p_onBlockActivated_2_, IBlockState p_onBlockActivated_3_, EntityPlayer p_onBlockActivated_4_, EnumHand p_onBlockActivated_5_, EnumFacing p_onBlockActivated_6_, float p_onBlockActivated_7_, float p_onBlockActivated_8_, float p_onBlockActivated_9_) {
        if (p_onBlockActivated_1_.isRemote) {
            return true;
        }
        p_onBlockActivated_3_ = p_onBlockActivated_3_.cycleProperty(POWERED);
        p_onBlockActivated_1_.setBlockState(p_onBlockActivated_2_, p_onBlockActivated_3_, 3);
        float f = p_onBlockActivated_3_.getValue(POWERED) != false ? 0.6f : 0.5f;
        p_onBlockActivated_1_.playSound(null, p_onBlockActivated_2_, SoundEvents.BLOCK_LEVER_CLICK, SoundCategory.BLOCKS, 0.3f, f);
        p_onBlockActivated_1_.notifyNeighborsOfStateChange(p_onBlockActivated_2_, this, false);
        EnumFacing enumfacing = p_onBlockActivated_3_.getValue(FACING).getFacing();
        p_onBlockActivated_1_.notifyNeighborsOfStateChange(p_onBlockActivated_2_.offset(enumfacing.getOpposite()), this, false);
        return true;
    }

    @Override
    public void breakBlock(World p_breakBlock_1_, BlockPos p_breakBlock_2_, IBlockState p_breakBlock_3_) {
        if (p_breakBlock_3_.getValue(POWERED).booleanValue()) {
            p_breakBlock_1_.notifyNeighborsOfStateChange(p_breakBlock_2_, this, false);
            EnumFacing enumfacing = p_breakBlock_3_.getValue(FACING).getFacing();
            p_breakBlock_1_.notifyNeighborsOfStateChange(p_breakBlock_2_.offset(enumfacing.getOpposite()), this, false);
        }
        super.breakBlock(p_breakBlock_1_, p_breakBlock_2_, p_breakBlock_3_);
    }

    @Override
    public int getWeakPower(IBlockState p_getWeakPower_1_, IBlockAccess p_getWeakPower_2_, BlockPos p_getWeakPower_3_, EnumFacing p_getWeakPower_4_) {
        return p_getWeakPower_1_.getValue(POWERED) != false ? 15 : 0;
    }

    @Override
    public int getStrongPower(IBlockState p_getStrongPower_1_, IBlockAccess p_getStrongPower_2_, BlockPos p_getStrongPower_3_, EnumFacing p_getStrongPower_4_) {
        return p_getStrongPower_1_.getValue(POWERED) == false ? 0 : (p_getStrongPower_1_.getValue(FACING).getFacing() == p_getStrongPower_4_ ? 15 : 0);
    }

    @Override
    public boolean canProvidePower(IBlockState p_canProvidePower_1_) {
        return true;
    }

    @Override
    public IBlockState getStateFromMeta(int p_getStateFromMeta_1_) {
        return this.getDefaultState().withProperty(FACING, EnumOrientation.byMetadata(p_getStateFromMeta_1_ & 7)).withProperty(POWERED, (p_getStateFromMeta_1_ & 8) > 0);
    }

    @Override
    public int getMetaFromState(IBlockState p_getMetaFromState_1_) {
        int i = 0;
        i |= p_getMetaFromState_1_.getValue(FACING).getMetadata();
        if (p_getMetaFromState_1_.getValue(POWERED).booleanValue()) {
            i |= 8;
        }
        return i;
    }

    @Override
    public IBlockState withRotation(IBlockState p_withRotation_1_, Rotation p_withRotation_2_) {
        switch (p_withRotation_2_) {
            case CLOCKWISE_180: {
                switch (p_withRotation_1_.getValue(FACING)) {
                    case EAST: {
                        return p_withRotation_1_.withProperty(FACING, EnumOrientation.WEST);
                    }
                    case WEST: {
                        return p_withRotation_1_.withProperty(FACING, EnumOrientation.EAST);
                    }
                    case SOUTH: {
                        return p_withRotation_1_.withProperty(FACING, EnumOrientation.NORTH);
                    }
                    case NORTH: {
                        return p_withRotation_1_.withProperty(FACING, EnumOrientation.SOUTH);
                    }
                }
                return p_withRotation_1_;
            }
            case COUNTERCLOCKWISE_90: {
                switch (p_withRotation_1_.getValue(FACING)) {
                    case EAST: {
                        return p_withRotation_1_.withProperty(FACING, EnumOrientation.NORTH);
                    }
                    case WEST: {
                        return p_withRotation_1_.withProperty(FACING, EnumOrientation.SOUTH);
                    }
                    case SOUTH: {
                        return p_withRotation_1_.withProperty(FACING, EnumOrientation.EAST);
                    }
                    case NORTH: {
                        return p_withRotation_1_.withProperty(FACING, EnumOrientation.WEST);
                    }
                    case UP_Z: {
                        return p_withRotation_1_.withProperty(FACING, EnumOrientation.UP_X);
                    }
                    case UP_X: {
                        return p_withRotation_1_.withProperty(FACING, EnumOrientation.UP_Z);
                    }
                    case DOWN_X: {
                        return p_withRotation_1_.withProperty(FACING, EnumOrientation.DOWN_Z);
                    }
                    case DOWN_Z: {
                        return p_withRotation_1_.withProperty(FACING, EnumOrientation.DOWN_X);
                    }
                }
            }
            case CLOCKWISE_90: {
                switch (p_withRotation_1_.getValue(FACING)) {
                    case EAST: {
                        return p_withRotation_1_.withProperty(FACING, EnumOrientation.SOUTH);
                    }
                    case WEST: {
                        return p_withRotation_1_.withProperty(FACING, EnumOrientation.NORTH);
                    }
                    case SOUTH: {
                        return p_withRotation_1_.withProperty(FACING, EnumOrientation.WEST);
                    }
                    case NORTH: {
                        return p_withRotation_1_.withProperty(FACING, EnumOrientation.EAST);
                    }
                    case UP_Z: {
                        return p_withRotation_1_.withProperty(FACING, EnumOrientation.UP_X);
                    }
                    case UP_X: {
                        return p_withRotation_1_.withProperty(FACING, EnumOrientation.UP_Z);
                    }
                    case DOWN_X: {
                        return p_withRotation_1_.withProperty(FACING, EnumOrientation.DOWN_Z);
                    }
                    case DOWN_Z: {
                        return p_withRotation_1_.withProperty(FACING, EnumOrientation.DOWN_X);
                    }
                }
            }
        }
        return p_withRotation_1_;
    }

    @Override
    public IBlockState withMirror(IBlockState p_withMirror_1_, Mirror p_withMirror_2_) {
        return p_withMirror_1_.withRotation(p_withMirror_2_.toRotation(p_withMirror_1_.getValue(FACING).getFacing()));
    }

    @Override
    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, FACING, POWERED);
    }

    private boolean canAttach(World p_canAttach_1_, BlockPos p_canAttach_2_, EnumFacing p_canAttach_3_) {
        return p_canAttach_1_.isSideSolid(p_canAttach_2_, p_canAttach_3_);
    }

    public static enum EnumOrientation implements IStringSerializable
    {
        DOWN_X(0, "down_x", EnumFacing.DOWN),
        EAST(1, "east", EnumFacing.EAST),
        WEST(2, "west", EnumFacing.WEST),
        SOUTH(3, "south", EnumFacing.SOUTH),
        NORTH(4, "north", EnumFacing.NORTH),
        UP_Z(5, "up_z", EnumFacing.UP),
        UP_X(6, "up_x", EnumFacing.UP),
        DOWN_Z(7, "down_z", EnumFacing.DOWN);

        private static final EnumOrientation[] META_LOOKUP;
        private final int meta;
        private final String name;
        private final EnumFacing facing;

        private EnumOrientation(int p_i45709_3_, String p_i45709_4_, EnumFacing p_i45709_5_) {
            this.meta = p_i45709_3_;
            this.name = p_i45709_4_;
            this.facing = p_i45709_5_;
        }

        public int getMetadata() {
            return this.meta;
        }

        public EnumFacing getFacing() {
            return this.facing;
        }

        public String toString() {
            return this.name;
        }

        public static EnumOrientation byMetadata(int p_byMetadata_0_) {
            if (p_byMetadata_0_ < 0 || p_byMetadata_0_ >= META_LOOKUP.length) {
                p_byMetadata_0_ = 0;
            }
            return META_LOOKUP[p_byMetadata_0_];
        }

        public static EnumOrientation forFacings(EnumFacing p_forFacings_0_, EnumFacing p_forFacings_1_) {
            switch (p_forFacings_0_) {
                case DOWN: {
                    switch (p_forFacings_1_.getAxis()) {
                        case X: {
                            return DOWN_X;
                        }
                        case Z: {
                            return DOWN_Z;
                        }
                    }
                    throw new IllegalArgumentException("Invalid entityFacing " + p_forFacings_1_ + " for facing " + p_forFacings_0_);
                }
                case UP: {
                    switch (p_forFacings_1_.getAxis()) {
                        case X: {
                            return UP_X;
                        }
                        case Z: {
                            return UP_Z;
                        }
                    }
                    throw new IllegalArgumentException("Invalid entityFacing " + p_forFacings_1_ + " for facing " + p_forFacings_0_);
                }
                case NORTH: {
                    return NORTH;
                }
                case SOUTH: {
                    return SOUTH;
                }
                case WEST: {
                    return WEST;
                }
                case EAST: {
                    return EAST;
                }
            }
            throw new IllegalArgumentException("Invalid facing: " + p_forFacings_0_);
        }

        @Override
        public String getName() {
            return this.name;
        }

        static {
            META_LOOKUP = new EnumOrientation[EnumOrientation.values().length];
            EnumOrientation[] enumOrientationArray = EnumOrientation.values();
            int n = enumOrientationArray.length;
            for (int i = 0; i < n; ++i) {
                EnumOrientation blocklever$enumorientation;
                EnumOrientation.META_LOOKUP[blocklever$enumorientation.getMetadata()] = blocklever$enumorientation = enumOrientationArray[i];
            }
        }
    }
}

