/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.List;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockLilyPad
extends BlockBush {
    protected static final AxisAlignedBB LILY_PAD_AABB = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.09375, 0.9375);

    protected BlockLilyPad() {
        this.setCreativeTab(CreativeTabs.DECORATIONS);
    }

    @Override
    public void addCollisionBoxToList(IBlockState p_addCollisionBoxToList_1_, World p_addCollisionBoxToList_2_, BlockPos p_addCollisionBoxToList_3_, AxisAlignedBB p_addCollisionBoxToList_4_, List<AxisAlignedBB> p_addCollisionBoxToList_5_, Entity p_addCollisionBoxToList_6_, boolean p_addCollisionBoxToList_7_) {
        if (!(p_addCollisionBoxToList_6_ instanceof EntityBoat)) {
            BlockLilyPad.addCollisionBoxToList(p_addCollisionBoxToList_3_, p_addCollisionBoxToList_4_, p_addCollisionBoxToList_5_, LILY_PAD_AABB);
        }
    }

    @Override
    public void onEntityCollidedWithBlock(World p_onEntityCollidedWithBlock_1_, BlockPos p_onEntityCollidedWithBlock_2_, IBlockState p_onEntityCollidedWithBlock_3_, Entity p_onEntityCollidedWithBlock_4_) {
        super.onEntityCollidedWithBlock(p_onEntityCollidedWithBlock_1_, p_onEntityCollidedWithBlock_2_, p_onEntityCollidedWithBlock_3_, p_onEntityCollidedWithBlock_4_);
        if (p_onEntityCollidedWithBlock_4_ instanceof EntityBoat) {
            p_onEntityCollidedWithBlock_1_.destroyBlock(new BlockPos(p_onEntityCollidedWithBlock_2_), true);
        }
    }

    @Override
    public AxisAlignedBB getBoundingBox(IBlockState p_getBoundingBox_1_, IBlockAccess p_getBoundingBox_2_, BlockPos p_getBoundingBox_3_) {
        return LILY_PAD_AABB;
    }

    @Override
    protected boolean canSustainBush(IBlockState p_canSustainBush_1_) {
        return p_canSustainBush_1_.getBlock() == Blocks.WATER || p_canSustainBush_1_.getMaterial() == Material.ICE;
    }

    @Override
    public boolean canBlockStay(World p_canBlockStay_1_, BlockPos p_canBlockStay_2_, IBlockState p_canBlockStay_3_) {
        if (p_canBlockStay_2_.getY() < 0 || p_canBlockStay_2_.getY() >= 256) {
            return false;
        }
        IBlockState lvt_4_1_ = p_canBlockStay_1_.getBlockState(p_canBlockStay_2_.down());
        Material lvt_5_1_ = lvt_4_1_.getMaterial();
        return lvt_5_1_ == Material.WATER && lvt_4_1_.getValue(BlockLiquid.LEVEL) == 0 || lvt_5_1_ == Material.ICE;
    }

    @Override
    public int getMetaFromState(IBlockState p_getMetaFromState_1_) {
        return 0;
    }
}

