/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDynamicLiquid;
import net.minecraft.block.BlockStaticLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockLiquid
extends Block {
    public static final PropertyInteger LEVEL = PropertyInteger.create("level", 0, 15);

    protected BlockLiquid(Material p_i45413_1_) {
        super(p_i45413_1_);
        this.setDefaultState(this.blockState.getBaseState().withProperty(LEVEL, 0));
        this.setTickRandomly(true);
    }

    @Override
    public AxisAlignedBB getBoundingBox(IBlockState p_getBoundingBox_1_, IBlockAccess p_getBoundingBox_2_, BlockPos p_getBoundingBox_3_) {
        return FULL_BLOCK_AABB;
    }

    @Override
    @Nullable
    public AxisAlignedBB getCollisionBoundingBox(IBlockState p_getCollisionBoundingBox_1_, IBlockAccess p_getCollisionBoundingBox_2_, BlockPos p_getCollisionBoundingBox_3_) {
        return NULL_AABB;
    }

    @Override
    public boolean isPassable(IBlockAccess p_isPassable_1_, BlockPos p_isPassable_2_) {
        return this.blockMaterial != Material.LAVA;
    }

    public static float getLiquidHeightPercent(int p_getLiquidHeightPercent_0_) {
        if (p_getLiquidHeightPercent_0_ >= 8) {
            p_getLiquidHeightPercent_0_ = 0;
        }
        return (float)(p_getLiquidHeightPercent_0_ + 1) / 9.0f;
    }

    protected int getDepth(IBlockState p_getDepth_1_) {
        if (p_getDepth_1_.getMaterial() == this.blockMaterial) {
            return p_getDepth_1_.getValue(LEVEL);
        }
        return -1;
    }

    protected int getRenderedDepth(IBlockState p_getRenderedDepth_1_) {
        int lvt_2_1_ = this.getDepth(p_getRenderedDepth_1_);
        return lvt_2_1_ >= 8 ? 0 : lvt_2_1_;
    }

    @Override
    public boolean isFullCube(IBlockState p_isFullCube_1_) {
        return false;
    }

    @Override
    public boolean isOpaqueCube(IBlockState p_isOpaqueCube_1_) {
        return false;
    }

    @Override
    public boolean canCollideCheck(IBlockState p_canCollideCheck_1_, boolean p_canCollideCheck_2_) {
        return p_canCollideCheck_2_ && p_canCollideCheck_1_.getValue(LEVEL) == 0;
    }

    @Override
    public boolean isBlockSolid(IBlockAccess p_isBlockSolid_1_, BlockPos p_isBlockSolid_2_, EnumFacing p_isBlockSolid_3_) {
        Material lvt_4_1_ = p_isBlockSolid_1_.getBlockState(p_isBlockSolid_2_).getMaterial();
        if (lvt_4_1_ == this.blockMaterial) {
            return false;
        }
        if (p_isBlockSolid_3_ == EnumFacing.UP) {
            return true;
        }
        if (lvt_4_1_ == Material.ICE) {
            return false;
        }
        return super.isBlockSolid(p_isBlockSolid_1_, p_isBlockSolid_2_, p_isBlockSolid_3_);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(IBlockState p_shouldSideBeRendered_1_, IBlockAccess p_shouldSideBeRendered_2_, BlockPos p_shouldSideBeRendered_3_, EnumFacing p_shouldSideBeRendered_4_) {
        if (p_shouldSideBeRendered_2_.getBlockState(p_shouldSideBeRendered_3_.offset(p_shouldSideBeRendered_4_)).getMaterial() == this.blockMaterial) {
            return false;
        }
        if (p_shouldSideBeRendered_4_ == EnumFacing.UP) {
            return true;
        }
        return super.shouldSideBeRendered(p_shouldSideBeRendered_1_, p_shouldSideBeRendered_2_, p_shouldSideBeRendered_3_, p_shouldSideBeRendered_4_);
    }

    @Override
    public EnumBlockRenderType getRenderType(IBlockState p_getRenderType_1_) {
        return EnumBlockRenderType.LIQUID;
    }

    @Override
    public Item getItemDropped(IBlockState p_getItemDropped_1_, Random p_getItemDropped_2_, int p_getItemDropped_3_) {
        return Items.AIR;
    }

    @Override
    public int quantityDropped(Random p_quantityDropped_1_) {
        return 0;
    }

    protected Vec3d getFlow(IBlockAccess p_getFlow_1_, BlockPos p_getFlow_2_, IBlockState p_getFlow_3_) {
        double lvt_4_1_ = 0.0;
        double lvt_6_1_ = 0.0;
        double lvt_8_1_ = 0.0;
        int lvt_10_1_ = this.getRenderedDepth(p_getFlow_3_);
        BlockPos.PooledMutableBlockPos lvt_11_1_ = BlockPos.PooledMutableBlockPos.retain();
        for (EnumFacing lvt_13_1_ : EnumFacing.Plane.HORIZONTAL) {
            lvt_11_1_.setPos(p_getFlow_2_).move(lvt_13_1_);
            int lvt_14_1_ = this.getRenderedDepth(p_getFlow_1_.getBlockState(lvt_11_1_));
            if (lvt_14_1_ < 0) {
                if (p_getFlow_1_.getBlockState(lvt_11_1_).getMaterial().blocksMovement() || (lvt_14_1_ = this.getRenderedDepth(p_getFlow_1_.getBlockState(lvt_11_1_.down()))) < 0) continue;
                int lvt_15_1_ = lvt_14_1_ - (lvt_10_1_ - 8);
                lvt_4_1_ += (double)(lvt_13_1_.getFrontOffsetX() * lvt_15_1_);
                lvt_6_1_ += (double)(lvt_13_1_.getFrontOffsetY() * lvt_15_1_);
                lvt_8_1_ += (double)(lvt_13_1_.getFrontOffsetZ() * lvt_15_1_);
                continue;
            }
            if (lvt_14_1_ < 0) continue;
            int lvt_15_2_ = lvt_14_1_ - lvt_10_1_;
            lvt_4_1_ += (double)(lvt_13_1_.getFrontOffsetX() * lvt_15_2_);
            lvt_6_1_ += (double)(lvt_13_1_.getFrontOffsetY() * lvt_15_2_);
            lvt_8_1_ += (double)(lvt_13_1_.getFrontOffsetZ() * lvt_15_2_);
        }
        Vec3d lvt_12_1_ = new Vec3d(lvt_4_1_, lvt_6_1_, lvt_8_1_);
        if (p_getFlow_3_.getValue(LEVEL) >= 8) {
            for (EnumFacing lvt_14_2_ : EnumFacing.Plane.HORIZONTAL) {
                lvt_11_1_.setPos(p_getFlow_2_).move(lvt_14_2_);
                if (!this.isBlockSolid(p_getFlow_1_, lvt_11_1_, lvt_14_2_) && !this.isBlockSolid(p_getFlow_1_, lvt_11_1_.up(), lvt_14_2_)) continue;
                lvt_12_1_ = lvt_12_1_.normalize().addVector(0.0, -6.0, 0.0);
                break;
            }
        }
        lvt_11_1_.release();
        return lvt_12_1_.normalize();
    }

    @Override
    public Vec3d modifyAcceleration(World p_modifyAcceleration_1_, BlockPos p_modifyAcceleration_2_, Entity p_modifyAcceleration_3_, Vec3d p_modifyAcceleration_4_) {
        return p_modifyAcceleration_4_.add(this.getFlow(p_modifyAcceleration_1_, p_modifyAcceleration_2_, p_modifyAcceleration_1_.getBlockState(p_modifyAcceleration_2_)));
    }

    @Override
    public int tickRate(World p_tickRate_1_) {
        if (this.blockMaterial == Material.WATER) {
            return 5;
        }
        if (this.blockMaterial == Material.LAVA) {
            return p_tickRate_1_.provider.hasNoSky() ? 10 : 30;
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean shouldRenderSides(IBlockAccess p_shouldRenderSides_1_, BlockPos p_shouldRenderSides_2_) {
        for (int lvt_3_1_ = -1; lvt_3_1_ <= 1; ++lvt_3_1_) {
            for (int lvt_4_1_ = -1; lvt_4_1_ <= 1; ++lvt_4_1_) {
                IBlockState lvt_5_1_ = p_shouldRenderSides_1_.getBlockState(p_shouldRenderSides_2_.add(lvt_3_1_, 0, lvt_4_1_));
                if (lvt_5_1_.getMaterial() == this.blockMaterial || lvt_5_1_.isFullBlock()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void onBlockAdded(World p_onBlockAdded_1_, BlockPos p_onBlockAdded_2_, IBlockState p_onBlockAdded_3_) {
        this.checkForMixing(p_onBlockAdded_1_, p_onBlockAdded_2_, p_onBlockAdded_3_);
    }

    @Override
    public void neighborChanged(IBlockState p_neighborChanged_1_, World p_neighborChanged_2_, BlockPos p_neighborChanged_3_, Block p_neighborChanged_4_, BlockPos p_neighborChanged_5_) {
        this.checkForMixing(p_neighborChanged_2_, p_neighborChanged_3_, p_neighborChanged_1_);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getPackedLightmapCoords(IBlockState p_getPackedLightmapCoords_1_, IBlockAccess p_getPackedLightmapCoords_2_, BlockPos p_getPackedLightmapCoords_3_) {
        int lvt_4_1_ = p_getPackedLightmapCoords_2_.getCombinedLight(p_getPackedLightmapCoords_3_, 0);
        int lvt_5_1_ = p_getPackedLightmapCoords_2_.getCombinedLight(p_getPackedLightmapCoords_3_.up(), 0);
        int lvt_6_1_ = lvt_4_1_ & 0xFF;
        int lvt_7_1_ = lvt_5_1_ & 0xFF;
        int lvt_8_1_ = lvt_4_1_ >> 16 & 0xFF;
        int lvt_9_1_ = lvt_5_1_ >> 16 & 0xFF;
        return (lvt_6_1_ > lvt_7_1_ ? lvt_6_1_ : lvt_7_1_) | (lvt_8_1_ > lvt_9_1_ ? lvt_8_1_ : lvt_9_1_) << 16;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer getBlockLayer() {
        return this.blockMaterial == Material.WATER ? BlockRenderLayer.TRANSLUCENT : BlockRenderLayer.SOLID;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(IBlockState p_randomDisplayTick_1_, World p_randomDisplayTick_2_, BlockPos p_randomDisplayTick_3_, Random p_randomDisplayTick_4_) {
        Material lvt_11_3_;
        double lvt_5_1_ = p_randomDisplayTick_3_.getX();
        double lvt_7_1_ = p_randomDisplayTick_3_.getY();
        double lvt_9_1_ = p_randomDisplayTick_3_.getZ();
        if (this.blockMaterial == Material.WATER) {
            int lvt_11_1_ = p_randomDisplayTick_1_.getValue(LEVEL);
            if (lvt_11_1_ > 0 && lvt_11_1_ < 8) {
                if (p_randomDisplayTick_4_.nextInt(64) == 0) {
                    p_randomDisplayTick_2_.playSound(lvt_5_1_ + 0.5, lvt_7_1_ + 0.5, lvt_9_1_ + 0.5, SoundEvents.BLOCK_WATER_AMBIENT, SoundCategory.BLOCKS, p_randomDisplayTick_4_.nextFloat() * 0.25f + 0.75f, p_randomDisplayTick_4_.nextFloat() + 0.5f, false);
                }
            } else if (p_randomDisplayTick_4_.nextInt(10) == 0) {
                p_randomDisplayTick_2_.spawnParticle(EnumParticleTypes.SUSPENDED, lvt_5_1_ + (double)p_randomDisplayTick_4_.nextFloat(), lvt_7_1_ + (double)p_randomDisplayTick_4_.nextFloat(), lvt_9_1_ + (double)p_randomDisplayTick_4_.nextFloat(), 0.0, 0.0, 0.0, new int[0]);
            }
        }
        if (this.blockMaterial == Material.LAVA && p_randomDisplayTick_2_.getBlockState(p_randomDisplayTick_3_.up()).getMaterial() == Material.AIR && !p_randomDisplayTick_2_.getBlockState(p_randomDisplayTick_3_.up()).isOpaqueCube()) {
            if (p_randomDisplayTick_4_.nextInt(100) == 0) {
                double lvt_11_2_ = lvt_5_1_ + (double)p_randomDisplayTick_4_.nextFloat();
                double lvt_13_1_ = lvt_7_1_ + p_randomDisplayTick_1_.getBoundingBox((IBlockAccess)p_randomDisplayTick_2_, (BlockPos)p_randomDisplayTick_3_).maxY;
                double lvt_15_1_ = lvt_9_1_ + (double)p_randomDisplayTick_4_.nextFloat();
                p_randomDisplayTick_2_.spawnParticle(EnumParticleTypes.LAVA, lvt_11_2_, lvt_13_1_, lvt_15_1_, 0.0, 0.0, 0.0, new int[0]);
                p_randomDisplayTick_2_.playSound(lvt_11_2_, lvt_13_1_, lvt_15_1_, SoundEvents.BLOCK_LAVA_POP, SoundCategory.BLOCKS, 0.2f + p_randomDisplayTick_4_.nextFloat() * 0.2f, 0.9f + p_randomDisplayTick_4_.nextFloat() * 0.15f, false);
            }
            if (p_randomDisplayTick_4_.nextInt(200) == 0) {
                p_randomDisplayTick_2_.playSound(lvt_5_1_, lvt_7_1_, lvt_9_1_, SoundEvents.BLOCK_LAVA_AMBIENT, SoundCategory.BLOCKS, 0.2f + p_randomDisplayTick_4_.nextFloat() * 0.2f, 0.9f + p_randomDisplayTick_4_.nextFloat() * 0.15f, false);
            }
        }
        if (p_randomDisplayTick_4_.nextInt(10) == 0 && p_randomDisplayTick_2_.getBlockState(p_randomDisplayTick_3_.down()).isFullyOpaque() && !(lvt_11_3_ = p_randomDisplayTick_2_.getBlockState(p_randomDisplayTick_3_.down(2)).getMaterial()).blocksMovement() && !lvt_11_3_.isLiquid()) {
            double lvt_12_1_ = lvt_5_1_ + (double)p_randomDisplayTick_4_.nextFloat();
            double lvt_14_1_ = lvt_7_1_ - 1.05;
            double lvt_16_1_ = lvt_9_1_ + (double)p_randomDisplayTick_4_.nextFloat();
            if (this.blockMaterial == Material.WATER) {
                p_randomDisplayTick_2_.spawnParticle(EnumParticleTypes.DRIP_WATER, lvt_12_1_, lvt_14_1_, lvt_16_1_, 0.0, 0.0, 0.0, new int[0]);
            } else {
                p_randomDisplayTick_2_.spawnParticle(EnumParticleTypes.DRIP_LAVA, lvt_12_1_, lvt_14_1_, lvt_16_1_, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static float getSlopeAngle(IBlockAccess p_getSlopeAngle_0_, BlockPos p_getSlopeAngle_1_, Material p_getSlopeAngle_2_, IBlockState p_getSlopeAngle_3_) {
        Vec3d lvt_4_1_ = BlockLiquid.getFlowingBlock(p_getSlopeAngle_2_).getFlow(p_getSlopeAngle_0_, p_getSlopeAngle_1_, p_getSlopeAngle_3_);
        if (lvt_4_1_.xCoord == 0.0 && lvt_4_1_.zCoord == 0.0) {
            return -1000.0f;
        }
        return (float)MathHelper.atan2(lvt_4_1_.zCoord, lvt_4_1_.xCoord) - 1.5707964f;
    }

    public boolean checkForMixing(World p_checkForMixing_1_, BlockPos p_checkForMixing_2_, IBlockState p_checkForMixing_3_) {
        if (this.blockMaterial == Material.LAVA) {
            boolean lvt_4_1_ = false;
            for (EnumFacing lvt_8_1_ : EnumFacing.values()) {
                if (lvt_8_1_ == EnumFacing.DOWN || p_checkForMixing_1_.getBlockState(p_checkForMixing_2_.offset(lvt_8_1_)).getMaterial() != Material.WATER) continue;
                lvt_4_1_ = true;
                break;
            }
            if (lvt_4_1_) {
                Integer lvt_5_1_ = p_checkForMixing_3_.getValue(LEVEL);
                if (lvt_5_1_ == 0) {
                    p_checkForMixing_1_.setBlockState(p_checkForMixing_2_, Blocks.OBSIDIAN.getDefaultState());
                    this.triggerMixEffects(p_checkForMixing_1_, p_checkForMixing_2_);
                    return true;
                }
                if (lvt_5_1_ <= 4) {
                    p_checkForMixing_1_.setBlockState(p_checkForMixing_2_, Blocks.COBBLESTONE.getDefaultState());
                    this.triggerMixEffects(p_checkForMixing_1_, p_checkForMixing_2_);
                    return true;
                }
            }
        }
        return false;
    }

    protected void triggerMixEffects(World p_triggerMixEffects_1_, BlockPos p_triggerMixEffects_2_) {
        double lvt_3_1_ = p_triggerMixEffects_2_.getX();
        double lvt_5_1_ = p_triggerMixEffects_2_.getY();
        double lvt_7_1_ = p_triggerMixEffects_2_.getZ();
        p_triggerMixEffects_1_.playSound(null, p_triggerMixEffects_2_, SoundEvents.BLOCK_LAVA_EXTINGUISH, SoundCategory.BLOCKS, 0.5f, 2.6f + (p_triggerMixEffects_1_.rand.nextFloat() - p_triggerMixEffects_1_.rand.nextFloat()) * 0.8f);
        for (int lvt_9_1_ = 0; lvt_9_1_ < 8; ++lvt_9_1_) {
            p_triggerMixEffects_1_.spawnParticle(EnumParticleTypes.SMOKE_LARGE, lvt_3_1_ + Math.random(), lvt_5_1_ + 1.2, lvt_7_1_ + Math.random(), 0.0, 0.0, 0.0, new int[0]);
        }
    }

    @Override
    public IBlockState getStateFromMeta(int p_getStateFromMeta_1_) {
        return this.getDefaultState().withProperty(LEVEL, p_getStateFromMeta_1_);
    }

    @Override
    public int getMetaFromState(IBlockState p_getMetaFromState_1_) {
        return p_getMetaFromState_1_.getValue(LEVEL);
    }

    @Override
    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, LEVEL);
    }

    public static BlockDynamicLiquid getFlowingBlock(Material p_getFlowingBlock_0_) {
        if (p_getFlowingBlock_0_ == Material.WATER) {
            return Blocks.FLOWING_WATER;
        }
        if (p_getFlowingBlock_0_ == Material.LAVA) {
            return Blocks.FLOWING_LAVA;
        }
        throw new IllegalArgumentException("Invalid material");
    }

    public static BlockStaticLiquid getStaticBlock(Material p_getStaticBlock_0_) {
        if (p_getStaticBlock_0_ == Material.WATER) {
            return Blocks.WATER;
        }
        if (p_getStaticBlock_0_ == Material.LAVA) {
            return Blocks.LAVA;
        }
        throw new IllegalArgumentException("Invalid material");
    }

    public static float getBlockLiquidHeight(IBlockState p_getBlockLiquidHeight_0_, IBlockAccess p_getBlockLiquidHeight_1_, BlockPos p_getBlockLiquidHeight_2_) {
        int lvt_3_1_ = p_getBlockLiquidHeight_0_.getValue(LEVEL);
        if ((lvt_3_1_ & 7) == 0 && p_getBlockLiquidHeight_1_.getBlockState(p_getBlockLiquidHeight_2_.up()).getMaterial() == Material.WATER) {
            return 1.0f;
        }
        return 1.0f - BlockLiquid.getLiquidHeightPercent(lvt_3_1_);
    }

    public static float getLiquidHeight(IBlockState p_getLiquidHeight_0_, IBlockAccess p_getLiquidHeight_1_, BlockPos p_getLiquidHeight_2_) {
        return (float)p_getLiquidHeight_2_.getY() + BlockLiquid.getBlockLiquidHeight(p_getLiquidHeight_0_, p_getLiquidHeight_1_, p_getLiquidHeight_2_);
    }
}

