/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import net.minecraft.block.BlockRotatedPillar;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class BlockLog
extends BlockRotatedPillar {
    public static final PropertyEnum<EnumAxis> LOG_AXIS = PropertyEnum.create("axis", EnumAxis.class);

    public BlockLog() {
        super(Material.WOOD);
        this.setCreativeTab(CreativeTabs.BUILDING_BLOCKS);
        this.setHardness(2.0f);
        this.setSoundType(SoundType.WOOD);
    }

    @Override
    public void breakBlock(World p_breakBlock_1_, BlockPos p_breakBlock_2_, IBlockState p_breakBlock_3_) {
        int i = 4;
        int j = 5;
        if (p_breakBlock_1_.isAreaLoaded(p_breakBlock_2_.add(-5, -5, -5), p_breakBlock_2_.add(5, 5, 5))) {
            for (BlockPos blockpos : BlockPos.getAllInBox(p_breakBlock_2_.add(-4, -4, -4), p_breakBlock_2_.add(4, 4, 4))) {
                IBlockState iblockstate = p_breakBlock_1_.getBlockState(blockpos);
                if (!iblockstate.getBlock().isLeaves(iblockstate, p_breakBlock_1_, blockpos)) continue;
                iblockstate.getBlock().beginLeavesDecay(iblockstate, p_breakBlock_1_, blockpos);
            }
        }
    }

    @Override
    public IBlockState getStateForPlacement(World p_getStateForPlacement_1_, BlockPos p_getStateForPlacement_2_, EnumFacing p_getStateForPlacement_3_, float p_getStateForPlacement_4_, float p_getStateForPlacement_5_, float p_getStateForPlacement_6_, int p_getStateForPlacement_7_, EntityLivingBase p_getStateForPlacement_8_) {
        return this.getStateFromMeta(p_getStateForPlacement_7_).withProperty(LOG_AXIS, EnumAxis.fromFacingAxis(p_getStateForPlacement_3_.getAxis()));
    }

    @Override
    public IBlockState withRotation(IBlockState p_withRotation_1_, Rotation p_withRotation_2_) {
        switch (p_withRotation_2_) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                switch (p_withRotation_1_.getValue(LOG_AXIS)) {
                    case X: {
                        return p_withRotation_1_.withProperty(LOG_AXIS, EnumAxis.Z);
                    }
                    case Z: {
                        return p_withRotation_1_.withProperty(LOG_AXIS, EnumAxis.X);
                    }
                }
                return p_withRotation_1_;
            }
        }
        return p_withRotation_1_;
    }

    @Override
    public boolean canSustainLeaves(IBlockState p_canSustainLeaves_1_, IBlockAccess p_canSustainLeaves_2_, BlockPos p_canSustainLeaves_3_) {
        return true;
    }

    @Override
    public boolean isWood(IBlockAccess p_isWood_1_, BlockPos p_isWood_2_) {
        return true;
    }

    public static enum EnumAxis implements IStringSerializable
    {
        X("x"),
        Y("y"),
        Z("z"),
        NONE("none");

        private final String name;

        private EnumAxis(String p_i45708_3_) {
            this.name = p_i45708_3_;
        }

        public String toString() {
            return this.name;
        }

        public static EnumAxis fromFacingAxis(EnumFacing.Axis p_fromFacingAxis_0_) {
            switch (p_fromFacingAxis_0_) {
                case X: {
                    return X;
                }
                case Y: {
                    return Y;
                }
                case Z: {
                    return Z;
                }
            }
            return NONE;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

