/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockMagma
extends Block {
    public BlockMagma() {
        super(Material.ROCK);
        this.setCreativeTab(CreativeTabs.BUILDING_BLOCKS);
        this.setLightLevel(0.2f);
        this.setTickRandomly(true);
    }

    @Override
    public MapColor getMapColor(IBlockState p_getMapColor_1_) {
        return MapColor.NETHERRACK;
    }

    @Override
    public void onEntityWalk(World p_onEntityWalk_1_, BlockPos p_onEntityWalk_2_, Entity p_onEntityWalk_3_) {
        if (!p_onEntityWalk_3_.isImmuneToFire() && p_onEntityWalk_3_ instanceof EntityLivingBase && !EnchantmentHelper.hasFrostWalkerEnchantment((EntityLivingBase)p_onEntityWalk_3_)) {
            p_onEntityWalk_3_.attackEntityFrom(DamageSource.HOT_FLOOR, 1.0f);
        }
        super.onEntityWalk(p_onEntityWalk_1_, p_onEntityWalk_2_, p_onEntityWalk_3_);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getPackedLightmapCoords(IBlockState p_getPackedLightmapCoords_1_, IBlockAccess p_getPackedLightmapCoords_2_, BlockPos p_getPackedLightmapCoords_3_) {
        return 0xF000F0;
    }

    @Override
    public void updateTick(World p_updateTick_1_, BlockPos p_updateTick_2_, IBlockState p_updateTick_3_, Random p_updateTick_4_) {
        BlockPos lvt_5_1_ = p_updateTick_2_.up();
        IBlockState lvt_6_1_ = p_updateTick_1_.getBlockState(lvt_5_1_);
        if (lvt_6_1_.getBlock() == Blocks.WATER || lvt_6_1_.getBlock() == Blocks.FLOWING_WATER) {
            p_updateTick_1_.setBlockToAir(lvt_5_1_);
            p_updateTick_1_.playSound(null, p_updateTick_2_, SoundEvents.BLOCK_FIRE_EXTINGUISH, SoundCategory.BLOCKS, 0.5f, 2.6f + (p_updateTick_1_.rand.nextFloat() - p_updateTick_1_.rand.nextFloat()) * 0.8f);
            if (p_updateTick_1_ instanceof WorldServer) {
                ((WorldServer)p_updateTick_1_).spawnParticle(EnumParticleTypes.SMOKE_LARGE, (double)lvt_5_1_.getX() + 0.5, (double)lvt_5_1_.getY() + 0.25, (double)lvt_5_1_.getZ() + 0.5, 8, 0.5, 0.25, 0.5, 0.0, new int[0]);
            }
        }
    }

    @Override
    public boolean canEntitySpawn(IBlockState p_canEntitySpawn_1_, Entity p_canEntitySpawn_2_) {
        return p_canEntitySpawn_2_.isImmuneToFire();
    }
}

