/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.IGrowable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenBigMushroom;
import net.minecraft.world.gen.feature.WorldGenerator;

public class BlockMushroom
extends BlockBush
implements IGrowable {
    protected static final AxisAlignedBB MUSHROOM_AABB = new AxisAlignedBB(0.3f, 0.0, 0.3f, 0.7f, 0.4f, 0.7f);

    protected BlockMushroom() {
        this.setTickRandomly(true);
    }

    @Override
    public AxisAlignedBB getBoundingBox(IBlockState p_getBoundingBox_1_, IBlockAccess p_getBoundingBox_2_, BlockPos p_getBoundingBox_3_) {
        return MUSHROOM_AABB;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void updateTick(World p_updateTick_1_, BlockPos p_updateTick_2_, IBlockState p_updateTick_3_, Random p_updateTick_4_) {
        if (p_updateTick_4_.nextInt(25) == 0) {
            void var8_10;
            int i = 5;
            int j = 4;
            for (BlockPos blockPos : BlockPos.getAllInBoxMutable(p_updateTick_2_.add(-4, -1, -4), p_updateTick_2_.add(4, 1, 4))) {
                if (p_updateTick_1_.getBlockState(blockPos).getBlock() != this || --i > 0) continue;
                return;
            }
            BlockPos blockpos1 = p_updateTick_2_.add(p_updateTick_4_.nextInt(3) - 1, p_updateTick_4_.nextInt(2) - p_updateTick_4_.nextInt(2), p_updateTick_4_.nextInt(3) - 1);
            boolean bl = false;
            while (var8_10 < 4) {
                if (p_updateTick_1_.isAirBlock(blockpos1) && this.canBlockStay(p_updateTick_1_, blockpos1, this.getDefaultState())) {
                    p_updateTick_2_ = blockpos1;
                }
                blockpos1 = p_updateTick_2_.add(p_updateTick_4_.nextInt(3) - 1, p_updateTick_4_.nextInt(2) - p_updateTick_4_.nextInt(2), p_updateTick_4_.nextInt(3) - 1);
                ++var8_10;
            }
            if (p_updateTick_1_.isAirBlock(blockpos1) && this.canBlockStay(p_updateTick_1_, blockpos1, this.getDefaultState())) {
                p_updateTick_1_.setBlockState(blockpos1, this.getDefaultState(), 2);
            }
        }
    }

    @Override
    public boolean canPlaceBlockAt(World p_canPlaceBlockAt_1_, BlockPos p_canPlaceBlockAt_2_) {
        return super.canPlaceBlockAt(p_canPlaceBlockAt_1_, p_canPlaceBlockAt_2_) && this.canBlockStay(p_canPlaceBlockAt_1_, p_canPlaceBlockAt_2_, this.getDefaultState());
    }

    @Override
    protected boolean canSustainBush(IBlockState p_canSustainBush_1_) {
        return p_canSustainBush_1_.isFullBlock();
    }

    @Override
    public boolean canBlockStay(World p_canBlockStay_1_, BlockPos p_canBlockStay_2_, IBlockState p_canBlockStay_3_) {
        if (p_canBlockStay_2_.getY() >= 0 && p_canBlockStay_2_.getY() < 256) {
            IBlockState iblockstate = p_canBlockStay_1_.getBlockState(p_canBlockStay_2_.down());
            return iblockstate.getBlock() == Blocks.MYCELIUM ? true : (iblockstate.getBlock() == Blocks.DIRT && iblockstate.getValue(BlockDirt.VARIANT) == BlockDirt.DirtType.PODZOL ? true : p_canBlockStay_1_.getLight(p_canBlockStay_2_) < 13 && iblockstate.getBlock().canSustainPlant(iblockstate, p_canBlockStay_1_, p_canBlockStay_2_.down(), EnumFacing.UP, this));
        }
        return false;
    }

    public boolean generateBigMushroom(World p_generateBigMushroom_1_, BlockPos p_generateBigMushroom_2_, IBlockState p_generateBigMushroom_3_, Random p_generateBigMushroom_4_) {
        p_generateBigMushroom_1_.setBlockToAir(p_generateBigMushroom_2_);
        WorldGenBigMushroom worldgenerator = null;
        if (this == Blocks.BROWN_MUSHROOM) {
            worldgenerator = new WorldGenBigMushroom(Blocks.BROWN_MUSHROOM_BLOCK);
        } else if (this == Blocks.RED_MUSHROOM) {
            worldgenerator = new WorldGenBigMushroom(Blocks.RED_MUSHROOM_BLOCK);
        }
        if (worldgenerator != null && ((WorldGenerator)worldgenerator).generate(p_generateBigMushroom_1_, p_generateBigMushroom_4_, p_generateBigMushroom_2_)) {
            return true;
        }
        p_generateBigMushroom_1_.setBlockState(p_generateBigMushroom_2_, p_generateBigMushroom_3_, 3);
        return false;
    }

    @Override
    public boolean canGrow(World p_canGrow_1_, BlockPos p_canGrow_2_, IBlockState p_canGrow_3_, boolean p_canGrow_4_) {
        return true;
    }

    @Override
    public boolean canUseBonemeal(World p_canUseBonemeal_1_, Random p_canUseBonemeal_2_, BlockPos p_canUseBonemeal_3_, IBlockState p_canUseBonemeal_4_) {
        return (double)p_canUseBonemeal_2_.nextFloat() < 0.4;
    }

    @Override
    public void grow(World p_grow_1_, Random p_grow_2_, BlockPos p_grow_3_, IBlockState p_grow_4_) {
        this.generateBigMushroom(p_grow_1_, p_grow_3_, p_grow_4_, p_grow_2_);
    }
}

