/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockMycelium
extends Block {
    public static final PropertyBool SNOWY = PropertyBool.create("snowy");

    protected BlockMycelium() {
        super(Material.GRASS, MapColor.PURPLE);
        this.setDefaultState(this.blockState.getBaseState().withProperty(SNOWY, false));
        this.setTickRandomly(true);
        this.setCreativeTab(CreativeTabs.BUILDING_BLOCKS);
    }

    @Override
    public IBlockState getActualState(IBlockState p_getActualState_1_, IBlockAccess p_getActualState_2_, BlockPos p_getActualState_3_) {
        Block block = p_getActualState_2_.getBlockState(p_getActualState_3_.up()).getBlock();
        return p_getActualState_1_.withProperty(SNOWY, block == Blocks.SNOW || block == Blocks.SNOW_LAYER);
    }

    @Override
    public void updateTick(World p_updateTick_1_, BlockPos p_updateTick_2_, IBlockState p_updateTick_3_, Random p_updateTick_4_) {
        if (!p_updateTick_1_.isRemote) {
            if (p_updateTick_1_.getLightFromNeighbors(p_updateTick_2_.up()) < 4 && p_updateTick_1_.getBlockState(p_updateTick_2_.up()).getLightOpacity(p_updateTick_1_, p_updateTick_2_.up()) > 2) {
                p_updateTick_1_.setBlockState(p_updateTick_2_, Blocks.DIRT.getDefaultState().withProperty(BlockDirt.VARIANT, BlockDirt.DirtType.DIRT));
            } else if (p_updateTick_1_.getLightFromNeighbors(p_updateTick_2_.up()) >= 9) {
                for (int i = 0; i < 4; ++i) {
                    BlockPos blockpos = p_updateTick_2_.add(p_updateTick_4_.nextInt(3) - 1, p_updateTick_4_.nextInt(5) - 3, p_updateTick_4_.nextInt(3) - 1);
                    IBlockState iblockstate = p_updateTick_1_.getBlockState(blockpos);
                    IBlockState iblockstate1 = p_updateTick_1_.getBlockState(blockpos.up());
                    if (iblockstate.getBlock() != Blocks.DIRT || iblockstate.getValue(BlockDirt.VARIANT) != BlockDirt.DirtType.DIRT || p_updateTick_1_.getLightFromNeighbors(blockpos.up()) < 4 || iblockstate1.getLightOpacity(p_updateTick_1_, blockpos.up()) > 2) continue;
                    p_updateTick_1_.setBlockState(blockpos, this.getDefaultState());
                }
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(IBlockState p_randomDisplayTick_1_, World p_randomDisplayTick_2_, BlockPos p_randomDisplayTick_3_, Random p_randomDisplayTick_4_) {
        super.randomDisplayTick(p_randomDisplayTick_1_, p_randomDisplayTick_2_, p_randomDisplayTick_3_, p_randomDisplayTick_4_);
        if (p_randomDisplayTick_4_.nextInt(10) == 0) {
            p_randomDisplayTick_2_.spawnParticle(EnumParticleTypes.TOWN_AURA, (float)p_randomDisplayTick_3_.getX() + p_randomDisplayTick_4_.nextFloat(), (double)((float)p_randomDisplayTick_3_.getY() + 1.1f), (double)((float)p_randomDisplayTick_3_.getZ() + p_randomDisplayTick_4_.nextFloat()), 0.0, 0.0, 0.0, new int[0]);
        }
    }

    @Override
    public Item getItemDropped(IBlockState p_getItemDropped_1_, Random p_getItemDropped_2_, int p_getItemDropped_3_) {
        return Blocks.DIRT.getItemDropped(Blocks.DIRT.getDefaultState().withProperty(BlockDirt.VARIANT, BlockDirt.DirtType.DIRT), p_getItemDropped_2_, p_getItemDropped_3_);
    }

    @Override
    public int getMetaFromState(IBlockState p_getMetaFromState_1_) {
        return 0;
    }

    @Override
    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, SNOWY);
    }
}

