/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class BlockNetherWart
extends BlockBush {
    public static final PropertyInteger AGE = PropertyInteger.create("age", 0, 3);
    private static final AxisAlignedBB[] NETHER_WART_AABB = new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.3125, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.6875, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.875, 1.0)};

    protected BlockNetherWart() {
        super(Material.PLANTS, MapColor.RED);
        this.setDefaultState(this.blockState.getBaseState().withProperty(AGE, 0));
        this.setTickRandomly(true);
        this.setCreativeTab(null);
    }

    @Override
    public AxisAlignedBB getBoundingBox(IBlockState p_getBoundingBox_1_, IBlockAccess p_getBoundingBox_2_, BlockPos p_getBoundingBox_3_) {
        return NETHER_WART_AABB[p_getBoundingBox_1_.getValue(AGE)];
    }

    @Override
    protected boolean canSustainBush(IBlockState p_canSustainBush_1_) {
        return p_canSustainBush_1_.getBlock() == Blocks.SOUL_SAND;
    }

    @Override
    public boolean canBlockStay(World p_canBlockStay_1_, BlockPos p_canBlockStay_2_, IBlockState p_canBlockStay_3_) {
        return super.canBlockStay(p_canBlockStay_1_, p_canBlockStay_2_, p_canBlockStay_3_);
    }

    @Override
    public void updateTick(World p_updateTick_1_, BlockPos p_updateTick_2_, IBlockState p_updateTick_3_, Random p_updateTick_4_) {
        int i = p_updateTick_3_.getValue(AGE);
        if (i < 3 && ForgeHooks.onCropsGrowPre(p_updateTick_1_, p_updateTick_2_, p_updateTick_3_, p_updateTick_4_.nextInt(10) == 0)) {
            p_updateTick_3_ = p_updateTick_3_.withProperty(AGE, i + 1);
            p_updateTick_1_.setBlockState(p_updateTick_2_, p_updateTick_3_, 2);
            ForgeHooks.onCropsGrowPost(p_updateTick_1_, p_updateTick_2_, p_updateTick_3_, p_updateTick_1_.getBlockState(p_updateTick_2_));
        }
        super.updateTick(p_updateTick_1_, p_updateTick_2_, p_updateTick_3_, p_updateTick_4_);
    }

    @Override
    public void dropBlockAsItemWithChance(World p_dropBlockAsItemWithChance_1_, BlockPos p_dropBlockAsItemWithChance_2_, IBlockState p_dropBlockAsItemWithChance_3_, float p_dropBlockAsItemWithChance_4_, int p_dropBlockAsItemWithChance_5_) {
        super.dropBlockAsItemWithChance(p_dropBlockAsItemWithChance_1_, p_dropBlockAsItemWithChance_2_, p_dropBlockAsItemWithChance_3_, p_dropBlockAsItemWithChance_4_, p_dropBlockAsItemWithChance_5_);
    }

    @Override
    public Item getItemDropped(IBlockState p_getItemDropped_1_, Random p_getItemDropped_2_, int p_getItemDropped_3_) {
        return Items.AIR;
    }

    @Override
    public int quantityDropped(Random p_quantityDropped_1_) {
        return 0;
    }

    @Override
    public ItemStack getItem(World p_getItem_1_, BlockPos p_getItem_2_, IBlockState p_getItem_3_) {
        return new ItemStack(Items.NETHER_WART);
    }

    @Override
    public IBlockState getStateFromMeta(int p_getStateFromMeta_1_) {
        return this.getDefaultState().withProperty(AGE, p_getStateFromMeta_1_);
    }

    @Override
    public int getMetaFromState(IBlockState p_getMetaFromState_1_) {
        return p_getMetaFromState_1_.getValue(AGE);
    }

    @Override
    public List<ItemStack> getDrops(IBlockAccess p_getDrops_1_, BlockPos p_getDrops_2_, IBlockState p_getDrops_3_, int p_getDrops_4_) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        Random rand = p_getDrops_1_ instanceof World ? ((World)p_getDrops_1_).rand : new Random();
        int count = 1;
        if (p_getDrops_3_.getValue(AGE) >= 3) {
            count = 2 + rand.nextInt(3) + (p_getDrops_4_ > 0 ? rand.nextInt(p_getDrops_4_ + 1) : 0);
        }
        for (int i = 0; i < count; ++i) {
            ret.add(new ItemStack(Items.NETHER_WART));
        }
        return ret;
    }

    @Override
    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, AGE);
    }
}

