/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import com.google.common.base.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockNewLog
extends BlockLog {
    public static final PropertyEnum<BlockPlanks.EnumType> VARIANT = PropertyEnum.create("variant", BlockPlanks.EnumType.class, new Predicate<BlockPlanks.EnumType>(){

        public boolean apply(BlockPlanks.EnumType p_apply_1_) {
            return p_apply_1_.getMetadata() >= 4;
        }

        public /* synthetic */ boolean apply(Object p_apply_1_) {
            return this.apply((BlockPlanks.EnumType)p_apply_1_);
        }
    });

    public BlockNewLog() {
        this.setDefaultState(this.blockState.getBaseState().withProperty(VARIANT, BlockPlanks.EnumType.ACACIA).withProperty(LOG_AXIS, BlockLog.EnumAxis.Y));
    }

    @Override
    public MapColor getMapColor(IBlockState p_getMapColor_1_) {
        BlockPlanks.EnumType lvt_2_1_ = p_getMapColor_1_.getValue(VARIANT);
        switch ((BlockLog.EnumAxis)p_getMapColor_1_.getValue(LOG_AXIS)) {
            default: {
                switch (lvt_2_1_) {
                    default: {
                        return MapColor.STONE;
                    }
                    case DARK_OAK: 
                }
                return BlockPlanks.EnumType.DARK_OAK.getMapColor();
            }
            case Y: 
        }
        return lvt_2_1_.getMapColor();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getSubBlocks(Item p_getSubBlocks_1_, CreativeTabs p_getSubBlocks_2_, NonNullList<ItemStack> p_getSubBlocks_3_) {
        p_getSubBlocks_3_.add(new ItemStack(p_getSubBlocks_1_, 1, BlockPlanks.EnumType.ACACIA.getMetadata() - 4));
        p_getSubBlocks_3_.add(new ItemStack(p_getSubBlocks_1_, 1, BlockPlanks.EnumType.DARK_OAK.getMetadata() - 4));
    }

    @Override
    public IBlockState getStateFromMeta(int p_getStateFromMeta_1_) {
        IBlockState lvt_2_1_ = this.getDefaultState().withProperty(VARIANT, BlockPlanks.EnumType.byMetadata((p_getStateFromMeta_1_ & 3) + 4));
        switch (p_getStateFromMeta_1_ & 0xC) {
            case 0: {
                lvt_2_1_ = lvt_2_1_.withProperty(LOG_AXIS, BlockLog.EnumAxis.Y);
                break;
            }
            case 4: {
                lvt_2_1_ = lvt_2_1_.withProperty(LOG_AXIS, BlockLog.EnumAxis.X);
                break;
            }
            case 8: {
                lvt_2_1_ = lvt_2_1_.withProperty(LOG_AXIS, BlockLog.EnumAxis.Z);
                break;
            }
            default: {
                lvt_2_1_ = lvt_2_1_.withProperty(LOG_AXIS, BlockLog.EnumAxis.NONE);
            }
        }
        return lvt_2_1_;
    }

    @Override
    public int getMetaFromState(IBlockState p_getMetaFromState_1_) {
        int lvt_2_1_ = 0;
        lvt_2_1_ |= p_getMetaFromState_1_.getValue(VARIANT).getMetadata() - 4;
        switch ((BlockLog.EnumAxis)p_getMetaFromState_1_.getValue(LOG_AXIS)) {
            case X: {
                lvt_2_1_ |= 4;
                break;
            }
            case Z: {
                lvt_2_1_ |= 8;
                break;
            }
            case NONE: {
                lvt_2_1_ |= 0xC;
            }
        }
        return lvt_2_1_;
    }

    @Override
    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, VARIANT, LOG_AXIS);
    }

    @Override
    protected ItemStack getSilkTouchDrop(IBlockState p_getSilkTouchDrop_1_) {
        return new ItemStack(Item.getItemFromBlock(this), 1, p_getSilkTouchDrop_1_.getValue(VARIANT).getMetadata() - 4);
    }

    @Override
    public int damageDropped(IBlockState p_damageDropped_1_) {
        return p_damageDropped_1_.getValue(VARIANT).getMetadata() - 4;
    }
}

