/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityNote;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.NoteBlockEvent;

public class BlockNote
extends BlockContainer {
    private static final List<SoundEvent> INSTRUMENTS = Lists.newArrayList((Object[])new SoundEvent[]{SoundEvents.BLOCK_NOTE_HARP, SoundEvents.BLOCK_NOTE_BASEDRUM, SoundEvents.BLOCK_NOTE_SNARE, SoundEvents.BLOCK_NOTE_HAT, SoundEvents.BLOCK_NOTE_BASS});

    public BlockNote() {
        super(Material.WOOD);
        this.setCreativeTab(CreativeTabs.REDSTONE);
    }

    @Override
    public void neighborChanged(IBlockState p_neighborChanged_1_, World p_neighborChanged_2_, BlockPos p_neighborChanged_3_, Block p_neighborChanged_4_, BlockPos p_neighborChanged_5_) {
        boolean flag = p_neighborChanged_2_.isBlockPowered(p_neighborChanged_3_);
        TileEntity tileentity = p_neighborChanged_2_.getTileEntity(p_neighborChanged_3_);
        if (tileentity instanceof TileEntityNote) {
            TileEntityNote tileentitynote = (TileEntityNote)tileentity;
            if (tileentitynote.previousRedstoneState != flag) {
                if (flag) {
                    tileentitynote.triggerNote(p_neighborChanged_2_, p_neighborChanged_3_);
                }
                tileentitynote.previousRedstoneState = flag;
            }
        }
    }

    @Override
    public boolean onBlockActivated(World p_onBlockActivated_1_, BlockPos p_onBlockActivated_2_, IBlockState p_onBlockActivated_3_, EntityPlayer p_onBlockActivated_4_, EnumHand p_onBlockActivated_5_, EnumFacing p_onBlockActivated_6_, float p_onBlockActivated_7_, float p_onBlockActivated_8_, float p_onBlockActivated_9_) {
        if (p_onBlockActivated_1_.isRemote) {
            return true;
        }
        TileEntity tileentity = p_onBlockActivated_1_.getTileEntity(p_onBlockActivated_2_);
        if (tileentity instanceof TileEntityNote) {
            TileEntityNote tileentitynote = (TileEntityNote)tileentity;
            byte old = tileentitynote.note;
            tileentitynote.changePitch();
            if (old == tileentitynote.note) {
                return false;
            }
            tileentitynote.triggerNote(p_onBlockActivated_1_, p_onBlockActivated_2_);
            p_onBlockActivated_4_.addStat(StatList.NOTEBLOCK_TUNED);
        }
        return true;
    }

    @Override
    public void onBlockClicked(World p_onBlockClicked_1_, BlockPos p_onBlockClicked_2_, EntityPlayer p_onBlockClicked_3_) {
        TileEntity tileentity;
        if (!p_onBlockClicked_1_.isRemote && (tileentity = p_onBlockClicked_1_.getTileEntity(p_onBlockClicked_2_)) instanceof TileEntityNote) {
            ((TileEntityNote)tileentity).triggerNote(p_onBlockClicked_1_, p_onBlockClicked_2_);
            p_onBlockClicked_3_.addStat(StatList.NOTEBLOCK_PLAYED);
        }
    }

    @Override
    public TileEntity createNewTileEntity(World p_createNewTileEntity_1_, int p_createNewTileEntity_2_) {
        return new TileEntityNote();
    }

    private SoundEvent getInstrument(int p_getInstrument_1_) {
        if (p_getInstrument_1_ < 0 || p_getInstrument_1_ >= INSTRUMENTS.size()) {
            p_getInstrument_1_ = 0;
        }
        return INSTRUMENTS.get(p_getInstrument_1_);
    }

    @Override
    public boolean eventReceived(IBlockState p_eventReceived_1_, World p_eventReceived_2_, BlockPos p_eventReceived_3_, int p_eventReceived_4_, int p_eventReceived_5_) {
        NoteBlockEvent.Play e = new NoteBlockEvent.Play(p_eventReceived_2_, p_eventReceived_3_, p_eventReceived_1_, p_eventReceived_5_, p_eventReceived_4_);
        if (MinecraftForge.EVENT_BUS.post(e)) {
            return false;
        }
        p_eventReceived_4_ = e.getInstrument().ordinal();
        p_eventReceived_5_ = e.getVanillaNoteId();
        float f = (float)Math.pow(2.0, (double)(p_eventReceived_5_ - 12) / 12.0);
        p_eventReceived_2_.playSound(null, p_eventReceived_3_, this.getInstrument(p_eventReceived_4_), SoundCategory.RECORDS, 3.0f, f);
        p_eventReceived_2_.spawnParticle(EnumParticleTypes.NOTE, (double)p_eventReceived_3_.getX() + 0.5, (double)p_eventReceived_3_.getY() + 1.2, (double)p_eventReceived_3_.getZ() + 0.5, (double)p_eventReceived_5_ / 24.0, 0.0, 0.0, new int[0]);
        return true;
    }

    @Override
    public EnumBlockRenderType getRenderType(IBlockState p_getRenderType_1_) {
        return EnumBlockRenderType.MODEL;
    }
}

