/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockObserver
extends BlockDirectional {
    public static final PropertyBool POWERED = PropertyBool.create("powered");

    public BlockObserver() {
        super(Material.ROCK);
        this.setDefaultState(this.blockState.getBaseState().withProperty(FACING, EnumFacing.SOUTH).withProperty(POWERED, false));
        this.setCreativeTab(CreativeTabs.REDSTONE);
    }

    @Override
    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, FACING, POWERED);
    }

    @Override
    public IBlockState withRotation(IBlockState p_withRotation_1_, Rotation p_withRotation_2_) {
        return p_withRotation_1_.withProperty(FACING, p_withRotation_2_.rotate(p_withRotation_1_.getValue(FACING)));
    }

    @Override
    public IBlockState withMirror(IBlockState p_withMirror_1_, Mirror p_withMirror_2_) {
        return p_withMirror_1_.withRotation(p_withMirror_2_.toRotation(p_withMirror_1_.getValue(FACING)));
    }

    @Override
    public void updateTick(World p_updateTick_1_, BlockPos p_updateTick_2_, IBlockState p_updateTick_3_, Random p_updateTick_4_) {
        if (p_updateTick_3_.getValue(POWERED).booleanValue()) {
            p_updateTick_1_.setBlockState(p_updateTick_2_, p_updateTick_3_.withProperty(POWERED, false), 2);
        } else {
            p_updateTick_1_.setBlockState(p_updateTick_2_, p_updateTick_3_.withProperty(POWERED, true), 2);
            p_updateTick_1_.scheduleUpdate(p_updateTick_2_, this, 2);
        }
        this.updateNeighborsInFront(p_updateTick_1_, p_updateTick_2_, p_updateTick_3_);
    }

    @Override
    public void neighborChanged(IBlockState p_neighborChanged_1_, World p_neighborChanged_2_, BlockPos p_neighborChanged_3_, Block p_neighborChanged_4_, BlockPos p_neighborChanged_5_) {
    }

    public void observedNeighborChanged(IBlockState p_observedNeighborChanged_1_, World p_observedNeighborChanged_2_, BlockPos p_observedNeighborChanged_3_, Block p_observedNeighborChanged_4_, BlockPos p_observedNeighborChanged_5_) {
        if (!p_observedNeighborChanged_2_.isRemote && p_observedNeighborChanged_3_.offset(p_observedNeighborChanged_1_.getValue(FACING)).equals(p_observedNeighborChanged_5_)) {
            this.startSignal(p_observedNeighborChanged_1_, p_observedNeighborChanged_2_, p_observedNeighborChanged_3_);
        }
    }

    private void startSignal(IBlockState p_startSignal_1_, World p_startSignal_2_, BlockPos p_startSignal_3_) {
        if (!p_startSignal_1_.getValue(POWERED).booleanValue() && !p_startSignal_2_.isUpdateScheduled(p_startSignal_3_, this)) {
            p_startSignal_2_.scheduleUpdate(p_startSignal_3_, this, 2);
        }
    }

    protected void updateNeighborsInFront(World p_updateNeighborsInFront_1_, BlockPos p_updateNeighborsInFront_2_, IBlockState p_updateNeighborsInFront_3_) {
        EnumFacing enumfacing = p_updateNeighborsInFront_3_.getValue(FACING);
        BlockPos blockpos = p_updateNeighborsInFront_2_.offset(enumfacing.getOpposite());
        p_updateNeighborsInFront_1_.neighborChanged(blockpos, this, p_updateNeighborsInFront_2_);
        p_updateNeighborsInFront_1_.notifyNeighborsOfStateExcept(blockpos, this, enumfacing);
    }

    @Override
    public boolean canProvidePower(IBlockState p_canProvidePower_1_) {
        return true;
    }

    @Override
    public int getStrongPower(IBlockState p_getStrongPower_1_, IBlockAccess p_getStrongPower_2_, BlockPos p_getStrongPower_3_, EnumFacing p_getStrongPower_4_) {
        return p_getStrongPower_1_.getWeakPower(p_getStrongPower_2_, p_getStrongPower_3_, p_getStrongPower_4_);
    }

    @Override
    public int getWeakPower(IBlockState p_getWeakPower_1_, IBlockAccess p_getWeakPower_2_, BlockPos p_getWeakPower_3_, EnumFacing p_getWeakPower_4_) {
        return p_getWeakPower_1_.getValue(POWERED) != false && p_getWeakPower_1_.getValue(FACING) == p_getWeakPower_4_ ? 15 : 0;
    }

    @Override
    public void onBlockAdded(World p_onBlockAdded_1_, BlockPos p_onBlockAdded_2_, IBlockState p_onBlockAdded_3_) {
        if (!p_onBlockAdded_1_.isRemote) {
            if (p_onBlockAdded_3_.getValue(POWERED).booleanValue()) {
                this.updateTick(p_onBlockAdded_1_, p_onBlockAdded_2_, p_onBlockAdded_3_, p_onBlockAdded_1_.rand);
            }
            this.startSignal(p_onBlockAdded_3_, p_onBlockAdded_1_, p_onBlockAdded_2_);
        }
    }

    @Override
    public void breakBlock(World p_breakBlock_1_, BlockPos p_breakBlock_2_, IBlockState p_breakBlock_3_) {
        if (p_breakBlock_3_.getValue(POWERED).booleanValue() && p_breakBlock_1_.isUpdateScheduled(p_breakBlock_2_, this)) {
            this.updateNeighborsInFront(p_breakBlock_1_, p_breakBlock_2_, p_breakBlock_3_.withProperty(POWERED, false));
        }
    }

    @Override
    public IBlockState getStateForPlacement(World p_getStateForPlacement_1_, BlockPos p_getStateForPlacement_2_, EnumFacing p_getStateForPlacement_3_, float p_getStateForPlacement_4_, float p_getStateForPlacement_5_, float p_getStateForPlacement_6_, int p_getStateForPlacement_7_, EntityLivingBase p_getStateForPlacement_8_) {
        return this.getDefaultState().withProperty(FACING, EnumFacing.getDirectionFromEntityLiving(p_getStateForPlacement_2_, p_getStateForPlacement_8_).getOpposite());
    }

    @Override
    public int getMetaFromState(IBlockState p_getMetaFromState_1_) {
        int i = 0;
        i |= p_getMetaFromState_1_.getValue(FACING).getIndex();
        if (p_getMetaFromState_1_.getValue(POWERED).booleanValue()) {
            i |= 8;
        }
        return i;
    }

    @Override
    public IBlockState getStateFromMeta(int p_getStateFromMeta_1_) {
        return this.getDefaultState().withProperty(FACING, EnumFacing.getFront(p_getStateFromMeta_1_ & 7));
    }

    @Override
    public void observedNeighborChange(IBlockState p_observedNeighborChange_1_, World p_observedNeighborChange_2_, BlockPos p_observedNeighborChange_3_, Block p_observedNeighborChange_4_, BlockPos p_observedNeighborChange_5_) {
        this.observedNeighborChanged(p_observedNeighborChange_1_, p_observedNeighborChange_2_, p_observedNeighborChange_3_, p_observedNeighborChange_4_, p_observedNeighborChange_5_);
    }
}

