/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import com.google.common.base.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockOldLeaf
extends BlockLeaves {
    public static final PropertyEnum<BlockPlanks.EnumType> VARIANT = PropertyEnum.create("variant", BlockPlanks.EnumType.class, new Predicate<BlockPlanks.EnumType>(){

        public boolean apply(BlockPlanks.EnumType p_apply_1_) {
            return p_apply_1_.getMetadata() < 4;
        }
    });

    public BlockOldLeaf() {
        this.setDefaultState(this.blockState.getBaseState().withProperty(VARIANT, BlockPlanks.EnumType.OAK).withProperty(CHECK_DECAY, true).withProperty(DECAYABLE, true));
    }

    @Override
    protected void dropApple(World p_dropApple_1_, BlockPos p_dropApple_2_, IBlockState p_dropApple_3_, int p_dropApple_4_) {
        if (p_dropApple_3_.getValue(VARIANT) == BlockPlanks.EnumType.OAK && p_dropApple_1_.rand.nextInt(p_dropApple_4_) == 0) {
            BlockOldLeaf.spawnAsEntity(p_dropApple_1_, p_dropApple_2_, new ItemStack(Items.APPLE));
        }
    }

    @Override
    protected int getSaplingDropChance(IBlockState p_getSaplingDropChance_1_) {
        return p_getSaplingDropChance_1_.getValue(VARIANT) == BlockPlanks.EnumType.JUNGLE ? 40 : super.getSaplingDropChance(p_getSaplingDropChance_1_);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void getSubBlocks(Item p_getSubBlocks_1_, CreativeTabs p_getSubBlocks_2_, NonNullList<ItemStack> p_getSubBlocks_3_) {
        p_getSubBlocks_3_.add(new ItemStack(p_getSubBlocks_1_, 1, BlockPlanks.EnumType.OAK.getMetadata()));
        p_getSubBlocks_3_.add(new ItemStack(p_getSubBlocks_1_, 1, BlockPlanks.EnumType.SPRUCE.getMetadata()));
        p_getSubBlocks_3_.add(new ItemStack(p_getSubBlocks_1_, 1, BlockPlanks.EnumType.BIRCH.getMetadata()));
        p_getSubBlocks_3_.add(new ItemStack(p_getSubBlocks_1_, 1, BlockPlanks.EnumType.JUNGLE.getMetadata()));
    }

    @Override
    protected ItemStack getSilkTouchDrop(IBlockState p_getSilkTouchDrop_1_) {
        return new ItemStack(Item.getItemFromBlock(this), 1, p_getSilkTouchDrop_1_.getValue(VARIANT).getMetadata());
    }

    @Override
    public IBlockState getStateFromMeta(int p_getStateFromMeta_1_) {
        return this.getDefaultState().withProperty(VARIANT, this.getWoodType(p_getStateFromMeta_1_)).withProperty(DECAYABLE, (p_getStateFromMeta_1_ & 4) == 0).withProperty(CHECK_DECAY, (p_getStateFromMeta_1_ & 8) > 0);
    }

    @Override
    public int getMetaFromState(IBlockState p_getMetaFromState_1_) {
        int i = 0;
        i |= p_getMetaFromState_1_.getValue(VARIANT).getMetadata();
        if (!p_getMetaFromState_1_.getValue(DECAYABLE).booleanValue()) {
            i |= 4;
        }
        if (p_getMetaFromState_1_.getValue(CHECK_DECAY).booleanValue()) {
            i |= 8;
        }
        return i;
    }

    @Override
    public BlockPlanks.EnumType getWoodType(int p_getWoodType_1_) {
        return BlockPlanks.EnumType.byMetadata((p_getWoodType_1_ & 3) % 4);
    }

    @Override
    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, VARIANT, CHECK_DECAY, DECAYABLE);
    }

    @Override
    public int damageDropped(IBlockState p_damageDropped_1_) {
        return p_damageDropped_1_.getValue(VARIANT).getMetadata();
    }

    @Override
    public void harvestBlock(World p_harvestBlock_1_, EntityPlayer p_harvestBlock_2_, BlockPos p_harvestBlock_3_, IBlockState p_harvestBlock_4_, TileEntity p_harvestBlock_5_, ItemStack p_harvestBlock_6_) {
        if (!p_harvestBlock_1_.isRemote && p_harvestBlock_6_.getItem() == Items.SHEARS) {
            p_harvestBlock_2_.addStat(StatList.getBlockStats(this));
        } else {
            super.harvestBlock(p_harvestBlock_1_, p_harvestBlock_2_, p_harvestBlock_3_, p_harvestBlock_4_, p_harvestBlock_5_, p_harvestBlock_6_);
        }
    }

    public NonNullList<ItemStack> onSheared(ItemStack p_onSheared_1_, IBlockAccess p_onSheared_2_, BlockPos p_onSheared_3_, int p_onSheared_4_) {
        return NonNullList.withSize(1, new ItemStack(this, 1, p_onSheared_2_.getBlockState(p_onSheared_3_).getValue(VARIANT).getMetadata()));
    }
}

