/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockOre
extends Block {
    public BlockOre() {
        this(Material.ROCK.getMaterialMapColor());
    }

    public BlockOre(MapColor p_i46390_1_) {
        super(Material.ROCK, p_i46390_1_);
        this.setCreativeTab(CreativeTabs.BUILDING_BLOCKS);
    }

    @Override
    public Item getItemDropped(IBlockState p_getItemDropped_1_, Random p_getItemDropped_2_, int p_getItemDropped_3_) {
        return this == Blocks.COAL_ORE ? Items.COAL : (this == Blocks.DIAMOND_ORE ? Items.DIAMOND : (this == Blocks.LAPIS_ORE ? Items.DYE : (this == Blocks.EMERALD_ORE ? Items.EMERALD : (this == Blocks.QUARTZ_ORE ? Items.QUARTZ : Item.getItemFromBlock(this)))));
    }

    @Override
    public int quantityDropped(Random p_quantityDropped_1_) {
        return this == Blocks.LAPIS_ORE ? 4 + p_quantityDropped_1_.nextInt(5) : 1;
    }

    @Override
    public int quantityDroppedWithBonus(int p_quantityDroppedWithBonus_1_, Random p_quantityDroppedWithBonus_2_) {
        if (p_quantityDroppedWithBonus_1_ > 0 && Item.getItemFromBlock(this) != this.getItemDropped((IBlockState)this.getBlockState().getValidStates().iterator().next(), p_quantityDroppedWithBonus_2_, p_quantityDroppedWithBonus_1_)) {
            int i = p_quantityDroppedWithBonus_2_.nextInt(p_quantityDroppedWithBonus_1_ + 2) - 1;
            if (i < 0) {
                i = 0;
            }
            return this.quantityDropped(p_quantityDroppedWithBonus_2_) * (i + 1);
        }
        return this.quantityDropped(p_quantityDroppedWithBonus_2_);
    }

    @Override
    public void dropBlockAsItemWithChance(World p_dropBlockAsItemWithChance_1_, BlockPos p_dropBlockAsItemWithChance_2_, IBlockState p_dropBlockAsItemWithChance_3_, float p_dropBlockAsItemWithChance_4_, int p_dropBlockAsItemWithChance_5_) {
        super.dropBlockAsItemWithChance(p_dropBlockAsItemWithChance_1_, p_dropBlockAsItemWithChance_2_, p_dropBlockAsItemWithChance_3_, p_dropBlockAsItemWithChance_4_, p_dropBlockAsItemWithChance_5_);
    }

    @Override
    public int getExpDrop(IBlockState p_getExpDrop_1_, IBlockAccess p_getExpDrop_2_, BlockPos p_getExpDrop_3_, int p_getExpDrop_4_) {
        Random rand;
        Random random = rand = p_getExpDrop_2_ instanceof World ? ((World)p_getExpDrop_2_).rand : new Random();
        if (this.getItemDropped(p_getExpDrop_1_, rand, p_getExpDrop_4_) != Item.getItemFromBlock(this)) {
            int i = 0;
            if (this == Blocks.COAL_ORE) {
                i = MathHelper.getInt(rand, 0, 2);
            } else if (this == Blocks.DIAMOND_ORE) {
                i = MathHelper.getInt(rand, 3, 7);
            } else if (this == Blocks.EMERALD_ORE) {
                i = MathHelper.getInt(rand, 3, 7);
            } else if (this == Blocks.LAPIS_ORE) {
                i = MathHelper.getInt(rand, 2, 5);
            } else if (this == Blocks.QUARTZ_ORE) {
                i = MathHelper.getInt(rand, 2, 5);
            }
            return i;
        }
        return 0;
    }

    @Override
    public ItemStack getItem(World p_getItem_1_, BlockPos p_getItem_2_, IBlockState p_getItem_3_) {
        return new ItemStack(this);
    }

    @Override
    public int damageDropped(IBlockState p_damageDropped_1_) {
        return this == Blocks.LAPIS_ORE ? EnumDyeColor.BLUE.getDyeDamage() : 0;
    }
}

