/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockPane
extends Block {
    public static final PropertyBool NORTH = PropertyBool.create("north");
    public static final PropertyBool EAST = PropertyBool.create("east");
    public static final PropertyBool SOUTH = PropertyBool.create("south");
    public static final PropertyBool WEST = PropertyBool.create("west");
    protected static final AxisAlignedBB[] AABB_BY_INDEX = new AxisAlignedBB[]{new AxisAlignedBB(0.4375, 0.0, 0.4375, 0.5625, 1.0, 0.5625), new AxisAlignedBB(0.4375, 0.0, 0.4375, 0.5625, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.4375, 0.5625, 1.0, 0.5625), new AxisAlignedBB(0.0, 0.0, 0.4375, 0.5625, 1.0, 1.0), new AxisAlignedBB(0.4375, 0.0, 0.0, 0.5625, 1.0, 0.5625), new AxisAlignedBB(0.4375, 0.0, 0.0, 0.5625, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 0.5625, 1.0, 0.5625), new AxisAlignedBB(0.0, 0.0, 0.0, 0.5625, 1.0, 1.0), new AxisAlignedBB(0.4375, 0.0, 0.4375, 1.0, 1.0, 0.5625), new AxisAlignedBB(0.4375, 0.0, 0.4375, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.4375, 1.0, 1.0, 0.5625), new AxisAlignedBB(0.0, 0.0, 0.4375, 1.0, 1.0, 1.0), new AxisAlignedBB(0.4375, 0.0, 0.0, 1.0, 1.0, 0.5625), new AxisAlignedBB(0.4375, 0.0, 0.0, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.5625), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0)};
    private final boolean canDrop;

    protected BlockPane(Material p_i45675_1_, boolean p_i45675_2_) {
        super(p_i45675_1_);
        this.setDefaultState(this.blockState.getBaseState().withProperty(NORTH, false).withProperty(EAST, false).withProperty(SOUTH, false).withProperty(WEST, false));
        this.canDrop = p_i45675_2_;
        this.setCreativeTab(CreativeTabs.DECORATIONS);
    }

    @Override
    public void addCollisionBoxToList(IBlockState p_addCollisionBoxToList_1_, World p_addCollisionBoxToList_2_, BlockPos p_addCollisionBoxToList_3_, AxisAlignedBB p_addCollisionBoxToList_4_, List<AxisAlignedBB> p_addCollisionBoxToList_5_, Entity p_addCollisionBoxToList_6_, boolean p_addCollisionBoxToList_7_) {
        if (!p_addCollisionBoxToList_7_) {
            p_addCollisionBoxToList_1_ = this.getActualState(p_addCollisionBoxToList_1_, p_addCollisionBoxToList_2_, p_addCollisionBoxToList_3_);
        }
        BlockPane.addCollisionBoxToList(p_addCollisionBoxToList_3_, p_addCollisionBoxToList_4_, p_addCollisionBoxToList_5_, AABB_BY_INDEX[0]);
        if (p_addCollisionBoxToList_1_.getValue(NORTH).booleanValue()) {
            BlockPane.addCollisionBoxToList(p_addCollisionBoxToList_3_, p_addCollisionBoxToList_4_, p_addCollisionBoxToList_5_, AABB_BY_INDEX[BlockPane.getBoundingBoxIndex(EnumFacing.NORTH)]);
        }
        if (p_addCollisionBoxToList_1_.getValue(SOUTH).booleanValue()) {
            BlockPane.addCollisionBoxToList(p_addCollisionBoxToList_3_, p_addCollisionBoxToList_4_, p_addCollisionBoxToList_5_, AABB_BY_INDEX[BlockPane.getBoundingBoxIndex(EnumFacing.SOUTH)]);
        }
        if (p_addCollisionBoxToList_1_.getValue(EAST).booleanValue()) {
            BlockPane.addCollisionBoxToList(p_addCollisionBoxToList_3_, p_addCollisionBoxToList_4_, p_addCollisionBoxToList_5_, AABB_BY_INDEX[BlockPane.getBoundingBoxIndex(EnumFacing.EAST)]);
        }
        if (p_addCollisionBoxToList_1_.getValue(WEST).booleanValue()) {
            BlockPane.addCollisionBoxToList(p_addCollisionBoxToList_3_, p_addCollisionBoxToList_4_, p_addCollisionBoxToList_5_, AABB_BY_INDEX[BlockPane.getBoundingBoxIndex(EnumFacing.WEST)]);
        }
    }

    private static int getBoundingBoxIndex(EnumFacing p_getBoundingBoxIndex_0_) {
        return 1 << p_getBoundingBoxIndex_0_.getHorizontalIndex();
    }

    @Override
    public AxisAlignedBB getBoundingBox(IBlockState p_getBoundingBox_1_, IBlockAccess p_getBoundingBox_2_, BlockPos p_getBoundingBox_3_) {
        p_getBoundingBox_1_ = this.getActualState(p_getBoundingBox_1_, p_getBoundingBox_2_, p_getBoundingBox_3_);
        return AABB_BY_INDEX[BlockPane.getBoundingBoxIndex(p_getBoundingBox_1_)];
    }

    private static int getBoundingBoxIndex(IBlockState p_getBoundingBoxIndex_0_) {
        int i = 0;
        if (p_getBoundingBoxIndex_0_.getValue(NORTH).booleanValue()) {
            i |= BlockPane.getBoundingBoxIndex(EnumFacing.NORTH);
        }
        if (p_getBoundingBoxIndex_0_.getValue(EAST).booleanValue()) {
            i |= BlockPane.getBoundingBoxIndex(EnumFacing.EAST);
        }
        if (p_getBoundingBoxIndex_0_.getValue(SOUTH).booleanValue()) {
            i |= BlockPane.getBoundingBoxIndex(EnumFacing.SOUTH);
        }
        if (p_getBoundingBoxIndex_0_.getValue(WEST).booleanValue()) {
            i |= BlockPane.getBoundingBoxIndex(EnumFacing.WEST);
        }
        return i;
    }

    @Override
    public IBlockState getActualState(IBlockState p_getActualState_1_, IBlockAccess p_getActualState_2_, BlockPos p_getActualState_3_) {
        return p_getActualState_1_.withProperty(NORTH, this.canPaneConnectTo(p_getActualState_2_, p_getActualState_3_, EnumFacing.NORTH)).withProperty(SOUTH, this.canPaneConnectTo(p_getActualState_2_, p_getActualState_3_, EnumFacing.SOUTH)).withProperty(WEST, this.canPaneConnectTo(p_getActualState_2_, p_getActualState_3_, EnumFacing.WEST)).withProperty(EAST, this.canPaneConnectTo(p_getActualState_2_, p_getActualState_3_, EnumFacing.EAST));
    }

    @Override
    public Item getItemDropped(IBlockState p_getItemDropped_1_, Random p_getItemDropped_2_, int p_getItemDropped_3_) {
        return !this.canDrop ? Items.AIR : super.getItemDropped(p_getItemDropped_1_, p_getItemDropped_2_, p_getItemDropped_3_);
    }

    @Override
    public boolean isOpaqueCube(IBlockState p_isOpaqueCube_1_) {
        return false;
    }

    @Override
    public boolean isFullCube(IBlockState p_isFullCube_1_) {
        return false;
    }

    public final boolean canPaneConnectToBlock(Block p_canPaneConnectToBlock_1_) {
        return p_canPaneConnectToBlock_1_.getDefaultState().isFullCube() || p_canPaneConnectToBlock_1_ == this || p_canPaneConnectToBlock_1_ == Blocks.GLASS || p_canPaneConnectToBlock_1_ == Blocks.STAINED_GLASS || p_canPaneConnectToBlock_1_ == Blocks.STAINED_GLASS_PANE || p_canPaneConnectToBlock_1_ instanceof BlockPane;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(IBlockState p_shouldSideBeRendered_1_, IBlockAccess p_shouldSideBeRendered_2_, BlockPos p_shouldSideBeRendered_3_, EnumFacing p_shouldSideBeRendered_4_) {
        return p_shouldSideBeRendered_2_.getBlockState(p_shouldSideBeRendered_3_.offset(p_shouldSideBeRendered_4_)).getBlock() == this ? false : super.shouldSideBeRendered(p_shouldSideBeRendered_1_, p_shouldSideBeRendered_2_, p_shouldSideBeRendered_3_, p_shouldSideBeRendered_4_);
    }

    @Override
    protected boolean canSilkHarvest() {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer getBlockLayer() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    @Override
    public int getMetaFromState(IBlockState p_getMetaFromState_1_) {
        return 0;
    }

    @Override
    public IBlockState withRotation(IBlockState p_withRotation_1_, Rotation p_withRotation_2_) {
        switch (p_withRotation_2_) {
            case CLOCKWISE_180: {
                return p_withRotation_1_.withProperty(NORTH, p_withRotation_1_.getValue(SOUTH)).withProperty(EAST, p_withRotation_1_.getValue(WEST)).withProperty(SOUTH, p_withRotation_1_.getValue(NORTH)).withProperty(WEST, p_withRotation_1_.getValue(EAST));
            }
            case COUNTERCLOCKWISE_90: {
                return p_withRotation_1_.withProperty(NORTH, p_withRotation_1_.getValue(EAST)).withProperty(EAST, p_withRotation_1_.getValue(SOUTH)).withProperty(SOUTH, p_withRotation_1_.getValue(WEST)).withProperty(WEST, p_withRotation_1_.getValue(NORTH));
            }
            case CLOCKWISE_90: {
                return p_withRotation_1_.withProperty(NORTH, p_withRotation_1_.getValue(WEST)).withProperty(EAST, p_withRotation_1_.getValue(NORTH)).withProperty(SOUTH, p_withRotation_1_.getValue(EAST)).withProperty(WEST, p_withRotation_1_.getValue(SOUTH));
            }
        }
        return p_withRotation_1_;
    }

    @Override
    public IBlockState withMirror(IBlockState p_withMirror_1_, Mirror p_withMirror_2_) {
        switch (p_withMirror_2_) {
            case LEFT_RIGHT: {
                return p_withMirror_1_.withProperty(NORTH, p_withMirror_1_.getValue(SOUTH)).withProperty(SOUTH, p_withMirror_1_.getValue(NORTH));
            }
            case FRONT_BACK: {
                return p_withMirror_1_.withProperty(EAST, p_withMirror_1_.getValue(WEST)).withProperty(WEST, p_withMirror_1_.getValue(EAST));
            }
        }
        return super.withMirror(p_withMirror_1_, p_withMirror_2_);
    }

    @Override
    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, NORTH, EAST, WEST, SOUTH);
    }

    @Override
    public boolean canBeConnectedTo(IBlockAccess p_canBeConnectedTo_1_, BlockPos p_canBeConnectedTo_2_, EnumFacing p_canBeConnectedTo_3_) {
        Block connector = p_canBeConnectedTo_1_.getBlockState(p_canBeConnectedTo_2_.offset(p_canBeConnectedTo_3_)).getBlock();
        return connector instanceof BlockPane;
    }

    public boolean canPaneConnectTo(IBlockAccess p_canPaneConnectTo_1_, BlockPos p_canPaneConnectTo_2_, EnumFacing p_canPaneConnectTo_3_) {
        IBlockState state = p_canPaneConnectTo_1_.getBlockState(p_canPaneConnectTo_2_.offset(p_canPaneConnectTo_3_));
        return state.getBlock().canBeConnectedTo(p_canPaneConnectTo_1_, p_canPaneConnectTo_2_.offset(p_canPaneConnectTo_3_), p_canPaneConnectTo_3_.getOpposite()) || this.canPaneConnectToBlock(state.getBlock()) || state.isSideSolid(p_canPaneConnectTo_1_, p_canPaneConnectTo_2_.offset(p_canPaneConnectTo_3_), p_canPaneConnectTo_3_.getOpposite());
    }
}

