/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.BlockPistonExtension;
import net.minecraft.block.BlockPistonMoving;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockPistonStructureHelper;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityPiston;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockPistonBase
extends BlockDirectional {
    public static final PropertyBool EXTENDED = PropertyBool.create("extended");
    protected static final AxisAlignedBB PISTON_BASE_EAST_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.75, 1.0, 1.0);
    protected static final AxisAlignedBB PISTON_BASE_WEST_AABB = new AxisAlignedBB(0.25, 0.0, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB PISTON_BASE_SOUTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.75);
    protected static final AxisAlignedBB PISTON_BASE_NORTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.25, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB PISTON_BASE_UP_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.75, 1.0);
    protected static final AxisAlignedBB PISTON_BASE_DOWN_AABB = new AxisAlignedBB(0.0, 0.25, 0.0, 1.0, 1.0, 1.0);
    private final boolean isSticky;

    public BlockPistonBase(boolean p_i45443_1_) {
        super(Material.PISTON);
        this.setDefaultState(this.blockState.getBaseState().withProperty(FACING, EnumFacing.NORTH).withProperty(EXTENDED, false));
        this.isSticky = p_i45443_1_;
        this.setSoundType(SoundType.STONE);
        this.setHardness(0.5f);
        this.setCreativeTab(CreativeTabs.REDSTONE);
    }

    @Override
    public boolean causesSuffocation(IBlockState p_causesSuffocation_1_) {
        return p_causesSuffocation_1_.getValue(EXTENDED) == false;
    }

    @Override
    public AxisAlignedBB getBoundingBox(IBlockState p_getBoundingBox_1_, IBlockAccess p_getBoundingBox_2_, BlockPos p_getBoundingBox_3_) {
        if (p_getBoundingBox_1_.getValue(EXTENDED).booleanValue()) {
            switch (p_getBoundingBox_1_.getValue(FACING)) {
                case DOWN: {
                    return PISTON_BASE_DOWN_AABB;
                }
                default: {
                    return PISTON_BASE_UP_AABB;
                }
                case NORTH: {
                    return PISTON_BASE_NORTH_AABB;
                }
                case SOUTH: {
                    return PISTON_BASE_SOUTH_AABB;
                }
                case WEST: {
                    return PISTON_BASE_WEST_AABB;
                }
                case EAST: 
            }
            return PISTON_BASE_EAST_AABB;
        }
        return FULL_BLOCK_AABB;
    }

    @Override
    public boolean isFullyOpaque(IBlockState p_isFullyOpaque_1_) {
        return p_isFullyOpaque_1_.getValue(EXTENDED) == false || p_isFullyOpaque_1_.getValue(FACING) == EnumFacing.DOWN;
    }

    @Override
    public void addCollisionBoxToList(IBlockState p_addCollisionBoxToList_1_, World p_addCollisionBoxToList_2_, BlockPos p_addCollisionBoxToList_3_, AxisAlignedBB p_addCollisionBoxToList_4_, List<AxisAlignedBB> p_addCollisionBoxToList_5_, Entity p_addCollisionBoxToList_6_, boolean p_addCollisionBoxToList_7_) {
        BlockPistonBase.addCollisionBoxToList(p_addCollisionBoxToList_3_, p_addCollisionBoxToList_4_, p_addCollisionBoxToList_5_, p_addCollisionBoxToList_1_.getBoundingBox(p_addCollisionBoxToList_2_, p_addCollisionBoxToList_3_));
    }

    @Override
    public boolean isOpaqueCube(IBlockState p_isOpaqueCube_1_) {
        return false;
    }

    @Override
    public void onBlockPlacedBy(World p_onBlockPlacedBy_1_, BlockPos p_onBlockPlacedBy_2_, IBlockState p_onBlockPlacedBy_3_, EntityLivingBase p_onBlockPlacedBy_4_, ItemStack p_onBlockPlacedBy_5_) {
        p_onBlockPlacedBy_1_.setBlockState(p_onBlockPlacedBy_2_, p_onBlockPlacedBy_3_.withProperty(FACING, EnumFacing.getDirectionFromEntityLiving(p_onBlockPlacedBy_2_, p_onBlockPlacedBy_4_)), 2);
        if (!p_onBlockPlacedBy_1_.isRemote) {
            this.checkForMove(p_onBlockPlacedBy_1_, p_onBlockPlacedBy_2_, p_onBlockPlacedBy_3_);
        }
    }

    @Override
    public void neighborChanged(IBlockState p_neighborChanged_1_, World p_neighborChanged_2_, BlockPos p_neighborChanged_3_, Block p_neighborChanged_4_, BlockPos p_neighborChanged_5_) {
        if (!p_neighborChanged_2_.isRemote) {
            this.checkForMove(p_neighborChanged_2_, p_neighborChanged_3_, p_neighborChanged_1_);
        }
    }

    @Override
    public void onBlockAdded(World p_onBlockAdded_1_, BlockPos p_onBlockAdded_2_, IBlockState p_onBlockAdded_3_) {
        if (!p_onBlockAdded_1_.isRemote && p_onBlockAdded_1_.getTileEntity(p_onBlockAdded_2_) == null) {
            this.checkForMove(p_onBlockAdded_1_, p_onBlockAdded_2_, p_onBlockAdded_3_);
        }
    }

    @Override
    public IBlockState getStateForPlacement(World p_getStateForPlacement_1_, BlockPos p_getStateForPlacement_2_, EnumFacing p_getStateForPlacement_3_, float p_getStateForPlacement_4_, float p_getStateForPlacement_5_, float p_getStateForPlacement_6_, int p_getStateForPlacement_7_, EntityLivingBase p_getStateForPlacement_8_) {
        return this.getDefaultState().withProperty(FACING, EnumFacing.getDirectionFromEntityLiving(p_getStateForPlacement_2_, p_getStateForPlacement_8_)).withProperty(EXTENDED, false);
    }

    private void checkForMove(World p_checkForMove_1_, BlockPos p_checkForMove_2_, IBlockState p_checkForMove_3_) {
        EnumFacing enumfacing = p_checkForMove_3_.getValue(FACING);
        boolean flag = this.shouldBeExtended(p_checkForMove_1_, p_checkForMove_2_, enumfacing);
        if (flag && !p_checkForMove_3_.getValue(EXTENDED).booleanValue()) {
            if (new BlockPistonStructureHelper(p_checkForMove_1_, p_checkForMove_2_, enumfacing, true).canMove()) {
                p_checkForMove_1_.addBlockEvent(p_checkForMove_2_, this, 0, enumfacing.getIndex());
            }
        } else if (!flag && p_checkForMove_3_.getValue(EXTENDED).booleanValue()) {
            p_checkForMove_1_.addBlockEvent(p_checkForMove_2_, this, 1, enumfacing.getIndex());
        }
    }

    private boolean shouldBeExtended(World p_shouldBeExtended_1_, BlockPos p_shouldBeExtended_2_, EnumFacing p_shouldBeExtended_3_) {
        for (EnumFacing enumfacing : EnumFacing.values()) {
            if (enumfacing == p_shouldBeExtended_3_ || !p_shouldBeExtended_1_.isSidePowered(p_shouldBeExtended_2_.offset(enumfacing), enumfacing)) continue;
            return true;
        }
        if (p_shouldBeExtended_1_.isSidePowered(p_shouldBeExtended_2_, EnumFacing.DOWN)) {
            return true;
        }
        BlockPos blockpos = p_shouldBeExtended_2_.up();
        for (EnumFacing enumfacing1 : EnumFacing.values()) {
            if (enumfacing1 == EnumFacing.DOWN || !p_shouldBeExtended_1_.isSidePowered(blockpos.offset(enumfacing1), enumfacing1)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean eventReceived(IBlockState p_eventReceived_1_, World p_eventReceived_2_, BlockPos p_eventReceived_3_, int p_eventReceived_4_, int p_eventReceived_5_) {
        EnumFacing enumfacing = p_eventReceived_1_.getValue(FACING);
        if (!p_eventReceived_2_.isRemote) {
            boolean flag = this.shouldBeExtended(p_eventReceived_2_, p_eventReceived_3_, enumfacing);
            if (flag && p_eventReceived_4_ == 1) {
                p_eventReceived_2_.setBlockState(p_eventReceived_3_, p_eventReceived_1_.withProperty(EXTENDED, true), 2);
                return false;
            }
            if (!flag && p_eventReceived_4_ == 0) {
                return false;
            }
        }
        if (p_eventReceived_4_ == 0) {
            if (!this.doMove(p_eventReceived_2_, p_eventReceived_3_, enumfacing, true)) {
                return false;
            }
            p_eventReceived_2_.setBlockState(p_eventReceived_3_, p_eventReceived_1_.withProperty(EXTENDED, true), 3);
            p_eventReceived_2_.playSound(null, p_eventReceived_3_, SoundEvents.BLOCK_PISTON_EXTEND, SoundCategory.BLOCKS, 0.5f, p_eventReceived_2_.rand.nextFloat() * 0.25f + 0.6f);
        } else if (p_eventReceived_4_ == 1) {
            TileEntity tileentity1 = p_eventReceived_2_.getTileEntity(p_eventReceived_3_.offset(enumfacing));
            if (tileentity1 instanceof TileEntityPiston) {
                ((TileEntityPiston)tileentity1).clearPistonTileEntity();
            }
            p_eventReceived_2_.setBlockState(p_eventReceived_3_, Blocks.PISTON_EXTENSION.getDefaultState().withProperty(BlockPistonMoving.FACING, enumfacing).withProperty(BlockPistonMoving.TYPE, this.isSticky ? BlockPistonExtension.EnumPistonType.STICKY : BlockPistonExtension.EnumPistonType.DEFAULT), 3);
            p_eventReceived_2_.setTileEntity(p_eventReceived_3_, BlockPistonMoving.createTilePiston(this.getStateFromMeta(p_eventReceived_5_), enumfacing, false, true));
            if (this.isSticky) {
                TileEntityPiston tileentitypiston;
                TileEntity tileentity;
                BlockPos blockpos = p_eventReceived_3_.add(enumfacing.getFrontOffsetX() * 2, enumfacing.getFrontOffsetY() * 2, enumfacing.getFrontOffsetZ() * 2);
                IBlockState iblockstate = p_eventReceived_2_.getBlockState(blockpos);
                Block block = iblockstate.getBlock();
                boolean flag1 = false;
                if (block == Blocks.PISTON_EXTENSION && (tileentity = p_eventReceived_2_.getTileEntity(blockpos)) instanceof TileEntityPiston && (tileentitypiston = (TileEntityPiston)tileentity).getFacing() == enumfacing && tileentitypiston.isExtending()) {
                    tileentitypiston.clearPistonTileEntity();
                    flag1 = true;
                }
                if (!(flag1 || iblockstate.getBlock().isAir(iblockstate, p_eventReceived_2_, p_eventReceived_3_) || !BlockPistonBase.canPush(iblockstate, p_eventReceived_2_, blockpos, enumfacing.getOpposite(), false) || iblockstate.getMobilityFlag() != EnumPushReaction.NORMAL && block != Blocks.PISTON && block != Blocks.STICKY_PISTON)) {
                    this.doMove(p_eventReceived_2_, p_eventReceived_3_, enumfacing, false);
                }
            } else {
                p_eventReceived_2_.setBlockToAir(p_eventReceived_3_.offset(enumfacing));
            }
            p_eventReceived_2_.playSound(null, p_eventReceived_3_, SoundEvents.BLOCK_PISTON_CONTRACT, SoundCategory.BLOCKS, 0.5f, p_eventReceived_2_.rand.nextFloat() * 0.15f + 0.6f);
        }
        return true;
    }

    @Override
    public boolean isFullCube(IBlockState p_isFullCube_1_) {
        return false;
    }

    @Nullable
    public static EnumFacing getFacing(int p_getFacing_0_) {
        int i = p_getFacing_0_ & 7;
        return i > 5 ? null : EnumFacing.getFront(i);
    }

    public static boolean canPush(IBlockState p_canPush_0_, World p_canPush_1_, BlockPos p_canPush_2_, EnumFacing p_canPush_3_, boolean p_canPush_4_) {
        Block block = p_canPush_0_.getBlock();
        if (block == Blocks.OBSIDIAN) {
            return false;
        }
        if (!p_canPush_1_.getWorldBorder().contains(p_canPush_2_)) {
            return false;
        }
        if (p_canPush_2_.getY() >= 0 && (p_canPush_3_ != EnumFacing.DOWN || p_canPush_2_.getY() != 0)) {
            if (p_canPush_2_.getY() <= p_canPush_1_.getHeight() - 1 && (p_canPush_3_ != EnumFacing.UP || p_canPush_2_.getY() != p_canPush_1_.getHeight() - 1)) {
                if (block != Blocks.PISTON && block != Blocks.STICKY_PISTON) {
                    if (p_canPush_0_.getBlockHardness(p_canPush_1_, p_canPush_2_) == -1.0f) {
                        return false;
                    }
                    if (p_canPush_0_.getMobilityFlag() == EnumPushReaction.BLOCK) {
                        return false;
                    }
                    if (p_canPush_0_.getMobilityFlag() == EnumPushReaction.DESTROY) {
                        return p_canPush_4_;
                    }
                } else if (p_canPush_0_.getValue(EXTENDED).booleanValue()) {
                    return false;
                }
                return !block.hasTileEntity(p_canPush_0_);
            }
            return false;
        }
        return false;
    }

    private boolean doMove(World p_doMove_1_, BlockPos p_doMove_2_, EnumFacing p_doMove_3_, boolean p_doMove_4_) {
        BlockPistonStructureHelper blockpistonstructurehelper;
        if (!p_doMove_4_) {
            p_doMove_1_.setBlockToAir(p_doMove_2_.offset(p_doMove_3_));
        }
        if (!(blockpistonstructurehelper = new BlockPistonStructureHelper(p_doMove_1_, p_doMove_2_, p_doMove_3_, p_doMove_4_)).canMove()) {
            return false;
        }
        List<BlockPos> list = blockpistonstructurehelper.getBlocksToMove();
        ArrayList list1 = Lists.newArrayList();
        for (int i = 0; i < list.size(); ++i) {
            BlockPos blockpos = list.get(i);
            list1.add(p_doMove_1_.getBlockState(blockpos).getActualState(p_doMove_1_, blockpos));
        }
        List<BlockPos> list2 = blockpistonstructurehelper.getBlocksToDestroy();
        int k = list.size() + list2.size();
        IBlockState[] aiblockstate = new IBlockState[k];
        EnumFacing enumfacing = p_doMove_4_ ? p_doMove_3_ : p_doMove_3_.getOpposite();
        for (int j = list2.size() - 1; j >= 0; --j) {
            BlockPos blockpos1 = list2.get(j);
            IBlockState iblockstate = p_doMove_1_.getBlockState(blockpos1);
            float chance = iblockstate.getBlock() instanceof BlockSnow ? -1.0f : 1.0f;
            iblockstate.getBlock().dropBlockAsItemWithChance(p_doMove_1_, blockpos1, iblockstate, chance, 0);
            p_doMove_1_.setBlockState(blockpos1, Blocks.AIR.getDefaultState(), 4);
            aiblockstate[--k] = iblockstate;
        }
        for (int l = list.size() - 1; l >= 0; --l) {
            BlockPos blockpos3 = list.get(l);
            IBlockState iblockstate2 = p_doMove_1_.getBlockState(blockpos3);
            p_doMove_1_.setBlockState(blockpos3, Blocks.AIR.getDefaultState(), 2);
            blockpos3 = blockpos3.offset(enumfacing);
            p_doMove_1_.setBlockState(blockpos3, Blocks.PISTON_EXTENSION.getDefaultState().withProperty(FACING, p_doMove_3_), 4);
            p_doMove_1_.setTileEntity(blockpos3, BlockPistonMoving.createTilePiston((IBlockState)list1.get(l), p_doMove_3_, p_doMove_4_, false));
            aiblockstate[--k] = iblockstate2;
        }
        BlockPos blockpos2 = p_doMove_2_.offset(p_doMove_3_);
        if (p_doMove_4_) {
            BlockPistonExtension.EnumPistonType blockpistonextension$enumpistontype = this.isSticky ? BlockPistonExtension.EnumPistonType.STICKY : BlockPistonExtension.EnumPistonType.DEFAULT;
            IBlockState iblockstate3 = Blocks.PISTON_HEAD.getDefaultState().withProperty(BlockPistonExtension.FACING, p_doMove_3_).withProperty(BlockPistonExtension.TYPE, blockpistonextension$enumpistontype);
            IBlockState iblockstate1 = Blocks.PISTON_EXTENSION.getDefaultState().withProperty(BlockPistonMoving.FACING, p_doMove_3_).withProperty(BlockPistonMoving.TYPE, this.isSticky ? BlockPistonExtension.EnumPistonType.STICKY : BlockPistonExtension.EnumPistonType.DEFAULT);
            p_doMove_1_.setBlockState(blockpos2, iblockstate1, 4);
            p_doMove_1_.setTileEntity(blockpos2, BlockPistonMoving.createTilePiston(iblockstate3, p_doMove_3_, true, true));
        }
        for (int i1 = list2.size() - 1; i1 >= 0; --i1) {
            p_doMove_1_.notifyNeighborsOfStateChange(list2.get(i1), aiblockstate[k++].getBlock(), false);
        }
        for (int j1 = list.size() - 1; j1 >= 0; --j1) {
            p_doMove_1_.notifyNeighborsOfStateChange(list.get(j1), aiblockstate[k++].getBlock(), false);
        }
        if (p_doMove_4_) {
            p_doMove_1_.notifyNeighborsOfStateChange(blockpos2, Blocks.PISTON_HEAD, false);
        }
        return true;
    }

    @Override
    public IBlockState getStateFromMeta(int p_getStateFromMeta_1_) {
        return this.getDefaultState().withProperty(FACING, BlockPistonBase.getFacing(p_getStateFromMeta_1_)).withProperty(EXTENDED, (p_getStateFromMeta_1_ & 8) > 0);
    }

    @Override
    public int getMetaFromState(IBlockState p_getMetaFromState_1_) {
        int i = 0;
        i |= p_getMetaFromState_1_.getValue(FACING).getIndex();
        if (p_getMetaFromState_1_.getValue(EXTENDED).booleanValue()) {
            i |= 8;
        }
        return i;
    }

    @Override
    public IBlockState withRotation(IBlockState p_withRotation_1_, Rotation p_withRotation_2_) {
        return p_withRotation_1_.withProperty(FACING, p_withRotation_2_.rotate(p_withRotation_1_.getValue(FACING)));
    }

    @Override
    public IBlockState withMirror(IBlockState p_withMirror_1_, Mirror p_withMirror_2_) {
        return p_withMirror_1_.withRotation(p_withMirror_2_.toRotation(p_withMirror_1_.getValue(FACING)));
    }

    @Override
    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, FACING, EXTENDED);
    }
}

