/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockPistonExtension
extends BlockDirectional {
    public static final PropertyEnum<EnumPistonType> TYPE = PropertyEnum.create("type", EnumPistonType.class);
    public static final PropertyBool SHORT = PropertyBool.create("short");
    protected static final AxisAlignedBB PISTON_EXTENSION_EAST_AABB = new AxisAlignedBB(0.75, 0.0, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB PISTON_EXTENSION_WEST_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.25, 1.0, 1.0);
    protected static final AxisAlignedBB PISTON_EXTENSION_SOUTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.75, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB PISTON_EXTENSION_NORTH_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.25);
    protected static final AxisAlignedBB PISTON_EXTENSION_UP_AABB = new AxisAlignedBB(0.0, 0.75, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB PISTON_EXTENSION_DOWN_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.25, 1.0);
    protected static final AxisAlignedBB UP_ARM_AABB = new AxisAlignedBB(0.375, -0.25, 0.375, 0.625, 0.75, 0.625);
    protected static final AxisAlignedBB DOWN_ARM_AABB = new AxisAlignedBB(0.375, 0.25, 0.375, 0.625, 1.25, 0.625);
    protected static final AxisAlignedBB SOUTH_ARM_AABB = new AxisAlignedBB(0.375, 0.375, -0.25, 0.625, 0.625, 0.75);
    protected static final AxisAlignedBB NORTH_ARM_AABB = new AxisAlignedBB(0.375, 0.375, 0.25, 0.625, 0.625, 1.25);
    protected static final AxisAlignedBB EAST_ARM_AABB = new AxisAlignedBB(-0.25, 0.375, 0.375, 0.75, 0.625, 0.625);
    protected static final AxisAlignedBB WEST_ARM_AABB = new AxisAlignedBB(0.25, 0.375, 0.375, 1.25, 0.625, 0.625);
    protected static final AxisAlignedBB SHORT_UP_ARM_AABB = new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 0.75, 0.625);
    protected static final AxisAlignedBB SHORT_DOWN_ARM_AABB = new AxisAlignedBB(0.375, 0.25, 0.375, 0.625, 1.0, 0.625);
    protected static final AxisAlignedBB SHORT_SOUTH_ARM_AABB = new AxisAlignedBB(0.375, 0.375, 0.0, 0.625, 0.625, 0.75);
    protected static final AxisAlignedBB SHORT_NORTH_ARM_AABB = new AxisAlignedBB(0.375, 0.375, 0.25, 0.625, 0.625, 1.0);
    protected static final AxisAlignedBB SHORT_EAST_ARM_AABB = new AxisAlignedBB(0.0, 0.375, 0.375, 0.75, 0.625, 0.625);
    protected static final AxisAlignedBB SHORT_WEST_ARM_AABB = new AxisAlignedBB(0.25, 0.375, 0.375, 1.0, 0.625, 0.625);

    public BlockPistonExtension() {
        super(Material.PISTON);
        this.setDefaultState(this.blockState.getBaseState().withProperty(FACING, EnumFacing.NORTH).withProperty(TYPE, EnumPistonType.DEFAULT).withProperty(SHORT, false));
        this.setSoundType(SoundType.STONE);
        this.setHardness(0.5f);
    }

    @Override
    public AxisAlignedBB getBoundingBox(IBlockState p_getBoundingBox_1_, IBlockAccess p_getBoundingBox_2_, BlockPos p_getBoundingBox_3_) {
        switch (p_getBoundingBox_1_.getValue(FACING)) {
            default: {
                return PISTON_EXTENSION_DOWN_AABB;
            }
            case UP: {
                return PISTON_EXTENSION_UP_AABB;
            }
            case NORTH: {
                return PISTON_EXTENSION_NORTH_AABB;
            }
            case SOUTH: {
                return PISTON_EXTENSION_SOUTH_AABB;
            }
            case WEST: {
                return PISTON_EXTENSION_WEST_AABB;
            }
            case EAST: 
        }
        return PISTON_EXTENSION_EAST_AABB;
    }

    @Override
    public void addCollisionBoxToList(IBlockState p_addCollisionBoxToList_1_, World p_addCollisionBoxToList_2_, BlockPos p_addCollisionBoxToList_3_, AxisAlignedBB p_addCollisionBoxToList_4_, List<AxisAlignedBB> p_addCollisionBoxToList_5_, Entity p_addCollisionBoxToList_6_, boolean p_addCollisionBoxToList_7_) {
        BlockPistonExtension.addCollisionBoxToList(p_addCollisionBoxToList_3_, p_addCollisionBoxToList_4_, p_addCollisionBoxToList_5_, p_addCollisionBoxToList_1_.getBoundingBox(p_addCollisionBoxToList_2_, p_addCollisionBoxToList_3_));
        BlockPistonExtension.addCollisionBoxToList(p_addCollisionBoxToList_3_, p_addCollisionBoxToList_4_, p_addCollisionBoxToList_5_, this.getArmShape(p_addCollisionBoxToList_1_));
    }

    private AxisAlignedBB getArmShape(IBlockState p_getArmShape_1_) {
        boolean lvt_2_1_ = p_getArmShape_1_.getValue(SHORT);
        switch (p_getArmShape_1_.getValue(FACING)) {
            default: {
                return lvt_2_1_ ? SHORT_DOWN_ARM_AABB : DOWN_ARM_AABB;
            }
            case UP: {
                return lvt_2_1_ ? SHORT_UP_ARM_AABB : UP_ARM_AABB;
            }
            case NORTH: {
                return lvt_2_1_ ? SHORT_NORTH_ARM_AABB : NORTH_ARM_AABB;
            }
            case SOUTH: {
                return lvt_2_1_ ? SHORT_SOUTH_ARM_AABB : SOUTH_ARM_AABB;
            }
            case WEST: {
                return lvt_2_1_ ? SHORT_WEST_ARM_AABB : WEST_ARM_AABB;
            }
            case EAST: 
        }
        return lvt_2_1_ ? SHORT_EAST_ARM_AABB : EAST_ARM_AABB;
    }

    @Override
    public boolean isFullyOpaque(IBlockState p_isFullyOpaque_1_) {
        return p_isFullyOpaque_1_.getValue(FACING) == EnumFacing.UP;
    }

    @Override
    public void onBlockHarvested(World p_onBlockHarvested_1_, BlockPos p_onBlockHarvested_2_, IBlockState p_onBlockHarvested_3_, EntityPlayer p_onBlockHarvested_4_) {
        BlockPos lvt_5_1_;
        Block lvt_6_1_;
        if (p_onBlockHarvested_4_.capabilities.isCreativeMode && ((lvt_6_1_ = p_onBlockHarvested_1_.getBlockState(lvt_5_1_ = p_onBlockHarvested_2_.offset(p_onBlockHarvested_3_.getValue(FACING).getOpposite())).getBlock()) == Blocks.PISTON || lvt_6_1_ == Blocks.STICKY_PISTON)) {
            p_onBlockHarvested_1_.setBlockToAir(lvt_5_1_);
        }
        super.onBlockHarvested(p_onBlockHarvested_1_, p_onBlockHarvested_2_, p_onBlockHarvested_3_, p_onBlockHarvested_4_);
    }

    @Override
    public void breakBlock(World p_breakBlock_1_, BlockPos p_breakBlock_2_, IBlockState p_breakBlock_3_) {
        super.breakBlock(p_breakBlock_1_, p_breakBlock_2_, p_breakBlock_3_);
        EnumFacing lvt_4_1_ = p_breakBlock_3_.getValue(FACING).getOpposite();
        p_breakBlock_2_ = p_breakBlock_2_.offset(lvt_4_1_);
        IBlockState lvt_5_1_ = p_breakBlock_1_.getBlockState(p_breakBlock_2_);
        if ((lvt_5_1_.getBlock() == Blocks.PISTON || lvt_5_1_.getBlock() == Blocks.STICKY_PISTON) && lvt_5_1_.getValue(BlockPistonBase.EXTENDED).booleanValue()) {
            lvt_5_1_.getBlock().dropBlockAsItem(p_breakBlock_1_, p_breakBlock_2_, lvt_5_1_, 0);
            p_breakBlock_1_.setBlockToAir(p_breakBlock_2_);
        }
    }

    @Override
    public boolean isOpaqueCube(IBlockState p_isOpaqueCube_1_) {
        return false;
    }

    @Override
    public boolean isFullCube(IBlockState p_isFullCube_1_) {
        return false;
    }

    @Override
    public boolean canPlaceBlockAt(World p_canPlaceBlockAt_1_, BlockPos p_canPlaceBlockAt_2_) {
        return false;
    }

    @Override
    public boolean canPlaceBlockOnSide(World p_canPlaceBlockOnSide_1_, BlockPos p_canPlaceBlockOnSide_2_, EnumFacing p_canPlaceBlockOnSide_3_) {
        return false;
    }

    @Override
    public int quantityDropped(Random p_quantityDropped_1_) {
        return 0;
    }

    @Override
    public void neighborChanged(IBlockState p_neighborChanged_1_, World p_neighborChanged_2_, BlockPos p_neighborChanged_3_, Block p_neighborChanged_4_, BlockPos p_neighborChanged_5_) {
        EnumFacing lvt_6_1_ = p_neighborChanged_1_.getValue(FACING);
        BlockPos lvt_7_1_ = p_neighborChanged_3_.offset(lvt_6_1_.getOpposite());
        IBlockState lvt_8_1_ = p_neighborChanged_2_.getBlockState(lvt_7_1_);
        if (lvt_8_1_.getBlock() == Blocks.PISTON || lvt_8_1_.getBlock() == Blocks.STICKY_PISTON) {
            lvt_8_1_.neighborChanged(p_neighborChanged_2_, lvt_7_1_, p_neighborChanged_4_, p_neighborChanged_5_);
        } else {
            p_neighborChanged_2_.setBlockToAir(p_neighborChanged_3_);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(IBlockState p_shouldSideBeRendered_1_, IBlockAccess p_shouldSideBeRendered_2_, BlockPos p_shouldSideBeRendered_3_, EnumFacing p_shouldSideBeRendered_4_) {
        return true;
    }

    @Nullable
    public static EnumFacing getFacing(int p_getFacing_0_) {
        int lvt_1_1_ = p_getFacing_0_ & 7;
        if (lvt_1_1_ > 5) {
            return null;
        }
        return EnumFacing.getFront(lvt_1_1_);
    }

    @Override
    public ItemStack getItem(World p_getItem_1_, BlockPos p_getItem_2_, IBlockState p_getItem_3_) {
        return new ItemStack(p_getItem_3_.getValue(TYPE) == EnumPistonType.STICKY ? Blocks.STICKY_PISTON : Blocks.PISTON);
    }

    @Override
    public IBlockState getStateFromMeta(int p_getStateFromMeta_1_) {
        return this.getDefaultState().withProperty(FACING, BlockPistonExtension.getFacing(p_getStateFromMeta_1_)).withProperty(TYPE, (p_getStateFromMeta_1_ & 8) > 0 ? EnumPistonType.STICKY : EnumPistonType.DEFAULT);
    }

    @Override
    public int getMetaFromState(IBlockState p_getMetaFromState_1_) {
        int lvt_2_1_ = 0;
        lvt_2_1_ |= p_getMetaFromState_1_.getValue(FACING).getIndex();
        if (p_getMetaFromState_1_.getValue(TYPE) == EnumPistonType.STICKY) {
            lvt_2_1_ |= 8;
        }
        return lvt_2_1_;
    }

    @Override
    public IBlockState withRotation(IBlockState p_withRotation_1_, Rotation p_withRotation_2_) {
        return p_withRotation_1_.withProperty(FACING, p_withRotation_2_.rotate(p_withRotation_1_.getValue(FACING)));
    }

    @Override
    public IBlockState withMirror(IBlockState p_withMirror_1_, Mirror p_withMirror_2_) {
        return p_withMirror_1_.withRotation(p_withMirror_2_.toRotation(p_withMirror_1_.getValue(FACING)));
    }

    @Override
    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, FACING, TYPE, SHORT);
    }

    public static enum EnumPistonType implements IStringSerializable
    {
        DEFAULT("normal"),
        STICKY("sticky");

        private final String VARIANT;

        private EnumPistonType(String p_i45666_3_) {
            this.VARIANT = p_i45666_3_;
        }

        public String toString() {
            return this.VARIANT;
        }

        @Override
        public String getName() {
            return this.VARIANT;
        }
    }
}

