/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.BlockPistonExtension;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityPiston;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockPistonMoving
extends BlockContainer {
    public static final PropertyDirection FACING = BlockPistonExtension.FACING;
    public static final PropertyEnum<BlockPistonExtension.EnumPistonType> TYPE = BlockPistonExtension.TYPE;

    public BlockPistonMoving() {
        super(Material.PISTON);
        this.setDefaultState(this.blockState.getBaseState().withProperty(FACING, EnumFacing.NORTH).withProperty(TYPE, BlockPistonExtension.EnumPistonType.DEFAULT));
        this.setHardness(-1.0f);
    }

    @Override
    @Nullable
    public TileEntity createNewTileEntity(World p_createNewTileEntity_1_, int p_createNewTileEntity_2_) {
        return null;
    }

    public static TileEntity createTilePiston(IBlockState p_createTilePiston_0_, EnumFacing p_createTilePiston_1_, boolean p_createTilePiston_2_, boolean p_createTilePiston_3_) {
        return new TileEntityPiston(p_createTilePiston_0_, p_createTilePiston_1_, p_createTilePiston_2_, p_createTilePiston_3_);
    }

    @Override
    public void breakBlock(World p_breakBlock_1_, BlockPos p_breakBlock_2_, IBlockState p_breakBlock_3_) {
        TileEntity tileentity = p_breakBlock_1_.getTileEntity(p_breakBlock_2_);
        if (tileentity instanceof TileEntityPiston) {
            ((TileEntityPiston)tileentity).clearPistonTileEntity();
        } else {
            super.breakBlock(p_breakBlock_1_, p_breakBlock_2_, p_breakBlock_3_);
        }
    }

    @Override
    public boolean canPlaceBlockAt(World p_canPlaceBlockAt_1_, BlockPos p_canPlaceBlockAt_2_) {
        return false;
    }

    @Override
    public boolean canPlaceBlockOnSide(World p_canPlaceBlockOnSide_1_, BlockPos p_canPlaceBlockOnSide_2_, EnumFacing p_canPlaceBlockOnSide_3_) {
        return false;
    }

    @Override
    public void onBlockDestroyedByPlayer(World p_onBlockDestroyedByPlayer_1_, BlockPos p_onBlockDestroyedByPlayer_2_, IBlockState p_onBlockDestroyedByPlayer_3_) {
        BlockPos blockpos = p_onBlockDestroyedByPlayer_2_.offset(p_onBlockDestroyedByPlayer_3_.getValue(FACING).getOpposite());
        IBlockState iblockstate = p_onBlockDestroyedByPlayer_1_.getBlockState(blockpos);
        if (iblockstate.getBlock() instanceof BlockPistonBase && iblockstate.getValue(BlockPistonBase.EXTENDED).booleanValue()) {
            p_onBlockDestroyedByPlayer_1_.setBlockToAir(blockpos);
        }
    }

    @Override
    public boolean isOpaqueCube(IBlockState p_isOpaqueCube_1_) {
        return false;
    }

    @Override
    public boolean isFullCube(IBlockState p_isFullCube_1_) {
        return false;
    }

    @Override
    public boolean onBlockActivated(World p_onBlockActivated_1_, BlockPos p_onBlockActivated_2_, IBlockState p_onBlockActivated_3_, EntityPlayer p_onBlockActivated_4_, EnumHand p_onBlockActivated_5_, EnumFacing p_onBlockActivated_6_, float p_onBlockActivated_7_, float p_onBlockActivated_8_, float p_onBlockActivated_9_) {
        if (!p_onBlockActivated_1_.isRemote && p_onBlockActivated_1_.getTileEntity(p_onBlockActivated_2_) == null) {
            p_onBlockActivated_1_.setBlockToAir(p_onBlockActivated_2_);
            return true;
        }
        return false;
    }

    @Override
    public Item getItemDropped(IBlockState p_getItemDropped_1_, Random p_getItemDropped_2_, int p_getItemDropped_3_) {
        return Items.AIR;
    }

    @Override
    public void dropBlockAsItemWithChance(World p_dropBlockAsItemWithChance_1_, BlockPos p_dropBlockAsItemWithChance_2_, IBlockState p_dropBlockAsItemWithChance_3_, float p_dropBlockAsItemWithChance_4_, int p_dropBlockAsItemWithChance_5_) {
        super.dropBlockAsItemWithChance(p_dropBlockAsItemWithChance_1_, p_dropBlockAsItemWithChance_2_, p_dropBlockAsItemWithChance_3_, 1.0f, p_dropBlockAsItemWithChance_5_);
    }

    @Override
    @Nullable
    public RayTraceResult collisionRayTrace(IBlockState p_collisionRayTrace_1_, World p_collisionRayTrace_2_, BlockPos p_collisionRayTrace_3_, Vec3d p_collisionRayTrace_4_, Vec3d p_collisionRayTrace_5_) {
        return null;
    }

    @Override
    public void neighborChanged(IBlockState p_neighborChanged_1_, World p_neighborChanged_2_, BlockPos p_neighborChanged_3_, Block p_neighborChanged_4_, BlockPos p_neighborChanged_5_) {
        if (!p_neighborChanged_2_.isRemote) {
            p_neighborChanged_2_.getTileEntity(p_neighborChanged_3_);
        }
    }

    @Override
    @Nullable
    public AxisAlignedBB getCollisionBoundingBox(IBlockState p_getCollisionBoundingBox_1_, IBlockAccess p_getCollisionBoundingBox_2_, BlockPos p_getCollisionBoundingBox_3_) {
        TileEntityPiston tileentitypiston = this.getTilePistonAt(p_getCollisionBoundingBox_2_, p_getCollisionBoundingBox_3_);
        return tileentitypiston == null ? null : tileentitypiston.getAABB(p_getCollisionBoundingBox_2_, p_getCollisionBoundingBox_3_);
    }

    @Override
    public void addCollisionBoxToList(IBlockState p_addCollisionBoxToList_1_, World p_addCollisionBoxToList_2_, BlockPos p_addCollisionBoxToList_3_, AxisAlignedBB p_addCollisionBoxToList_4_, List<AxisAlignedBB> p_addCollisionBoxToList_5_, Entity p_addCollisionBoxToList_6_, boolean p_addCollisionBoxToList_7_) {
        TileEntityPiston tileentitypiston = this.getTilePistonAt(p_addCollisionBoxToList_2_, p_addCollisionBoxToList_3_);
        if (tileentitypiston != null) {
            tileentitypiston.addCollissionAABBs(p_addCollisionBoxToList_2_, p_addCollisionBoxToList_3_, p_addCollisionBoxToList_4_, p_addCollisionBoxToList_5_, p_addCollisionBoxToList_6_);
        }
    }

    @Override
    public AxisAlignedBB getBoundingBox(IBlockState p_getBoundingBox_1_, IBlockAccess p_getBoundingBox_2_, BlockPos p_getBoundingBox_3_) {
        TileEntityPiston tileentitypiston = this.getTilePistonAt(p_getBoundingBox_2_, p_getBoundingBox_3_);
        return tileentitypiston != null ? tileentitypiston.getAABB(p_getBoundingBox_2_, p_getBoundingBox_3_) : FULL_BLOCK_AABB;
    }

    @Nullable
    private TileEntityPiston getTilePistonAt(IBlockAccess p_getTilePistonAt_1_, BlockPos p_getTilePistonAt_2_) {
        TileEntity tileentity = p_getTilePistonAt_1_.getTileEntity(p_getTilePistonAt_2_);
        return tileentity instanceof TileEntityPiston ? (TileEntityPiston)tileentity : null;
    }

    @Override
    public ItemStack getItem(World p_getItem_1_, BlockPos p_getItem_2_, IBlockState p_getItem_3_) {
        return ItemStack.EMPTY;
    }

    @Override
    public IBlockState getStateFromMeta(int p_getStateFromMeta_1_) {
        return this.getDefaultState().withProperty(FACING, BlockPistonExtension.getFacing(p_getStateFromMeta_1_)).withProperty(TYPE, (p_getStateFromMeta_1_ & 8) > 0 ? BlockPistonExtension.EnumPistonType.STICKY : BlockPistonExtension.EnumPistonType.DEFAULT);
    }

    @Override
    public IBlockState withRotation(IBlockState p_withRotation_1_, Rotation p_withRotation_2_) {
        return p_withRotation_1_.withProperty(FACING, p_withRotation_2_.rotate(p_withRotation_1_.getValue(FACING)));
    }

    @Override
    public IBlockState withMirror(IBlockState p_withMirror_1_, Mirror p_withMirror_2_) {
        return p_withMirror_1_.withRotation(p_withMirror_2_.toRotation(p_withMirror_1_.getValue(FACING)));
    }

    @Override
    public int getMetaFromState(IBlockState p_getMetaFromState_1_) {
        int i = 0;
        i |= p_getMetaFromState_1_.getValue(FACING).getIndex();
        if (p_getMetaFromState_1_.getValue(TYPE) == BlockPistonExtension.EnumPistonType.STICKY) {
            i |= 8;
        }
        return i;
    }

    @Override
    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, FACING, TYPE);
    }

    @Override
    public List<ItemStack> getDrops(IBlockAccess p_getDrops_1_, BlockPos p_getDrops_2_, IBlockState p_getDrops_3_, int p_getDrops_4_) {
        TileEntityPiston tileentitypiston = this.getTilePistonAt(p_getDrops_1_, p_getDrops_2_);
        if (tileentitypiston != null) {
            IBlockState pushed = tileentitypiston.getPistonState();
            return pushed.getBlock().getDrops(p_getDrops_1_, p_getDrops_2_, pushed, p_getDrops_4_);
        }
        return new ArrayList<ItemStack>();
    }
}

