/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import com.google.common.cache.LoadingCache;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBreakable;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.BlockWorldState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockPattern;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemMonsterPlacer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockPortal
extends BlockBreakable {
    public static final PropertyEnum<EnumFacing.Axis> AXIS = PropertyEnum.create((String)"axis", EnumFacing.Axis.class, (Enum[])new EnumFacing.Axis[]{EnumFacing.Axis.X, EnumFacing.Axis.Z});
    protected static final AxisAlignedBB X_AABB = new AxisAlignedBB(0.0, 0.0, 0.375, 1.0, 1.0, 0.625);
    protected static final AxisAlignedBB Z_AABB = new AxisAlignedBB(0.375, 0.0, 0.0, 0.625, 1.0, 1.0);
    protected static final AxisAlignedBB Y_AABB = new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 1.0, 0.625);

    public BlockPortal() {
        super(Material.PORTAL, false);
        this.setDefaultState(this.blockState.getBaseState().withProperty(AXIS, EnumFacing.Axis.X));
        this.setTickRandomly(true);
    }

    @Override
    public AxisAlignedBB getBoundingBox(IBlockState p_getBoundingBox_1_, IBlockAccess p_getBoundingBox_2_, BlockPos p_getBoundingBox_3_) {
        switch (p_getBoundingBox_1_.getValue(AXIS)) {
            case X: {
                return X_AABB;
            }
            default: {
                return Y_AABB;
            }
            case Z: 
        }
        return Z_AABB;
    }

    @Override
    public void updateTick(World p_updateTick_1_, BlockPos p_updateTick_2_, IBlockState p_updateTick_3_, Random p_updateTick_4_) {
        super.updateTick(p_updateTick_1_, p_updateTick_2_, p_updateTick_3_, p_updateTick_4_);
        if (p_updateTick_1_.provider.isSurfaceWorld() && p_updateTick_1_.getGameRules().getBoolean("doMobSpawning") && p_updateTick_4_.nextInt(2000) < p_updateTick_1_.getDifficulty().getDifficultyId()) {
            Entity lvt_7_1_;
            int lvt_5_1_ = p_updateTick_2_.getY();
            BlockPos lvt_6_1_ = p_updateTick_2_;
            while (!p_updateTick_1_.getBlockState(lvt_6_1_).isFullyOpaque() && lvt_6_1_.getY() > 0) {
                lvt_6_1_ = lvt_6_1_.down();
            }
            if (lvt_5_1_ > 0 && !p_updateTick_1_.getBlockState(lvt_6_1_.up()).isNormalCube() && (lvt_7_1_ = ItemMonsterPlacer.spawnCreature(p_updateTick_1_, EntityList.getKey(EntityPigZombie.class), (double)lvt_6_1_.getX() + 0.5, (double)lvt_6_1_.getY() + 1.1, (double)lvt_6_1_.getZ() + 0.5)) != null) {
                lvt_7_1_.timeUntilPortal = lvt_7_1_.getPortalCooldown();
            }
        }
    }

    @Override
    @Nullable
    public AxisAlignedBB getCollisionBoundingBox(IBlockState p_getCollisionBoundingBox_1_, IBlockAccess p_getCollisionBoundingBox_2_, BlockPos p_getCollisionBoundingBox_3_) {
        return NULL_AABB;
    }

    public static int getMetaForAxis(EnumFacing.Axis p_getMetaForAxis_0_) {
        if (p_getMetaForAxis_0_ == EnumFacing.Axis.X) {
            return 1;
        }
        if (p_getMetaForAxis_0_ == EnumFacing.Axis.Z) {
            return 2;
        }
        return 0;
    }

    @Override
    public boolean isFullCube(IBlockState p_isFullCube_1_) {
        return false;
    }

    public boolean trySpawnPortal(World p_trySpawnPortal_1_, BlockPos p_trySpawnPortal_2_) {
        Size lvt_3_1_ = new Size(p_trySpawnPortal_1_, p_trySpawnPortal_2_, EnumFacing.Axis.X);
        if (lvt_3_1_.isValid() && lvt_3_1_.portalBlockCount == 0) {
            lvt_3_1_.placePortalBlocks();
            return true;
        }
        Size lvt_4_1_ = new Size(p_trySpawnPortal_1_, p_trySpawnPortal_2_, EnumFacing.Axis.Z);
        if (lvt_4_1_.isValid() && lvt_4_1_.portalBlockCount == 0) {
            lvt_4_1_.placePortalBlocks();
            return true;
        }
        return false;
    }

    @Override
    public void neighborChanged(IBlockState p_neighborChanged_1_, World p_neighborChanged_2_, BlockPos p_neighborChanged_3_, Block p_neighborChanged_4_, BlockPos p_neighborChanged_5_) {
        Size lvt_7_2_;
        EnumFacing.Axis lvt_6_1_ = p_neighborChanged_1_.getValue(AXIS);
        if (lvt_6_1_ == EnumFacing.Axis.X) {
            Size lvt_7_1_ = new Size(p_neighborChanged_2_, p_neighborChanged_3_, EnumFacing.Axis.X);
            if (!lvt_7_1_.isValid() || lvt_7_1_.portalBlockCount < lvt_7_1_.width * lvt_7_1_.height) {
                p_neighborChanged_2_.setBlockState(p_neighborChanged_3_, Blocks.AIR.getDefaultState());
            }
        } else if (!(lvt_6_1_ != EnumFacing.Axis.Z || (lvt_7_2_ = new Size(p_neighborChanged_2_, p_neighborChanged_3_, EnumFacing.Axis.Z)).isValid() && lvt_7_2_.portalBlockCount >= lvt_7_2_.width * lvt_7_2_.height)) {
            p_neighborChanged_2_.setBlockState(p_neighborChanged_3_, Blocks.AIR.getDefaultState());
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldSideBeRendered(IBlockState p_shouldSideBeRendered_1_, IBlockAccess p_shouldSideBeRendered_2_, BlockPos p_shouldSideBeRendered_3_, EnumFacing p_shouldSideBeRendered_4_) {
        boolean lvt_11_1_;
        p_shouldSideBeRendered_3_ = p_shouldSideBeRendered_3_.offset(p_shouldSideBeRendered_4_);
        EnumFacing.Axis lvt_5_1_ = null;
        if (p_shouldSideBeRendered_1_.getBlock() == this) {
            lvt_5_1_ = p_shouldSideBeRendered_1_.getValue(AXIS);
            if (lvt_5_1_ == null) {
                return false;
            }
            if (lvt_5_1_ == EnumFacing.Axis.Z && p_shouldSideBeRendered_4_ != EnumFacing.EAST && p_shouldSideBeRendered_4_ != EnumFacing.WEST) {
                return false;
            }
            if (lvt_5_1_ == EnumFacing.Axis.X && p_shouldSideBeRendered_4_ != EnumFacing.SOUTH && p_shouldSideBeRendered_4_ != EnumFacing.NORTH) {
                return false;
            }
        }
        boolean lvt_6_1_ = p_shouldSideBeRendered_2_.getBlockState(p_shouldSideBeRendered_3_.west()).getBlock() == this && p_shouldSideBeRendered_2_.getBlockState(p_shouldSideBeRendered_3_.west(2)).getBlock() != this;
        boolean lvt_7_1_ = p_shouldSideBeRendered_2_.getBlockState(p_shouldSideBeRendered_3_.east()).getBlock() == this && p_shouldSideBeRendered_2_.getBlockState(p_shouldSideBeRendered_3_.east(2)).getBlock() != this;
        boolean lvt_8_1_ = p_shouldSideBeRendered_2_.getBlockState(p_shouldSideBeRendered_3_.north()).getBlock() == this && p_shouldSideBeRendered_2_.getBlockState(p_shouldSideBeRendered_3_.north(2)).getBlock() != this;
        boolean lvt_9_1_ = p_shouldSideBeRendered_2_.getBlockState(p_shouldSideBeRendered_3_.south()).getBlock() == this && p_shouldSideBeRendered_2_.getBlockState(p_shouldSideBeRendered_3_.south(2)).getBlock() != this;
        boolean lvt_10_1_ = lvt_6_1_ || lvt_7_1_ || lvt_5_1_ == EnumFacing.Axis.X;
        boolean bl = lvt_11_1_ = lvt_8_1_ || lvt_9_1_ || lvt_5_1_ == EnumFacing.Axis.Z;
        if (lvt_10_1_ && p_shouldSideBeRendered_4_ == EnumFacing.WEST) {
            return true;
        }
        if (lvt_10_1_ && p_shouldSideBeRendered_4_ == EnumFacing.EAST) {
            return true;
        }
        if (lvt_11_1_ && p_shouldSideBeRendered_4_ == EnumFacing.NORTH) {
            return true;
        }
        return lvt_11_1_ && p_shouldSideBeRendered_4_ == EnumFacing.SOUTH;
    }

    @Override
    public int quantityDropped(Random p_quantityDropped_1_) {
        return 0;
    }

    @Override
    public void onEntityCollidedWithBlock(World p_onEntityCollidedWithBlock_1_, BlockPos p_onEntityCollidedWithBlock_2_, IBlockState p_onEntityCollidedWithBlock_3_, Entity p_onEntityCollidedWithBlock_4_) {
        if (!p_onEntityCollidedWithBlock_4_.isRiding() && !p_onEntityCollidedWithBlock_4_.isBeingRidden() && p_onEntityCollidedWithBlock_4_.isNonBoss()) {
            p_onEntityCollidedWithBlock_4_.setPortal(p_onEntityCollidedWithBlock_2_);
        }
    }

    @Override
    public ItemStack getItem(World p_getItem_1_, BlockPos p_getItem_2_, IBlockState p_getItem_3_) {
        return ItemStack.EMPTY;
    }

    @Override
    public IBlockState getStateFromMeta(int p_getStateFromMeta_1_) {
        return this.getDefaultState().withProperty(AXIS, (p_getStateFromMeta_1_ & 3) == 2 ? EnumFacing.Axis.Z : EnumFacing.Axis.X);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer getBlockLayer() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick(IBlockState p_randomDisplayTick_1_, World p_randomDisplayTick_2_, BlockPos p_randomDisplayTick_3_, Random p_randomDisplayTick_4_) {
        if (p_randomDisplayTick_4_.nextInt(100) == 0) {
            p_randomDisplayTick_2_.playSound((double)p_randomDisplayTick_3_.getX() + 0.5, (double)p_randomDisplayTick_3_.getY() + 0.5, (double)p_randomDisplayTick_3_.getZ() + 0.5, SoundEvents.BLOCK_PORTAL_AMBIENT, SoundCategory.BLOCKS, 0.5f, p_randomDisplayTick_4_.nextFloat() * 0.4f + 0.8f, false);
        }
        for (int lvt_5_1_ = 0; lvt_5_1_ < 4; ++lvt_5_1_) {
            double lvt_6_1_ = (float)p_randomDisplayTick_3_.getX() + p_randomDisplayTick_4_.nextFloat();
            double lvt_8_1_ = (float)p_randomDisplayTick_3_.getY() + p_randomDisplayTick_4_.nextFloat();
            double lvt_10_1_ = (float)p_randomDisplayTick_3_.getZ() + p_randomDisplayTick_4_.nextFloat();
            double lvt_12_1_ = ((double)p_randomDisplayTick_4_.nextFloat() - 0.5) * 0.5;
            double lvt_14_1_ = ((double)p_randomDisplayTick_4_.nextFloat() - 0.5) * 0.5;
            double lvt_16_1_ = ((double)p_randomDisplayTick_4_.nextFloat() - 0.5) * 0.5;
            int lvt_18_1_ = p_randomDisplayTick_4_.nextInt(2) * 2 - 1;
            if (p_randomDisplayTick_2_.getBlockState(p_randomDisplayTick_3_.west()).getBlock() == this || p_randomDisplayTick_2_.getBlockState(p_randomDisplayTick_3_.east()).getBlock() == this) {
                lvt_10_1_ = (double)p_randomDisplayTick_3_.getZ() + 0.5 + 0.25 * (double)lvt_18_1_;
                lvt_16_1_ = p_randomDisplayTick_4_.nextFloat() * 2.0f * (float)lvt_18_1_;
            } else {
                lvt_6_1_ = (double)p_randomDisplayTick_3_.getX() + 0.5 + 0.25 * (double)lvt_18_1_;
                lvt_12_1_ = p_randomDisplayTick_4_.nextFloat() * 2.0f * (float)lvt_18_1_;
            }
            p_randomDisplayTick_2_.spawnParticle(EnumParticleTypes.PORTAL, lvt_6_1_, lvt_8_1_, lvt_10_1_, lvt_12_1_, lvt_14_1_, lvt_16_1_, new int[0]);
        }
    }

    @Override
    public int getMetaFromState(IBlockState p_getMetaFromState_1_) {
        return BlockPortal.getMetaForAxis(p_getMetaFromState_1_.getValue(AXIS));
    }

    @Override
    public IBlockState withRotation(IBlockState p_withRotation_1_, Rotation p_withRotation_2_) {
        switch (p_withRotation_2_) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                switch (p_withRotation_1_.getValue(AXIS)) {
                    case X: {
                        return p_withRotation_1_.withProperty(AXIS, EnumFacing.Axis.Z);
                    }
                    case Z: {
                        return p_withRotation_1_.withProperty(AXIS, EnumFacing.Axis.X);
                    }
                }
                return p_withRotation_1_;
            }
        }
        return p_withRotation_1_;
    }

    @Override
    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, AXIS);
    }

    public BlockPattern.PatternHelper createPatternHelper(World p_createPatternHelper_1_, BlockPos p_createPatternHelper_2_) {
        EnumFacing.Axis lvt_3_1_ = EnumFacing.Axis.Z;
        Size lvt_4_1_ = new Size(p_createPatternHelper_1_, p_createPatternHelper_2_, EnumFacing.Axis.X);
        LoadingCache<BlockPos, BlockWorldState> lvt_5_1_ = BlockPattern.createLoadingCache(p_createPatternHelper_1_, true);
        if (!lvt_4_1_.isValid()) {
            lvt_3_1_ = EnumFacing.Axis.X;
            lvt_4_1_ = new Size(p_createPatternHelper_1_, p_createPatternHelper_2_, EnumFacing.Axis.Z);
        }
        if (!lvt_4_1_.isValid()) {
            return new BlockPattern.PatternHelper(p_createPatternHelper_2_, EnumFacing.NORTH, EnumFacing.UP, lvt_5_1_, 1, 1, 1);
        }
        int[] lvt_6_1_ = new int[EnumFacing.AxisDirection.values().length];
        EnumFacing lvt_7_1_ = lvt_4_1_.rightDir.rotateYCCW();
        BlockPos lvt_8_1_ = lvt_4_1_.bottomLeft.up(lvt_4_1_.getHeight() - 1);
        for (EnumFacing.AxisDirection lvt_12_1_ : EnumFacing.AxisDirection.values()) {
            BlockPattern.PatternHelper lvt_13_1_ = new BlockPattern.PatternHelper(lvt_7_1_.getAxisDirection() == lvt_12_1_ ? lvt_8_1_ : lvt_8_1_.offset(lvt_4_1_.rightDir, lvt_4_1_.getWidth() - 1), EnumFacing.getFacingFromAxis(lvt_12_1_, lvt_3_1_), EnumFacing.UP, lvt_5_1_, lvt_4_1_.getWidth(), lvt_4_1_.getHeight(), 1);
            for (int lvt_14_1_ = 0; lvt_14_1_ < lvt_4_1_.getWidth(); ++lvt_14_1_) {
                for (int lvt_15_1_ = 0; lvt_15_1_ < lvt_4_1_.getHeight(); ++lvt_15_1_) {
                    BlockWorldState lvt_16_1_ = lvt_13_1_.translateOffset(lvt_14_1_, lvt_15_1_, 1);
                    if (lvt_16_1_.getBlockState() == null || lvt_16_1_.getBlockState().getMaterial() == Material.AIR) continue;
                    int n = lvt_12_1_.ordinal();
                    lvt_6_1_[n] = lvt_6_1_[n] + 1;
                }
            }
        }
        EnumFacing.AxisDirection lvt_9_1_ = EnumFacing.AxisDirection.POSITIVE;
        for (EnumFacing.AxisDirection lvt_13_2_ : EnumFacing.AxisDirection.values()) {
            if (lvt_6_1_[lvt_13_2_.ordinal()] >= lvt_6_1_[lvt_9_1_.ordinal()]) continue;
            lvt_9_1_ = lvt_13_2_;
        }
        return new BlockPattern.PatternHelper(lvt_7_1_.getAxisDirection() == lvt_9_1_ ? lvt_8_1_ : lvt_8_1_.offset(lvt_4_1_.rightDir, lvt_4_1_.getWidth() - 1), EnumFacing.getFacingFromAxis(lvt_9_1_, lvt_3_1_), EnumFacing.UP, lvt_5_1_, lvt_4_1_.getWidth(), lvt_4_1_.getHeight(), 1);
    }

    public static class Size {
        private final World world;
        private final EnumFacing.Axis axis;
        private final EnumFacing rightDir;
        private final EnumFacing leftDir;
        private int portalBlockCount;
        private BlockPos bottomLeft;
        private int height;
        private int width;

        public Size(World p_i45694_1_, BlockPos p_i45694_2_, EnumFacing.Axis p_i45694_3_) {
            this.world = p_i45694_1_;
            this.axis = p_i45694_3_;
            if (p_i45694_3_ == EnumFacing.Axis.X) {
                this.leftDir = EnumFacing.EAST;
                this.rightDir = EnumFacing.WEST;
            } else {
                this.leftDir = EnumFacing.NORTH;
                this.rightDir = EnumFacing.SOUTH;
            }
            BlockPos lvt_4_1_ = p_i45694_2_;
            while (p_i45694_2_.getY() > lvt_4_1_.getY() - 21 && p_i45694_2_.getY() > 0 && this.isEmptyBlock(p_i45694_1_.getBlockState(p_i45694_2_.down()).getBlock())) {
                p_i45694_2_ = p_i45694_2_.down();
            }
            int lvt_5_1_ = this.getDistanceUntilEdge(p_i45694_2_, this.leftDir) - 1;
            if (lvt_5_1_ >= 0) {
                this.bottomLeft = p_i45694_2_.offset(this.leftDir, lvt_5_1_);
                this.width = this.getDistanceUntilEdge(this.bottomLeft, this.rightDir);
                if (this.width < 2 || this.width > 21) {
                    this.bottomLeft = null;
                    this.width = 0;
                }
            }
            if (this.bottomLeft != null) {
                this.height = this.calculatePortalHeight();
            }
        }

        protected int getDistanceUntilEdge(BlockPos p_getDistanceUntilEdge_1_, EnumFacing p_getDistanceUntilEdge_2_) {
            BlockPos lvt_4_1_;
            int lvt_3_1_;
            for (lvt_3_1_ = 0; lvt_3_1_ < 22 && this.isEmptyBlock(this.world.getBlockState(lvt_4_1_ = p_getDistanceUntilEdge_1_.offset(p_getDistanceUntilEdge_2_, lvt_3_1_)).getBlock()) && this.world.getBlockState(lvt_4_1_.down()).getBlock() == Blocks.OBSIDIAN; ++lvt_3_1_) {
            }
            Block lvt_4_2_ = this.world.getBlockState(p_getDistanceUntilEdge_1_.offset(p_getDistanceUntilEdge_2_, lvt_3_1_)).getBlock();
            if (lvt_4_2_ == Blocks.OBSIDIAN) {
                return lvt_3_1_;
            }
            return 0;
        }

        public int getHeight() {
            return this.height;
        }

        public int getWidth() {
            return this.width;
        }

        protected int calculatePortalHeight() {
            this.height = 0;
            block0: while (this.height < 21) {
                for (int lvt_1_1_ = 0; lvt_1_1_ < this.width; ++lvt_1_1_) {
                    BlockPos lvt_2_1_ = this.bottomLeft.offset(this.rightDir, lvt_1_1_).up(this.height);
                    Block lvt_3_1_ = this.world.getBlockState(lvt_2_1_).getBlock();
                    if (!this.isEmptyBlock(lvt_3_1_)) break block0;
                    if (lvt_3_1_ == Blocks.PORTAL) {
                        ++this.portalBlockCount;
                    }
                    if (lvt_1_1_ == 0 ? (lvt_3_1_ = this.world.getBlockState(lvt_2_1_.offset(this.leftDir)).getBlock()) != Blocks.OBSIDIAN : lvt_1_1_ == this.width - 1 && (lvt_3_1_ = this.world.getBlockState(lvt_2_1_.offset(this.rightDir)).getBlock()) != Blocks.OBSIDIAN) break block0;
                }
                ++this.height;
            }
            for (int lvt_1_2_ = 0; lvt_1_2_ < this.width; ++lvt_1_2_) {
                if (this.world.getBlockState(this.bottomLeft.offset(this.rightDir, lvt_1_2_).up(this.height)).getBlock() == Blocks.OBSIDIAN) continue;
                this.height = 0;
                break;
            }
            if (this.height > 21 || this.height < 3) {
                this.bottomLeft = null;
                this.width = 0;
                this.height = 0;
                return 0;
            }
            return this.height;
        }

        protected boolean isEmptyBlock(Block p_isEmptyBlock_1_) {
            return p_isEmptyBlock_1_.blockMaterial == Material.AIR || p_isEmptyBlock_1_ == Blocks.FIRE || p_isEmptyBlock_1_ == Blocks.PORTAL;
        }

        public boolean isValid() {
            return this.bottomLeft != null && this.width >= 2 && this.width <= 21 && this.height >= 3 && this.height <= 21;
        }

        public void placePortalBlocks() {
            for (int lvt_1_1_ = 0; lvt_1_1_ < this.width; ++lvt_1_1_) {
                BlockPos lvt_2_1_ = this.bottomLeft.offset(this.rightDir, lvt_1_1_);
                for (int lvt_3_1_ = 0; lvt_3_1_ < this.height; ++lvt_3_1_) {
                    this.world.setBlockState(lvt_2_1_.up(lvt_3_1_), Blocks.PORTAL.getDefaultState().withProperty(AXIS, this.axis), 2);
                }
            }
        }
    }
}

