/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBasePressurePlate;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockPressurePlate
extends BlockBasePressurePlate {
    public static final PropertyBool POWERED = PropertyBool.create("powered");
    private final Sensitivity sensitivity;

    protected BlockPressurePlate(Material p_i45693_1_, Sensitivity p_i45693_2_) {
        super(p_i45693_1_);
        this.setDefaultState(this.blockState.getBaseState().withProperty(POWERED, false));
        this.sensitivity = p_i45693_2_;
    }

    @Override
    protected int getRedstoneStrength(IBlockState p_getRedstoneStrength_1_) {
        return p_getRedstoneStrength_1_.getValue(POWERED) != false ? 15 : 0;
    }

    @Override
    protected IBlockState setRedstoneStrength(IBlockState p_setRedstoneStrength_1_, int p_setRedstoneStrength_2_) {
        return p_setRedstoneStrength_1_.withProperty(POWERED, p_setRedstoneStrength_2_ > 0);
    }

    @Override
    protected void playClickOnSound(World p_playClickOnSound_1_, BlockPos p_playClickOnSound_2_) {
        if (this.blockMaterial == Material.WOOD) {
            p_playClickOnSound_1_.playSound(null, p_playClickOnSound_2_, SoundEvents.BLOCK_WOOD_PRESSPLATE_CLICK_ON, SoundCategory.BLOCKS, 0.3f, 0.8f);
        } else {
            p_playClickOnSound_1_.playSound(null, p_playClickOnSound_2_, SoundEvents.BLOCK_STONE_PRESSPLATE_CLICK_ON, SoundCategory.BLOCKS, 0.3f, 0.6f);
        }
    }

    @Override
    protected void playClickOffSound(World p_playClickOffSound_1_, BlockPos p_playClickOffSound_2_) {
        if (this.blockMaterial == Material.WOOD) {
            p_playClickOffSound_1_.playSound(null, p_playClickOffSound_2_, SoundEvents.BLOCK_WOOD_PRESSPLATE_CLICK_OFF, SoundCategory.BLOCKS, 0.3f, 0.7f);
        } else {
            p_playClickOffSound_1_.playSound(null, p_playClickOffSound_2_, SoundEvents.BLOCK_STONE_PRESSPLATE_CLICK_OFF, SoundCategory.BLOCKS, 0.3f, 0.5f);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected int computeRedstoneStrength(World p_computeRedstoneStrength_1_, BlockPos p_computeRedstoneStrength_2_) {
        void lvt_4_3_;
        AxisAlignedBB lvt_3_1_ = PRESSURE_AABB.offset(p_computeRedstoneStrength_2_);
        switch (this.sensitivity) {
            case EVERYTHING: {
                List<Entity> lvt_4_1_ = p_computeRedstoneStrength_1_.getEntitiesWithinAABBExcludingEntity(null, lvt_3_1_);
                break;
            }
            case MOBS: {
                List<EntityLivingBase> lvt_4_2_ = p_computeRedstoneStrength_1_.getEntitiesWithinAABB(EntityLivingBase.class, lvt_3_1_);
                break;
            }
            default: {
                return 0;
            }
        }
        if (!lvt_4_3_.isEmpty()) {
            for (Entity lvt_6_1_ : lvt_4_3_) {
                if (lvt_6_1_.doesEntityNotTriggerPressurePlate()) continue;
                return 15;
            }
        }
        return 0;
    }

    @Override
    public IBlockState getStateFromMeta(int p_getStateFromMeta_1_) {
        return this.getDefaultState().withProperty(POWERED, p_getStateFromMeta_1_ == 1);
    }

    @Override
    public int getMetaFromState(IBlockState p_getMetaFromState_1_) {
        return p_getMetaFromState_1_.getValue(POWERED) != false ? 1 : 0;
    }

    @Override
    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, POWERED);
    }

    public static enum Sensitivity {
        EVERYTHING,
        MOBS;

    }
}

