/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import net.minecraft.block.Block;
import net.minecraft.block.BlockBasePressurePlate;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class BlockPressurePlateWeighted
extends BlockBasePressurePlate {
    public static final PropertyInteger POWER = PropertyInteger.create("power", 0, 15);
    private final int maxWeight;

    protected BlockPressurePlateWeighted(Material p_i46379_1_, int p_i46379_2_) {
        this(p_i46379_1_, p_i46379_2_, p_i46379_1_.getMaterialMapColor());
    }

    protected BlockPressurePlateWeighted(Material p_i46380_1_, int p_i46380_2_, MapColor p_i46380_3_) {
        super(p_i46380_1_, p_i46380_3_);
        this.setDefaultState(this.blockState.getBaseState().withProperty(POWER, 0));
        this.maxWeight = p_i46380_2_;
    }

    @Override
    protected int computeRedstoneStrength(World p_computeRedstoneStrength_1_, BlockPos p_computeRedstoneStrength_2_) {
        int lvt_3_1_ = Math.min(p_computeRedstoneStrength_1_.getEntitiesWithinAABB(Entity.class, PRESSURE_AABB.offset(p_computeRedstoneStrength_2_)).size(), this.maxWeight);
        if (lvt_3_1_ > 0) {
            float lvt_4_1_ = (float)Math.min(this.maxWeight, lvt_3_1_) / (float)this.maxWeight;
            return MathHelper.ceil(lvt_4_1_ * 15.0f);
        }
        return 0;
    }

    @Override
    protected void playClickOnSound(World p_playClickOnSound_1_, BlockPos p_playClickOnSound_2_) {
        p_playClickOnSound_1_.playSound(null, p_playClickOnSound_2_, SoundEvents.BLOCK_METAL_PRESSPLATE_CLICK_ON, SoundCategory.BLOCKS, 0.3f, 0.90000004f);
    }

    @Override
    protected void playClickOffSound(World p_playClickOffSound_1_, BlockPos p_playClickOffSound_2_) {
        p_playClickOffSound_1_.playSound(null, p_playClickOffSound_2_, SoundEvents.BLOCK_METAL_PRESSPLATE_CLICK_OFF, SoundCategory.BLOCKS, 0.3f, 0.75f);
    }

    @Override
    protected int getRedstoneStrength(IBlockState p_getRedstoneStrength_1_) {
        return p_getRedstoneStrength_1_.getValue(POWER);
    }

    @Override
    protected IBlockState setRedstoneStrength(IBlockState p_setRedstoneStrength_1_, int p_setRedstoneStrength_2_) {
        return p_setRedstoneStrength_1_.withProperty(POWER, p_setRedstoneStrength_2_);
    }

    @Override
    public int tickRate(World p_tickRate_1_) {
        return 10;
    }

    @Override
    public IBlockState getStateFromMeta(int p_getStateFromMeta_1_) {
        return this.getDefaultState().withProperty(POWER, p_getStateFromMeta_1_);
    }

    @Override
    public int getMetaFromState(IBlockState p_getMetaFromState_1_) {
        return p_getMetaFromState_1_.getValue(POWER);
    }

    @Override
    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, POWER);
    }
}

