/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import net.minecraft.block.Block;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockRail
extends BlockRailBase {
    public static final PropertyEnum<BlockRailBase.EnumRailDirection> SHAPE = PropertyEnum.create("shape", BlockRailBase.EnumRailDirection.class);

    protected BlockRail() {
        super(false);
        this.setDefaultState(this.blockState.getBaseState().withProperty(SHAPE, BlockRailBase.EnumRailDirection.NORTH_SOUTH));
    }

    @Override
    protected void updateState(IBlockState p_updateState_1_, World p_updateState_2_, BlockPos p_updateState_3_, Block p_updateState_4_) {
        if (p_updateState_4_.getDefaultState().canProvidePower() && new BlockRailBase.Rail(p_updateState_2_, p_updateState_3_, p_updateState_1_).countAdjacentRails() == 3) {
            this.updateDir(p_updateState_2_, p_updateState_3_, p_updateState_1_, false);
        }
    }

    @Override
    public IProperty<BlockRailBase.EnumRailDirection> getShapeProperty() {
        return SHAPE;
    }

    @Override
    public IBlockState getStateFromMeta(int p_getStateFromMeta_1_) {
        return this.getDefaultState().withProperty(SHAPE, BlockRailBase.EnumRailDirection.byMetadata(p_getStateFromMeta_1_));
    }

    @Override
    public int getMetaFromState(IBlockState p_getMetaFromState_1_) {
        return p_getMetaFromState_1_.getValue(SHAPE).getMetadata();
    }

    @Override
    public IBlockState withRotation(IBlockState p_withRotation_1_, Rotation p_withRotation_2_) {
        switch (p_withRotation_2_) {
            case CLOCKWISE_180: {
                switch (p_withRotation_1_.getValue(SHAPE)) {
                    case ASCENDING_EAST: {
                        return p_withRotation_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.ASCENDING_WEST);
                    }
                    case ASCENDING_WEST: {
                        return p_withRotation_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.ASCENDING_EAST);
                    }
                    case ASCENDING_NORTH: {
                        return p_withRotation_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.ASCENDING_SOUTH);
                    }
                    case ASCENDING_SOUTH: {
                        return p_withRotation_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.ASCENDING_NORTH);
                    }
                    case SOUTH_EAST: {
                        return p_withRotation_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.NORTH_WEST);
                    }
                    case SOUTH_WEST: {
                        return p_withRotation_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.NORTH_EAST);
                    }
                    case NORTH_WEST: {
                        return p_withRotation_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.SOUTH_EAST);
                    }
                    case NORTH_EAST: {
                        return p_withRotation_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.SOUTH_WEST);
                    }
                }
            }
            case COUNTERCLOCKWISE_90: {
                switch (p_withRotation_1_.getValue(SHAPE)) {
                    case NORTH_SOUTH: {
                        return p_withRotation_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.EAST_WEST);
                    }
                    case EAST_WEST: {
                        return p_withRotation_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.NORTH_SOUTH);
                    }
                    case ASCENDING_EAST: {
                        return p_withRotation_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.ASCENDING_NORTH);
                    }
                    case ASCENDING_WEST: {
                        return p_withRotation_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.ASCENDING_SOUTH);
                    }
                    case ASCENDING_NORTH: {
                        return p_withRotation_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.ASCENDING_WEST);
                    }
                    case ASCENDING_SOUTH: {
                        return p_withRotation_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.ASCENDING_EAST);
                    }
                    case SOUTH_EAST: {
                        return p_withRotation_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.NORTH_EAST);
                    }
                    case SOUTH_WEST: {
                        return p_withRotation_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.SOUTH_EAST);
                    }
                    case NORTH_WEST: {
                        return p_withRotation_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.SOUTH_WEST);
                    }
                    case NORTH_EAST: {
                        return p_withRotation_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.NORTH_WEST);
                    }
                }
            }
            case CLOCKWISE_90: {
                switch (p_withRotation_1_.getValue(SHAPE)) {
                    case NORTH_SOUTH: {
                        return p_withRotation_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.EAST_WEST);
                    }
                    case EAST_WEST: {
                        return p_withRotation_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.NORTH_SOUTH);
                    }
                    case ASCENDING_EAST: {
                        return p_withRotation_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.ASCENDING_SOUTH);
                    }
                    case ASCENDING_WEST: {
                        return p_withRotation_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.ASCENDING_NORTH);
                    }
                    case ASCENDING_NORTH: {
                        return p_withRotation_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.ASCENDING_EAST);
                    }
                    case ASCENDING_SOUTH: {
                        return p_withRotation_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.ASCENDING_WEST);
                    }
                    case SOUTH_EAST: {
                        return p_withRotation_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.SOUTH_WEST);
                    }
                    case SOUTH_WEST: {
                        return p_withRotation_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.NORTH_WEST);
                    }
                    case NORTH_WEST: {
                        return p_withRotation_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.NORTH_EAST);
                    }
                    case NORTH_EAST: {
                        return p_withRotation_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.SOUTH_EAST);
                    }
                }
            }
        }
        return p_withRotation_1_;
    }

    @Override
    public IBlockState withMirror(IBlockState p_withMirror_1_, Mirror p_withMirror_2_) {
        BlockRailBase.EnumRailDirection lvt_3_1_ = p_withMirror_1_.getValue(SHAPE);
        switch (p_withMirror_2_) {
            case LEFT_RIGHT: {
                switch (lvt_3_1_) {
                    case ASCENDING_NORTH: {
                        return p_withMirror_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.ASCENDING_SOUTH);
                    }
                    case ASCENDING_SOUTH: {
                        return p_withMirror_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.ASCENDING_NORTH);
                    }
                    case SOUTH_EAST: {
                        return p_withMirror_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.NORTH_EAST);
                    }
                    case SOUTH_WEST: {
                        return p_withMirror_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.NORTH_WEST);
                    }
                    case NORTH_WEST: {
                        return p_withMirror_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.SOUTH_WEST);
                    }
                    case NORTH_EAST: {
                        return p_withMirror_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.SOUTH_EAST);
                    }
                }
                break;
            }
            case FRONT_BACK: {
                switch (lvt_3_1_) {
                    case ASCENDING_EAST: {
                        return p_withMirror_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.ASCENDING_WEST);
                    }
                    case ASCENDING_WEST: {
                        return p_withMirror_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.ASCENDING_EAST);
                    }
                    case SOUTH_EAST: {
                        return p_withMirror_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.SOUTH_WEST);
                    }
                    case SOUTH_WEST: {
                        return p_withMirror_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.SOUTH_EAST);
                    }
                    case NORTH_WEST: {
                        return p_withMirror_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.NORTH_EAST);
                    }
                    case NORTH_EAST: {
                        return p_withMirror_1_.withProperty(SHAPE, BlockRailBase.EnumRailDirection.NORTH_WEST);
                    }
                }
                break;
            }
        }
        return super.withMirror(p_withMirror_1_, p_withMirror_2_);
    }

    @Override
    protected BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)this, SHAPE);
    }
}

