/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockRailBase
extends Block {
    protected static final AxisAlignedBB FLAT_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0);
    protected static final AxisAlignedBB ASCENDING_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
    protected final boolean isPowered;

    public static boolean isRailBlock(World p_isRailBlock_0_, BlockPos p_isRailBlock_1_) {
        return BlockRailBase.isRailBlock(p_isRailBlock_0_.getBlockState(p_isRailBlock_1_));
    }

    public static boolean isRailBlock(IBlockState p_isRailBlock_0_) {
        Block block = p_isRailBlock_0_.getBlock();
        return block instanceof BlockRailBase;
    }

    protected BlockRailBase(boolean p_i45389_1_) {
        super(Material.CIRCUITS);
        this.isPowered = p_i45389_1_;
        this.setCreativeTab(CreativeTabs.TRANSPORTATION);
    }

    @Override
    @Nullable
    public AxisAlignedBB getCollisionBoundingBox(IBlockState p_getCollisionBoundingBox_1_, IBlockAccess p_getCollisionBoundingBox_2_, BlockPos p_getCollisionBoundingBox_3_) {
        return NULL_AABB;
    }

    @Override
    public boolean isOpaqueCube(IBlockState p_isOpaqueCube_1_) {
        return false;
    }

    @Override
    public AxisAlignedBB getBoundingBox(IBlockState p_getBoundingBox_1_, IBlockAccess p_getBoundingBox_2_, BlockPos p_getBoundingBox_3_) {
        EnumRailDirection blockrailbase$enumraildirection = p_getBoundingBox_1_.getBlock() == this ? this.getRailDirection(p_getBoundingBox_2_, p_getBoundingBox_3_, p_getBoundingBox_1_, null) : null;
        return blockrailbase$enumraildirection != null && blockrailbase$enumraildirection.isAscending() ? ASCENDING_AABB : FLAT_AABB;
    }

    @Override
    public boolean isFullCube(IBlockState p_isFullCube_1_) {
        return false;
    }

    @Override
    public boolean canPlaceBlockAt(World p_canPlaceBlockAt_1_, BlockPos p_canPlaceBlockAt_2_) {
        return p_canPlaceBlockAt_1_.getBlockState(p_canPlaceBlockAt_2_.down()).isSideSolid(p_canPlaceBlockAt_1_, p_canPlaceBlockAt_2_.down(), EnumFacing.UP);
    }

    @Override
    public void onBlockAdded(World p_onBlockAdded_1_, BlockPos p_onBlockAdded_2_, IBlockState p_onBlockAdded_3_) {
        if (!p_onBlockAdded_1_.isRemote) {
            p_onBlockAdded_3_ = this.updateDir(p_onBlockAdded_1_, p_onBlockAdded_2_, p_onBlockAdded_3_, true);
            if (this.isPowered) {
                p_onBlockAdded_3_.neighborChanged(p_onBlockAdded_1_, p_onBlockAdded_2_, this, p_onBlockAdded_2_);
            }
        }
    }

    @Override
    public void neighborChanged(IBlockState p_neighborChanged_1_, World p_neighborChanged_2_, BlockPos p_neighborChanged_3_, Block p_neighborChanged_4_, BlockPos p_neighborChanged_5_) {
        if (!p_neighborChanged_2_.isRemote) {
            EnumRailDirection blockrailbase$enumraildirection = this.getRailDirection(p_neighborChanged_2_, p_neighborChanged_3_, p_neighborChanged_2_.getBlockState(p_neighborChanged_3_), null);
            boolean flag = false;
            if (!p_neighborChanged_2_.getBlockState(p_neighborChanged_3_.down()).isSideSolid(p_neighborChanged_2_, p_neighborChanged_3_.down(), EnumFacing.UP)) {
                flag = true;
            }
            if (blockrailbase$enumraildirection == EnumRailDirection.ASCENDING_EAST && !p_neighborChanged_2_.getBlockState(p_neighborChanged_3_.east()).isSideSolid(p_neighborChanged_2_, p_neighborChanged_3_.east(), EnumFacing.UP)) {
                flag = true;
            } else if (blockrailbase$enumraildirection == EnumRailDirection.ASCENDING_WEST && !p_neighborChanged_2_.getBlockState(p_neighborChanged_3_.west()).isSideSolid(p_neighborChanged_2_, p_neighborChanged_3_.west(), EnumFacing.UP)) {
                flag = true;
            } else if (blockrailbase$enumraildirection == EnumRailDirection.ASCENDING_NORTH && !p_neighborChanged_2_.getBlockState(p_neighborChanged_3_.north()).isSideSolid(p_neighborChanged_2_, p_neighborChanged_3_.north(), EnumFacing.UP)) {
                flag = true;
            } else if (blockrailbase$enumraildirection == EnumRailDirection.ASCENDING_SOUTH && !p_neighborChanged_2_.getBlockState(p_neighborChanged_3_.south()).isSideSolid(p_neighborChanged_2_, p_neighborChanged_3_.south(), EnumFacing.UP)) {
                flag = true;
            }
            if (flag && !p_neighborChanged_2_.isAirBlock(p_neighborChanged_3_)) {
                this.dropBlockAsItem(p_neighborChanged_2_, p_neighborChanged_3_, p_neighborChanged_1_, 0);
                p_neighborChanged_2_.setBlockToAir(p_neighborChanged_3_);
            } else {
                this.updateState(p_neighborChanged_1_, p_neighborChanged_2_, p_neighborChanged_3_, p_neighborChanged_4_);
            }
        }
    }

    protected void updateState(IBlockState p_updateState_1_, World p_updateState_2_, BlockPos p_updateState_3_, Block p_updateState_4_) {
    }

    protected IBlockState updateDir(World p_updateDir_1_, BlockPos p_updateDir_2_, IBlockState p_updateDir_3_, boolean p_updateDir_4_) {
        return p_updateDir_1_.isRemote ? p_updateDir_3_ : new Rail(p_updateDir_1_, p_updateDir_2_, p_updateDir_3_).place(p_updateDir_1_.isBlockPowered(p_updateDir_2_), p_updateDir_4_).getBlockState();
    }

    @Override
    public EnumPushReaction getMobilityFlag(IBlockState p_getMobilityFlag_1_) {
        return EnumPushReaction.NORMAL;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer getBlockLayer() {
        return BlockRenderLayer.CUTOUT;
    }

    @Override
    public void breakBlock(World p_breakBlock_1_, BlockPos p_breakBlock_2_, IBlockState p_breakBlock_3_) {
        super.breakBlock(p_breakBlock_1_, p_breakBlock_2_, p_breakBlock_3_);
        if (this.getRailDirection(p_breakBlock_1_, p_breakBlock_2_, p_breakBlock_3_, null).isAscending()) {
            p_breakBlock_1_.notifyNeighborsOfStateChange(p_breakBlock_2_.up(), this, false);
        }
        if (this.isPowered) {
            p_breakBlock_1_.notifyNeighborsOfStateChange(p_breakBlock_2_, this, false);
            p_breakBlock_1_.notifyNeighborsOfStateChange(p_breakBlock_2_.down(), this, false);
        }
    }

    public abstract IProperty<EnumRailDirection> getShapeProperty();

    public boolean isFlexibleRail(IBlockAccess p_isFlexibleRail_1_, BlockPos p_isFlexibleRail_2_) {
        return !this.isPowered;
    }

    public boolean canMakeSlopes(IBlockAccess p_canMakeSlopes_1_, BlockPos p_canMakeSlopes_2_) {
        return true;
    }

    public EnumRailDirection getRailDirection(IBlockAccess p_getRailDirection_1_, BlockPos p_getRailDirection_2_, IBlockState p_getRailDirection_3_, EntityMinecart p_getRailDirection_4_) {
        return p_getRailDirection_3_.getValue(this.getShapeProperty());
    }

    public float getRailMaxSpeed(World p_getRailMaxSpeed_1_, EntityMinecart p_getRailMaxSpeed_2_, BlockPos p_getRailMaxSpeed_3_) {
        return 0.4f;
    }

    public void onMinecartPass(World p_onMinecartPass_1_, EntityMinecart p_onMinecartPass_2_, BlockPos p_onMinecartPass_3_) {
    }

    @Override
    public boolean rotateBlock(World p_rotateBlock_1_, BlockPos p_rotateBlock_2_, EnumFacing p_rotateBlock_3_) {
        IBlockState state = p_rotateBlock_1_.getBlockState(p_rotateBlock_2_);
        for (IProperty prop : state.getProperties().keySet()) {
            if (!prop.getName().equals("shape")) continue;
            p_rotateBlock_1_.setBlockState(p_rotateBlock_2_, state.cycleProperty(prop));
            return true;
        }
        return false;
    }

    public class Rail {
        private final World world;
        private final BlockPos pos;
        private final BlockRailBase block;
        private IBlockState state;
        private final boolean isPowered;
        private final List<BlockPos> connectedRails = Lists.newArrayList();
        private final boolean canMakeSlopes;

        public Rail(World p_i45739_2_, BlockPos p_i45739_3_, IBlockState p_i45739_4_) {
            this.world = p_i45739_2_;
            this.pos = p_i45739_3_;
            this.state = p_i45739_4_;
            this.block = (BlockRailBase)p_i45739_4_.getBlock();
            EnumRailDirection blockrailbase$enumraildirection = this.block.getRailDirection(p_i45739_2_, p_i45739_3_, p_i45739_4_, null);
            this.isPowered = !this.block.isFlexibleRail(p_i45739_2_, p_i45739_3_);
            this.canMakeSlopes = this.block.canMakeSlopes(p_i45739_2_, p_i45739_3_);
            this.updateConnectedRails(blockrailbase$enumraildirection);
        }

        public List<BlockPos> getConnectedRails() {
            return this.connectedRails;
        }

        private void updateConnectedRails(EnumRailDirection p_updateConnectedRails_1_) {
            this.connectedRails.clear();
            switch (p_updateConnectedRails_1_) {
                case NORTH_SOUTH: {
                    this.connectedRails.add(this.pos.north());
                    this.connectedRails.add(this.pos.south());
                    break;
                }
                case EAST_WEST: {
                    this.connectedRails.add(this.pos.west());
                    this.connectedRails.add(this.pos.east());
                    break;
                }
                case ASCENDING_EAST: {
                    this.connectedRails.add(this.pos.west());
                    this.connectedRails.add(this.pos.east().up());
                    break;
                }
                case ASCENDING_WEST: {
                    this.connectedRails.add(this.pos.west().up());
                    this.connectedRails.add(this.pos.east());
                    break;
                }
                case ASCENDING_NORTH: {
                    this.connectedRails.add(this.pos.north().up());
                    this.connectedRails.add(this.pos.south());
                    break;
                }
                case ASCENDING_SOUTH: {
                    this.connectedRails.add(this.pos.north());
                    this.connectedRails.add(this.pos.south().up());
                    break;
                }
                case SOUTH_EAST: {
                    this.connectedRails.add(this.pos.east());
                    this.connectedRails.add(this.pos.south());
                    break;
                }
                case SOUTH_WEST: {
                    this.connectedRails.add(this.pos.west());
                    this.connectedRails.add(this.pos.south());
                    break;
                }
                case NORTH_WEST: {
                    this.connectedRails.add(this.pos.west());
                    this.connectedRails.add(this.pos.north());
                    break;
                }
                case NORTH_EAST: {
                    this.connectedRails.add(this.pos.east());
                    this.connectedRails.add(this.pos.north());
                }
            }
        }

        private void removeSoftConnections() {
            for (int i = 0; i < this.connectedRails.size(); ++i) {
                Rail blockrailbase$rail = this.findRailAt(this.connectedRails.get(i));
                if (blockrailbase$rail != null && blockrailbase$rail.isConnectedToRail(this)) {
                    this.connectedRails.set(i, blockrailbase$rail.pos);
                    continue;
                }
                this.connectedRails.remove(i--);
            }
        }

        private boolean hasRailAt(BlockPos p_hasRailAt_1_) {
            return BlockRailBase.isRailBlock(this.world, p_hasRailAt_1_) || BlockRailBase.isRailBlock(this.world, p_hasRailAt_1_.up()) || BlockRailBase.isRailBlock(this.world, p_hasRailAt_1_.down());
        }

        @Nullable
        private Rail findRailAt(BlockPos p_findRailAt_1_) {
            Rail rail;
            IBlockState iblockstate = this.world.getBlockState(p_findRailAt_1_);
            if (BlockRailBase.isRailBlock(iblockstate)) {
                BlockRailBase blockRailBase = BlockRailBase.this;
                blockRailBase.getClass();
                return blockRailBase.new Rail(this.world, p_findRailAt_1_, iblockstate);
            }
            BlockPos lvt_2_1_ = p_findRailAt_1_.up();
            iblockstate = this.world.getBlockState(lvt_2_1_);
            if (BlockRailBase.isRailBlock(iblockstate)) {
                BlockRailBase blockRailBase = BlockRailBase.this;
                blockRailBase.getClass();
                return blockRailBase.new Rail(this.world, lvt_2_1_, iblockstate);
            }
            lvt_2_1_ = p_findRailAt_1_.down();
            iblockstate = this.world.getBlockState(lvt_2_1_);
            if (BlockRailBase.isRailBlock(iblockstate)) {
                BlockRailBase blockRailBase = BlockRailBase.this;
                blockRailBase.getClass();
                rail = blockRailBase.new Rail(this.world, lvt_2_1_, iblockstate);
            } else {
                rail = null;
            }
            return rail;
        }

        private boolean isConnectedToRail(Rail p_isConnectedToRail_1_) {
            return this.isConnectedTo(p_isConnectedToRail_1_.pos);
        }

        private boolean isConnectedTo(BlockPos p_isConnectedTo_1_) {
            for (int i = 0; i < this.connectedRails.size(); ++i) {
                BlockPos blockpos = this.connectedRails.get(i);
                if (blockpos.getX() != p_isConnectedTo_1_.getX() || blockpos.getZ() != p_isConnectedTo_1_.getZ()) continue;
                return true;
            }
            return false;
        }

        protected int countAdjacentRails() {
            int i = 0;
            for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
                if (!this.hasRailAt(this.pos.offset(enumfacing))) continue;
                ++i;
            }
            return i;
        }

        private boolean canConnectTo(Rail p_canConnectTo_1_) {
            return this.isConnectedToRail(p_canConnectTo_1_) || this.connectedRails.size() != 2;
        }

        private void connectTo(Rail p_connectTo_1_) {
            this.connectedRails.add(p_connectTo_1_.pos);
            BlockPos blockpos = this.pos.north();
            BlockPos blockpos1 = this.pos.south();
            BlockPos blockpos2 = this.pos.west();
            BlockPos blockpos3 = this.pos.east();
            boolean flag = this.isConnectedTo(blockpos);
            boolean flag1 = this.isConnectedTo(blockpos1);
            boolean flag2 = this.isConnectedTo(blockpos2);
            boolean flag3 = this.isConnectedTo(blockpos3);
            EnumRailDirection blockrailbase$enumraildirection = null;
            if (flag || flag1) {
                blockrailbase$enumraildirection = EnumRailDirection.NORTH_SOUTH;
            }
            if (flag2 || flag3) {
                blockrailbase$enumraildirection = EnumRailDirection.EAST_WEST;
            }
            if (!this.isPowered) {
                if (flag1 && flag3 && !flag && !flag2) {
                    blockrailbase$enumraildirection = EnumRailDirection.SOUTH_EAST;
                }
                if (flag1 && flag2 && !flag && !flag3) {
                    blockrailbase$enumraildirection = EnumRailDirection.SOUTH_WEST;
                }
                if (flag && flag2 && !flag1 && !flag3) {
                    blockrailbase$enumraildirection = EnumRailDirection.NORTH_WEST;
                }
                if (flag && flag3 && !flag1 && !flag2) {
                    blockrailbase$enumraildirection = EnumRailDirection.NORTH_EAST;
                }
            }
            if (blockrailbase$enumraildirection == EnumRailDirection.NORTH_SOUTH && this.canMakeSlopes) {
                if (BlockRailBase.isRailBlock(this.world, blockpos.up())) {
                    blockrailbase$enumraildirection = EnumRailDirection.ASCENDING_NORTH;
                }
                if (BlockRailBase.isRailBlock(this.world, blockpos1.up())) {
                    blockrailbase$enumraildirection = EnumRailDirection.ASCENDING_SOUTH;
                }
            }
            if (blockrailbase$enumraildirection == EnumRailDirection.EAST_WEST && this.canMakeSlopes) {
                if (BlockRailBase.isRailBlock(this.world, blockpos3.up())) {
                    blockrailbase$enumraildirection = EnumRailDirection.ASCENDING_EAST;
                }
                if (BlockRailBase.isRailBlock(this.world, blockpos2.up())) {
                    blockrailbase$enumraildirection = EnumRailDirection.ASCENDING_WEST;
                }
            }
            if (blockrailbase$enumraildirection == null) {
                blockrailbase$enumraildirection = EnumRailDirection.NORTH_SOUTH;
            }
            this.state = this.state.withProperty(this.block.getShapeProperty(), blockrailbase$enumraildirection);
            this.world.setBlockState(this.pos, this.state, 3);
        }

        private boolean hasNeighborRail(BlockPos p_hasNeighborRail_1_) {
            Rail blockrailbase$rail = this.findRailAt(p_hasNeighborRail_1_);
            if (blockrailbase$rail == null) {
                return false;
            }
            blockrailbase$rail.removeSoftConnections();
            return blockrailbase$rail.canConnectTo(this);
        }

        public Rail place(boolean p_place_1_, boolean p_place_2_) {
            BlockPos blockpos = this.pos.north();
            BlockPos blockpos1 = this.pos.south();
            BlockPos blockpos2 = this.pos.west();
            BlockPos blockpos3 = this.pos.east();
            boolean flag = this.hasNeighborRail(blockpos);
            boolean flag1 = this.hasNeighborRail(blockpos1);
            boolean flag2 = this.hasNeighborRail(blockpos2);
            boolean flag3 = this.hasNeighborRail(blockpos3);
            EnumRailDirection blockrailbase$enumraildirection = null;
            if ((flag || flag1) && !flag2 && !flag3) {
                blockrailbase$enumraildirection = EnumRailDirection.NORTH_SOUTH;
            }
            if ((flag2 || flag3) && !flag && !flag1) {
                blockrailbase$enumraildirection = EnumRailDirection.EAST_WEST;
            }
            if (!this.isPowered) {
                if (flag1 && flag3 && !flag && !flag2) {
                    blockrailbase$enumraildirection = EnumRailDirection.SOUTH_EAST;
                }
                if (flag1 && flag2 && !flag && !flag3) {
                    blockrailbase$enumraildirection = EnumRailDirection.SOUTH_WEST;
                }
                if (flag && flag2 && !flag1 && !flag3) {
                    blockrailbase$enumraildirection = EnumRailDirection.NORTH_WEST;
                }
                if (flag && flag3 && !flag1 && !flag2) {
                    blockrailbase$enumraildirection = EnumRailDirection.NORTH_EAST;
                }
            }
            if (blockrailbase$enumraildirection == null) {
                if (flag || flag1) {
                    blockrailbase$enumraildirection = EnumRailDirection.NORTH_SOUTH;
                }
                if (flag2 || flag3) {
                    blockrailbase$enumraildirection = EnumRailDirection.EAST_WEST;
                }
                if (!this.isPowered) {
                    if (p_place_1_) {
                        if (flag1 && flag3) {
                            blockrailbase$enumraildirection = EnumRailDirection.SOUTH_EAST;
                        }
                        if (flag2 && flag1) {
                            blockrailbase$enumraildirection = EnumRailDirection.SOUTH_WEST;
                        }
                        if (flag3 && flag) {
                            blockrailbase$enumraildirection = EnumRailDirection.NORTH_EAST;
                        }
                        if (flag && flag2) {
                            blockrailbase$enumraildirection = EnumRailDirection.NORTH_WEST;
                        }
                    } else {
                        if (flag && flag2) {
                            blockrailbase$enumraildirection = EnumRailDirection.NORTH_WEST;
                        }
                        if (flag3 && flag) {
                            blockrailbase$enumraildirection = EnumRailDirection.NORTH_EAST;
                        }
                        if (flag2 && flag1) {
                            blockrailbase$enumraildirection = EnumRailDirection.SOUTH_WEST;
                        }
                        if (flag1 && flag3) {
                            blockrailbase$enumraildirection = EnumRailDirection.SOUTH_EAST;
                        }
                    }
                }
            }
            if (blockrailbase$enumraildirection == EnumRailDirection.NORTH_SOUTH && this.canMakeSlopes) {
                if (BlockRailBase.isRailBlock(this.world, blockpos.up())) {
                    blockrailbase$enumraildirection = EnumRailDirection.ASCENDING_NORTH;
                }
                if (BlockRailBase.isRailBlock(this.world, blockpos1.up())) {
                    blockrailbase$enumraildirection = EnumRailDirection.ASCENDING_SOUTH;
                }
            }
            if (blockrailbase$enumraildirection == EnumRailDirection.EAST_WEST && this.canMakeSlopes) {
                if (BlockRailBase.isRailBlock(this.world, blockpos3.up())) {
                    blockrailbase$enumraildirection = EnumRailDirection.ASCENDING_EAST;
                }
                if (BlockRailBase.isRailBlock(this.world, blockpos2.up())) {
                    blockrailbase$enumraildirection = EnumRailDirection.ASCENDING_WEST;
                }
            }
            if (blockrailbase$enumraildirection == null) {
                blockrailbase$enumraildirection = EnumRailDirection.NORTH_SOUTH;
            }
            this.updateConnectedRails(blockrailbase$enumraildirection);
            this.state = this.state.withProperty(this.block.getShapeProperty(), blockrailbase$enumraildirection);
            if (p_place_2_ || this.world.getBlockState(this.pos) != this.state) {
                this.world.setBlockState(this.pos, this.state, 3);
                for (int i = 0; i < this.connectedRails.size(); ++i) {
                    Rail blockrailbase$rail = this.findRailAt(this.connectedRails.get(i));
                    if (blockrailbase$rail == null) continue;
                    blockrailbase$rail.removeSoftConnections();
                    if (!blockrailbase$rail.canConnectTo(this)) continue;
                    blockrailbase$rail.connectTo(this);
                }
            }
            return this;
        }

        public IBlockState getBlockState() {
            return this.state;
        }
    }

    public static enum EnumRailDirection implements IStringSerializable
    {
        NORTH_SOUTH(0, "north_south"),
        EAST_WEST(1, "east_west"),
        ASCENDING_EAST(2, "ascending_east"),
        ASCENDING_WEST(3, "ascending_west"),
        ASCENDING_NORTH(4, "ascending_north"),
        ASCENDING_SOUTH(5, "ascending_south"),
        SOUTH_EAST(6, "south_east"),
        SOUTH_WEST(7, "south_west"),
        NORTH_WEST(8, "north_west"),
        NORTH_EAST(9, "north_east");

        private static final EnumRailDirection[] META_LOOKUP;
        private final int meta;
        private final String name;

        private EnumRailDirection(int p_i45738_3_, String p_i45738_4_) {
            this.meta = p_i45738_3_;
            this.name = p_i45738_4_;
        }

        public int getMetadata() {
            return this.meta;
        }

        public String toString() {
            return this.name;
        }

        public boolean isAscending() {
            return this == ASCENDING_NORTH || this == ASCENDING_EAST || this == ASCENDING_SOUTH || this == ASCENDING_WEST;
        }

        public static EnumRailDirection byMetadata(int p_byMetadata_0_) {
            if (p_byMetadata_0_ < 0 || p_byMetadata_0_ >= META_LOOKUP.length) {
                p_byMetadata_0_ = 0;
            }
            return META_LOOKUP[p_byMetadata_0_];
        }

        @Override
        public String getName() {
            return this.name;
        }

        static {
            META_LOOKUP = new EnumRailDirection[EnumRailDirection.values().length];
            EnumRailDirection[] enumRailDirectionArray = EnumRailDirection.values();
            int n = enumRailDirectionArray.length;
            for (int i = 0; i < n; ++i) {
                EnumRailDirection blockrailbase$enumraildirection;
                EnumRailDirection.META_LOOKUP[blockrailbase$enumraildirection.getMetadata()] = blockrailbase$enumraildirection = enumRailDirectionArray[i];
            }
        }
    }
}

